/*
 * Copyright (C) 2005 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*  modified and restricted to data ahdnling and buffer allocation
 *  binder and ipc support removed
 *  transfer of complex objects removed
 */

#ifndef _PARCEL_H
#define _PARCEL_H

#include "ril_i.h"

class Parcel{
public:

    Parcel();
    ~Parcel();

    /* buffer control and generic data handling */

    static int32_t      ParcelEnd;

    const uint8_t*      data() const;
    size_t              dataSize() const;
    size_t              dataAvail() const;
    size_t              dataPosition() const;
    size_t              dataCapacity() const;

    status_t            setDataSize(size_t size);
    void                setDataPosition(size_t pos) const;
    status_t            setDataCapacity(size_t size);

    status_t            setData(const uint8_t* buffer, size_t len);

    status_t            setDataRef(uint8_t* buffer, size_t len);
    status_t            unsetDataRef(uint8_t* buffer);

    status_t            appendFrom(const Parcel *parcel,
                                   size_t start, size_t len);

    void                freeData();

    status_t            errorCheck() const;
    void                setError(status_t err);

    status_t            write(const void* data, size_t len);
    void*               writeInplace(size_t len);
    void*               writeInplaceUnpadded(size_t len);
    status_t            writeUnpadded(const void* data, size_t len);
    status_t            writeInt32(int32_t val);
    status_t            writeInt64(int64_t val);
    status_t            writeFloat(float val);
    status_t            writeDouble(double val);
    status_t            writeIntPtr(intptr_t val);
    status_t            writeCString(const char* str);
    status_t            writeString16(const char16_t* str, size_t len);

    void                remove(size_t start, size_t amt);

    status_t            read(void* outData, size_t len) const;
    status_t            readUnpadded(void* outData, size_t len) const;

    const void*         readInplace(size_t len) const;
    int32_t             readInt32() const;
    status_t            readInt32(int32_t *pArg) const;
    int64_t             readInt64() const;
    status_t            readInt64(int64_t *pArg) const;
    float               readFloat() const;
    status_t            readFloat(float *pArg) const;
    double              readDouble() const;
    status_t            readDouble(double *pArg) const;
    intptr_t            readIntPtr() const;
    status_t            readIntPtr(intptr_t *pArg) const;

    const char*         readCString() const;
    const char16_t*     readString16Inplace(size_t* outLen) const;
    size_t              readString16(char16_t* buffer, size_t bufferSize)const;


    static char *       strdupReadString(Parcel &p);
    void                writeStringToParcel(const char *s);
    static unsigned char *strdupReadByteArrayUnpadded(Parcel &p, int size);
    static unsigned char *strdupReadByteArray(Parcel &p, int size);

private:
                        Parcel(const Parcel& o);
    Parcel&             operator=(const Parcel& o);

    status_t            finishWrite(size_t len);
    status_t            growData(size_t len);
    status_t            restartWrite(size_t desired);
    status_t            continueWrite(size_t desired);
    void                freeDataNoInit();
    void                initState();

    static char *       strndup16to8 (const char16_t* s, size_t n);
    static size_t       strnlen16to8 (const char16_t* s, size_t n);
    static char *       strncpy16to8 (char *dest, const char16_t*s, size_t n);

    static char16_t *   strdup8to16 (const char* s, size_t *out_len);
    static size_t       strlen8to16 (const char* utf8Str);
    static char16_t *   strcpy8to16 (char16_t *dest, const char*s, size_t *out_len);
    static uint32_t     getUtf32FromUtf8(const char** pUtf8Ptr);


template<class T>
    status_t            readAligned(T *pArg) const;

    template<class T>   T readAligned() const;

    template<class T>
    status_t            writeAligned(T val);

    status_t            mError;
    uint8_t*            mData;
    size_t              mDataSize;
    size_t              mDataCapacity;
    mutable size_t      mDataPos;
};

#endif //_LIBS_PARCEL_H



