
#ifndef RILPROC_H_
#define RILPROC_H_

/* Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * A simple utility for reading fixed records out of a stream fd
 */
#include "ril.h"

class Parcel;

typedef enum{
    PROC_INIT,
    PROC_CLOSED,
    PROC_SHOULD_CLOSE,
    PROC_ACT
}ril_procState_t;

namespace rilProc {
extern int init(const char *inetAddr, int inetPort);
extern void setState(int procId, ril_procState_t state);
extern int getCommandFd(int procId);
extern int sendResponse (int procId, Parcel &p);
extern int sendResponseRaw (int procId, const void *data, size_t dataSize,int isLocked);
extern void sendEvent (int unsolResponse,Parcel &p);
};


typedef struct ril_readerProps{
    int inetPort;
    const char *inetName;
}rilReader_props_t;



#endif /*RILPROC_H_*/

