/* //device/libs/telephony/ril_event.h
**
** Copyright 2008, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

// Max number of fd's we watch at any one time.  Increase if necessary.
#define MAX_FD_EVENTS 16

#ifndef NULL
#define NULL 0
#endif

typedef struct ril_event rilEvent_t;
typedef void (*ril_event_cb)(short events, void *userdata);

extern rilEvent_t *rilEvent_create();

// Initialize internal data structs
extern int rilEvent_init();

// Initialize an event
extern void rilEvent_set(rilEvent_t* ev, bool persistent, ril_event_cb func, void * param);

// Add event to watch list
void rilEvent_add(rilEvent_t *ev);

// Add timer event
void rilEvent_timerAdd(rilEvent_t *ev, struct timeval * tv);

// Remove event from watch list
void rilEvent_del(rilEvent_t *ev);

void rilEvent_trigger();

void rilEvent_fire(rilEvent_t *ev);

