/* //device/libs/telephony/ril_commands.h
**
** Copyright 2006, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/
    {0, NULL, NULL},                   //none
    {RIL_REQUEST_GET_SIM_STATUS, radio::getIccCardStatusRequest, radio::getIccCardStatusResponse},
    {RIL_REQUEST_ENTER_SIM_PIN, radio::supplyIccPinForAppRequest, radio::supplyIccPinForAppResponse},
    {RIL_REQUEST_ENTER_SIM_PUK, radio::supplyIccPukForAppRequest, radio::supplyIccPukForAppResponse},
    {RIL_REQUEST_ENTER_SIM_PIN2, radio::supplyIccPin2ForAppRequest, radio::supplyIccPin2ForAppResponse},
    {RIL_REQUEST_ENTER_SIM_PUK2, radio::supplyIccPuk2ForAppRequest, radio::supplyIccPuk2ForAppResponse},
    {RIL_REQUEST_CHANGE_SIM_PIN, radio::changeIccPinForAppRequest, radio::changeIccPinForAppResponse},
    {RIL_REQUEST_CHANGE_SIM_PIN2, radio::changeIccPin2ForAppRequest, radio::changeIccPin2ForAppResponse},
    {RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION,  radio::supplyNetworkDepersonalizationRequest, radio::supplyNetworkDepersonalizationResponse},
    {RIL_REQUEST_GET_CURRENT_CALLS, radio::getCurrentCallsRequest, radio::getCurrentCallsResponse},
    {RIL_REQUEST_DIAL, radio::dialRequest, radio::dialResponse},
    {RIL_REQUEST_GET_IMSI, radio::getIMSIForAppRequest, radio::getIMSIForAppResponse},
    {RIL_REQUEST_HANGUP, radio::hangupConnectionRequest, radio::hangupConnectionResponse},
    {RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND, radio::HangupWaitingOrBackgroundRequest, radio::hangupWaitingOrBackgroundResponse},
    {RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND, radio::HangupForegroundResumeBackgroundRequest, radio::hangupForegroundResumeBackgroundResponse},
    {RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE, radio::switchWaitingOrHoldingAndActiveRequest, radio::switchWaitingOrHoldingAndActiveResponse},
    {RIL_REQUEST_CONFERENCE, radio::conferenceRequest, radio::conferenceResponse},
    {RIL_REQUEST_UDUB, radio::rejectCallRequest, radio::rejectCallResponse},
    {RIL_REQUEST_LAST_CALL_FAIL_CAUSE,  radio::getLastCallFailCauseRequest, radio::getLastCallFailCauseResponse},
    {RIL_REQUEST_SIGNAL_STRENGTH, radio::getSignalStrengthRequest, radio::getSignalStrengthResponse},
    {RIL_REQUEST_VOICE_REGISTRATION_STATE, radio::getVoiceRegistrationStateRequest, radio::getVoiceRegistrationStateResponse},
    {RIL_REQUEST_DATA_REGISTRATION_STATE, radio::getDataRegistrationStateRequest, radio::getDataRegistrationStateResponse},
    {RIL_REQUEST_OPERATOR, radio::getOperatorRequest, radio::getOperatorResponse},
    {RIL_REQUEST_RADIO_POWER,  radio::setRadioPowerRequest, radio::setRadioPowerResponse},
    {RIL_REQUEST_DTMF, radio::sendDtmfRequest,  radio::sendDtmfResponse},
    {RIL_REQUEST_SEND_SMS, radio::sendSmsRequest, radio::sendSmsResponse},
    {RIL_REQUEST_SEND_SMS_EXPECT_MORE, radio::sendSMSExpectMoreRequest, radio::sendSmsResponseExpectMore},
    {RIL_REQUEST_SETUP_DATA_CALL, radio::setupDataCallRequest, radio::setupDataCallResponse},
    {RIL_REQUEST_SIM_IO, radio::iccIOForAppRequest, radio::iccIOForAppResponse},
    {RIL_REQUEST_SEND_USSD, radio::sendUssdRequest, radio::sendUssdResponse},
    {RIL_REQUEST_CANCEL_USSD, radio::cancelPendingUssdRequest, radio::cancelPendingUssdResponse},
    {RIL_REQUEST_GET_CLIR, radio::getClirRequest, radio::getClirResponse},
    {RIL_REQUEST_SET_CLIR, radio::setClirRequest, radio::setClirResponse},
    {RIL_REQUEST_QUERY_CALL_FORWARD_STATUS, radio::getCallForwardStatusRequest, radio::getCallForwardStatusResponse},
    {RIL_REQUEST_SET_CALL_FORWARD, radio::setCallForwardRequest, radio::setCallForwardResponse},
    {RIL_REQUEST_QUERY_CALL_WAITING, radio::getCallWaitingRequest, radio::getCallWaitingResponse},
    {RIL_REQUEST_SET_CALL_WAITING, radio::setCallWaitingRequest, radio::setCallWaitingResponse},
    {RIL_REQUEST_SMS_ACKNOWLEDGE,  radio::acknowledgeLastIncomingGsmSmsRequest, radio::acknowledgeLastIncomingGsmSmsResponse},
    {RIL_REQUEST_GET_IMEI, radio::getImeiRequest, radio::getImeiResponse},
    {RIL_REQUEST_GET_IMEISV, radio::getImeiSvRequest, radio::getImeiSvResponse},
    {RIL_REQUEST_ANSWER,radio::acceptCallRequest, radio::acceptCallResponse},
    {RIL_REQUEST_DEACTIVATE_DATA_CALL, radio::deactivateDataCallRequest, radio::deactivateDataCallResponse},
    {RIL_REQUEST_QUERY_FACILITY_LOCK, radio::getFacilityLockForAppRequest, radio::getFacilityLockForAppResponse},
    {RIL_REQUEST_SET_FACILITY_LOCK, radio::setFacilityLockForAppRequest, radio::setFacilityLockForAppResponse},
    {RIL_REQUEST_CHANGE_BARRING_PASSWORD, radio::setBarringPasswordRequest, radio::setBarringPasswordResponse},
    {RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE, radio::getNetworkSelectionModeRequest, radio::getNetworkSelectionModeResponse},
    {RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC, radio::setNetworkSelectionModeAutomaticRequest, radio::setNetworkSelectionModeAutomaticResponse},
    {RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL, radio::setNetworkSelectionModeManualRequest, radio::setNetworkSelectionModeManualResponse},
    {RIL_REQUEST_QUERY_AVAILABLE_NETWORKS , radio::getAvailableNetworksRequest, radio::getAvailableNetworksResponse},
    {RIL_REQUEST_DTMF_START, radio::startDtmfRequest, radio::startDtmfResponse},
    {RIL_REQUEST_DTMF_STOP, radio::stopDtmfRequest, radio::stopDtmfResponse},
    {RIL_REQUEST_BASEBAND_VERSION, radio::getBasebandVersionRequest, radio::getBasebandVersionResponse},
    {RIL_REQUEST_SEPARATE_CONNECTION, radio::separateConnectionRequest, radio::separateConnectionResponse},
    {RIL_REQUEST_SET_MUTE, radio::setMuteRequest, radio::setMuteResponse},
    {RIL_REQUEST_GET_MUTE, radio::getMuteRequest, radio::getMuteResponse},
    {RIL_REQUEST_QUERY_CLIP, radio::getClipRequest, radio::getClipResponse},
    {RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE, NULL, NULL},
    {RIL_REQUEST_DATA_CALL_LIST, radio::getDataCallListRequest,  radio::getDataCallListResponse},
    {RIL_REQUEST_RESET_RADIO, NULL, NULL},
    {RIL_REQUEST_OEM_HOOK_RAW, radio::oemHookRawRequest, radio::oemHookRawIndOrResp},
    {RIL_REQUEST_OEM_HOOK_STRINGS,  radio::oemHookStringsRequest, radio::oemHookStringsResponse},
    {RIL_REQUEST_SCREEN_STATE, radio::sendDeviceStateRequest, radio::sendDeviceStateResponse},   // Note the response function is different.,
    {RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION,  radio::setSuppServiceNotificationsRequest, radio::setSuppServiceNotificationsResponse},
    {RIL_REQUEST_WRITE_SMS_TO_SIM, radio::writeSmsToSimRequest, radio::writeSmsToSimResponse},
    {RIL_REQUEST_DELETE_SMS_ON_SIM, radio::deleteSmsOnSimRequest, radio::deleteSmsOnSimResponse},
    {RIL_REQUEST_SET_BAND_MODE,  radio::setBandModeRequest, radio::setBandModeResponse},
    {RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE, radio::getAvailableBandModesRequest, radio::getAvailableBandModesResponse},
    {RIL_REQUEST_STK_GET_PROFILE, NULL, NULL},
    {RIL_REQUEST_STK_SET_PROFILE, NULL, NULL},
    {RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND, radio::sendEnvelopeRequest, radio::sendEnvelopeResponse},
    {RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE,  radio::sendTerminalResponseToSimRequest, radio::sendTerminalResponseToSimResponse},
    {RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM, radio::handleStkCallSetupRequestFromSimRequest, radio::handleStkCallSetupRequestFromSimResponse},
    {RIL_REQUEST_EXPLICIT_CALL_TRANSFER, radio::explicitCallTransferRequest, radio::explicitCallTransferResponse},
    {RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE, radio::setPreferredNetworkTypeRequest, radio::setPreferredNetworkTypeResponse},
    {RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE, radio::getPreferredNetworkTypeRequest, radio::getPreferredNetworkTypeResponse},
    {RIL_REQUEST_GET_NEIGHBORING_CELL_IDS, radio::getNeighboringCidsRequest, radio::getNeighboringCidsResponse},
    {RIL_REQUEST_SET_LOCATION_UPDATES, radio::setLocationUpdatesRequest, radio::setLocationUpdatesResponse},
    {RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE, NULL, NULL},
    {RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE, NULL, NULL},
    {RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE, NULL, NULL},
    {RIL_REQUEST_SET_TTY_MODE, radio::setTTYModeRequest, radio::setTTYModeResponse},
    {RIL_REQUEST_QUERY_TTY_MODE,  radio::getTTYModeRequest, radio::getTTYModeResponse},
    {RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE, NULL, NULL},
    {RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE, NULL, NULL},
    {RIL_REQUEST_CDMA_FLASH, NULL, NULL},
    {RIL_REQUEST_CDMA_BURST_DTMF, NULL, NULL},
    {RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY, NULL, NULL},
    {RIL_REQUEST_CDMA_SEND_SMS, NULL, NULL},
    {RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE, NULL, NULL},
    {RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG, radio::getGsmBroadcastConfigRequest, radio::getGsmBroadcastConfigResponse},
    {RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG,  radio::setGsmBroadcastConfigRequest, radio::setGsmBroadcastConfigResponse},
    {RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION, radio::setGsmBroadcastActivationRequest, radio::setGsmBroadcastActivationResponse},
    {RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG, NULL, NULL},
    {RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG, NULL, NULL},
    {RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION, NULL, NULL},
    {RIL_REQUEST_CDMA_SUBSCRIPTION, NULL, NULL},
    {RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM, NULL, NULL},
    {RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM, NULL, NULL},
    {RIL_REQUEST_DEVICE_IDENTITY, radio::getDeviceIdentityRequest, radio::getDeviceIdentityResponse},
    {RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE, radio::exitEmergencyCallbackModeRequest, radio::exitEmergencyCallbackModeResponse},
    {RIL_REQUEST_GET_SMSC_ADDRESS, radio::getSmscAddressRequest, radio::getSmscAddressResponse},
    {RIL_REQUEST_SET_SMSC_ADDRESS,  radio::setSmscAddressRequest, radio::setSmscAddressResponse},
    {RIL_REQUEST_REPORT_SMS_MEMORY_STATUS, radio::reportSmsMemoryStatusRequest, radio::reportSmsMemoryStatusResponse},
    {RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING, radio::reportStkServiceIsRunningRequest, radio::reportStkServiceIsRunningResponse},
    {RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE, NULL, NULL},
    {RIL_REQUEST_ISIM_AUTHENTICATION, radio::requestIsimAuthenticationRequest, radio::requestIsimAuthenticationResponse},
    {RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU, radio::acknowledgeIncomingGsmSmsWithPduReqquest, radio::acknowledgeIncomingGsmSmsWithPduResponse},
    {RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS, radio::sendEnvelopeWithStatusRequest, radio::sendEnvelopeWithStatusResponse},
    {RIL_REQUEST_VOICE_RADIO_TECH, radio::getVoiceRadioTechnologyRequest, radio::getVoiceRadioTechnologyResponse},
    {RIL_REQUEST_GET_CELL_INFO_LIST, radio::getCellInfoListRequest, radio::getCellInfoListResponse},
    {RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE, radio::setCellInfoListRateRequest, radio::setCellInfoListRateResponse},
    {RIL_REQUEST_SET_INITIAL_ATTACH_APN,  radio::setInitialAttachApnRequest, radio::setInitialAttachApnResponse},
    {RIL_REQUEST_IMS_REGISTRATION_STATE, radio::getImsRegistrationStateRequest, radio::getImsRegistrationStateResponse},
    {RIL_REQUEST_IMS_SEND_SMS, radio::sendImsSmsRequest, radio::sendImsSmsResponse},
    {RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC, radio::iccTransmitApduBasicChannelRequest, radio::iccTransmitApduBasicChannelResponse},
    {RIL_REQUEST_SIM_OPEN_CHANNEL, radio::iccOpenLogicalChannelRequest, radio::iccOpenLogicalChannelResponse},
    {RIL_REQUEST_SIM_CLOSE_CHANNEL, radio::iccCloseLogicalChannelRequest, radio::iccCloseLogicalChannelResponse},
    {RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL, radio::iccTransmitApduLogicalChannelRequest, radio::iccTransmitApduLogicalChannelResponse},
    {RIL_REQUEST_NV_READ_ITEM, radio::nvReadItemRequest, radio::nvReadItemResponse},
    {RIL_REQUEST_NV_WRITE_ITEM, radio::nvWriteItemRequest, radio::nvWriteItemResponse},
    {RIL_REQUEST_NV_WRITE_CDMA_PRL, NULL, NULL},
    {RIL_REQUEST_NV_RESET_CONFIG, radio::nvResetConfigRequest, radio::nvResetConfigResponse},
    {RIL_REQUEST_SET_UICC_SUBSCRIPTION, radio::setUiccSubscriptionRequest, radio::setUiccSubscriptionResponse},
    {RIL_REQUEST_ALLOW_DATA, radio::setDataAllowedRequest, radio::setDataAllowedResponse},
    {RIL_REQUEST_GET_HARDWARE_CONFIG,  radio::getHardwareConfigRequest, radio::getHardwareConfigResponse},
    {RIL_REQUEST_SIM_AUTHENTICATION, radio::requestIccSimAuthenticationRequest, radio::requestIccSimAuthenticationResponse},
    {RIL_REQUEST_GET_DC_RT_INFO, NULL, NULL},
    {RIL_REQUEST_SET_DC_RT_INFO_RATE, NULL, NULL},
    {RIL_REQUEST_SET_DATA_PROFILE,  radio::setDataProfileRequest, radio::setDataProfileResponse},
    {RIL_REQUEST_SHUTDOWN, radio::requestShutdownRequest, radio::requestShutdownResponse},
    {RIL_REQUEST_GET_RADIO_CAPABILITY,  radio::getRadioCapabilityRequest, radio::getRadioCapabilityResponse},
    {RIL_REQUEST_SET_RADIO_CAPABILITY, radio::setRadioCapabilityRequest, radio::setRadioCapabilityResponse},
    {RIL_REQUEST_START_LCE, radio::startLceServiceRequest, radio::startLceServiceResponse},
    {RIL_REQUEST_STOP_LCE,  radio::stopLceServiceRequest, radio::stopLceServiceResponse},
    {RIL_REQUEST_PULL_LCEDATA, radio::pullLceDataRequest, radio::pullLceDataResponse},
    {RIL_REQUEST_GET_ACTIVITY_INFO, radio::getModemActivityInfoRequest, radio::getModemActivityInfoResponse},
    {RIL_REQUEST_SET_CARRIER_RESTRICTIONS, radio::setAllowedCarriersRequest, radio::setAllowedCarriersResponse},
    {RIL_REQUEST_GET_CARRIER_RESTRICTIONS, radio::getAllowedCarriersRequest, radio::getAllowedCarriersResponse},
    {RIL_REQUEST_SEND_DEVICE_STATE,  radio::sendDeviceStateRequest, radio::sendDeviceStateResponse},
    {RIL_REQUEST_SET_UNSOLICITED_RESPONSE_FILTER,  radio::setIndicationFilterRequest, radio::setIndicationFilterResponse},
    {RIL_REQUEST_SET_SIM_CARD_POWER, radio::setSimCardPowerRequest, radio::setSimCardPowerResponse},
    {RIL_REQUEST_SET_CARRIER_INFO_IMSI_ENCRYPTION, radio::setCarrierInfoForImsiEncryptionRequest, radio::setCarrierInfoForImsiEncryptionResponse},
    {RIL_REQUEST_START_NETWORK_SCAN,  radio::startNetworkScanRequest, radio::startNetworkScanResponse},
    {RIL_REQUEST_STOP_NETWORK_SCAN, radio::stopNetworkScanRequest, radio::stopNetworkScanResponse},
    {RIL_REQUEST_START_KEEPALIVE, radio::startKeepaliveRequest, radio::startKeepaliveResponse},
    {RIL_REQUEST_STOP_KEEPALIVE, radio::stopKeepaliveRequest, radio::stopKeepaliveResponse},
    {RIL_REQUEST_DATA_RADIO_TECH, radio::getDataRadioTechnologyRequest, radio::getDataRadioTechnologyResponse},
    {RIL_REQUEST_INCREMENTAL_NETWORK_SCAN, radio::getIncrementalNetworkScanRequest, radio::getIncrementalNetworkScanResponse},

