/*
 * ril_i.h
 *
 *  Created on: 12.03.2014
 *      Author: wsc
 */

#ifndef RIL_I_H_
#define RIL_I_H_

#include <sys/types.h>
#include <errno.h>
#include <stdint.h>


typedef struct memhdr mem_header_t;
typedef struct mem mem_t;

extern mem_header_t *mem_hdr;

typedef int32_t     status_t;

#if __cplusplus <= 199711L
typedef uint16_t    char16_t;
#endif


extern int loglevel;

enum {
    OK                = 0,    // Everything is well.
    NO_ERROR          = 0,    // No errors.

    UNKNOWN_ERROR       = 0x80000000,

    NO_MEMORY           = -ENOMEM,
    INVALID_OPERATION   = -ENOSYS,
    BAD_VALUE           = -EINVAL,
    BAD_TYPE            = 0x80000001,
    NAME_NOT_FOUND      = -ENOENT,
    PERMISSION_DENIED   = -EPERM,
    NO_INIT             = -ENODEV,
    ALREADY_EXISTS      = -EEXIST,
    DEAD_OBJECT         = -EPIPE,
    FAILED_TRANSACTION  = 0x80000002,
    JPARKS_BROKE_IT     = -EPIPE,
    BAD_INDEX           = -EOVERFLOW,
    NOT_ENOUGH_DATA     = -ENODATA,
    WOULD_BLOCK         = -EWOULDBLOCK,
    TIMED_OUT           = -ETIME,
    UNKNOWN_TRANSACTION = -EBADMSG,
};

extern void libril_onProcClosed(int procId);
extern int libril_processCommandBuffer(void *buffer, size_t buflen, int procId);
extern void libril_onProcConnect(int procId);
extern void libril_checkMem(short flags, void *param);
extern int libril_getInterfaceVersion();

#endif /* RIL_I_H_ */
