/*
**
** Copyright 2012, Peiker acustic GmbH & Co.KG
**
** Peiker Proprietary and Confidential.
*/

#ifndef UTILS_LOG_H
#define UTILS_LOG_H

#include "config.h"

#if defined (USE_SYSLOG)
#include <sys/syslog.h>
#elif defined (USE_STDLOG)

#define        LOG_EMERG        0        /* system is unusable */
#define        LOG_ALERT        1        /* action must be taken immediately */
#define        LOG_CRIT         2        /* critical conditions */
#define        LOG_ERR          3        /* error conditions */
#define        LOG_WARNING      4        /* warning conditions */
#define        LOG_NOTICE       5        /* normal but significant condition */
#define        LOG_INFO         6        /* informational */
#define        LOG_DEBUG        7        /* debug-level messages */

#elif defined (USE_SDJOURNAL)
#include <systemd/sd-journal.h>

#elif defined (USE_DLTLOG)
#include <sys/syslog.h>
#include <dlt/dlt.h>

/* Max 4 char for DLT context name */
DLT_IMPORT_CONTEXT(LRIL);

#define DLTS_SIZE  200
#define DLTLOG(logLevel, format, ...) { \
            char buffer[DLTS_SIZE] = ""; \
            snprintf(buffer, DLTS_SIZE, format, __VA_ARGS__); \
            DLT_LOG(LRIL, logLevel, DLT_STRING(buffer)); \
}

#endif

#ifdef SYS_gettid
#define GETTID() (int)syscall(SYS_gettid)
#else
#define GETTID() 0
#endif

#ifndef DEBUG
#define DEBUG 1
#endif

/* open connection to syslog:
 *
 * identification string
 *
 */

#ifndef LOG_TAG
#define LOG_TAG "LIBRIL"
#endif

extern int loglevel;
extern unsigned int logmask;

#ifdef USE_SYSLOG
    #ifdef USE_SYSLOG_CONS
        #ifdef LOGOPEN_STATIC
            #define ALOGOPEN(tag)   openlog(tag,LOG_CONS|LOG_NOWAIT|LOG_PID,LOG_SYSLOG)
        #else
            #define ALOGOPEN(LOG_TAG)  while(0){}
        #endif
        #define LOG_SETTING LOG_CONS|LOG_NOWAIT|LOG_PID
    #else
        #ifdef LOGOPEN_STATIC
            #define ALOGOPEN(tag)   openlog(tag,LOG_NOWAIT|LOG_PID,LOG_SYSLOG)
        else
            #define ALOGOPEN(LOG_TAG)  while(0){}
        #endif
        #define LOG_SETTING  LOG_NOWAIT|LOG_PID
    #endif

    #ifdef USE_SYSLOG_CONS
        #define ALOGCLOSE()  closelog()
    #else
        #define ALOGCLOSE()  while(0){}
    #endif
#else
    #define ALOGOPEN(LOG_TAG)  while(0){}
    #define ALOGCLOSE()  while(0){}
#endif


/*
 * Simplified macros to send log message using the current LOG_TAG.
 */
#if defined (TEST) || (USE_STDLOG)
    #ifndef ACLOGE
        #define ACLOGE(tag,format,...)if (loglevel >=LOG_ERR){ printf(tag "[%d:%d-err]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
    #endif
    #ifndef ALOGE
        #define ALOGE(tag,format,...)  printf(tag "[%d:%d-err]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
    #endif

    #ifndef ACLOGI
        #define ACLOGI(tag,format,...)if (loglevel >=LOG_INFO){ printf(tag "[%d:%d-info]: " format"\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
    #endif
    #ifndef ALOGI
        #define ALOGI(tag,format,...)  printf(tag "[%d:%d-info]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
    #endif

    #ifndef ACLOGN
        #define ACLOGN(tag,format,...)if (loglevel >=LOG_NOTICE){ printf(tag "[%d:%d]-notice]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
    #endif
    #ifndef ALOGN
        #define ALOGN(tag,format,...)  printf(tag "[%d:%d-notice]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
    #endif

    #ifndef ACLOGW
        #define ACLOGW(tag,format,...)if (loglevel >=LOG_WARNING){ printf(tag "[%d:%d-warning]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
    #endif
    #ifndef ALOGW
        #define ALOGW(tag,format,...)  printf(tag "[%d:%d-warning]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
    #endif

    #ifndef ACLOGD
        #ifdef DEBUG
            #define ACLOGD(tag,format,...)if (loglevel >=LOG_DEBUG){ printf(tag "[%d:%d-debug]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
        #else
            #define ACLOGD(tag,format,...)  while(0){}
        #endif
    #endif
    #ifndef ALOGD
        #ifdef DEBUG
            #define ALOGD(tag,format,...)  printf(tag "[%d:%d-debug]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
        #else
            #define ALOGD(tag,format,...)  while(0){}
        #endif
    #endif

   #ifndef ACLOGV
        #ifdef LOG_VERBOSE
            #define ACLOGV(tag,format,...)if (loglevel > LOG_DEBUG){ printf(tag "[%d:%d-verbose]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);}
        #else
            #define ACLOGV(tag,format,...) while(0){}
        #endif
    #endif

    #ifndef ALOGV
        #ifdef LOG_VERBOSE
            #define ALOGV(tag,format,...)  printf(tag "[%d:%d-verbose]: " format "\n",getpid(),GETTID(),__VA_ARGS__);fflush(stdout);
        #else
            #define ALOGV(tag,format,...) while(0){}
        #endif
    #endif


#elif defined (USE_SYSLOG)
    #ifndef LOGOPEN_STATIC
        #ifndef ALOGE
            #define ALOGE(tag,...) openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_ERR,__VA_ARGS__);closelog()
        #endif
        #ifndef ACLOGE
            #define ACLOGE(tag,...) if (loglevel >= LOG_ERR){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_ERR,__VA_ARGS__);closelog();}
        #endif

        #ifndef ALOGI
            #define ALOGI(tag,...) openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_INFO,__VA_ARGS__);closelog()
        #endif
        #ifndef ACLOGI
            #define ACLOGI(tag,...) if (loglevel >= LOG_INFO){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_INFO,__VA_ARGS__);closelog();}
        #endif

        #ifndef ACLOGIM
            #define ACLOGIM(mask,tag,format,...) if ((loglevel >= LOG_INFO)&&(mask &logmask)) {syslog(LOG_INFO,__VA_ARGS__);}
        #endif

        #ifndef ALOGN
            #define ALOGN(tag,...) openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_NOTICE,__VA_ARGS__);closelog()
        #endif
        #ifndef ACLOGN
            #define ACLOGN(tag,...) if (loglevel >= LOG_NOTICE){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_NOTICE,__VA_ARGS__);closelog();}
        #endif

        #ifndef ACLOGNM
            #define ACLOGNM(mask,tag,format,...) if ((loglevel >= LOG_NOTICE)&&(mask &logmask)){syslog(LOG_NOTICE,__VA_ARGS__);}
        #endif

        #ifndef ALOGW
            #define ALOGW(tag,...) openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_WARNING,__VA_ARGS__);closelog()
        #endif
        #ifndef ACLOGW
            #define ACLOGW(tag,...) if (loglevel >= LOG_WARNING){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_WARNING,__VA_ARGS__);closelog();}
        #endif

        #ifndef ALOGD
            #ifdef DEBUG
                #define ALOGD(tag,...) openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog()
            #else
                #define ALOGD(tag,...)  while(0){}
            #endif
        #endif
        #ifndef ACLOGD
            #ifdef DEBUG
                #define ACLOGD(tag,...) if (loglevel >= LOG_DEBUG){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog();}
            #else
                #define ACLOGD(tag,...)  while(0){}
            #endif
        #endif

        #ifndef ALOGV
            #ifdef LOG_VERBOSE
                #define ALOGV(tag,...)  openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog()
            #else
                #define ALOGV(tag,...) while(0){}
            #endif
        #endif
        #ifndef ACLOGV
            #ifdef LOG_VERBOSE
                #define ACLOGV(tag,...) if (loglevel > LOG_DEBUG){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog();}
            #else
                #define ACLOGV(tag,...) while(0){}
            #endif
        #endif

    #else
        #ifndef ALOGE
            #define ALOGE(tag,...) syslog(LOG_ERR,__VA_ARGS__)
        #endif
        #ifndef ACLOGE
            #define ACLOGE(tag,...) if (loglevel >= LOG_ERR) {syslog(LOG_ERR,__VA_ARGS__);}
        #endif

        #ifndef ALOGI
            #define ALOGI(tag,...) syslog(LOG_INFO,__VA_ARGS__)
        #endif
        #ifndef ACLOGI
            #define ACLOGI(tag,...) if (loglevel >= LOG_INFO) {syslog(LOG_INFO,__VA_ARGS__);}
        #endif

        #ifndef ALOGN
            #define ALOGN(tag,...) syslog(LOG_NOTICE,__VA_ARGS__)
        #endif
        #ifndef ACLOGN
            #define ACLOGN(tag,...) if (loglevel >= LOG_NOTICE){syslog(LOG_NOTICE,__VA_ARGS__);}
        #endif

        #ifndef ALOGW
            #define ALOGW(tag,...) syslog(LOG_WARNING,__VA_ARGS__)
        #endif
        #ifndef ACLOGW
            #define ACLOGW(tag,...)  if (loglevel >= LOG_WARNING) { syslog(LOG_WARNING,__VA_ARGS__);}
        #endif

        #ifndef ALOGD
            #ifdef DEBUG
                #define ALOGD(tag,...) syslog(LOG_DEBUG,__VA_ARGS__)
            #else
                #define ALOGD(tag,...)  while(0){}
            #endif
        #endif

        #ifndef ACLOGD
            #ifdef DEBUG
                #define ACLOGD(tag,...)  if (loglevel >= LOG_DEBUG) { syslog(LOG_DEBUG,__VA_ARGS__);}
            #else
                #define ACLOGD(tag,...)  while(0){}
            #endif
        #endif

        #ifndef ALOGV
            #ifdef LOG_VERBOSE
                #define ALOGV(tag,...)  syslog(LOG_INFO,__VA_ARGS__)
            #else
                #define ALOGVid(tag,...)  while(0){}
            #endif
        #endif
        #ifndef ACLOGV
            #ifdef LOG_VERBOSE
                #define ACLOGV(tag,...)  if (loglevel > LOG_DEBUG) { syslog(LOG_DEBUG,__VA_ARGS__);}
            #else
                #define ALOGVid(tag,...)  while(0){}
            #endif
        #endif

        #ifndef ALOGV
            #ifdef LOG_VERBOSE
                #define ALOGV(tag,...)  openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog()
            #else
                #define ALOGV(tag,...) while(0){}
            #endif
        #endif
        #ifndef ACLOGV
            #ifdef LOG_VERBOSE
                #define ACLOGV(tag,...) if (loglevel > LOG_DEBUG){openlog(tag,LOG_SETTING,LOG_SYSLOG);syslog(LOG_DEBUG,__VA_ARGS__);closelog();}
            #else
                #define ACLOGV(tag,...) while(0){}
            #endif
        #endif
    #endif
#elif defined (USE_SDJOURNAL)

    #ifndef ALOGE
        #define ALOGE(tag,format,...)  sd_journal_print(LOG_ERR,format,__VA_ARGS__)
    #endif
    #ifndef ACLOGE
        #define ACLOGE(tag,format,...)  if (loglevel >=LOG_ERR){  sd_journal_print(LOG_ERR,format,__VA_ARGS__);}
    #endif

    #ifndef ALOGI
        #define ALOGI(tag,format,...) sd_journal_print(LOG_INFO, format,__VA_ARGS__)
    #endif
    #ifndef ACLOGI
        #define ACLOGI(tag,format,...) if (loglevel >=LOG_INFO){ sd_journal_print(LOG_INFO, format,__VA_ARGS__);}
    #endif
    #ifndef ACLOGIM
        #define ACLOGIM(mask,tag,format,...) if ((loglevel>=LOG_INFO)&&(mask &logmask)){ sd_journal_print(LOG_INFO,format,__VA_ARGS__);}
    #endif

    #ifndef ALOGN
        #define ACLOGN(tag,format,...) sd_journal_print(LOG_NOTICE,format,__VA_ARGS__)
    #endif
    #ifndef ACLOGN
        #define ACLOGN(tag,format,...) if (loglevel >=LOG_NOTICE){ sd_journal_print(LOG_NOTICE,format,__VA_ARGS__);}
    #endif
    #ifndef ACLOGNM
        #define ACLOGNM(mask,tag,format,...) if ((loglevel>=LOG_NOTICE) && (mask &logmask)){ sd_journal_print(LOG_NOTICE,format,__VA_ARGS__);}
    #endif


    #ifndef ACLOGD
        #ifdef DEBUG
            #define ACLOGD(tag,format,...) if (loglevel >=LOG_DEBUG){ sd_journal_print(LOG_DEBUG,format,__VA_ARGS__);}
        #else
            #define ACLOGD(tag,format,...)  while(0){}
        #endif
    #endif
    #ifndef ALOGD
        #ifdef DEBUG
            #define ALOGD(tag,format,...) sd_journal_print(LOG_DEBUG,format,__VA_ARGS__)
        #else
            #define ALOGD(tag,format,...)  while(0){}
        #endif
    #endif

    #ifndef ACLOGW
        #define ACLOGW(tag,format,...) if (loglevel >=LOG_WARNING){ sd_journal_print(LOG_WARNING,format,__VA_ARGS__);}
    #endif
    #ifndef ALOGW
        #define ALOGW(tag,format,...)  sd_journal_print(LOG_WARNING,format,__VA_ARGS__)
    #endif


    #ifndef ACLOGV
        #ifdef LOG_VERBOSE
            #define ACLOGV(tag,format,...)if (loglevel > LOG_DEBUG){ sd_journal_print(LOG_DEBUG,format,__VA_ARGS__);}
        #else
            #define ACLOGV(tag,format,...) while(0){}
        #endif
    #endif
    #ifndef ALOGV
        #ifdef LOG_VERBOSE
            #define ALOGV(tag,format,...) sd_journal_print(LOG_DEBUG,format,__VA_ARGS__)
        #else
            #define ALOGV(tag,format,...) while(0){}
        #endif
    #endif

#elif defined (USE_DLTLOG)

    #ifndef ALOGE
        #define ALOGE(tag,format,...)  { DLTLOG(DLT_LOG_ERROR,format,__VA_ARGS__); }
    #endif
    #ifndef ACLOGE
        #define ACLOGE(tag,format,...)  if (loglevel >= LOG_ERR){ DLTLOG(DLT_LOG_ERROR,format,__VA_ARGS__); }
    #endif

    #ifndef ALOGI
        #define ALOGI(tag,format,...) { DLTLOG(DLT_LOG_INFO,format,__VA_ARGS__); }
    #endif
    #ifndef ACLOGI
        #define ACLOGI(tag,format,...) if (loglevel >= LOG_INFO){ DLTLOG(DLT_LOG_INFO,format,__VA_ARGS__); }
    #endif

    #ifndef ALOGN
        #define ALOGN(tag,format,...) { DLTLOG(DLT_LOG_INFO,format,__VA_ARGS__); }
    #endif
    #ifndef ACLOGN
        #define ACLOGN(tag,format,...) if (loglevel >= LOG_NOTICE){ DLTLOG(DLT_LOG_INFO,format,__VA_ARGS__); }
    #endif
    #ifndef ACLOGD
        #ifdef DEBUG
            #define ACLOGD(tag,format,...) if (loglevel >= LOG_DEBUG){ DLTLOG(DLT_LOG_DEBUG,format,__VA_ARGS__); }
        #else
            #define ACLOGD(tag,format,...)  while(0){}
        #endif
    #endif
    #ifndef ALOGD
        #ifdef DEBUG
            #define ALOGD(tag,format,...) { DLTLOG(DLT_LOG_DEBUG,format,__VA_ARGS__); }
        #else
            #define ALOGD(tag,format,...)  while(0){}
        #endif
    #endif

    #ifndef ACLOGW
        #define ACLOGW(tag,format,...) if (loglevel >= LOG_WARNING){ DLTLOG(DLT_LOG_WARN,format,__VA_ARGS__); }
    #endif
    #ifndef ALOGW
        #define ALOGW(tag,format,...) { DLTLOG(DLT_LOG_WARN,format,__VA_ARGS__); }
    #endif

    #ifndef ACLOGV
        #ifdef LOG_VERBOSE
            #define ACLOGV(tag,format,...)if (loglevel > LOG_DEBUG){ DLTLOG(DLT_LOG_VERBOSE,format,__VA_ARGS__); }
        #else
            #define ACLOGV(tag,format,...) while(0){}
        #endif
    #endif
    #ifndef ALOGV
        #ifdef LOG_VERBOSE
            #define ALOGV(tag,format,...) { DLTLOG(DLT_LOG_VERBOSE,format,__VA_ARGS__); }
        #else
            #define ALOGV(tag,format,...) while(0){}
        #endif
    #endif

#else
    #ifndef ACLOGE
        #define ACLOGE(tag,format,...) while(0){}
    #endif
    #ifndef ALOGE
        #define ALOGE(tag,format,...) while(0){}
    #endif

    #ifndef ACLOGI
        #define ACLOGI(tag,format,...) while(0){}
    #endif
    #ifndef ALOGI
        #define ALOGI(tag,format,...) while(0){}
    #endif
    #ifndef ACLOGIM
        #define ACLOGIM(mask,tag,...) while(0){}
    #endif

    #ifndef ACLOGN
        #define ACLOGN(tag,format,...) while(0){}
    #endif
    #ifndef ALOGN
        #define ALOGN(tag,format,...) while(0){}
    #endif
    #ifndef ACLOGNM
        #define ACLOGNM(mask,tag,...) while(0){}
    #endif

    #ifndef ACLOGD
        #define ACLOGD(tag,format,...) while(0){}
    #endif
    #ifndef ALOGD
        #define ALOGD(tag,format,...) while(0){}
    #endif

    #ifndef ACLOGW
        #define ACLOGW(tag,format,...) while(0){}
    #endif
    #ifndef ALOGW
        #define ALOGW(tag,format,...) while(0){}
    #endif

    #ifndef ACLOGV
        #define ACLOGV(tag,format,...) while(0){}
    #endif
    #ifndef ACLOGV
        #define ACLOGV(tag,format,...) while(0){}
    #endif

#endif



#endif
