/*
**
** Copyright (c) 2022 Valeo Telematik & Akustik GmbH.  All Rights Reserved.
** Valeo Proprietary and Confidential.
**
*/

#include "config.h"
#include "ril_i.h"

#include "Parcel.h"
#include "utils_parcel.h"

/* C wrapper for parcel methods required by vendorlib
 * (for OEM Hook raw data marshalling/unmarshalling)
 */

extern "C"
{
    ParcelHandle create_Parcel(){
        return (ParcelHandle) new Parcel();
    };

    void    delete_Parcel(ParcelHandle p)   {
        delete (Parcel*) p;
    }

    status_t parcel_readInt32(ParcelHandle p, int32_t *pArg){
        return ((Parcel *)p)->readInt32(pArg);
    }

    status_t parcel_readDouble(ParcelHandle p, double *pArg){
        return ((Parcel *)p)->readDouble(pArg);
    }

    status_t parcel_readFloat(ParcelHandle p, float *pArg){
        return ((Parcel *)p)->readFloat(pArg);
    }

    status_t parcel_readUnpadded(ParcelHandle p, void* Data, size_t len){
        return ((Parcel *)p)->readUnpadded(Data,len);
    }

    status_t parcel_read(ParcelHandle p, void* Data, size_t len){
        return ((Parcel *)p)->read(Data,len);
    }

    char * parcel_strdupReadString(ParcelHandle p){
        Parcel *pptr=(Parcel *)p;
        return Parcel::strdupReadString(*pptr);
    }

    unsigned char * parcel_strdupReadByteArray(ParcelHandle p,int size)
    {
        Parcel *pptr=(Parcel *)p;
        return Parcel::strdupReadByteArray(*pptr,size);
    }

    status_t parcel_setData(ParcelHandle p, const uint8_t* buffer, size_t len){
        return ((Parcel *)p)->setData(buffer,len);
    }
    status_t parcel_setDataRef(ParcelHandle p, uint8_t* buffer, size_t len){
        return ((Parcel *)p)->setDataRef(buffer,len);
    }

    status_t parcel_unsetDataRef(ParcelHandle p,  uint8_t* buffer){
        return ((Parcel *)p)->unsetDataRef(buffer);
    }

    status_t parcel_readInt64(ParcelHandle p, int64_t *pArg){
        return ((Parcel *)p)->readInt64(pArg);
    }

    status_t parcel_writeInt32(ParcelHandle p, int32_t val){
        return ((Parcel *)p)->writeInt32(val);
    }

    status_t parcel_writeInt64(ParcelHandle p, int64_t val){
        return ((Parcel *)p)->writeInt64(val);
    }

    status_t parcel_setDataSize(ParcelHandle p,  size_t desired){
        return ((Parcel *)p)->setDataSize(desired);
    }

    void parcel_writeStringToParcel(ParcelHandle p,  const char *s){
        ((Parcel *)p)->writeStringToParcel(s);
    }

    status_t  parcel_writeUnpadded(ParcelHandle p, const void* data, size_t len){
        return  ((Parcel *)p)->writeUnpadded(data,len);
    }

    status_t  parcel_write(ParcelHandle p, const void* data, size_t len){
        return  ((Parcel *)p)->write(data,len);
    }

    status_t parcel_writeDouble(ParcelHandle p, double value){
        return  ((Parcel *)p)->writeDouble(value);
    }

    status_t parcel_writeFloat(ParcelHandle p, float value){
        return  ((Parcel *)p)->writeFloat(value);
    }
    void free_Parcel(ParcelHandle p){
        delete (Parcel*) p;
    }

    void  parcel_setDataPosition(ParcelHandle p, size_t pos){
        ((Parcel *)p)->setDataPosition(pos);
    }

    size_t  parcel_getDataPosition(ParcelHandle p){
        return ((Parcel *)p)->dataPosition();
    }

    const uint8_t* parcel_data(ParcelHandle p){
        return ((Parcel *)p)->data();
    }

}