/**
**
** Copyright 2022, Valeo Telematik & Akustik GmbH
**
** Valeo Proprietary and Confidential.
*/

#ifndef UTILS_PARCEL_H
#define UTILS_PARCEL_H

#include "ril_i.h"

/*** utils_parcel.h ***/
#ifdef __cplusplus
extern "C" {
#endif
    typedef void *ParcelHandle;
    ParcelHandle create_Parcel();
    void    delete_Parcel(ParcelHandle);

    status_t parcel_readInt32(ParcelHandle p, int32_t *pArg);
    status_t parcel_readDouble(ParcelHandle p,double *pArg);
    status_t parcel_readFloat(ParcelHandle p,float *pArg);
    status_t parcel_readUnpadded(ParcelHandle p,void* Data, size_t len);
    char *   parcel_strdupReadString(ParcelHandle p);
    status_t parcel_setData(ParcelHandle p, const uint8_t* buffer, size_t len);
    status_t parcel_setDataRef(ParcelHandle p, uint8_t* buffer, size_t len);
    status_t parcel_unsetDataRef(ParcelHandle p, uint8_t* buffer);
    status_t parcel_readInt64(ParcelHandle p,int64_t *pArg);

    status_t parcel_writeInt32(ParcelHandle p,int32_t val);
    status_t parcel_writeInt64(ParcelHandle p,int64_t val);

    status_t parcel_setDataSize(ParcelHandle p,  size_t desired);
    void parcel_writeStringToParcel(ParcelHandle p,  const char *s);
    status_t  parcel_writeUnpadded(ParcelHandle p, const void* data, size_t len);
    status_t parcel_writeDouble(ParcelHandle p, double value);
    status_t parcel_writeFloat(ParcelHandle p,float value);

    void  parcel_setDataPosition(ParcelHandle p,size_t pos);
    size_t  parcel_getDataPosition(ParcelHandle p);
    const uint8_t* parcel_data(ParcelHandle p);

    status_t parcel_write(ParcelHandle p, const void* data, size_t len);
    status_t parcel_read(ParcelHandle p,void* Data, size_t len);

    unsigned char *parcel_strdupReadByteArray(ParcelHandle p,int size);


#ifdef __cplusplus
}
#endif

#endif