/*
    intercom - Event based Interprocess Communication for Dummies
    Copyright 2016 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef LOG_H_
#define LOG_H_

#ifdef __cplusplus
extern "C" {
#endif

/*! \file log.h
    \brief logging

    \addtogroup logging_api Logging
    @{
 */


#ifndef LOG_TAG
/*! log tag for libintercom library notification and error messages */
#define LOG_TAG "ICOM"
#endif


/*! initialize logging (syslog)
 *
 *  needs to be invoked once to start logging
 */
int icom_log_init(void);


/*! release logging (syslog)
 *
 * stops logging
 */
void icom_log_release(void);


/*!
 * writes notifying message to syslog
 *
 * \param fmt format string as used in clib e.g. printf
 */
void icom_message( const char* fmt, ... );


/*!
 * writes error message to syslog
 *
 * \param fmt format string as used in clib e.g. printf
 */
void icom_error( const char* fmt, ... );

/*! @} */

#ifdef __cplusplus
}
#endif


#endif /* #ifndef LOG_H_ */
