/*
    intercom - Event based Interprocess Communication for Dummies
    Copyright 2016 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef UTILS_H
#define UTILS_H

#include <sys/socket.h>
#include <intercom/events.h>
#include <olcutils/slist.h>


#ifndef MIN
#define MIN(x,y) ( ((x)<(y)) ? (x) : (y) )
#endif

#ifndef MAX
#define MAX(x,y) ( ((x)>(y)) ? (x) : (y) )
#endif

/*! create a new list and omit element data */
slist_t* clone_slist_without_elem( const slist_t* l, const void* data );


/*! unlink event for processing out of pool */
t_icom_evt* create_new_event( t_icom_events* p_events );


/*! insert newly created event in ready list */
void send_event( t_icom_events* p_events, t_icom_evt* p_evt );


/*! retrieve data size of from event pool */
int get_evt_max_data_size( t_icom_events* p_events );


/*! samea as send (socket.h) but adds automatic tcp msg delimiter when missing */
ssize_t send_with_delim( int socket, const void *buffer, size_t length, int flags );


#endif /*#ifndef UTILS_H */
