#ifndef __VTZ2_MAIN_H__
#define __VTZ2_MAIN_H__
/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

#include <linux/cdev.h>		/* cdev_init() etc. */
#include <linux/mutex.h>		 /*struct mutex */
#include <vtz_user.h>

#define DRV_NAME "vtz2"
#define PFX DRV_NAME ": "
#define DEVICES_COUNT 6
#define BUFFER_SIZE (1<<10) //BUFFER_SIZE should always be a power of 2

extern struct vtz_drvdata_t *vtz_drvdata;	/* private driver data */

struct vtz_error_buffer{
	vtz_error error_array [BUFFER_SIZE];
	uint32_t head;
	uint32_t tail;
	uint32_t count;
};


struct vtz_device_t {
        dev_t           dev;                    /* MAJOR & MINOR combined */
        struct device   *device;
        struct cdev     cdev;
        uint64_t        transaction;            /* default: 0 by kzalloc */
        uint64_t        pin;
        bool            transaction_lock;       /* default: 0 by kzalloc */
};

struct vtz_drvdata_t {
        dev_t                   dev;            /* from alloc_chrdev_region() */
        struct class            *class;         /* from class_create() */
#ifdef CONFIG_VTZ2_STORAGE
        struct vtz_device_t     dev_vdstorage;
#endif
#ifdef CONFIG_VTZ2_RSA
        struct vtz_device_t     dev_vdacrypt;
#endif

#ifdef CONFIG_VTZ2_LOG
        struct vtz_device_t dev_vdlog;
#endif

#ifdef CONFIG_VTZ2_DEVICE
       struct vtz_device_t dev_vddevice;
#endif

#ifdef CONFIG_VTZ2_BOOT
       struct vtz_device_t dev_vdboot;
#endif
#ifdef CONFIG_VTZ2_FOTA
        struct vtz_device_t     dev_vdfota;
#endif
        struct mutex            inside_tz_call_mutex;           /* for waiting/blocking */
        atomic_t                inside_long_tz_call_counter;    /* for returning EWOULDBLOCK */
        atomic_t                inside_short_tz_call_counter;

#ifdef CONFIG_HAS_WAKELOCK
        struct wakelock         vtz_wakelock;
#endif

        struct mutex log_buffer_mutex;    /* Protecting error log ring buffer from concurrent access*/
        struct vtz_error_buffer vtz_ring_buffer;
        wait_queue_head_t log_event;    /* Wait queue for processes waiting on error log rung buffer*/
};


#endif
