#ifndef __VTZ2_RSA_H__
#define __VTZ2_RSA_H__
/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

#include <linux/types.h>

/**************************************************/
/* TrustZone Macros (with permission by Qualcomm) */
/**************************************************/
#define WORKAROUND_MISSING_SIGN_MHASH_WITH_PAD


#define CRYPTO_ASYM_KEY_SIZE_MAX	(512+16)	/* 4096 bits */
#define CRYPTO_ASYM_PUB_EXP_SIZE_MAX	(5)		/* 5 bytes max public exponent size supported */
#define CRYPTO_ASYM_IV_LENGTH		(16)		/* AES128 CBC IV */
#define CRYPTO_ASYM_HMAC_LENGTH		(32)		/* SHA2 will be used for HMAC  */

#define SHA256_HASH_LENGTH		(32)
#define SHA384_HASH_LENGTH		(48)
#define SHA512_HASH_LENGTH		(64)

/*********************************************/
/*  file_operations structure for RSA crypto */
/*********************************************/

extern const struct file_operations vtz_fops_acrypt;

/**************************************************************/
/* TrustZone RSA struct defines (with permission by Qualcomm) */
/**************************************************************/

typedef enum {
	CRYPTO_STORAGE_GENERATE_KEY_OLD		= 0x00000001,
	CRYPTO_STORAGE_EXPORT_PUBKEY		= 0x00000002,
	CRYPTO_STORAGE_SIGN_DATA_OLD		= 0x00000003,
	CRYPTO_STORAGE_VERIFY_DATA_OLD		= 0x00000004,
	CRYPTO_STORAGE_IMPORT_KEY		= 0x00000005,
	CRYPTO_STORAGE_SIGN_MHASH		= 0x00000006,
	CRYPTO_STORAGE_VERIFY_MHASH		= 0x00000007,
	CRYPTO_STORAGE_SIGN_DATA_WITH_PAD	= 0x00000008,
	CRYPTO_STORAGE_VERIFY_DATA_WITH_PAD	= 0x00000009,
	CRYPTO_STORAGE_SIGN_MHASH_WITH_PAD	= 0x0000000A,
	CRYPTO_STORAGE_VERIFY_MHASH_WITH_PAD	= 0x0000000B,
	CRYPTO_STORAGE_LAST_CMD_ENTRY		= 0x7FFFFFFF
} crypto_asym_cmd_t;

typedef enum {
	TZ_RSA_DIGEST_PADDING_NONE	= 0x0,
	TZ_RSA_PKCS115_SHA2_256		= 0x1,
	TZ_RSA_PSS_SHA2_256		= 0x2,
	TZ_RSA_PKCS115_SHA2_384		= 0x3,
	TZ_RSA_PKCS115_SHA2_512		= 0x4
} tz_rsa_digest_pad_algo_t;

typedef struct {
	uint32_t			magic_num;
	uint32_t			version;
	tz_rsa_digest_pad_algo_t	digest_padding;
	uint8_t				modulus[CRYPTO_ASYM_KEY_SIZE_MAX];
	uint32_t			modulus_size;
	uint8_t				public_exponent[CRYPTO_ASYM_KEY_SIZE_MAX];
	uint32_t			public_exponent_size;
	uint8_t				iv[CRYPTO_ASYM_IV_LENGTH];
	uint8_t				encrypted_private_exponent[CRYPTO_ASYM_KEY_SIZE_MAX];
	uint32_t			encrypted_private_exponent_size;
	uint8_t				hmac[CRYPTO_ASYM_HMAC_LENGTH];
} crypto_rsa_key_type_t;

typedef struct {
	crypto_rsa_key_type_t		*key_material;
	uint32_t			key_material_len;
} crypto_rsa_key_blob_type_t;

typedef struct {
	uint32_t			modulus_size;
	uint64_t			public_exponent;
	tz_rsa_digest_pad_algo_t	digest_pad_type;
} crypto_asym_rsa_keygen_params_t;

typedef enum {
	CRYPTO_STORAGE_FORMAT_RAW_BYTES	= 1,
} crypto_storage_rsa_key_format_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	crypto_rsa_key_blob_type_t	key_blob;
	crypto_asym_rsa_keygen_params_t	rsa_params;
} tz_crypto_asym_gen_keypair_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	int32_t				status;
	unsigned int			key_blob_size;
} tz_crypto_asym_gen_keypair_resp_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	crypto_rsa_key_blob_type_t	key_blob;
	uint8_t*			data;
	size_t				dlen;
	uint8_t*			signeddata;
	uint32_t			signeddata_len;
} tz_crypto_asym_sign_data_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	crypto_rsa_key_blob_type_t	key_blob;
	uint8_t*			data;
	size_t				dlen;
	tz_rsa_digest_pad_algo_t	digest_pad_type;
	uint8_t*			signeddata;
	uint32_t			signeddata_len;
} tz_crypto_asym_sign_data_with_pad_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	size_t				sig_len;
	int32_t				status;
} tz_crypto_asym_sign_data_resp_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	crypto_rsa_key_blob_type_t	key_blob;
	uint8_t*			signed_data;
	size_t				signed_dlen;
	uint8_t*			signature;
	size_t				slen;
} tz_crypto_asym_verify_data_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	int32_t				status;
} tz_crypto_asym_verify_data_resp_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	crypto_rsa_key_blob_type_t	key_blob;
	crypto_storage_rsa_key_format_t	export_format;
	uint8_t*			modulus;
	uint32_t			modulus_size;
	uint8_t*			public_exponent;
	uint32_t			public_exponent_size;
} tz_crypto_storage_rsa_export_key_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	int32_t				status;
	uint32_t			modulus_size;
	uint32_t			public_exponent_size;
	uint32_t			exported_key_len;
} tz_crypto_storage_rsa_export_key_resp_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	uint8_t				modulus[CRYPTO_ASYM_KEY_SIZE_MAX];
	uint32_t			modulus_size;
	uint8_t				public_exponent[CRYPTO_ASYM_PUB_EXP_SIZE_MAX];
	uint32_t			public_exponent_size;
	uint8_t				private_exponent[CRYPTO_ASYM_KEY_SIZE_MAX];
	uint32_t			private_exponent_size;
	tz_rsa_digest_pad_algo_t	digest_pad_type;
	crypto_rsa_key_blob_type_t	key_blob;
} tz_crypto_storage_rsa_import_key_cmd_t;

typedef struct {
	crypto_asym_cmd_t		cmd_id;
	int32_t				status;
} tz_crypto_storage_rsa_import_key_resp_t;

#endif /* __VTZ2_RSA_H__ */