/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

#include <vtz2_scm.h>

int vtz_scm_call(uint32_t scm_service_id, uint32_t scm_cmd_id, vtz_mem_internal_t *tz_memory)
{
	struct scm_desc desc = {0};
	int rc;

	desc.arginfo = TZ_SYSCALL_CREATE_PARAM_ID_4(
		TZ_SYSCALL_PARAM_TYPE_BUF_RW,	/* args[0] */
		TZ_SYSCALL_PARAM_TYPE_VAL,	/* args[1] */
		TZ_SYSCALL_PARAM_TYPE_BUF_RW,	/* args[2] */
		TZ_SYSCALL_PARAM_TYPE_VAL);	/* args[3] */
	desc.args[0] = virt_to_phys(tz_memory->request.addr);
	desc.args[1] = tz_memory->request.size;
	desc.args[2] = virt_to_phys(tz_memory->response.addr);
	desc.args[3] = tz_memory->response.size;

#ifdef CONFIG_HAS_WAKELOCK
	wake_lock(&vtz_drvdata->vtz_wakelock);
#endif

	dmac_flush_range(vtz_mem_begin(&tz_memory->complete), vtz_mem_end(&tz_memory->complete));	/* flush write cache */
	pdev_set_bus(1);										/* enable crypto clocks */
	rc = scm_call2(scm_cmd_id, &desc);								/* call trustzone */
	pdev_set_bus(0);										/* disable crypto clocks */
	dmac_inv_range(vtz_mem_begin(&tz_memory->complete), vtz_mem_end(&tz_memory->complete));		/* invalidate read cache */

#ifdef CONFIG_HAS_WAKELOCK
	wake_lock_timeout(&vtz_drvdata->vtz_wakelock, HZ / 4);	/* 250ms delay */
#endif

	return rc;
}
