#ifndef __VTZ_USER_H__
#define __VTZ_USER_H__
/*
 * vtz Valeo TrustZone user interface for Qualcomm MSM9640 SoC
 *
 *   Copyright (C) 2016 Valeo peiker Telematik GmbH
 *
 *   Author: Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */


/**************************/
/* public user mode types */
/**************************/

#define VTZ_RSA_KEYBLOB_SIZE     1656
#define VTZ_RSA_MODULUS_MAX      (512+16)
#define VTZ_STORAGE_KEYBLOB_SIZE 56

enum vtz_rsa_digest_padding_t {
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_256	= 1,
	VTZ_RSA_DIGEST_PADDING_PSS_SHA2_256	= 2,
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_384	= 3,
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_512	= 4
};

enum vtz_ioctl_cmd_t {
	VTZ_IOCTL_STORAGE_REGISTER	= 0xF0000010,
	VTZ_IOCTL_STORAGE_GENERATE,
	VTZ_IOCTL_STORAGE_SEAL,
	VTZ_IOCTL_STORAGE_UNSEAL,
	VTZ_IOCTL_RSA_REGISTER		= 0xF0000020,
	VTZ_IOCTL_RSA_GENERATE,
	VTZ_IOCTL_RSA_SIGN,
	VTZ_IOCTL_RSA_VERIFY,
	VTZ_IOCTL_RSA_EXPORT,
	VTZ_IOCTL_RSA_SIGN_MHASH,
	VTZ_IOCTL_RSA_IMPORT,
	VTZ_IOCTL_LOG_READ = 0xF0000030,
	VTZ_IOCTL_LOG_GET_COUNT,
	VTZ_IOCTl_LOG_CLEAR,
};

typedef struct {
	void*		addr;
	size_t		size;
} vtz_memory_t;

typedef struct {
	uint64_t	transaction_challenge;
} vtz_ioctl_register_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
} vtz_ioctl_storage_generate_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	sealed;
	vtz_memory_t	unsealed;
} vtz_ioctl_storage_seal_unseal_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	uint64_t	public_exponent;	// e.g. 65537
	int		digest_pad_type;	// DIGEST_PADDING_NONE=0, PKCS115_SHA2_256=1, PSS_SHA2_256=2
	uint16_t	modulus_bitlen;		// e.g. 4096
} vtz_ioctl_rsa_generate_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	data;
	vtz_memory_t	signature;
} vtz_ioctl_rsa_sign_verify_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	modulus;
	uint64_t	public_exponent;	// e.g. 65537
} vtz_ioctl_rsa_export_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	modulus;
	uint64_t	public_exponent;	// e.g. 65537, max. 5 byte (<= 0xFFFFFFFFFF)
	vtz_memory_t	private_exponent;
	int		digest_pad_type;	// DIGEST_PADDING_NONE=0, PKCS115_SHA2_256=1, PSS_SHA2_256=2
} vtz_ioctl_rsa_import_t;

/**************************/
/* ring buffer type definitions */
/**************************/

typedef enum {
	MEM_NO_ERR,
	MEM_COPY_TO_USR_ERR,
	MEM_COPY_FROM_USR_ERR,
	MEM_COPY_TO_TZ_ERR,
	MEM_COPY_FROM_TZ_ERR,
	MEM_ALLOC_ERR,
	TRANSAC_ERR,
	SCM_ERR,
	RESP_ERR,
	STAT_ERR,
	RSA_HASH_SIZE_ERR,      // Only relevant if CONFIG_VTZ2_RSA is enabled
	RSA_PUBLIC_EXP_OF_ERR,  // Only relevant if CONFIG_VTZ2_RSA is enabled
} vtz_err_type_t;

typedef struct {
	vtz_err_type_t error_type;
	int32_t error_code;
} vtz_error;

#endif  /*__VTZ_USER_H__*/