/* ehci-msm-hsic-kmod.c - QTI onchip HSIC driver for EHCI
 *
 * Copyright (c) 2011-2018, The Linux Foundation. All rights reserved.
 *
 * Partly derived from ehci-fsl.c and ehci-hcd.c
 * Copyright (c) 2000-2004 by David Brownell
 * Copyright (c) 2005 MontaVista Software
 *
 * All source code in this file is licensed under the following license except
 * where indicated.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can find it at http://www.fsf.org
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/platform_device.h>

extern struct platform_driver ehci_msm_hsic_driver;

static int __init ehci_msm_hsic_init(void)
{
	int retval = 0;

	retval = platform_driver_register(&ehci_msm_hsic_driver);
	printk(KERN_INFO"%s.platform_driver_register.%d\n", __func__,retval);
	return retval;
}
module_init(ehci_msm_hsic_init);

static void __exit ehci_msm_hsic_cleanup(void)
{
	platform_driver_unregister(&ehci_msm_hsic_driver);
}
module_exit(ehci_msm_hsic_cleanup);

MODULE_DESCRIPTION("QTI onchip HSIC driver for EHCI");
MODULE_AUTHOR ("WNC");
MODULE_LICENSE("GPL");
