/*
    Simple Sound Controller 2
    Copyright 2023 Otto Linnemann

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef SSC_COMMON_H
#define SSC_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif


/*! \file common.h
    \brief common definitions

    \addtogroup config
    @{
 */


/*! maximum number of characters for fully qualified file names in ssc daemon */
#define SSC_MAX_PATH          256
#define SSC_MAX_MSG_LEN       256                           /*!< maximum IPC message payload length */
#define SSC_MAX_BUF_MSGS      30                            /*!< maximum number of IPC messages in buffer */
#define SSC_MAX_ID_LEN        30                            /*!< maximum length of action (verb) id name */
#define SSC_MAX_DEVNAME_LEN   30                            /*!< maximum length of alsa pcm device name */

/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SSC_COMMON_H */
