/*
    Simple Sound Controller 2
    Copyright 2023 Otto Linnemann

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef EVENT_HANDLER_H_
#define EVENT_HANDLER_H_

#include <uv.h>

#ifdef __cplusplus
extern "C" {
#endif

/*! \file event_handler.h
    \brief event handler main callback function

    \addtogroup event_handler
    @{
 */


/*!
 * main event handler which is invoked via libuv
 *
 * \param handle libuv async handle
 */
void ssc_event_handler( uv_async_t* handle );


/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef EVENT_HANDLER_ */
