/*
    Simple Sound Controller 2
    Copyright 2023 Otto Linnemann

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef MEDIATYPE_H
#define MEDIATYPE_H

#include <config.h>

#ifdef __cplusplus
extern "C" {
#endif


/*! \file mediatype.h
    \brief utility functions for playback mediatypes

    \addtogroup tasks
    @{
 */


/*!
 * playback media type
 */
typedef enum {
  ssc_media_invalid,          /*!< media type is not supported */
  ssc_media_wav,              /*!< microsoft wav file format */
#if HAVE_LIBMAD
  ssc_media_mp3               /*!< mp3 container file format */
#endif
} ssc_media_t;


/*!
 * assign media type to given file name
 *
 * \param filename name of the playback file
 * \return mediatype of ssc_media_invalid if not supported
 */
ssc_media_t ssc_media_type( const char* filename );

/*!
 * test function for ssc_media_type
 *
 * \return negative error code in case of error
 */
int ssc_media_type_test( void );

/*! @} */

#ifdef __cplusplus
}
#endif


#endif /* #ifndef MEDIATYPE_H */
