/*
    Simple Sound Controller 2
    Copyright 2023 Otto Linnemann

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef SSC_H
#define SSC_H

#include <uv.h>
#include <pthread.h>
#include <olcutils/clist.h>
#include <ssc_events.h>
#include <ssc_control.h>
#include <ssc_tasks.h>

#ifdef __cplusplus
extern "C" {
#endif


/*! \file ssc.h
    \brief global data context

    \addtogroup control
    @{
 */

typedef struct {
  ssc_events_t*         p_ssc_events;
  ssc_control_t*        p_ssc_control;
  ssc_tasks_t*          p_ssc_tasks;
} ssc_t;


/*!
 * main entry point into ssc2
 *
 * \return 0 in case of error-free graceful termination, otherwise negative error code
 */
int sscd2(void);


/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SSC_H */
