/* Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _BOLERO_CDC_REGISTERS_H
#define _BOLERO_CDC_REGISTERS_H

#define TX_START_OFFSET 0x0000

#define BOLERO_CDC_TX_CLK_RST_CTRL_MCLK_CONTROL (TX_START_OFFSET + 0x0000)
#define BOLERO_CDC_TX_CLK_RST_CTRL_FS_CNT_CONTROL (TX_START_OFFSET + 0x0004)
#define BOLERO_CDC_TX_CLK_RST_CTRL_SWR_CONTROL	(TX_START_OFFSET + 0x0008)
#define BOLERO_CDC_TX_TOP_CSR_TOP_CFG0		(TX_START_OFFSET + 0x0080)
#define BOLERO_CDC_TX_TOP_CSR_ANC_CFG		(TX_START_OFFSET + 0x0084)
#define BOLERO_CDC_TX_TOP_CSR_SWR_CTRL		(TX_START_OFFSET + 0x0088)
#define BOLERO_CDC_TX_TOP_CSR_FREQ_MCLK		(TX_START_OFFSET + 0x0090)
#define BOLERO_CDC_TX_TOP_CSR_DEBUG_BUS		(TX_START_OFFSET + 0x0094)
#define BOLERO_CDC_TX_TOP_CSR_DEBUG_EN		(TX_START_OFFSET + 0x0098)
#define BOLERO_CDC_TX_TOP_CSR_TX_I2S_CTL	(TX_START_OFFSET + 0x00A4)
#define BOLERO_CDC_TX_TOP_CSR_I2S_CLK		(TX_START_OFFSET + 0x00A8)
#define BOLERO_CDC_TX_TOP_CSR_I2S_RESET		(TX_START_OFFSET + 0x00AC)
#define BOLERO_CDC_TX_TOP_CSR_SWR_DMIC0_CTL	(TX_START_OFFSET + 0x00C0)
#define BOLERO_CDC_TX_TOP_CSR_SWR_DMIC1_CTL	(TX_START_OFFSET + 0x00C4)
#define BOLERO_CDC_TX_TOP_CSR_SWR_DMIC2_CTL	(TX_START_OFFSET + 0x00C8)
#define BOLERO_CDC_TX_TOP_CSR_SWR_DMIC3_CTL	(TX_START_OFFSET + 0x00CC)
#define BOLERO_CDC_TX_TOP_CSR_SWR_AMIC0_CTL	(TX_START_OFFSET + 0x00D0)
#define BOLERO_CDC_TX_TOP_CSR_SWR_AMIC1_CTL	(TX_START_OFFSET + 0x00D4)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX0_CFG0	(TX_START_OFFSET + 0x0100)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX0_CFG1	(TX_START_OFFSET + 0x0104)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX1_CFG0	(TX_START_OFFSET + 0x0108)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX1_CFG1	(TX_START_OFFSET + 0x010C)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX2_CFG0	(TX_START_OFFSET + 0x0110)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX2_CFG1	(TX_START_OFFSET + 0x0114)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX3_CFG0	(TX_START_OFFSET + 0x0118)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX3_CFG1	(TX_START_OFFSET + 0x011C)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX4_CFG0	(TX_START_OFFSET + 0x0120)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX4_CFG1	(TX_START_OFFSET + 0x0124)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX5_CFG0	(TX_START_OFFSET + 0x0128)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX5_CFG1	(TX_START_OFFSET + 0x012C)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX6_CFG0	(TX_START_OFFSET + 0x0130)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX6_CFG1	(TX_START_OFFSET + 0x0134)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX7_CFG0	(TX_START_OFFSET + 0x0138)
#define BOLERO_CDC_TX_INP_MUX_ADC_MUX7_CFG1	(TX_START_OFFSET + 0x013C)
#define BOLERO_CDC_TX_ANC0_CLK_RESET_CTL	(TX_START_OFFSET + 0x0200)
#define BOLERO_CDC_TX_ANC0_MODE_1_CTL		(TX_START_OFFSET + 0x0204)
#define BOLERO_CDC_TX_ANC0_MODE_2_CTL		(TX_START_OFFSET + 0x0208)
#define BOLERO_CDC_TX_ANC0_FF_SHIFT		(TX_START_OFFSET + 0x020C)
#define BOLERO_CDC_TX_ANC0_FB_SHIFT		(TX_START_OFFSET + 0x0210)
#define BOLERO_CDC_TX_ANC0_LPF_FF_A_CTL	(TX_START_OFFSET + 0x0214)
#define BOLERO_CDC_TX_ANC0_LPF_FF_B_CTL	(TX_START_OFFSET + 0x0218)
#define BOLERO_CDC_TX_ANC0_LPF_FB_CTL	(TX_START_OFFSET + 0x021C)
#define BOLERO_CDC_TX_ANC0_SMLPF_CTL	(TX_START_OFFSET + 0x0220)
#define BOLERO_CDC_TX_ANC0_DCFLT_SHIFT_CTL	(TX_START_OFFSET + 0x0224)
#define BOLERO_CDC_TX_ANC0_IIR_ADAPT_CTL	(TX_START_OFFSET + 0x0228)
#define BOLERO_CDC_TX_ANC0_IIR_COEFF_1_CTL	(TX_START_OFFSET + 0x022C)
#define BOLERO_CDC_TX_ANC0_IIR_COEFF_2_CTL	(TX_START_OFFSET + 0x0230)
#define BOLERO_CDC_TX_ANC0_FF_A_GAIN_CTL	(TX_START_OFFSET + 0x0234)
#define BOLERO_CDC_TX_ANC0_FF_B_GAIN_CTL	(TX_START_OFFSET + 0x0238)
#define BOLERO_CDC_TX_ANC0_FB_GAIN_CTL	(TX_START_OFFSET + 0x023C)
#define BOLERO_CDC_TX0_TX_PATH_CTL	(TX_START_OFFSET + 0x0400)
#define BOLERO_CDC_TX0_TX_PATH_CFG0	(TX_START_OFFSET + 0x0404)
#define BOLERO_CDC_TX0_TX_PATH_CFG1	(TX_START_OFFSET + 0x0408)
#define BOLERO_CDC_TX0_TX_VOL_CTL	(TX_START_OFFSET + 0x040C)
#define BOLERO_CDC_TX0_TX_PATH_SEC0	(TX_START_OFFSET + 0x0410)
#define BOLERO_CDC_TX0_TX_PATH_SEC1	(TX_START_OFFSET + 0x0414)
#define BOLERO_CDC_TX0_TX_PATH_SEC2	(TX_START_OFFSET + 0x0418)
#define BOLERO_CDC_TX0_TX_PATH_SEC3	(TX_START_OFFSET + 0x041C)
#define BOLERO_CDC_TX0_TX_PATH_SEC4	(TX_START_OFFSET + 0x0420)
#define BOLERO_CDC_TX0_TX_PATH_SEC5	(TX_START_OFFSET + 0x0424)
#define BOLERO_CDC_TX0_TX_PATH_SEC6	(TX_START_OFFSET + 0x0428)
#define BOLERO_CDC_TX0_TX_PATH_SEC7	(TX_START_OFFSET + 0x042C)
#define BOLERO_CDC_TX1_TX_PATH_CTL	(TX_START_OFFSET + 0x0480)
#define BOLERO_CDC_TX1_TX_PATH_CFG0	(TX_START_OFFSET + 0x0484)
#define BOLERO_CDC_TX1_TX_PATH_CFG1	(TX_START_OFFSET + 0x0488)
#define BOLERO_CDC_TX1_TX_VOL_CTL	(TX_START_OFFSET + 0x048C)
#define BOLERO_CDC_TX1_TX_PATH_SEC0	(TX_START_OFFSET + 0x0490)
#define BOLERO_CDC_TX1_TX_PATH_SEC1	(TX_START_OFFSET + 0x0494)
#define BOLERO_CDC_TX1_TX_PATH_SEC2	(TX_START_OFFSET + 0x0498)
#define BOLERO_CDC_TX1_TX_PATH_SEC3	(TX_START_OFFSET + 0x049C)
#define BOLERO_CDC_TX1_TX_PATH_SEC4	(TX_START_OFFSET + 0x04A0)
#define BOLERO_CDC_TX1_TX_PATH_SEC5	(TX_START_OFFSET + 0x04A4)
#define BOLERO_CDC_TX1_TX_PATH_SEC6	(TX_START_OFFSET + 0x04A8)
#define BOLERO_CDC_TX2_TX_PATH_CTL	(TX_START_OFFSET + 0x0500)
#define BOLERO_CDC_TX2_TX_PATH_CFG0	(TX_START_OFFSET + 0x0504)
#define BOLERO_CDC_TX2_TX_PATH_CFG1	(TX_START_OFFSET + 0x0508)
#define BOLERO_CDC_TX2_TX_VOL_CTL	(TX_START_OFFSET + 0x050C)
#define BOLERO_CDC_TX2_TX_PATH_SEC0	(TX_START_OFFSET + 0x0510)
#define BOLERO_CDC_TX2_TX_PATH_SEC1	(TX_START_OFFSET + 0x0514)
#define BOLERO_CDC_TX2_TX_PATH_SEC2	(TX_START_OFFSET + 0x0518)
#define BOLERO_CDC_TX2_TX_PATH_SEC3	(TX_START_OFFSET + 0x051C)
#define BOLERO_CDC_TX2_TX_PATH_SEC4	(TX_START_OFFSET + 0x0520)
#define BOLERO_CDC_TX2_TX_PATH_SEC5	(TX_START_OFFSET + 0x0524)
#define BOLERO_CDC_TX2_TX_PATH_SEC6	(TX_START_OFFSET + 0x0528)
#define BOLERO_CDC_TX3_TX_PATH_CTL	(TX_START_OFFSET + 0x0580)
#define BOLERO_CDC_TX3_TX_PATH_CFG0	(TX_START_OFFSET + 0x0584)
#define BOLERO_CDC_TX3_TX_PATH_CFG1	(TX_START_OFFSET + 0x0588)
#define BOLERO_CDC_TX3_TX_VOL_CTL	(TX_START_OFFSET + 0x058C)
#define BOLERO_CDC_TX3_TX_PATH_SEC0	(TX_START_OFFSET + 0x0590)
#define BOLERO_CDC_TX3_TX_PATH_SEC1	(TX_START_OFFSET + 0x0594)
#define BOLERO_CDC_TX3_TX_PATH_SEC2	(TX_START_OFFSET + 0x0598)
#define BOLERO_CDC_TX3_TX_PATH_SEC3	(TX_START_OFFSET + 0x059C)
#define BOLERO_CDC_TX3_TX_PATH_SEC4	(TX_START_OFFSET + 0x05A0)
#define BOLERO_CDC_TX3_TX_PATH_SEC5	(TX_START_OFFSET + 0x05A4)
#define BOLERO_CDC_TX3_TX_PATH_SEC6	(TX_START_OFFSET + 0x05A8)
#define BOLERO_CDC_TX4_TX_PATH_CTL	(TX_START_OFFSET + 0x0600)
#define BOLERO_CDC_TX4_TX_PATH_CFG0	(TX_START_OFFSET + 0x0604)
#define BOLERO_CDC_TX4_TX_PATH_CFG1	(TX_START_OFFSET + 0x0608)
#define BOLERO_CDC_TX4_TX_VOL_CTL	(TX_START_OFFSET + 0x060C)
#define BOLERO_CDC_TX4_TX_PATH_SEC0	(TX_START_OFFSET + 0x0610)
#define BOLERO_CDC_TX4_TX_PATH_SEC1	(TX_START_OFFSET + 0x0614)
#define BOLERO_CDC_TX4_TX_PATH_SEC2	(TX_START_OFFSET + 0x0618)
#define BOLERO_CDC_TX4_TX_PATH_SEC3	(TX_START_OFFSET + 0x061C)
#define BOLERO_CDC_TX4_TX_PATH_SEC4	(TX_START_OFFSET + 0x0620)
#define BOLERO_CDC_TX4_TX_PATH_SEC5	(TX_START_OFFSET + 0x0624)
#define BOLERO_CDC_TX4_TX_PATH_SEC6	(TX_START_OFFSET + 0x0628)
#define BOLERO_CDC_TX5_TX_PATH_CTL	(TX_START_OFFSET + 0x0680)
#define BOLERO_CDC_TX5_TX_PATH_CFG0	(TX_START_OFFSET + 0x0684)
#define BOLERO_CDC_TX5_TX_PATH_CFG1	(TX_START_OFFSET + 0x0688)
#define BOLERO_CDC_TX5_TX_VOL_CTL	(TX_START_OFFSET + 0x068C)
#define BOLERO_CDC_TX5_TX_PATH_SEC0	(TX_START_OFFSET + 0x0690)
#define BOLERO_CDC_TX5_TX_PATH_SEC1	(TX_START_OFFSET + 0x0694)
#define BOLERO_CDC_TX5_TX_PATH_SEC2	(TX_START_OFFSET + 0x0698)
#define BOLERO_CDC_TX5_TX_PATH_SEC3	(TX_START_OFFSET + 0x069C)
#define BOLERO_CDC_TX5_TX_PATH_SEC4	(TX_START_OFFSET + 0x06A0)
#define BOLERO_CDC_TX5_TX_PATH_SEC5	(TX_START_OFFSET + 0x06A4)
#define BOLERO_CDC_TX5_TX_PATH_SEC6	(TX_START_OFFSET + 0x06A8)
#define BOLERO_CDC_TX6_TX_PATH_CTL	(TX_START_OFFSET + 0x0700)
#define BOLERO_CDC_TX6_TX_PATH_CFG0	(TX_START_OFFSET + 0x0704)
#define BOLERO_CDC_TX6_TX_PATH_CFG1	(TX_START_OFFSET + 0x0708)
#define BOLERO_CDC_TX6_TX_VOL_CTL	(TX_START_OFFSET + 0x070C)
#define BOLERO_CDC_TX6_TX_PATH_SEC0	(TX_START_OFFSET + 0x0710)
#define BOLERO_CDC_TX6_TX_PATH_SEC1	(TX_START_OFFSET + 0x0714)
#define BOLERO_CDC_TX6_TX_PATH_SEC2	(TX_START_OFFSET + 0x0718)
#define BOLERO_CDC_TX6_TX_PATH_SEC3	(TX_START_OFFSET + 0x071C)
#define BOLERO_CDC_TX6_TX_PATH_SEC4	(TX_START_OFFSET + 0x0720)
#define BOLERO_CDC_TX6_TX_PATH_SEC5	(TX_START_OFFSET + 0x0724)
#define BOLERO_CDC_TX6_TX_PATH_SEC6	(TX_START_OFFSET + 0x0728)
#define BOLERO_CDC_TX7_TX_PATH_CTL	(TX_START_OFFSET + 0x0780)
#define BOLERO_CDC_TX7_TX_PATH_CFG0	(TX_START_OFFSET + 0x0784)
#define BOLERO_CDC_TX7_TX_PATH_CFG1	(TX_START_OFFSET + 0x0788)
#define BOLERO_CDC_TX7_TX_VOL_CTL	(TX_START_OFFSET + 0x078C)
#define BOLERO_CDC_TX7_TX_PATH_SEC0	(TX_START_OFFSET + 0x0790)
#define BOLERO_CDC_TX7_TX_PATH_SEC1	(TX_START_OFFSET + 0x0794)
#define BOLERO_CDC_TX7_TX_PATH_SEC2	(TX_START_OFFSET + 0x0798)
#define BOLERO_CDC_TX7_TX_PATH_SEC3	(TX_START_OFFSET + 0x079C)
#define BOLERO_CDC_TX7_TX_PATH_SEC4	(TX_START_OFFSET + 0x07A0)
#define BOLERO_CDC_TX7_TX_PATH_SEC5	(TX_START_OFFSET + 0x07A4)
#define BOLERO_CDC_TX7_TX_PATH_SEC6	(TX_START_OFFSET + 0x07A8)
#define TX_MAX_OFFSET			(TX_START_OFFSET + 0x07A8)

#define BOLERO_CDC_TX_MACRO_MAX 0x1EB /* 7A8/4 = 1EA + 1 */

#define RX_START_OFFSET				0x1000
#define BOLERO_CDC_RX_TOP_TOP_CFG0		(RX_START_OFFSET + 0x0000)
#define BOLERO_CDC_RX_TOP_SWR_CTRL		(RX_START_OFFSET + 0x0008)
#define BOLERO_CDC_RX_TOP_DEBUG			(RX_START_OFFSET + 0x000C)
#define BOLERO_CDC_RX_TOP_DEBUG_BUS		(RX_START_OFFSET + 0x0010)
#define BOLERO_CDC_RX_TOP_DEBUG_EN0		(RX_START_OFFSET + 0x0014)
#define BOLERO_CDC_RX_TOP_DEBUG_EN1		(RX_START_OFFSET + 0x0018)
#define BOLERO_CDC_RX_TOP_DEBUG_EN2		(RX_START_OFFSET + 0x001C)
#define BOLERO_CDC_RX_TOP_HPHL_COMP_WR_LSB	(RX_START_OFFSET + 0x0020)
#define BOLERO_CDC_RX_TOP_HPHL_COMP_WR_MSB	(RX_START_OFFSET + 0x0024)
#define BOLERO_CDC_RX_TOP_HPHL_COMP_LUT		(RX_START_OFFSET + 0x0028)
#define BOLERO_CDC_RX_TOP_HPHL_COMP_RD_LSB	(RX_START_OFFSET + 0x002C)
#define BOLERO_CDC_RX_TOP_HPHL_COMP_RD_MSB	(RX_START_OFFSET + 0x0030)
#define BOLERO_CDC_RX_TOP_HPHR_COMP_WR_LSB	(RX_START_OFFSET + 0x0034)
#define BOLERO_CDC_RX_TOP_HPHR_COMP_WR_MSB	(RX_START_OFFSET + 0x0038)
#define BOLERO_CDC_RX_TOP_HPHR_COMP_LUT		(RX_START_OFFSET + 0x003C)
#define BOLERO_CDC_RX_TOP_HPHR_COMP_RD_LSB	(RX_START_OFFSET + 0x0040)
#define BOLERO_CDC_RX_TOP_HPHR_COMP_RD_MSB	(RX_START_OFFSET + 0x0044)
#define BOLERO_CDC_RX_TOP_DSD0_DEBUG_CFG0	(RX_START_OFFSET + 0x0070)
#define BOLERO_CDC_RX_TOP_DSD0_DEBUG_CFG1	(RX_START_OFFSET + 0x0074)
#define BOLERO_CDC_RX_TOP_DSD0_DEBUG_CFG2	(RX_START_OFFSET + 0x0078)
#define BOLERO_CDC_RX_TOP_DSD0_DEBUG_CFG3	(RX_START_OFFSET + 0x007C)
#define BOLERO_CDC_RX_TOP_DSD1_DEBUG_CFG0	(RX_START_OFFSET + 0x0080)
#define BOLERO_CDC_RX_TOP_DSD1_DEBUG_CFG1	(RX_START_OFFSET + 0x0084)
#define BOLERO_CDC_RX_TOP_DSD1_DEBUG_CFG2	(RX_START_OFFSET + 0x0088)
#define BOLERO_CDC_RX_TOP_DSD1_DEBUG_CFG3	(RX_START_OFFSET + 0x008C)
#define BOLERO_CDC_RX_TOP_RX_I2S_CTL		(RX_START_OFFSET + 0x0090)
#define BOLERO_CDC_RX_TOP_TX_I2S2_CTL		(RX_START_OFFSET + 0x0094)
#define BOLERO_CDC_RX_TOP_I2S_CLK		(RX_START_OFFSET + 0x0098)
#define BOLERO_CDC_RX_TOP_I2S_RESET		(RX_START_OFFSET + 0x009C)
#define BOLERO_CDC_RX_TOP_I2S_MUX		(RX_START_OFFSET + 0x00A0)
#define BOLERO_CDC_RX_CLK_RST_CTRL_MCLK_CONTROL	(RX_START_OFFSET + 0x0100)
#define BOLERO_CDC_RX_CLK_RST_CTRL_FS_CNT_CONTROL \
						(RX_START_OFFSET + 0x0104)
#define BOLERO_CDC_RX_CLK_RST_CTRL_SWR_CONTROL	(RX_START_OFFSET + 0x0108)
#define BOLERO_CDC_RX_CLK_RST_CTRL_DSD_CONTROL	(RX_START_OFFSET + 0x010C)
#define BOLERO_CDC_RX_CLK_RST_CTRL_ASRC_SHARE_CONTROL \
						(RX_START_OFFSET + 0x0110)
#define BOLERO_CDC_RX_SOFTCLIP_CRC		(RX_START_OFFSET + 0x0140)
#define BOLERO_CDC_RX_SOFTCLIP_SOFTCLIP_CTRL	(RX_START_OFFSET + 0x0144)
#define BOLERO_CDC_RX_INP_MUX_RX_INT0_CFG0	(RX_START_OFFSET + 0x0180)
#define BOLERO_CDC_RX_INP_MUX_RX_INT0_CFG1	(RX_START_OFFSET + 0x0184)
#define BOLERO_CDC_RX_INP_MUX_RX_INT1_CFG0	(RX_START_OFFSET + 0x0188)
#define BOLERO_CDC_RX_INP_MUX_RX_INT1_CFG1	(RX_START_OFFSET + 0x018C)
#define BOLERO_CDC_RX_INP_MUX_RX_INT2_CFG0	(RX_START_OFFSET + 0x0190)
#define BOLERO_CDC_RX_INP_MUX_RX_INT2_CFG1	(RX_START_OFFSET + 0x0194)
#define BOLERO_CDC_RX_INP_MUX_RX_MIX_CFG4	(RX_START_OFFSET + 0x0198)
#define BOLERO_CDC_RX_INP_MUX_RX_MIX_CFG5	(RX_START_OFFSET + 0x019C)
#define BOLERO_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0	(RX_START_OFFSET + 0x01A0)
#define BOLERO_CDC_RX_CLSH_CRC			(RX_START_OFFSET + 0x0200)
#define BOLERO_CDC_RX_CLSH_DLY_CTRL		(RX_START_OFFSET + 0x0204)
#define BOLERO_CDC_RX_CLSH_DECAY_CTRL		(RX_START_OFFSET + 0x0208)
#define BOLERO_CDC_RX_CLSH_HPH_V_PA		(RX_START_OFFSET + 0x020C)
#define BOLERO_CDC_RX_CLSH_EAR_V_PA		(RX_START_OFFSET + 0x0210)
#define BOLERO_CDC_RX_CLSH_HPH_V_HD		(RX_START_OFFSET + 0x0214)
#define BOLERO_CDC_RX_CLSH_EAR_V_HD		(RX_START_OFFSET + 0x0218)
#define BOLERO_CDC_RX_CLSH_K1_MSB		(RX_START_OFFSET + 0x021C)
#define BOLERO_CDC_RX_CLSH_K1_LSB		(RX_START_OFFSET + 0x0220)
#define BOLERO_CDC_RX_CLSH_K2_MSB		(RX_START_OFFSET + 0x0224)
#define BOLERO_CDC_RX_CLSH_K2_LSB		(RX_START_OFFSET + 0x0228)
#define BOLERO_CDC_RX_CLSH_IDLE_CTRL		(RX_START_OFFSET + 0x022C)
#define BOLERO_CDC_RX_CLSH_IDLE_HPH		(RX_START_OFFSET + 0x0230)
#define BOLERO_CDC_RX_CLSH_IDLE_EAR		(RX_START_OFFSET + 0x0234)
#define BOLERO_CDC_RX_CLSH_TEST0		(RX_START_OFFSET + 0x0238)
#define BOLERO_CDC_RX_CLSH_TEST1		(RX_START_OFFSET + 0x023C)
#define BOLERO_CDC_RX_CLSH_OVR_VREF		(RX_START_OFFSET + 0x0240)
#define BOLERO_CDC_RX_CLSH_CLSG_CTL		(RX_START_OFFSET + 0x0244)
#define BOLERO_CDC_RX_CLSH_CLSG_CFG1		(RX_START_OFFSET + 0x0248)
#define BOLERO_CDC_RX_CLSH_CLSG_CFG2		(RX_START_OFFSET + 0x024C)
#define BOLERO_CDC_RX_BCL_VBAT_PATH_CTL		(RX_START_OFFSET + 0x0280)
#define BOLERO_CDC_RX_BCL_VBAT_CFG		(RX_START_OFFSET + 0x0284)
#define BOLERO_CDC_RX_BCL_VBAT_ADC_CAL1		(RX_START_OFFSET + 0x0288)
#define BOLERO_CDC_RX_BCL_VBAT_ADC_CAL2		(RX_START_OFFSET + 0x028C)
#define BOLERO_CDC_RX_BCL_VBAT_ADC_CAL3		(RX_START_OFFSET + 0x0290)
#define BOLERO_CDC_RX_BCL_VBAT_PK_EST1		(RX_START_OFFSET + 0x0294)
#define BOLERO_CDC_RX_BCL_VBAT_PK_EST2		(RX_START_OFFSET + 0x0298)
#define BOLERO_CDC_RX_BCL_VBAT_PK_EST3		(RX_START_OFFSET + 0x029C)
#define BOLERO_CDC_RX_BCL_VBAT_RF_PROC1		(RX_START_OFFSET + 0x02A0)
#define BOLERO_CDC_RX_BCL_VBAT_RF_PROC2		(RX_START_OFFSET + 0x02A4)
#define BOLERO_CDC_RX_BCL_VBAT_TAC1		(RX_START_OFFSET + 0x02A8)
#define BOLERO_CDC_RX_BCL_VBAT_TAC2		(RX_START_OFFSET + 0x02AC)
#define BOLERO_CDC_RX_BCL_VBAT_TAC3		(RX_START_OFFSET + 0x02B0)
#define BOLERO_CDC_RX_BCL_VBAT_TAC4		(RX_START_OFFSET + 0x02B4)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD1	(RX_START_OFFSET + 0x02B8)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD2	(RX_START_OFFSET + 0x02BC)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD3	(RX_START_OFFSET + 0x02C0)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD4	(RX_START_OFFSET + 0x02C4)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD5	(RX_START_OFFSET + 0x02C8)
#define BOLERO_CDC_RX_BCL_VBAT_DEBUG1		(RX_START_OFFSET + 0x02CC)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_UPD_MON	(RX_START_OFFSET + 0x02D0)
#define BOLERO_CDC_RX_BCL_VBAT_GAIN_MON_VAL	(RX_START_OFFSET + 0x02D4)
#define BOLERO_CDC_RX_BCL_VBAT_BAN		(RX_START_OFFSET + 0x02D8)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD1	(RX_START_OFFSET + 0x02DC)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD2	(RX_START_OFFSET + 0x02E0)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD3	(RX_START_OFFSET + 0x02E4)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD4	(RX_START_OFFSET + 0x02E8)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD5	(RX_START_OFFSET + 0x02EC)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD6	(RX_START_OFFSET + 0x02F0)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD7	(RX_START_OFFSET + 0x02F4)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD8	(RX_START_OFFSET + 0x02F8)
#define BOLERO_CDC_RX_BCL_VBAT_BCL_GAIN_UPD9	(RX_START_OFFSET + 0x02FC)
#define BOLERO_CDC_RX_BCL_VBAT_ATTN1		(RX_START_OFFSET + 0x0300)
#define BOLERO_CDC_RX_BCL_VBAT_ATTN2		(RX_START_OFFSET + 0x0304)
#define BOLERO_CDC_RX_BCL_VBAT_ATTN3		(RX_START_OFFSET + 0x0308)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CTL1	(RX_START_OFFSET + 0x030C)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CTL2	(RX_START_OFFSET + 0x0310)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CFG1	(RX_START_OFFSET + 0x0314)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CFG2	(RX_START_OFFSET + 0x0318)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CFG3	(RX_START_OFFSET + 0x031C)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_CFG4	(RX_START_OFFSET + 0x0320)
#define BOLERO_CDC_RX_BCL_VBAT_DECODE_ST	(RX_START_OFFSET + 0x0324)
#define BOLERO_CDC_RX_INTR_CTRL_CFG		(RX_START_OFFSET + 0x0340)
#define BOLERO_CDC_RX_INTR_CTRL_CLR_COMMIT	(RX_START_OFFSET + 0x0344)
#define BOLERO_CDC_RX_INTR_CTRL_PIN1_MASK0	(RX_START_OFFSET + 0x0360)
#define BOLERO_CDC_RX_INTR_CTRL_PIN1_STATUS0	(RX_START_OFFSET + 0x0368)
#define BOLERO_CDC_RX_INTR_CTRL_PIN1_CLEAR0	(RX_START_OFFSET + 0x0370)
#define BOLERO_CDC_RX_INTR_CTRL_PIN2_MASK0	(RX_START_OFFSET + 0x0380)
#define BOLERO_CDC_RX_INTR_CTRL_PIN2_STATUS0	(RX_START_OFFSET + 0x0388)
#define BOLERO_CDC_RX_INTR_CTRL_PIN2_CLEAR0	(RX_START_OFFSET + 0x0390)
#define BOLERO_CDC_RX_INTR_CTRL_LEVEL0		(RX_START_OFFSET + 0x03C0)
#define BOLERO_CDC_RX_INTR_CTRL_BYPASS0		(RX_START_OFFSET + 0x03C8)
#define BOLERO_CDC_RX_INTR_CTRL_SET0		(RX_START_OFFSET + 0x03D0)
#define BOLERO_CDC_RX_RX0_RX_PATH_CTL		(RX_START_OFFSET + 0x0400)
#define BOLERO_CDC_RX_RX0_RX_PATH_CFG0		(RX_START_OFFSET + 0x0404)
#define BOLERO_CDC_RX_RX0_RX_PATH_CFG1		(RX_START_OFFSET + 0x0408)
#define BOLERO_CDC_RX_RX0_RX_PATH_CFG2		(RX_START_OFFSET + 0x040C)
#define BOLERO_CDC_RX_RX0_RX_PATH_CFG3		(RX_START_OFFSET + 0x0410)
#define BOLERO_CDC_RX_RX0_RX_VOL_CTL		(RX_START_OFFSET + 0x0414)
#define BOLERO_CDC_RX_RX0_RX_PATH_MIX_CTL	(RX_START_OFFSET + 0x0418)
#define BOLERO_CDC_RX_RX0_RX_PATH_MIX_CFG	(RX_START_OFFSET + 0x041C)
#define BOLERO_CDC_RX_RX0_RX_VOL_MIX_CTL	(RX_START_OFFSET + 0x0420)
#define BOLERO_CDC_RX_RX0_RX_PATH_SEC1		(RX_START_OFFSET + 0x0424)
#define BOLERO_CDC_RX_RX0_RX_PATH_SEC2		(RX_START_OFFSET + 0x0428)
#define BOLERO_CDC_RX_RX0_RX_PATH_SEC3		(RX_START_OFFSET + 0x042C)
#define BOLERO_CDC_RX_RX0_RX_PATH_SEC4		(RX_START_OFFSET + 0x0430)
#define BOLERO_CDC_RX_RX0_RX_PATH_SEC7		(RX_START_OFFSET + 0x0434)
#define BOLERO_CDC_RX_RX0_RX_PATH_MIX_SEC0	(RX_START_OFFSET + 0x0438)
#define BOLERO_CDC_RX_RX0_RX_PATH_MIX_SEC1	(RX_START_OFFSET + 0x043C)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_CTL	(RX_START_OFFSET + 0x0440)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA1	(RX_START_OFFSET + 0x0444)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA2	(RX_START_OFFSET + 0x0448)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA3	(RX_START_OFFSET + 0x044C)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA4	(RX_START_OFFSET + 0x0450)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA5	(RX_START_OFFSET + 0x0454)
#define BOLERO_CDC_RX_RX0_RX_PATH_DSM_DATA6	(RX_START_OFFSET + 0x0458)
#define BOLERO_CDC_RX_RX1_RX_PATH_CTL		(RX_START_OFFSET + 0x0480)
#define BOLERO_CDC_RX_RX1_RX_PATH_CFG0		(RX_START_OFFSET + 0x0484)
#define BOLERO_CDC_RX_RX1_RX_PATH_CFG1		(RX_START_OFFSET + 0x0488)
#define BOLERO_CDC_RX_RX1_RX_PATH_CFG2		(RX_START_OFFSET + 0x048C)
#define BOLERO_CDC_RX_RX1_RX_PATH_CFG3		(RX_START_OFFSET + 0x0490)
#define BOLERO_CDC_RX_RX1_RX_VOL_CTL		(RX_START_OFFSET + 0x0494)
#define BOLERO_CDC_RX_RX1_RX_PATH_MIX_CTL	(RX_START_OFFSET + 0x0498)
#define BOLERO_CDC_RX_RX1_RX_PATH_MIX_CFG	(RX_START_OFFSET + 0x049C)
#define BOLERO_CDC_RX_RX1_RX_VOL_MIX_CTL	(RX_START_OFFSET + 0x04A0)
#define BOLERO_CDC_RX_RX1_RX_PATH_SEC1		(RX_START_OFFSET + 0x04A4)
#define BOLERO_CDC_RX_RX1_RX_PATH_SEC2		(RX_START_OFFSET + 0x04A8)
#define BOLERO_CDC_RX_RX1_RX_PATH_SEC3		(RX_START_OFFSET + 0x04AC)
#define BOLERO_CDC_RX_RX1_RX_PATH_SEC4		(RX_START_OFFSET + 0x04B0)
#define BOLERO_CDC_RX_RX1_RX_PATH_SEC7		(RX_START_OFFSET + 0x04B4)
#define BOLERO_CDC_RX_RX1_RX_PATH_MIX_SEC0	(RX_START_OFFSET + 0x04B8)
#define BOLERO_CDC_RX_RX1_RX_PATH_MIX_SEC1	(RX_START_OFFSET + 0x04BC)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_CTL	(RX_START_OFFSET + 0x04C0)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA1	(RX_START_OFFSET + 0x04C4)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA2	(RX_START_OFFSET + 0x04C8)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA3	(RX_START_OFFSET + 0x04CC)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA4	(RX_START_OFFSET + 0x04D0)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA5	(RX_START_OFFSET + 0x04D4)
#define BOLERO_CDC_RX_RX1_RX_PATH_DSM_DATA6	(RX_START_OFFSET + 0x04D8)
#define BOLERO_CDC_RX_RX2_RX_PATH_CTL		(RX_START_OFFSET + 0x0500)
#define BOLERO_CDC_RX_RX2_RX_PATH_CFG0		(RX_START_OFFSET + 0x0504)
#define BOLERO_CDC_RX_RX2_RX_PATH_CFG1		(RX_START_OFFSET + 0x0508)
#define BOLERO_CDC_RX_RX2_RX_PATH_CFG2		(RX_START_OFFSET + 0x050C)
#define BOLERO_CDC_RX_RX2_RX_PATH_CFG3		(RX_START_OFFSET + 0x0510)
#define BOLERO_CDC_RX_RX2_RX_VOL_CTL		(RX_START_OFFSET + 0x0514)
#define BOLERO_CDC_RX_RX2_RX_PATH_MIX_CTL	(RX_START_OFFSET + 0x0518)
#define BOLERO_CDC_RX_RX2_RX_PATH_MIX_CFG	(RX_START_OFFSET + 0x051C)
#define BOLERO_CDC_RX_RX2_RX_VOL_MIX_CTL	(RX_START_OFFSET + 0x0520)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC0		(RX_START_OFFSET + 0x0524)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC1		(RX_START_OFFSET + 0x0528)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC2		(RX_START_OFFSET + 0x052C)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC3		(RX_START_OFFSET + 0x0530)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC4		(RX_START_OFFSET + 0x0534)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC5		(RX_START_OFFSET + 0x0538)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC6		(RX_START_OFFSET + 0x053C)
#define BOLERO_CDC_RX_RX2_RX_PATH_SEC7		(RX_START_OFFSET + 0x0540)
#define BOLERO_CDC_RX_RX2_RX_PATH_MIX_SEC0	(RX_START_OFFSET + 0x0544)
#define BOLERO_CDC_RX_RX2_RX_PATH_MIX_SEC1	(RX_START_OFFSET + 0x0548)
#define BOLERO_CDC_RX_RX2_RX_PATH_DSM_CTL	(RX_START_OFFSET + 0x054C)
#define BOLERO_CDC_RX_IDLE_DETECT_PATH_CTL	(RX_START_OFFSET + 0x0780)
#define BOLERO_CDC_RX_IDLE_DETECT_CFG0		(RX_START_OFFSET + 0x0784)
#define BOLERO_CDC_RX_IDLE_DETECT_CFG1		(RX_START_OFFSET + 0x0788)
#define BOLERO_CDC_RX_IDLE_DETECT_CFG2		(RX_START_OFFSET + 0x078C)
#define BOLERO_CDC_RX_IDLE_DETECT_CFG3		(RX_START_OFFSET + 0x0790)
#define BOLERO_CDC_RX_COMPANDER0_CTL0		(RX_START_OFFSET + 0x0800)
#define BOLERO_CDC_RX_COMPANDER0_CTL1		(RX_START_OFFSET + 0x0804)
#define BOLERO_CDC_RX_COMPANDER0_CTL2		(RX_START_OFFSET + 0x0808)
#define BOLERO_CDC_RX_COMPANDER0_CTL3		(RX_START_OFFSET + 0x080C)
#define BOLERO_CDC_RX_COMPANDER0_CTL4		(RX_START_OFFSET + 0x0810)
#define BOLERO_CDC_RX_COMPANDER0_CTL5		(RX_START_OFFSET + 0x0814)
#define BOLERO_CDC_RX_COMPANDER0_CTL6		(RX_START_OFFSET + 0x0818)
#define BOLERO_CDC_RX_COMPANDER0_CTL7		(RX_START_OFFSET + 0x081C)
#define BOLERO_CDC_RX_COMPANDER1_CTL0		(RX_START_OFFSET + 0x0840)
#define BOLERO_CDC_RX_COMPANDER1_CTL1		(RX_START_OFFSET + 0x0844)
#define BOLERO_CDC_RX_COMPANDER1_CTL2		(RX_START_OFFSET + 0x0848)
#define BOLERO_CDC_RX_COMPANDER1_CTL3		(RX_START_OFFSET + 0x084C)
#define BOLERO_CDC_RX_COMPANDER1_CTL4		(RX_START_OFFSET + 0x0850)
#define BOLERO_CDC_RX_COMPANDER1_CTL5		(RX_START_OFFSET + 0x0854)
#define BOLERO_CDC_RX_COMPANDER1_CTL6		(RX_START_OFFSET + 0x0858)
#define BOLERO_CDC_RX_COMPANDER1_CTL7		(RX_START_OFFSET + 0x085C)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_PATH_CTL \
						(RX_START_OFFSET + 0x0A00)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B1_CTL \
						(RX_START_OFFSET + 0x0A04)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B2_CTL \
						(RX_START_OFFSET + 0x0A08)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B3_CTL \
						(RX_START_OFFSET + 0x0A0C)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B4_CTL \
						(RX_START_OFFSET + 0x0A10)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B5_CTL \
						(RX_START_OFFSET + 0x0A14)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B6_CTL \
						(RX_START_OFFSET + 0x0A18)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B7_CTL \
						(RX_START_OFFSET + 0x0A1C)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_B8_CTL \
						(RX_START_OFFSET + 0x0A20)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_CTL	(RX_START_OFFSET + 0x0A24)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL \
						(RX_START_OFFSET + 0x0A28)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_COEF_B1_CTL \
						(RX_START_OFFSET + 0x0A2C)
#define BOLERO_CDC_RX_SIDETONE_IIR0_IIR_COEF_B2_CTL \
						(RX_START_OFFSET + 0x0A30)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_PATH_CTL \
						(RX_START_OFFSET + 0x0A80)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B1_CTL \
						(RX_START_OFFSET + 0x0A84)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B2_CTL \
						(RX_START_OFFSET + 0x0A88)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B3_CTL \
						(RX_START_OFFSET + 0x0A8C)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B4_CTL \
						(RX_START_OFFSET + 0x0A90)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B5_CTL \
						(RX_START_OFFSET + 0x0A94)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B6_CTL \
						(RX_START_OFFSET + 0x0A98)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B7_CTL \
						(RX_START_OFFSET + 0x0A9C)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_B8_CTL \
						(RX_START_OFFSET + 0x0AA0)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_CTL	(RX_START_OFFSET + 0x0AA4)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_GAIN_TIMER_CTL \
						(RX_START_OFFSET + 0x0AA8)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_COEF_B1_CTL \
						(RX_START_OFFSET + 0x0AAC)
#define BOLERO_CDC_RX_SIDETONE_IIR1_IIR_COEF_B2_CTL \
						(RX_START_OFFSET + 0x0AB0)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR0_MIX_CFG0	(RX_START_OFFSET + 0x0B00)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR0_MIX_CFG1	(RX_START_OFFSET + 0x0B04)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR0_MIX_CFG2	(RX_START_OFFSET + 0x0B08)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR0_MIX_CFG3	(RX_START_OFFSET + 0x0B0C)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR1_MIX_CFG0	(RX_START_OFFSET + 0x0B10)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR1_MIX_CFG1	(RX_START_OFFSET + 0x0B14)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR1_MIX_CFG2	(RX_START_OFFSET + 0x0B18)
#define BOLERO_CDC_RX_IIR_INP_MUX_IIR1_MIX_CFG3	(RX_START_OFFSET + 0x0B1C)
#define BOLERO_CDC_RX_SIDETONE_SRC0_ST_SRC_PATH_CTL \
						(RX_START_OFFSET + 0x0B40)
#define BOLERO_CDC_RX_SIDETONE_SRC0_ST_SRC_PATH_CFG1 \
						(RX_START_OFFSET + 0x0B44)
#define BOLERO_CDC_RX_SIDETONE_SRC1_ST_SRC_PATH_CTL \
						(RX_START_OFFSET + 0x0B50)
#define BOLERO_CDC_RX_SIDETONE_SRC1_ST_SRC_PATH_CFG1 \
						(RX_START_OFFSET + 0x0B54)
#define BOLERO_CDC_RX_EC_REF_HQ0_EC_REF_HQ_PATH_CTL \
						(RX_START_OFFSET + 0x0C00)
#define BOLERO_CDC_RX_EC_REF_HQ0_EC_REF_HQ_CFG0	(RX_START_OFFSET + 0x0C04)
#define BOLERO_CDC_RX_EC_REF_HQ1_EC_REF_HQ_PATH_CTL \
						(RX_START_OFFSET + 0x0C40)
#define BOLERO_CDC_RX_EC_REF_HQ1_EC_REF_HQ_CFG0	(RX_START_OFFSET + 0x0C44)
#define BOLERO_CDC_RX_EC_REF_HQ2_EC_REF_HQ_PATH_CTL \
						(RX_START_OFFSET + 0x0C80)
#define BOLERO_CDC_RX_EC_REF_HQ2_EC_REF_HQ_CFG0	(RX_START_OFFSET + 0x0C84)
#define BOLERO_CDC_RX_EC_ASRC0_CLK_RST_CTL	(RX_START_OFFSET + 0x0D00)
#define BOLERO_CDC_RX_EC_ASRC0_CTL0		(RX_START_OFFSET + 0x0D04)
#define BOLERO_CDC_RX_EC_ASRC0_CTL1		(RX_START_OFFSET + 0x0D08)
#define BOLERO_CDC_RX_EC_ASRC0_FIFO_CTL		(RX_START_OFFSET + 0x0D0C)
#define BOLERO_CDC_RX_EC_ASRC0_STATUS_FMIN_CNTR_LSB \
						(RX_START_OFFSET + 0x0D10)
#define BOLERO_CDC_RX_EC_ASRC0_STATUS_FMIN_CNTR_MSB \
						(RX_START_OFFSET + 0x0D14)
#define BOLERO_CDC_RX_EC_ASRC0_STATUS_FMAX_CNTR_LSB \
						(RX_START_OFFSET + 0x0D18)
#define BOLERO_CDC_RX_EC_ASRC0_STATUS_FMAX_CNTR_MSB \
						(RX_START_OFFSET + 0x0D1C)
#define BOLERO_CDC_RX_EC_ASRC0_STATUS_FIFO	(RX_START_OFFSET + 0x0D20)
#define BOLERO_CDC_RX_EC_ASRC1_CLK_RST_CTL	(RX_START_OFFSET + 0x0D40)
#define BOLERO_CDC_RX_EC_ASRC1_CTL0		(RX_START_OFFSET + 0x0D44)
#define BOLERO_CDC_RX_EC_ASRC1_CTL1		(RX_START_OFFSET + 0x0D48)
#define BOLERO_CDC_RX_EC_ASRC1_FIFO_CTL		(RX_START_OFFSET + 0x0D4C)
#define BOLERO_CDC_RX_EC_ASRC1_STATUS_FMIN_CNTR_LSB \
						(RX_START_OFFSET + 0x0D50)
#define BOLERO_CDC_RX_EC_ASRC1_STATUS_FMIN_CNTR_MSB \
						(RX_START_OFFSET + 0x0D54)
#define BOLERO_CDC_RX_EC_ASRC1_STATUS_FMAX_CNTR_LSB \
						(RX_START_OFFSET + 0x0D58)
#define BOLERO_CDC_RX_EC_ASRC1_STATUS_FMAX_CNTR_MSB \
						(RX_START_OFFSET + 0x0D5C)
#define BOLERO_CDC_RX_EC_ASRC1_STATUS_FIFO	(RX_START_OFFSET + 0x0D60)
#define BOLERO_CDC_RX_EC_ASRC2_CLK_RST_CTL	(RX_START_OFFSET + 0x0D80)
#define BOLERO_CDC_RX_EC_ASRC2_CTL0		(RX_START_OFFSET + 0x0D84)
#define BOLERO_CDC_RX_EC_ASRC2_CTL1		(RX_START_OFFSET + 0x0D88)
#define BOLERO_CDC_RX_EC_ASRC2_FIFO_CTL		(RX_START_OFFSET + 0x0D8C)
#define BOLERO_CDC_RX_EC_ASRC2_STATUS_FMIN_CNTR_LSB \
						(RX_START_OFFSET + 0x0D90)
#define BOLERO_CDC_RX_EC_ASRC2_STATUS_FMIN_CNTR_MSB \
						(RX_START_OFFSET + 0x0D94)
#define BOLERO_CDC_RX_EC_ASRC2_STATUS_FMAX_CNTR_LSB \
						(RX_START_OFFSET + 0x0D98)
#define BOLERO_CDC_RX_EC_ASRC2_STATUS_FMAX_CNTR_MSB \
						(RX_START_OFFSET + 0x0D9C)
#define BOLERO_CDC_RX_EC_ASRC2_STATUS_FIFO	(RX_START_OFFSET + 0x0DA0)
#define BOLERO_CDC_RX_DSD0_PATH_CTL		(RX_START_OFFSET + 0x0F00)
#define BOLERO_CDC_RX_DSD0_CFG0			(RX_START_OFFSET + 0x0F04)
#define BOLERO_CDC_RX_DSD0_CFG1			(RX_START_OFFSET + 0x0F08)
#define BOLERO_CDC_RX_DSD0_CFG2			(RX_START_OFFSET + 0x0F0C)
#define BOLERO_CDC_RX_DSD1_PATH_CTL		(RX_START_OFFSET + 0x0F80)
#define BOLERO_CDC_RX_DSD1_CFG0			(RX_START_OFFSET + 0x0F84)
#define BOLERO_CDC_RX_DSD1_CFG1			(RX_START_OFFSET + 0x0F88)
#define BOLERO_CDC_RX_DSD1_CFG2			(RX_START_OFFSET + 0x0F8C)
#define RX_MAX_OFFSET				(RX_START_OFFSET + 0x0F8C)

#define BOLERO_CDC_RX_MACRO_MAX 0x3E4 /* F8C/4 = 3E3 + 1 */

/* WSA - macro#2 */
#define WSA_START_OFFSET			0x2000
#define BOLERO_CDC_WSA_CLK_RST_CTRL_MCLK_CONTROL \
						(WSA_START_OFFSET + 0x0000)
#define BOLERO_CDC_WSA_CLK_RST_CTRL_FS_CNT_CONTROL \
						(WSA_START_OFFSET + 0x0004)
#define BOLERO_CDC_WSA_CLK_RST_CTRL_SWR_CONTROL	(WSA_START_OFFSET + 0x0008)
#define BOLERO_CDC_WSA_TOP_TOP_CFG0		(WSA_START_OFFSET + 0x0080)
#define BOLERO_CDC_WSA_TOP_TOP_CFG1		(WSA_START_OFFSET + 0x0084)
#define BOLERO_CDC_WSA_TOP_FREQ_MCLK		(WSA_START_OFFSET + 0x0088)
#define BOLERO_CDC_WSA_TOP_DEBUG_BUS_SEL	(WSA_START_OFFSET + 0x008C)
#define BOLERO_CDC_WSA_TOP_DEBUG_EN0		(WSA_START_OFFSET + 0x0090)
#define BOLERO_CDC_WSA_TOP_DEBUG_EN1		(WSA_START_OFFSET + 0x0094)
#define BOLERO_CDC_WSA_TOP_DEBUG_DSM_LB		(WSA_START_OFFSET + 0x0098)
#define BOLERO_CDC_WSA_TOP_RX_I2S_CTL		(WSA_START_OFFSET + 0x009C)
#define BOLERO_CDC_WSA_TOP_TX_I2S_CTL		(WSA_START_OFFSET + 0x00A0)
#define BOLERO_CDC_WSA_TOP_I2S_CLK		(WSA_START_OFFSET + 0x00A4)
#define BOLERO_CDC_WSA_TOP_I2S_RESET		(WSA_START_OFFSET + 0x00A8)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_INT0_CFG0	(WSA_START_OFFSET + 0x0100)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_INT0_CFG1	(WSA_START_OFFSET + 0x0104)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_INT1_CFG0	(WSA_START_OFFSET + 0x0108)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_INT1_CFG1	(WSA_START_OFFSET + 0x010C)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_MIX_CFG0	(WSA_START_OFFSET + 0x0110)
#define BOLERO_CDC_WSA_RX_INP_MUX_RX_EC_CFG0	(WSA_START_OFFSET + 0x0114)
#define BOLERO_CDC_WSA_RX_INP_MUX_SOFTCLIP_CFG0	(WSA_START_OFFSET + 0x0118)
/* VBAT registers  */
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_PATH_CTL	(WSA_START_OFFSET + 0x0180)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_CFG	(WSA_START_OFFSET + 0x0184)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_ADC_CAL1	(WSA_START_OFFSET + 0x0188)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_ADC_CAL2	(WSA_START_OFFSET + 0x018C)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_ADC_CAL3	(WSA_START_OFFSET + 0x0190)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_PK_EST1	(WSA_START_OFFSET + 0x0194)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_PK_EST2	(WSA_START_OFFSET + 0x0198)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_PK_EST3	(WSA_START_OFFSET + 0x019C)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_RF_PROC1	(WSA_START_OFFSET + 0x01A0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_RF_PROC2	(WSA_START_OFFSET + 0x01A4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_TAC1	(WSA_START_OFFSET + 0x01A8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_TAC2	(WSA_START_OFFSET + 0x01AC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_TAC3	(WSA_START_OFFSET + 0x01B0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_TAC4	(WSA_START_OFFSET + 0x01B4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD1	(WSA_START_OFFSET + 0x01B8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD2	(WSA_START_OFFSET + 0x01BC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD3	(WSA_START_OFFSET + 0x01C0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD4	(WSA_START_OFFSET + 0x01C4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD5	(WSA_START_OFFSET + 0x01C8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DEBUG1	(WSA_START_OFFSET + 0x01CC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_UPD_MON \
						(WSA_START_OFFSET + 0x01D0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_GAIN_MON_VAL \
						(WSA_START_OFFSET + 0x01D4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BAN	(WSA_START_OFFSET + 0x01D8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD1 \
						(WSA_START_OFFSET + 0x01DC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD2 \
						(WSA_START_OFFSET + 0x01E0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD3 \
						(WSA_START_OFFSET + 0x01E4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD4 \
						(WSA_START_OFFSET + 0x01E8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD5 \
						(WSA_START_OFFSET + 0x01EC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD6 \
						(WSA_START_OFFSET + 0x01F0)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD7 \
						(WSA_START_OFFSET + 0x01F4)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD8 \
						(WSA_START_OFFSET + 0x01F8)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_GAIN_UPD9 \
						(WSA_START_OFFSET + 0x01FC)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_ATTN1	(WSA_START_OFFSET + 0x0200)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_ATTN2	(WSA_START_OFFSET + 0x0204)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_BCL_ATTN3	(WSA_START_OFFSET + 0x0208)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CTL1 \
						(WSA_START_OFFSET + 0x020C)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CTL2 \
						(WSA_START_OFFSET + 0x0210)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CFG1 \
						(WSA_START_OFFSET + 0x0214)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CFG2 \
						(WSA_START_OFFSET + 0x0218)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CFG3 \
						(WSA_START_OFFSET + 0x021C)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_CFG4 \
						(WSA_START_OFFSET + 0x0220)
#define BOLERO_CDC_WSA_VBAT_BCL_VBAT_DECODE_ST	(WSA_START_OFFSET + 0x0224)
#define BOLERO_CDC_WSA_TX0_SPKR_PROT_PATH_CTL	(WSA_START_OFFSET + 0x0244)
#define BOLERO_CDC_WSA_TX0_SPKR_PROT_PATH_CFG0	(WSA_START_OFFSET + 0x0248)
#define BOLERO_CDC_WSA_TX1_SPKR_PROT_PATH_CTL	(WSA_START_OFFSET + 0x0264)
#define BOLERO_CDC_WSA_TX1_SPKR_PROT_PATH_CFG0	(WSA_START_OFFSET + 0x0268)
#define BOLERO_CDC_WSA_TX2_SPKR_PROT_PATH_CTL	(WSA_START_OFFSET + 0x0284)
#define BOLERO_CDC_WSA_TX2_SPKR_PROT_PATH_CFG0	(WSA_START_OFFSET + 0x0288)
#define BOLERO_CDC_WSA_TX3_SPKR_PROT_PATH_CTL	(WSA_START_OFFSET + 0x02A4)
#define BOLERO_CDC_WSA_TX3_SPKR_PROT_PATH_CFG0	(WSA_START_OFFSET + 0x02A8)
#define BOLERO_CDC_WSA_INTR_CTRL_CFG		(WSA_START_OFFSET + 0x0340)
#define BOLERO_CDC_WSA_INTR_CTRL_CLR_COMMIT	(WSA_START_OFFSET + 0x0344)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN1_MASK0	(WSA_START_OFFSET + 0x0360)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN1_STATUS0	(WSA_START_OFFSET + 0x0368)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN1_CLEAR0	(WSA_START_OFFSET + 0x0370)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN2_MASK0	(WSA_START_OFFSET + 0x0380)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN2_STATUS0	(WSA_START_OFFSET + 0x0388)
#define BOLERO_CDC_WSA_INTR_CTRL_PIN2_CLEAR0	(WSA_START_OFFSET + 0x0390)
#define BOLERO_CDC_WSA_INTR_CTRL_LEVEL0		(WSA_START_OFFSET + 0x03C0)
#define BOLERO_CDC_WSA_INTR_CTRL_BYPASS0	(WSA_START_OFFSET + 0x03C8)
#define BOLERO_CDC_WSA_INTR_CTRL_SET0		(WSA_START_OFFSET + 0x03D0)
#define BOLERO_CDC_WSA_RX0_RX_PATH_CTL		(WSA_START_OFFSET + 0x0400)
#define BOLERO_CDC_WSA_RX0_RX_PATH_CFG0		(WSA_START_OFFSET + 0x0404)
#define BOLERO_CDC_WSA_RX0_RX_PATH_CFG1		(WSA_START_OFFSET + 0x0408)
#define BOLERO_CDC_WSA_RX0_RX_PATH_CFG2		(WSA_START_OFFSET + 0x040C)
#define BOLERO_CDC_WSA_RX0_RX_PATH_CFG3		(WSA_START_OFFSET + 0x0410)
#define BOLERO_CDC_WSA_RX0_RX_VOL_CTL		(WSA_START_OFFSET + 0x0414)
#define BOLERO_CDC_WSA_RX0_RX_PATH_MIX_CTL	(WSA_START_OFFSET + 0x0418)
#define BOLERO_CDC_WSA_RX0_RX_PATH_MIX_CFG	(WSA_START_OFFSET + 0x041C)
#define BOLERO_CDC_WSA_RX0_RX_VOL_MIX_CTL	(WSA_START_OFFSET + 0x0420)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC0		(WSA_START_OFFSET + 0x0424)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC1		(WSA_START_OFFSET + 0x0428)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC2		(WSA_START_OFFSET + 0x042C)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC3		(WSA_START_OFFSET + 0x0430)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC5		(WSA_START_OFFSET + 0x0438)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC6		(WSA_START_OFFSET + 0x043C)
#define BOLERO_CDC_WSA_RX0_RX_PATH_SEC7		(WSA_START_OFFSET + 0x0440)
#define BOLERO_CDC_WSA_RX0_RX_PATH_MIX_SEC0	(WSA_START_OFFSET + 0x0444)
#define BOLERO_CDC_WSA_RX0_RX_PATH_MIX_SEC1	(WSA_START_OFFSET + 0x0448)
#define BOLERO_CDC_WSA_RX0_RX_PATH_DSMDEM_CTL	(WSA_START_OFFSET + 0x044C)
#define BOLERO_CDC_WSA_RX1_RX_PATH_CTL		(WSA_START_OFFSET + 0x0480)
#define BOLERO_CDC_WSA_RX1_RX_PATH_CFG0		(WSA_START_OFFSET + 0x0484)
#define BOLERO_CDC_WSA_RX1_RX_PATH_CFG1		(WSA_START_OFFSET + 0x0488)
#define BOLERO_CDC_WSA_RX1_RX_PATH_CFG2		(WSA_START_OFFSET + 0x048C)
#define BOLERO_CDC_WSA_RX1_RX_PATH_CFG3		(WSA_START_OFFSET + 0x0490)
#define BOLERO_CDC_WSA_RX1_RX_VOL_CTL		(WSA_START_OFFSET + 0x0494)
#define BOLERO_CDC_WSA_RX1_RX_PATH_MIX_CTL	(WSA_START_OFFSET + 0x0498)
#define BOLERO_CDC_WSA_RX1_RX_PATH_MIX_CFG	(WSA_START_OFFSET + 0x049C)
#define BOLERO_CDC_WSA_RX1_RX_VOL_MIX_CTL	(WSA_START_OFFSET + 0x04A0)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC0		(WSA_START_OFFSET + 0x04A4)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC1		(WSA_START_OFFSET + 0x04A8)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC2		(WSA_START_OFFSET + 0x04AC)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC3		(WSA_START_OFFSET + 0x04B0)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC5		(WSA_START_OFFSET + 0x04B8)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC6		(WSA_START_OFFSET + 0x04BC)
#define BOLERO_CDC_WSA_RX1_RX_PATH_SEC7		(WSA_START_OFFSET + 0x04C0)
#define BOLERO_CDC_WSA_RX1_RX_PATH_MIX_SEC0	(WSA_START_OFFSET + 0x04C4)
#define BOLERO_CDC_WSA_RX1_RX_PATH_MIX_SEC1	(WSA_START_OFFSET + 0x04C8)
#define BOLERO_CDC_WSA_RX1_RX_PATH_DSMDEM_CTL	(WSA_START_OFFSET + 0x04CC)
#define BOLERO_CDC_WSA_BOOST0_BOOST_PATH_CTL	(WSA_START_OFFSET + 0x0500)
#define BOLERO_CDC_WSA_BOOST0_BOOST_CTL		(WSA_START_OFFSET + 0x0504)
#define BOLERO_CDC_WSA_BOOST0_BOOST_CFG1	(WSA_START_OFFSET + 0x0508)
#define BOLERO_CDC_WSA_BOOST0_BOOST_CFG2	(WSA_START_OFFSET + 0x050C)
#define BOLERO_CDC_WSA_BOOST1_BOOST_PATH_CTL	(WSA_START_OFFSET + 0x0540)
#define BOLERO_CDC_WSA_BOOST1_BOOST_CTL		(WSA_START_OFFSET + 0x0544)
#define BOLERO_CDC_WSA_BOOST1_BOOST_CFG1	(WSA_START_OFFSET + 0x0548)
#define BOLERO_CDC_WSA_BOOST1_BOOST_CFG2	(WSA_START_OFFSET + 0x054C)
#define BOLERO_CDC_WSA_COMPANDER0_CTL0		(WSA_START_OFFSET + 0x0580)
#define BOLERO_CDC_WSA_COMPANDER0_CTL1		(WSA_START_OFFSET + 0x0584)
#define BOLERO_CDC_WSA_COMPANDER0_CTL2		(WSA_START_OFFSET + 0x0588)
#define BOLERO_CDC_WSA_COMPANDER0_CTL3		(WSA_START_OFFSET + 0x058C)
#define BOLERO_CDC_WSA_COMPANDER0_CTL4		(WSA_START_OFFSET + 0x0590)
#define BOLERO_CDC_WSA_COMPANDER0_CTL5		(WSA_START_OFFSET + 0x0594)
#define BOLERO_CDC_WSA_COMPANDER0_CTL6		(WSA_START_OFFSET + 0x0598)
#define BOLERO_CDC_WSA_COMPANDER0_CTL7		(WSA_START_OFFSET + 0x059C)
#define BOLERO_CDC_WSA_COMPANDER1_CTL0		(WSA_START_OFFSET + 0x05C0)
#define BOLERO_CDC_WSA_COMPANDER1_CTL1		(WSA_START_OFFSET + 0x05C4)
#define BOLERO_CDC_WSA_COMPANDER1_CTL2		(WSA_START_OFFSET + 0x05C8)
#define BOLERO_CDC_WSA_COMPANDER1_CTL3		(WSA_START_OFFSET + 0x05CC)
#define BOLERO_CDC_WSA_COMPANDER1_CTL4		(WSA_START_OFFSET + 0x05D0)
#define BOLERO_CDC_WSA_COMPANDER1_CTL5		(WSA_START_OFFSET + 0x05D4)
#define BOLERO_CDC_WSA_COMPANDER1_CTL6		(WSA_START_OFFSET + 0x05D8)
#define BOLERO_CDC_WSA_COMPANDER1_CTL7		(WSA_START_OFFSET + 0x05DC)
#define BOLERO_CDC_WSA_SOFTCLIP0_CRC		(WSA_START_OFFSET + 0x0600)
#define BOLERO_CDC_WSA_SOFTCLIP0_SOFTCLIP_CTRL	(WSA_START_OFFSET + 0x0604)
#define BOLERO_CDC_WSA_SOFTCLIP1_CRC		(WSA_START_OFFSET + 0x0640)
#define BOLERO_CDC_WSA_SOFTCLIP1_SOFTCLIP_CTRL	(WSA_START_OFFSET + 0x0644)
#define BOLERO_CDC_WSA_EC_HQ0_EC_REF_HQ_PATH_CTL \
						(WSA_START_OFFSET + 0x0680)
#define BOLERO_CDC_WSA_EC_HQ0_EC_REF_HQ_CFG0	(WSA_START_OFFSET + 0x0684)
#define BOLERO_CDC_WSA_EC_HQ1_EC_REF_HQ_PATH_CTL \
						(WSA_START_OFFSET + 0x06C0)
#define BOLERO_CDC_WSA_EC_HQ1_EC_REF_HQ_CFG0	(WSA_START_OFFSET + 0x06C4)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_CLK_RST_CTL	(WSA_START_OFFSET + 0x0700)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_CTL0	(WSA_START_OFFSET + 0x0704)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_CTL1	(WSA_START_OFFSET + 0x0708)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_FIFO_CTL	(WSA_START_OFFSET + 0x070C)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_STATUS_FMIN_CNTR_LSB \
						(WSA_START_OFFSET + 0x0710)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_STATUS_FMIN_CNTR_MSB \
						(WSA_START_OFFSET + 0x0714)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_STATUS_FMAX_CNTR_LSB \
						(WSA_START_OFFSET + 0x0718)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_STATUS_FMAX_CNTR_MSB \
						(WSA_START_OFFSET + 0x071C)
#define BOLERO_CDC_WSA_SPLINE_ASRC0_STATUS_FIFO	(WSA_START_OFFSET + 0x0720)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_CLK_RST_CTL	(WSA_START_OFFSET + 0x0740)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_CTL0	(WSA_START_OFFSET + 0x0744)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_CTL1	(WSA_START_OFFSET + 0x0748)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_FIFO_CTL	(WSA_START_OFFSET + 0x074C)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_STATUS_FMIN_CNTR_LSB \
						(WSA_START_OFFSET + 0x0750)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_STATUS_FMIN_CNTR_MSB \
						(WSA_START_OFFSET + 0x0754)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_STATUS_FMAX_CNTR_LSB \
						(WSA_START_OFFSET + 0x0758)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_STATUS_FMAX_CNTR_MSB \
						(WSA_START_OFFSET + 0x075C)
#define BOLERO_CDC_WSA_SPLINE_ASRC1_STATUS_FIFO	(WSA_START_OFFSET + 0x0760)
#define WSA_MAX_OFFSET				(WSA_START_OFFSET + 0x0760)

#define BOLERO_CDC_WSA_MACRO_MAX 0x1D9 /* 0x760/4 = 0x1D8 + 1 registers */

/* VA macro registers */
#define VA_START_OFFSET				0x3000
#define BOLERO_CDC_VA_CLK_RST_CTRL_MCLK_CONTROL	(VA_START_OFFSET + 0x0000)
#define BOLERO_CDC_VA_CLK_RST_CTRL_FS_CNT_CONTROL \
						(VA_START_OFFSET + 0x0004)
#define BOLERO_CDC_VA_TOP_CSR_TOP_CFG0		(VA_START_OFFSET + 0x0080)
#define BOLERO_CDC_VA_TOP_CSR_DMIC0_CTL		(VA_START_OFFSET + 0x0084)
#define BOLERO_CDC_VA_TOP_CSR_DMIC1_CTL		(VA_START_OFFSET + 0x0088)
#define BOLERO_CDC_VA_TOP_CSR_DMIC2_CTL		(VA_START_OFFSET + 0x008C)
#define BOLERO_CDC_VA_TOP_CSR_DMIC3_CTL		(VA_START_OFFSET + 0x0090)
#define BOLERO_CDC_VA_TOP_CSR_DMIC_CFG		(VA_START_OFFSET + 0x0094)
#define BOLERO_CDC_VA_TOP_CSR_DEBUG_BUS		(VA_START_OFFSET + 0x009C)
#define BOLERO_CDC_VA_TOP_CSR_DEBUG_EN		(VA_START_OFFSET + 0x00A0)
#define BOLERO_CDC_VA_TOP_CSR_TX_I2S_CTL	(VA_START_OFFSET + 0x00A4)
#define BOLERO_CDC_VA_TOP_CSR_I2S_CLK		(VA_START_OFFSET + 0x00A8)
#define BOLERO_CDC_VA_TOP_CSR_I2S_RESET		(VA_START_OFFSET + 0x00AC)
#define BOLERO_CDC_VA_TOP_CSR_CORE_ID_0		(VA_START_OFFSET + 0x00C0)
#define BOLERO_CDC_VA_TOP_CSR_CORE_ID_1		(VA_START_OFFSET + 0x00C4)
#define BOLERO_CDC_VA_TOP_CSR_CORE_ID_2		(VA_START_OFFSET + 0x00C8)
#define BOLERO_CDC_VA_TOP_CSR_CORE_ID_3		(VA_START_OFFSET + 0x00CC)
#define VA_TOP_MAX_OFFSET			(VA_START_OFFSET + 0x00CC)

#define BOLERO_CDC_VA_MACRO_TOP_MAX 0x34 /* 0x0CC/4 = 0x33 + 1 = 0x34 */

#define BOLERO_CDC_VA_INP_MUX_ADC_MUX0_CFG0	(VA_START_OFFSET + 0x0100)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX0_CFG1	(VA_START_OFFSET + 0x0104)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX1_CFG0	(VA_START_OFFSET + 0x0108)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX1_CFG1	(VA_START_OFFSET + 0x010C)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX2_CFG0	(VA_START_OFFSET + 0x0110)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX2_CFG1	(VA_START_OFFSET + 0x0114)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX3_CFG0	(VA_START_OFFSET + 0x0118)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX3_CFG1	(VA_START_OFFSET + 0x011C)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX4_CFG0	(VA_START_OFFSET + 0x0120)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX4_CFG1	(VA_START_OFFSET + 0x0124)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX5_CFG0	(VA_START_OFFSET + 0x0128)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX5_CFG1	(VA_START_OFFSET + 0x012C)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX6_CFG0	(VA_START_OFFSET + 0x0130)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX6_CFG1	(VA_START_OFFSET + 0x0134)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX7_CFG0	(VA_START_OFFSET + 0x0138)
#define BOLERO_CDC_VA_INP_MUX_ADC_MUX7_CFG1	(VA_START_OFFSET + 0x013C)

#define BOLERO_CDC_VA_TX0_TX_PATH_CTL	(VA_START_OFFSET + 0x0400)
#define BOLERO_CDC_VA_TX0_TX_PATH_CFG0	(VA_START_OFFSET + 0x0404)
#define BOLERO_CDC_VA_TX0_TX_PATH_CFG1	(VA_START_OFFSET + 0x0408)
#define BOLERO_CDC_VA_TX0_TX_VOL_CTL	(VA_START_OFFSET + 0x040C)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC0	(VA_START_OFFSET + 0x0410)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC1	(VA_START_OFFSET + 0x0414)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC2	(VA_START_OFFSET + 0x0418)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC3	(VA_START_OFFSET + 0x041C)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC4	(VA_START_OFFSET + 0x0420)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC5	(VA_START_OFFSET + 0x0424)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC6	(VA_START_OFFSET + 0x0428)
#define BOLERO_CDC_VA_TX0_TX_PATH_SEC7	(VA_START_OFFSET + 0x042C)
#define BOLERO_CDC_VA_TX1_TX_PATH_CTL	(VA_START_OFFSET + 0x0480)
#define BOLERO_CDC_VA_TX1_TX_PATH_CFG0	(VA_START_OFFSET + 0x0484)
#define BOLERO_CDC_VA_TX1_TX_PATH_CFG1	(VA_START_OFFSET + 0x0488)
#define BOLERO_CDC_VA_TX1_TX_VOL_CTL	(VA_START_OFFSET + 0x048C)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC0	(VA_START_OFFSET + 0x0490)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC1	(VA_START_OFFSET + 0x0494)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC2	(VA_START_OFFSET + 0x0498)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC3	(VA_START_OFFSET + 0x049C)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC4	(VA_START_OFFSET + 0x04A0)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC5	(VA_START_OFFSET + 0x04A4)
#define BOLERO_CDC_VA_TX1_TX_PATH_SEC6	(VA_START_OFFSET + 0x04A8)
#define BOLERO_CDC_VA_TX2_TX_PATH_CTL	(VA_START_OFFSET + 0x0500)
#define BOLERO_CDC_VA_TX2_TX_PATH_CFG0	(VA_START_OFFSET + 0x0504)
#define BOLERO_CDC_VA_TX2_TX_PATH_CFG1	(VA_START_OFFSET + 0x0508)
#define BOLERO_CDC_VA_TX2_TX_VOL_CTL	(VA_START_OFFSET + 0x050C)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC0	(VA_START_OFFSET + 0x0510)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC1	(VA_START_OFFSET + 0x0514)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC2	(VA_START_OFFSET + 0x0518)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC3	(VA_START_OFFSET + 0x051C)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC4	(VA_START_OFFSET + 0x0520)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC5	(VA_START_OFFSET + 0x0524)
#define BOLERO_CDC_VA_TX2_TX_PATH_SEC6	(VA_START_OFFSET + 0x0528)
#define BOLERO_CDC_VA_TX3_TX_PATH_CTL	(VA_START_OFFSET + 0x0580)
#define BOLERO_CDC_VA_TX3_TX_PATH_CFG0	(VA_START_OFFSET + 0x0584)
#define BOLERO_CDC_VA_TX3_TX_PATH_CFG1	(VA_START_OFFSET + 0x0588)
#define BOLERO_CDC_VA_TX3_TX_VOL_CTL	(VA_START_OFFSET + 0x058C)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC0	(VA_START_OFFSET + 0x0590)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC1	(VA_START_OFFSET + 0x0594)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC2	(VA_START_OFFSET + 0x0598)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC3	(VA_START_OFFSET + 0x059C)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC4	(VA_START_OFFSET + 0x05A0)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC5	(VA_START_OFFSET + 0x05A4)
#define BOLERO_CDC_VA_TX3_TX_PATH_SEC6	(VA_START_OFFSET + 0x05A8)
#define BOLERO_CDC_VA_TX4_TX_PATH_CTL	(VA_START_OFFSET + 0x0600)
#define BOLERO_CDC_VA_TX4_TX_PATH_CFG0	(VA_START_OFFSET + 0x0604)
#define BOLERO_CDC_VA_TX4_TX_PATH_CFG1	(VA_START_OFFSET + 0x0608)
#define BOLERO_CDC_VA_TX4_TX_VOL_CTL	(VA_START_OFFSET + 0x060C)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC0	(VA_START_OFFSET + 0x0610)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC1	(VA_START_OFFSET + 0x0614)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC2	(VA_START_OFFSET + 0x0618)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC3	(VA_START_OFFSET + 0x061C)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC4	(VA_START_OFFSET + 0x0620)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC5	(VA_START_OFFSET + 0x0624)
#define BOLERO_CDC_VA_TX4_TX_PATH_SEC6	(VA_START_OFFSET + 0x0628)
#define BOLERO_CDC_VA_TX5_TX_PATH_CTL	(VA_START_OFFSET + 0x0680)
#define BOLERO_CDC_VA_TX5_TX_PATH_CFG0	(VA_START_OFFSET + 0x0684)
#define BOLERO_CDC_VA_TX5_TX_PATH_CFG1	(VA_START_OFFSET + 0x0688)
#define BOLERO_CDC_VA_TX5_TX_VOL_CTL	(VA_START_OFFSET + 0x068C)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC0	(VA_START_OFFSET + 0x0690)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC1	(VA_START_OFFSET + 0x0694)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC2	(VA_START_OFFSET + 0x0698)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC3	(VA_START_OFFSET + 0x069C)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC4	(VA_START_OFFSET + 0x06A0)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC5	(VA_START_OFFSET + 0x06A4)
#define BOLERO_CDC_VA_TX5_TX_PATH_SEC6	(VA_START_OFFSET + 0x06A8)
#define BOLERO_CDC_VA_TX6_TX_PATH_CTL	(VA_START_OFFSET + 0x0700)
#define BOLERO_CDC_VA_TX6_TX_PATH_CFG0	(VA_START_OFFSET + 0x0704)
#define BOLERO_CDC_VA_TX6_TX_PATH_CFG1	(VA_START_OFFSET + 0x0708)
#define BOLERO_CDC_VA_TX6_TX_VOL_CTL	(VA_START_OFFSET + 0x070C)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC0	(VA_START_OFFSET + 0x0710)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC1	(VA_START_OFFSET + 0x0714)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC2	(VA_START_OFFSET + 0x0718)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC3	(VA_START_OFFSET + 0x071C)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC4	(VA_START_OFFSET + 0x0720)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC5	(VA_START_OFFSET + 0x0724)
#define BOLERO_CDC_VA_TX6_TX_PATH_SEC6	(VA_START_OFFSET + 0x0728)
#define BOLERO_CDC_VA_TX7_TX_PATH_CTL	(VA_START_OFFSET + 0x0780)
#define BOLERO_CDC_VA_TX7_TX_PATH_CFG0	(VA_START_OFFSET + 0x0784)
#define BOLERO_CDC_VA_TX7_TX_PATH_CFG1	(VA_START_OFFSET + 0x0788)
#define BOLERO_CDC_VA_TX7_TX_VOL_CTL	(VA_START_OFFSET + 0x078C)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC0	(VA_START_OFFSET + 0x0790)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC1	(VA_START_OFFSET + 0x0794)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC2	(VA_START_OFFSET + 0x0798)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC3	(VA_START_OFFSET + 0x079C)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC4	(VA_START_OFFSET + 0x07A0)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC5	(VA_START_OFFSET + 0x07A4)
#define BOLERO_CDC_VA_TX7_TX_PATH_SEC6	(VA_START_OFFSET + 0x07A8)
#define VA_MAX_OFFSET			(VA_START_OFFSET + 0x07A8)

#define BOLERO_CDC_VA_MACRO_MAX 0x1EB /* 7A8/4 = 1EA + 1 = 1EB */

#define BOLERO_CDC_MAX_REGISTER VA_MAX_OFFSET

#define BOLERO_REG(reg)  (((reg) & 0x0FFF)/4)

#endif
