/*
 * Copyright (c) 2015-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/regmap.h>
#include <linux/device.h>
#include "core.h"
#include "wcd9xxx-regmap.h"
#include "wcd9335_registers.h"

static const struct reg_sequence wcd9335_1_x_defaults[] = {
	{ WCD9335_CODEC_RPM_CLK_GATE,                     0x03,  0x00 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DRAM1_SHUTDOWN,       0x1f,  0x00 },
	{ WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE0,           0x00,  0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_CTL,               0x00,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX0_INP_CFG,          0x00,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX1_INP_CFG,          0x00,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX2_INP_CFG,          0x00,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX3_INP_CFG,          0x00,  0x00 },
	{ WCD9335_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD,       0x14,  0x00 },
	{ WCD9335_CPE_SS_SS_ERROR_INT_MASK,               0x3f,  0x00 },
	{ WCD9335_SOC_MAD_AUDIO_IIR_CTL_VAL,              0x00,  0x00 },
	{ WCD9335_BIAS_VBG_FINE_ADJ,                      0x55,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_2,                        0x6c,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_3,                        0x2d,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_8,                        0x6c,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_10,                       0x6c,  0x00 },
	{ WCD9335_SIDO_SIDO_DRIVER_2,                     0x77,  0x00 },
	{ WCD9335_SIDO_SIDO_DRIVER_3,                     0x77,  0x00 },
	{ WCD9335_SIDO_SIDO_TEST_2,                       0x00,  0x00 },
	{ WCD9335_MBHC_ZDET_ANA_CTL,                      0x00,  0x00 },
	{ WCD9335_MBHC_FSM_DEBUG,                         0xc0,  0x00 },
	{ WCD9335_TX_1_2_ATEST_REFCTL,                    0x08,  0x00 },
	{ WCD9335_TX_3_4_ATEST_REFCTL,                    0x08,  0x00 },
	{ WCD9335_TX_5_6_ATEST_REFCTL,                    0x08,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_1,                    0x67,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_4,                    0x5f,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_9,                    0x50,  0x00 },
	{ WCD9335_FLYBACK_VNEG_DAC_CTRL_1,                0x65,  0x00 },
	{ WCD9335_FLYBACK_VNEG_DAC_CTRL_4,                0x40,  0x00 },
	{ WCD9335_RX_BIAS_HPH_PA,                         0xaa,  0x00 },
	{ WCD9335_RX_BIAS_HPH_LOWPOWER,                   0x62,  0x00 },
	{ WCD9335_HPH_PA_CTL2,                            0x40,  0x00 },
	{ WCD9335_HPH_L_EN,                               0x00,  0x00 },
	{ WCD9335_HPH_R_EN,                               0x00,  0x00 },
	{ WCD9335_HPH_R_ATEST,                            0x50,  0x00 },
	{ WCD9335_HPH_RDAC_LDO_CTL,                       0x00,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_CFG0,                   0x00,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_CFG1,                   0x00,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC2,                   0x00,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC3,                   0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER1_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER2_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER3_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER4_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER5_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER6_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER7_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_COMPANDER8_CTL7,                    0x0c,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_CFG1,                   0x04,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_CFG,                0x0e,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC0,                   0x00,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC1,                   0x00,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_SEC0,               0x00,  0x00 },
	{ WCD9335_SPLINE_SRC0_CLK_RST_CTL_0,              0x00,  0x00 },
	{ WCD9335_SPLINE_SRC1_CLK_RST_CTL_0,              0x00,  0x00 },
	{ WCD9335_SPLINE_SRC2_CLK_RST_CTL_0,              0x00,  0x00 },
	{ WCD9335_SPLINE_SRC3_CLK_RST_CTL_0,              0x00,  0x00 },
	{ WCD9335_CDC_CLK_RST_CTRL_FS_CNT_CONTROL,        0x00,  0x00 },
	{ WCD9335_TEST_DEBUG_NPL_DLY_TEST_1,              0x00,  0x00 },
	{ WCD9335_TEST_DEBUG_NPL_DLY_TEST_2,              0x00,  0x00 },
};

static const struct reg_sequence wcd9335_2_0_defaults[] = {
	{ WCD9335_CODEC_RPM_CLK_GATE,                     0x07,  0x00 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DRAM1_SHUTDOWN,       0x3f,  0x00 },
	{ WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE0,           0x01,  0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_CTL,               0x10,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX0_INP_CFG,          0x08,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX1_INP_CFG,          0x08,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX2_INP_CFG,          0x08,  0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX3_INP_CFG,          0x08,  0x00 },
	{ WCD9335_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD,       0x13,  0x00 },
	{ WCD9335_CPE_SS_SS_ERROR_INT_MASK,               0xff,  0x00 },
	{ WCD9335_SOC_MAD_AUDIO_IIR_CTL_VAL,              0x40,  0x00 },
	{ WCD9335_BIAS_VBG_FINE_ADJ,                      0xc5,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_2,                        0x92,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_3,                        0x35,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_8,                        0x6e,  0x00 },
	{ WCD9335_SIDO_SIDO_CCL_10,                       0x6e,  0x00 },
	{ WCD9335_SIDO_SIDO_DRIVER_2,                     0x55,  0x00 },
	{ WCD9335_SIDO_SIDO_DRIVER_3,                     0x55,  0x00 },
	{ WCD9335_SIDO_SIDO_TEST_2,                       0x0f,  0x00 },
	{ WCD9335_MBHC_ZDET_ANA_CTL,                      0x0f,  0x00 },
	{ WCD9335_TX_1_2_ATEST_REFCTL,                    0x0a,  0x00 },
	{ WCD9335_TX_3_4_ATEST_REFCTL,                    0x0a,  0x00 },
	{ WCD9335_TX_5_6_ATEST_REFCTL,                    0x0a,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_1,                    0xeb,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_4,                    0x7f,  0x00 },
	{ WCD9335_FLYBACK_VNEG_CTRL_9,                    0x64,  0x00 },
	{ WCD9335_FLYBACK_VNEG_DAC_CTRL_1,                0xed,  0x00 },
	{ WCD9335_RX_BIAS_HPH_PA,                         0x9a,  0x00 },
	{ WCD9335_RX_BIAS_HPH_LOWPOWER,                   0x82,  0x00 },
	{ WCD9335_HPH_PA_CTL2,                            0x50,  0x00 },
	{ WCD9335_HPH_L_EN,                               0x80,  0x00 },
	{ WCD9335_HPH_R_EN,                               0x80,  0x00 },
	{ WCD9335_HPH_R_ATEST,                            0x54,  0x00 },
	{ WCD9335_HPH_RDAC_LDO_CTL,                       0x33,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_CFG0,                   0x10,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_CFG1,                   0x02,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC2,                   0x01,  0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC3,                   0x3c,  0x00 },
	{ WCD9335_CDC_COMPANDER1_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER2_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER3_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER4_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER5_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER6_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER7_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_COMPANDER8_CTL7,                    0x08,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_CFG1,                   0x44,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_CFG,                0x1e,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC0,                   0xfc,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC1,                   0x08,  0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_SEC0,               0x08,  0x00 },
	{ WCD9335_SPLINE_SRC0_CLK_RST_CTL_0,              0x20,  0x00 },
	{ WCD9335_SPLINE_SRC1_CLK_RST_CTL_0,              0x20,  0x00 },
	{ WCD9335_SPLINE_SRC2_CLK_RST_CTL_0,              0x20,  0x00 },
	{ WCD9335_SPLINE_SRC3_CLK_RST_CTL_0,              0x20,  0x00 },
	{ WCD9335_CDC_CLK_RST_CTRL_FS_CNT_CONTROL,        0x0c,  0x00 },
	{ WCD9335_TEST_DEBUG_NPL_DLY_TEST_1,              0x10,  0x00 },
	{ WCD9335_TEST_DEBUG_NPL_DLY_TEST_2,              0x60,  0x00 },
	{ WCD9335_DATA_HUB_NATIVE_FIFO_SYNC,              0x00,  0x00 },
	{ WCD9335_DATA_HUB_NATIVE_FIFO_STATUS,            0x00,  0x00 },
	{ WCD9335_CPE_SS_TX_PP_BUF_INT_PERIOD,            0x60,  0x00 },
	{ WCD9335_CPE_SS_TX_PP_CFG,                       0x3C,  0x00 },
	{ WCD9335_CPE_SS_SVA_CFG,                         0x00,  0x00 },
	{ WCD9335_MBHC_FSM_STATUS,                        0x00,  0x00 },
	{ WCD9335_FLYBACK_CTRL_1,                         0x45,  0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC7,                   0x25,  0x00 },
	{ WCD9335_SPLINE_SRC0_STATUS,                     0x00,  0x00 },
	{ WCD9335_SPLINE_SRC1_STATUS,                     0x00,  0x00 },
	{ WCD9335_SPLINE_SRC2_STATUS,                     0x00,  0x00 },
	{ WCD9335_SPLINE_SRC3_STATUS,                     0x00,  0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT,    0x00,  0x00 },
};

static const struct reg_default wcd9335_defaults[] = {
	/* Page #0 registers */
	{ WCD9335_PAGE0_PAGE_REGISTER,                    0x00 },
	{ WCD9335_CODEC_RPM_CLK_BYPASS,                   0x00 },
	{ WCD9335_CODEC_RPM_CLK_MCLK_CFG,                 0x00 },
	{ WCD9335_CODEC_RPM_RST_CTL,                      0x00 },
	{ WCD9335_CODEC_RPM_PWR_CDC_DIG_HM_CTL,           0x07 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_1,            0x00 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_2,            0x00 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DEEPSLP_3,            0x00 },
	{ WCD9335_CODEC_RPM_PWR_CPE_IRAM_SHUTDOWN,        0x01 },
	{ WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_1,     0xff },
	{ WCD9335_CODEC_RPM_PWR_CPE_DRAM0_SHUTDOWN_2,     0xff },
	{ WCD9335_CODEC_RPM_INT_MASK,                     0x3f },
	{ WCD9335_CODEC_RPM_INT_STATUS,                   0x00 },
	{ WCD9335_CODEC_RPM_INT_CLEAR,                    0x00 },
	{ WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE1,           0x00 },
	{ WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE2,           0x07 },
	{ WCD9335_CHIP_TIER_CTRL_CHIP_ID_BYTE3,           0x01 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_TEST0,             0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_TEST1,             0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT0,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT1,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT2,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT3,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT4,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT5,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT6,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT7,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT8,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT9,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT10,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT11,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT12,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT13,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT14,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_VAL_OUT15,         0x00 },
	{ WCD9335_CHIP_TIER_CTRL_EFUSE_STATUS,            0x00 },
	{ WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO,    0x0d },
	{ WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_1,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_2,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_I2C_SLAVE_ID_3,          0x00 },
	{ WCD9335_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL,      0xCC },
	{ WCD9335_CHIP_TIER_CTRL_I2C_ACTIVE,              0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC1_MON_CTL,           0x06 },
	{ WCD9335_CHIP_TIER_CTRL_PROC1_MON_STATUS,        0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_MSB,       0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC1_MON_CNT_LSB,       0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC2_MON_CTL,           0x06 },
	{ WCD9335_CHIP_TIER_CTRL_PROC2_MON_STATUS,        0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_MSB,       0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC2_MON_CNT_LSB,       0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC3_MON_CTL,           0x06 },
	{ WCD9335_CHIP_TIER_CTRL_PROC3_MON_STATUS,        0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_MSB,       0x00 },
	{ WCD9335_CHIP_TIER_CTRL_PROC3_MON_CNT_LSB,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX_I2S_CTL,           0x0c },
	{ WCD9335_DATA_HUB_DATA_HUB_TX_I2S_CTL,           0x0c },
	{ WCD9335_DATA_HUB_DATA_HUB_I2S_CLK,              0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX4_INP_CFG,          0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX5_INP_CFG,          0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX6_INP_CFG,          0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_RX7_INP_CFG,          0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX0_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX1_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX2_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX3_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX4_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX5_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX6_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX7_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX8_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX9_INP_CFG,       0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX10_INP_CFG,      0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX11_INP_CFG,      0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX13_INP_CFG,      0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX14_INP_CFG,      0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_SB_TX15_INP_CFG,      0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_L_CFG,     0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD0_R_CFG,     0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_L_CFG,     0x00 },
	{ WCD9335_DATA_HUB_DATA_HUB_TX_I2S_SD1_R_CFG,     0x00 },
	{ WCD9335_INTR_CFG,                               0x00 },
	{ WCD9335_INTR_CLR_COMMIT,                        0x00 },
	{ WCD9335_INTR_PIN1_MASK0,                        0xff },
	{ WCD9335_INTR_PIN1_MASK1,                        0xff },
	{ WCD9335_INTR_PIN1_MASK2,                        0xff },
	{ WCD9335_INTR_PIN1_MASK3,                        0xff },
	{ WCD9335_INTR_PIN1_STATUS0,                      0x00 },
	{ WCD9335_INTR_PIN1_STATUS1,                      0x00 },
	{ WCD9335_INTR_PIN1_STATUS2,                      0x00 },
	{ WCD9335_INTR_PIN1_STATUS3,                      0x00 },
	{ WCD9335_INTR_PIN1_CLEAR0,                       0x00 },
	{ WCD9335_INTR_PIN1_CLEAR1,                       0x00 },
	{ WCD9335_INTR_PIN1_CLEAR2,                       0x00 },
	{ WCD9335_INTR_PIN1_CLEAR3,                       0x00 },
	{ WCD9335_INTR_PIN2_MASK0,                        0xff },
	{ WCD9335_INTR_PIN2_MASK1,                        0xff },
	{ WCD9335_INTR_PIN2_MASK2,                        0xff },
	{ WCD9335_INTR_PIN2_MASK3,                        0xff },
	{ WCD9335_INTR_PIN2_STATUS0,                      0x00 },
	{ WCD9335_INTR_PIN2_STATUS1,                      0x00 },
	{ WCD9335_INTR_PIN2_STATUS2,                      0x00 },
	{ WCD9335_INTR_PIN2_STATUS3,                      0x00 },
	{ WCD9335_INTR_PIN2_CLEAR0,                       0x00 },
	{ WCD9335_INTR_PIN2_CLEAR1,                       0x00 },
	{ WCD9335_INTR_PIN2_CLEAR2,                       0x00 },
	{ WCD9335_INTR_PIN2_CLEAR3,                       0x00 },
	{ WCD9335_INTR_LEVEL0,                            0x03 },
	{ WCD9335_INTR_LEVEL1,                            0xe0 },
	{ WCD9335_INTR_LEVEL2,                            0x10 },
	{ WCD9335_INTR_LEVEL3,                            0x80 },
	{ WCD9335_INTR_BYPASS0,                           0x00 },
	{ WCD9335_INTR_BYPASS1,                           0x00 },
	{ WCD9335_INTR_BYPASS2,                           0x00 },
	{ WCD9335_INTR_BYPASS3,                           0x00 },
	{ WCD9335_INTR_SET0,                              0x00 },
	{ WCD9335_INTR_SET1,                              0x00 },
	{ WCD9335_INTR_SET2,                              0x00 },
	{ WCD9335_INTR_SET3,                              0x00 },
	/* Page #1 registers */
	{ WCD9335_PAGE1_PAGE_REGISTER,                    0x00 },
	{ WCD9335_CPE_FLL_USER_CTL_0,                     0x71 },
	{ WCD9335_CPE_FLL_USER_CTL_1,                     0x34 },
	{ WCD9335_CPE_FLL_USER_CTL_2,                     0x0b },
	{ WCD9335_CPE_FLL_USER_CTL_3,                     0x02 },
	{ WCD9335_CPE_FLL_USER_CTL_4,                     0x04 },
	{ WCD9335_CPE_FLL_USER_CTL_5,                     0x02 },
	{ WCD9335_CPE_FLL_USER_CTL_6,                     0x64 },
	{ WCD9335_CPE_FLL_USER_CTL_7,                     0x00 },
	{ WCD9335_CPE_FLL_USER_CTL_8,                     0x94 },
	{ WCD9335_CPE_FLL_USER_CTL_9,                     0x70 },
	{ WCD9335_CPE_FLL_L_VAL_CTL_0,                    0x40 },
	{ WCD9335_CPE_FLL_L_VAL_CTL_1,                    0x00 },
	{ WCD9335_CPE_FLL_DSM_FRAC_CTL_0,                 0x00 },
	{ WCD9335_CPE_FLL_DSM_FRAC_CTL_1,                 0xff },
	{ WCD9335_CPE_FLL_CONFIG_CTL_0,                   0x6b },
	{ WCD9335_CPE_FLL_CONFIG_CTL_1,                   0x05 },
	{ WCD9335_CPE_FLL_CONFIG_CTL_2,                   0x08 },
	{ WCD9335_CPE_FLL_CONFIG_CTL_3,                   0x00 },
	{ WCD9335_CPE_FLL_CONFIG_CTL_4,                   0x10 },
	{ WCD9335_CPE_FLL_TEST_CTL_0,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_1,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_2,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_3,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_4,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_5,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_6,                     0x00 },
	{ WCD9335_CPE_FLL_TEST_CTL_7,                     0x33 },
	{ WCD9335_CPE_FLL_FREQ_CTL_0,                     0x00 },
	{ WCD9335_CPE_FLL_FREQ_CTL_1,                     0x00 },
	{ WCD9335_CPE_FLL_FREQ_CTL_2,                     0x00 },
	{ WCD9335_CPE_FLL_FREQ_CTL_3,                     0x00 },
	{ WCD9335_CPE_FLL_SSC_CTL_0,                      0x00 },
	{ WCD9335_CPE_FLL_SSC_CTL_1,                      0x00 },
	{ WCD9335_CPE_FLL_SSC_CTL_2,                      0x00 },
	{ WCD9335_CPE_FLL_SSC_CTL_3,                      0x00 },
	{ WCD9335_CPE_FLL_FLL_MODE,                       0x20 },
	{ WCD9335_CPE_FLL_STATUS_0,                       0x00 },
	{ WCD9335_CPE_FLL_STATUS_1,                       0x00 },
	{ WCD9335_CPE_FLL_STATUS_2,                       0x00 },
	{ WCD9335_CPE_FLL_STATUS_3,                       0x00 },
	{ WCD9335_I2S_FLL_USER_CTL_0,                     0x41 },
	{ WCD9335_I2S_FLL_USER_CTL_1,                     0x94 },
	{ WCD9335_I2S_FLL_USER_CTL_2,                     0x08 },
	{ WCD9335_I2S_FLL_USER_CTL_3,                     0x02 },
	{ WCD9335_I2S_FLL_USER_CTL_4,                     0x04 },
	{ WCD9335_I2S_FLL_USER_CTL_5,                     0x02 },
	{ WCD9335_I2S_FLL_USER_CTL_6,                     0x40 },
	{ WCD9335_I2S_FLL_USER_CTL_7,                     0x00 },
	{ WCD9335_I2S_FLL_USER_CTL_8,                     0x5f },
	{ WCD9335_I2S_FLL_USER_CTL_9,                     0x02 },
	{ WCD9335_I2S_FLL_L_VAL_CTL_0,                    0x40 },
	{ WCD9335_I2S_FLL_L_VAL_CTL_1,                    0x00 },
	{ WCD9335_I2S_FLL_DSM_FRAC_CTL_0,                 0x00 },
	{ WCD9335_I2S_FLL_DSM_FRAC_CTL_1,                 0xff },
	{ WCD9335_I2S_FLL_CONFIG_CTL_0,                   0x6b },
	{ WCD9335_I2S_FLL_CONFIG_CTL_1,                   0x05 },
	{ WCD9335_I2S_FLL_CONFIG_CTL_2,                   0x08 },
	{ WCD9335_I2S_FLL_CONFIG_CTL_3,                   0x00 },
	{ WCD9335_I2S_FLL_CONFIG_CTL_4,                   0x30 },
	{ WCD9335_I2S_FLL_TEST_CTL_0,                     0x80 },
	{ WCD9335_I2S_FLL_TEST_CTL_1,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_2,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_3,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_4,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_5,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_6,                     0x00 },
	{ WCD9335_I2S_FLL_TEST_CTL_7,                     0xff },
	{ WCD9335_I2S_FLL_FREQ_CTL_0,                     0x00 },
	{ WCD9335_I2S_FLL_FREQ_CTL_1,                     0x00 },
	{ WCD9335_I2S_FLL_FREQ_CTL_2,                     0x00 },
	{ WCD9335_I2S_FLL_FREQ_CTL_3,                     0x00 },
	{ WCD9335_I2S_FLL_SSC_CTL_0,                      0x00 },
	{ WCD9335_I2S_FLL_SSC_CTL_1,                      0x00 },
	{ WCD9335_I2S_FLL_SSC_CTL_2,                      0x00 },
	{ WCD9335_I2S_FLL_SSC_CTL_3,                      0x00 },
	{ WCD9335_I2S_FLL_FLL_MODE,                       0x00 },
	{ WCD9335_I2S_FLL_STATUS_0,                       0x00 },
	{ WCD9335_I2S_FLL_STATUS_1,                       0x00 },
	{ WCD9335_I2S_FLL_STATUS_2,                       0x00 },
	{ WCD9335_I2S_FLL_STATUS_3,                       0x00 },
	{ WCD9335_SB_FLL_USER_CTL_0,                      0x41 },
	{ WCD9335_SB_FLL_USER_CTL_1,                      0x94 },
	{ WCD9335_SB_FLL_USER_CTL_2,                      0x08 },
	{ WCD9335_SB_FLL_USER_CTL_3,                      0x02 },
	{ WCD9335_SB_FLL_USER_CTL_4,                      0x04 },
	{ WCD9335_SB_FLL_USER_CTL_5,                      0x02 },
	{ WCD9335_SB_FLL_USER_CTL_6,                      0x40 },
	{ WCD9335_SB_FLL_USER_CTL_7,                      0x00 },
	{ WCD9335_SB_FLL_USER_CTL_8,                      0x5e },
	{ WCD9335_SB_FLL_USER_CTL_9,                      0x01 },
	{ WCD9335_SB_FLL_L_VAL_CTL_0,                     0x40 },
	{ WCD9335_SB_FLL_L_VAL_CTL_1,                     0x00 },
	{ WCD9335_SB_FLL_DSM_FRAC_CTL_0,                  0x00 },
	{ WCD9335_SB_FLL_DSM_FRAC_CTL_1,                  0xff },
	{ WCD9335_SB_FLL_CONFIG_CTL_0,                    0x6b },
	{ WCD9335_SB_FLL_CONFIG_CTL_1,                    0x05 },
	{ WCD9335_SB_FLL_CONFIG_CTL_2,                    0x08 },
	{ WCD9335_SB_FLL_CONFIG_CTL_3,                    0x00 },
	{ WCD9335_SB_FLL_CONFIG_CTL_4,                    0x10 },
	{ WCD9335_SB_FLL_TEST_CTL_0,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_1,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_2,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_3,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_4,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_5,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_6,                      0x00 },
	{ WCD9335_SB_FLL_TEST_CTL_7,                      0xff },
	{ WCD9335_SB_FLL_FREQ_CTL_0,                      0x00 },
	{ WCD9335_SB_FLL_FREQ_CTL_1,                      0x00 },
	{ WCD9335_SB_FLL_FREQ_CTL_2,                      0x00 },
	{ WCD9335_SB_FLL_FREQ_CTL_3,                      0x00 },
	{ WCD9335_SB_FLL_SSC_CTL_0,                       0x00 },
	{ WCD9335_SB_FLL_SSC_CTL_1,                       0x00 },
	{ WCD9335_SB_FLL_SSC_CTL_2,                       0x00 },
	{ WCD9335_SB_FLL_SSC_CTL_3,                       0x00 },
	{ WCD9335_SB_FLL_FLL_MODE,                        0x00 },
	{ WCD9335_SB_FLL_STATUS_0,                        0x00 },
	{ WCD9335_SB_FLL_STATUS_1,                        0x00 },
	{ WCD9335_SB_FLL_STATUS_2,                        0x00 },
	{ WCD9335_SB_FLL_STATUS_3,                        0x00 },
	/* Page #2 registers */
	{ WCD9335_PAGE2_PAGE_REGISTER,                    0x00 },
	{ WCD9335_CPE_SS_MEM_PTR_0,                       0x00 },
	{ WCD9335_CPE_SS_MEM_PTR_1,                       0x00 },
	{ WCD9335_CPE_SS_MEM_PTR_2,                       0x00 },
	{ WCD9335_CPE_SS_MEM_CTRL,                        0x08 },
	{ WCD9335_CPE_SS_MEM_BANK_0,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_1,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_2,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_3,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_4,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_5,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_6,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_7,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_8,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_9,                      0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_10,                     0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_11,                     0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_12,                     0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_13,                     0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_14,                     0x00 },
	{ WCD9335_CPE_SS_MEM_BANK_15,                     0x00 },
	{ WCD9335_CPE_SS_INBOX1_TRG,                      0x00 },
	{ WCD9335_CPE_SS_INBOX2_TRG,                      0x00 },
	{ WCD9335_CPE_SS_INBOX1_0,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_1,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_2,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_3,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_4,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_5,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_6,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_7,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_8,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_9,                        0x00 },
	{ WCD9335_CPE_SS_INBOX1_10,                       0x00 },
	{ WCD9335_CPE_SS_INBOX1_11,                       0x00 },
	{ WCD9335_CPE_SS_INBOX1_12,                       0x00 },
	{ WCD9335_CPE_SS_INBOX1_13,                       0x00 },
	{ WCD9335_CPE_SS_INBOX1_14,                       0x00 },
	{ WCD9335_CPE_SS_INBOX1_15,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_0,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_1,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_2,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_3,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_4,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_5,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_6,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_7,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_8,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_9,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_10,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_11,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_12,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_13,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_14,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_15,                      0x00 },
	{ WCD9335_CPE_SS_INBOX2_0,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_1,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_2,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_3,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_4,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_5,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_6,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_7,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_8,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_9,                        0x00 },
	{ WCD9335_CPE_SS_INBOX2_10,                       0x00 },
	{ WCD9335_CPE_SS_INBOX2_11,                       0x00 },
	{ WCD9335_CPE_SS_INBOX2_12,                       0x00 },
	{ WCD9335_CPE_SS_INBOX2_13,                       0x00 },
	{ WCD9335_CPE_SS_INBOX2_14,                       0x00 },
	{ WCD9335_CPE_SS_INBOX2_15,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_0,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_1,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_2,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_3,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_4,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_5,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_6,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_7,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_8,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_9,                       0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_10,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_11,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_12,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_13,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_14,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_15,                      0x00 },
	{ WCD9335_CPE_SS_OUTBOX1_ACK,                     0x00 },
	{ WCD9335_CPE_SS_OUTBOX2_ACK,                     0x00 },
	{ WCD9335_CPE_SS_EC_BUF_INT_PERIOD,               0x3c },
	{ WCD9335_CPE_SS_US_BUF_INT_PERIOD,               0x60 },
	{ WCD9335_CPE_SS_CFG,                             0x41 },
	{ WCD9335_CPE_SS_US_EC_MUX_CFG,                   0x00 },
	{ WCD9335_CPE_SS_MAD_CTL,                         0x00 },
	{ WCD9335_CPE_SS_CPAR_CTL,                        0x00 },
	{ WCD9335_CPE_SS_DMIC0_CTL,                       0x00 },
	{ WCD9335_CPE_SS_DMIC1_CTL,                       0x00 },
	{ WCD9335_CPE_SS_DMIC2_CTL,                       0x00 },
	{ WCD9335_CPE_SS_DMIC_CFG,                        0x80 },
	{ WCD9335_CPE_SS_CPAR_CFG,                        0x00 },
	{ WCD9335_CPE_SS_WDOG_CFG,                        0x01 },
	{ WCD9335_CPE_SS_BACKUP_INT,                      0x00 },
	{ WCD9335_CPE_SS_STATUS,                          0x00 },
	{ WCD9335_CPE_SS_CPE_OCD_CFG,                     0x00 },
	{ WCD9335_CPE_SS_SS_ERROR_INT_STATUS,             0x00 },
	{ WCD9335_CPE_SS_SS_ERROR_INT_CLEAR,              0x00 },
	{ WCD9335_SOC_MAD_MAIN_CTL_1,                     0x00 },
	{ WCD9335_SOC_MAD_MAIN_CTL_2,                     0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_1,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_2,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_3,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_4,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_5,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_6,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_7,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_CTL_8,                    0x00 },
	{ WCD9335_SOC_MAD_AUDIO_IIR_CTL_PTR,              0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_1,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_2,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_3,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_4,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_5,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_6,                     0x00 },
	{ WCD9335_SOC_MAD_ULTR_CTL_7,                     0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_1,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_2,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_3,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_4,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_5,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_6,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_7,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_CTL_8,                   0x00 },
	{ WCD9335_SOC_MAD_BEACON_IIR_CTL_PTR,             0x00 },
	{ WCD9335_SOC_MAD_BEACON_IIR_CTL_VAL,             0x00 },
	{ WCD9335_SOC_MAD_INP_SEL,                        0x00 },
	/* Page #6 registers */
	{ WCD9335_PAGE6_PAGE_REGISTER,                    0x00 },
	{ WCD9335_ANA_BIAS,                               0x00 },
	{ WCD9335_ANA_CLK_TOP,                            0x00 },
	{ WCD9335_ANA_RCO,                                0x30 },
	{ WCD9335_ANA_BUCK_VOUT_A,                        0xb4 },
	{ WCD9335_ANA_BUCK_VOUT_D,                        0xb4 },
	{ WCD9335_ANA_BUCK_CTL,                           0x00 },
	{ WCD9335_ANA_BUCK_STATUS,                        0xe0 },
	{ WCD9335_ANA_RX_SUPPLIES,                        0x00 },
	{ WCD9335_ANA_HPH,                                0x00 },
	{ WCD9335_ANA_EAR,                                0x00 },
	{ WCD9335_ANA_LO_1_2,                             0x00 },
	{ WCD9335_ANA_LO_3_4,                             0x00 },
	{ WCD9335_ANA_MAD_SETUP,                          0x81 },
	{ WCD9335_ANA_AMIC1,                              0x20 },
	{ WCD9335_ANA_AMIC2,                              0x00 },
	{ WCD9335_ANA_AMIC3,                              0x20 },
	{ WCD9335_ANA_AMIC4,                              0x00 },
	{ WCD9335_ANA_AMIC5,                              0x20 },
	{ WCD9335_ANA_AMIC6,                              0x00 },
	{ WCD9335_ANA_MBHC_MECH,                          0x39 },
	{ WCD9335_ANA_MBHC_ELECT,                         0x08 },
	{ WCD9335_ANA_MBHC_ZDET,                          0x00 },
	{ WCD9335_ANA_MBHC_RESULT_1,                      0x00 },
	{ WCD9335_ANA_MBHC_RESULT_2,                      0x00 },
	{ WCD9335_ANA_MBHC_RESULT_3,                      0x00 },
	{ WCD9335_ANA_MBHC_BTN0,                          0x00 },
	{ WCD9335_ANA_MBHC_BTN1,                          0x10 },
	{ WCD9335_ANA_MBHC_BTN2,                          0x20 },
	{ WCD9335_ANA_MBHC_BTN3,                          0x30 },
	{ WCD9335_ANA_MBHC_BTN4,                          0x40 },
	{ WCD9335_ANA_MBHC_BTN5,                          0x50 },
	{ WCD9335_ANA_MBHC_BTN6,                          0x60 },
	{ WCD9335_ANA_MBHC_BTN7,                          0x70 },
	{ WCD9335_ANA_MICB1,                              0x10 },
	{ WCD9335_ANA_MICB2,                              0x10 },
	{ WCD9335_ANA_MICB2_RAMP,                         0x00 },
	{ WCD9335_ANA_MICB3,                              0x10 },
	{ WCD9335_ANA_MICB4,                              0x10 },
	{ WCD9335_ANA_VBADC,                              0x00 },
	{ WCD9335_BIAS_CTL,                               0x28 },
	{ WCD9335_CLOCK_TEST_CTL,                         0x00 },
	{ WCD9335_RCO_CTRL_1,                             0x44 },
	{ WCD9335_RCO_CTRL_2,                             0x44 },
	{ WCD9335_RCO_CAL,                                0x00 },
	{ WCD9335_RCO_CAL_1,                              0x00 },
	{ WCD9335_RCO_CAL_2,                              0x00 },
	{ WCD9335_RCO_TEST_CTRL,                          0x00 },
	{ WCD9335_RCO_CAL_OUT_1,                          0x00 },
	{ WCD9335_RCO_CAL_OUT_2,                          0x00 },
	{ WCD9335_RCO_CAL_OUT_3,                          0x00 },
	{ WCD9335_RCO_CAL_OUT_4,                          0x00 },
	{ WCD9335_RCO_CAL_OUT_5,                          0x00 },
	{ WCD9335_SIDO_SIDO_MODE_1,                       0x84 },
	{ WCD9335_SIDO_SIDO_MODE_2,                       0xfe },
	{ WCD9335_SIDO_SIDO_MODE_3,                       0xf6 },
	{ WCD9335_SIDO_SIDO_MODE_4,                       0x56 },
	{ WCD9335_SIDO_SIDO_VCL_1,                        0x00 },
	{ WCD9335_SIDO_SIDO_VCL_2,                        0x6c },
	{ WCD9335_SIDO_SIDO_VCL_3,                        0x44 },
	{ WCD9335_SIDO_SIDO_CCL_1,                        0x57 },
	{ WCD9335_SIDO_SIDO_CCL_4,                        0x61 },
	{ WCD9335_SIDO_SIDO_CCL_5,                        0x6d },
	{ WCD9335_SIDO_SIDO_CCL_6,                        0x60 },
	{ WCD9335_SIDO_SIDO_CCL_7,                        0x6f },
	{ WCD9335_SIDO_SIDO_CCL_9,                        0x6e },
	{ WCD9335_SIDO_SIDO_FILTER_1,                     0x92 },
	{ WCD9335_SIDO_SIDO_FILTER_2,                     0x54 },
	{ WCD9335_SIDO_SIDO_DRIVER_1,                     0x77 },
	{ WCD9335_SIDO_SIDO_CAL_CODE_EXT_1,               0x9c },
	{ WCD9335_SIDO_SIDO_CAL_CODE_EXT_2,               0x82 },
	{ WCD9335_SIDO_SIDO_CAL_CODE_OUT_1,               0x00 },
	{ WCD9335_SIDO_SIDO_CAL_CODE_OUT_2,               0x00 },
	{ WCD9335_SIDO_SIDO_TEST_1,                       0x00 },
	{ WCD9335_MBHC_CTL_1,                             0x32 },
	{ WCD9335_MBHC_CTL_2,                             0x01 },
	{ WCD9335_MBHC_PLUG_DETECT_CTL,                   0x69 },
	{ WCD9335_MBHC_ZDET_RAMP_CTL,                     0x00 },
	{ WCD9335_MBHC_TEST_CTL,                          0x00 },
	{ WCD9335_VBADC_SUBBLOCK_EN,                      0xfe },
	{ WCD9335_VBADC_IBIAS_FE,                         0x54 },
	{ WCD9335_VBADC_BIAS_ADC,                         0x51 },
	{ WCD9335_VBADC_FE_CTRL,                          0x1c },
	{ WCD9335_VBADC_ADC_REF,                          0x20 },
	{ WCD9335_VBADC_ADC_IO,                           0x80 },
	{ WCD9335_VBADC_ADC_SAR,                          0xff },
	{ WCD9335_VBADC_DEBUG,                            0x00 },
	{ WCD9335_VBADC_ADC_DOUTMSB,                      0x00 },
	{ WCD9335_VBADC_ADC_DOUTLSB,                      0x00 },
	{ WCD9335_LDOH_MODE,                              0x2b },
	{ WCD9335_LDOH_BIAS,                              0x68 },
	{ WCD9335_LDOH_STB_LOADS,                         0x00 },
	{ WCD9335_LDOH_SLOWRAMP,                          0x50 },
	{ WCD9335_MICB1_TEST_CTL_1,                       0x1a },
	{ WCD9335_MICB1_TEST_CTL_2,                       0x18 },
	{ WCD9335_MICB1_TEST_CTL_3,                       0xa4 },
	{ WCD9335_MICB2_TEST_CTL_1,                       0x1a },
	{ WCD9335_MICB2_TEST_CTL_2,                       0x18 },
	{ WCD9335_MICB2_TEST_CTL_3,                       0x24 },
	{ WCD9335_MICB3_TEST_CTL_1,                       0x1a },
	{ WCD9335_MICB3_TEST_CTL_2,                       0x18 },
	{ WCD9335_MICB3_TEST_CTL_3,                       0xa4 },
	{ WCD9335_MICB4_TEST_CTL_1,                       0x1a },
	{ WCD9335_MICB4_TEST_CTL_2,                       0x18 },
	{ WCD9335_MICB4_TEST_CTL_3,                       0xa4 },
	{ WCD9335_TX_COM_ADC_VCM,                         0x39 },
	{ WCD9335_TX_COM_BIAS_ATEST,                      0xc0 },
	{ WCD9335_TX_COM_ADC_INT1_IB,                     0x6f },
	{ WCD9335_TX_COM_ADC_INT2_IB,                     0x4f },
	{ WCD9335_TX_COM_TXFE_DIV_CTL,                    0x2e },
	{ WCD9335_TX_COM_TXFE_DIV_START,                  0x00 },
	{ WCD9335_TX_COM_TXFE_DIV_STOP_9P6M,              0xc7 },
	{ WCD9335_TX_COM_TXFE_DIV_STOP_12P288M,           0xff },
	{ WCD9335_TX_1_2_TEST_EN,                         0xcc },
	{ WCD9335_TX_1_2_ADC_IB,                          0x09 },
	{ WCD9335_TX_1_2_TEST_CTL,                        0x38 },
	{ WCD9335_TX_1_2_TEST_BLK_EN,                     0xff },
	{ WCD9335_TX_1_2_TXFE_CLKDIV,                     0x00 },
	{ WCD9335_TX_1_2_SAR1_ERR,                        0x00 },
	{ WCD9335_TX_1_2_SAR2_ERR,                        0x00 },
	{ WCD9335_TX_3_4_TEST_EN,                         0xcc },
	{ WCD9335_TX_3_4_ADC_IB,                          0x09 },
	{ WCD9335_TX_3_4_TEST_CTL,                        0x38 },
	{ WCD9335_TX_3_4_TEST_BLK_EN,                     0xff },
	{ WCD9335_TX_3_4_TXFE_CLKDIV,                     0x00 },
	{ WCD9335_TX_3_4_SAR1_ERR,                        0x00 },
	{ WCD9335_TX_3_4_SAR2_ERR,                        0x00 },
	{ WCD9335_TX_5_6_TEST_EN,                         0xcc },
	{ WCD9335_TX_5_6_ADC_IB,                          0x09 },
	{ WCD9335_TX_5_6_TEST_CTL,                        0x38 },
	{ WCD9335_TX_5_6_TEST_BLK_EN,                     0xff },
	{ WCD9335_TX_5_6_TXFE_CLKDIV,                     0x00 },
	{ WCD9335_TX_5_6_SAR1_ERR,                        0x00 },
	{ WCD9335_TX_5_6_SAR2_ERR,                        0x00 },
	{ WCD9335_CLASSH_MODE_1,                          0x40 },
	{ WCD9335_CLASSH_MODE_2,                          0x3a },
	{ WCD9335_CLASSH_MODE_3,                          0x00 },
	{ WCD9335_CLASSH_CTRL_VCL_1,                      0x70 },
	{ WCD9335_CLASSH_CTRL_VCL_2,                      0xa2 },
	{ WCD9335_CLASSH_CTRL_CCL_1,                      0x51 },
	{ WCD9335_CLASSH_CTRL_CCL_2,                      0x80 },
	{ WCD9335_CLASSH_CTRL_CCL_3,                      0x80 },
	{ WCD9335_CLASSH_CTRL_CCL_4,                      0x51 },
	{ WCD9335_CLASSH_CTRL_CCL_5,                      0x00 },
	{ WCD9335_CLASSH_BUCK_TMUX_A_D,                   0x00 },
	{ WCD9335_CLASSH_BUCK_SW_DRV_CNTL,                0x77 },
	{ WCD9335_CLASSH_SPARE,                           0x00 },
	{ WCD9335_FLYBACK_EN,                             0x4e },
	{ WCD9335_FLYBACK_VNEG_CTRL_2,                    0x45 },
	{ WCD9335_FLYBACK_VNEG_CTRL_3,                    0x74 },
	{ WCD9335_FLYBACK_VNEG_CTRL_5,                    0x83 },
	{ WCD9335_FLYBACK_VNEG_CTRL_6,                    0x98 },
	{ WCD9335_FLYBACK_VNEG_CTRL_7,                    0xa9 },
	{ WCD9335_FLYBACK_VNEG_CTRL_8,                    0x68 },
	{ WCD9335_FLYBACK_VNEG_DAC_CTRL_2,                0x50 },
	{ WCD9335_FLYBACK_VNEG_DAC_CTRL_3,                0xa6 },
	{ WCD9335_FLYBACK_TEST_CTL,                       0x00 },
	{ WCD9335_RX_AUX_SW_CTL,                          0x00 },
	{ WCD9335_RX_PA_AUX_IN_CONN,                      0x00 },
	{ WCD9335_RX_TIMER_DIV,                           0x74 },
	{ WCD9335_RX_OCP_CTL,                             0x1f },
	{ WCD9335_RX_OCP_COUNT,                           0x77 },
	{ WCD9335_RX_BIAS_EAR_DAC,                        0xa0 },
	{ WCD9335_RX_BIAS_EAR_AMP,                        0xaa },
	{ WCD9335_RX_BIAS_HPH_LDO,                        0xa9 },
	{ WCD9335_RX_BIAS_HPH_RDACBUFF_CNP2,              0x8a },
	{ WCD9335_RX_BIAS_HPH_RDAC_LDO,                   0x88 },
	{ WCD9335_RX_BIAS_HPH_CNP1,                       0x86 },
	{ WCD9335_RX_BIAS_DIFFLO_PA,                      0x80 },
	{ WCD9335_RX_BIAS_DIFFLO_REF,                     0x88 },
	{ WCD9335_RX_BIAS_DIFFLO_LDO,                     0x88 },
	{ WCD9335_RX_BIAS_SELO_DAC_PA,                    0xa8 },
	{ WCD9335_RX_BIAS_BUCK_RST,                       0x08 },
	{ WCD9335_RX_BIAS_BUCK_VREF_ERRAMP,               0x44 },
	{ WCD9335_RX_BIAS_FLYB_ERRAMP,                    0x40 },
	{ WCD9335_RX_BIAS_FLYB_BUFF,                      0xaa },
	{ WCD9335_RX_BIAS_FLYB_MID_RST,                   0x44 },
	{ WCD9335_HPH_L_STATUS,                           0x04 },
	{ WCD9335_HPH_R_STATUS,                           0x04 },
	{ WCD9335_HPH_CNP_EN,                             0x80 },
	{ WCD9335_HPH_CNP_WG_CTL,                         0xda },
	{ WCD9335_HPH_CNP_WG_TIME,                        0x15 },
	{ WCD9335_HPH_OCP_CTL,                            0x28 },
	{ WCD9335_HPH_AUTO_CHOP,                          0x12 },
	{ WCD9335_HPH_CHOP_CTL,                           0x83 },
	{ WCD9335_HPH_PA_CTL1,                            0x46 },
	{ WCD9335_HPH_L_TEST,                             0x00 },
	{ WCD9335_HPH_L_ATEST,                            0x50 },
	{ WCD9335_HPH_R_TEST,                             0x00 },
	{ WCD9335_HPH_RDAC_CLK_CTL1,                      0x99 },
	{ WCD9335_HPH_RDAC_CLK_CTL2,                      0x9b },
	{ WCD9335_HPH_RDAC_CHOP_CLK_LP_CTL,               0x00 },
	{ WCD9335_HPH_REFBUFF_UHQA_CTL,                   0xa8 },
	{ WCD9335_HPH_REFBUFF_LP_CTL,                     0x00 },
	{ WCD9335_HPH_L_DAC_CTL,                          0x00 },
	{ WCD9335_HPH_R_DAC_CTL,                          0x00 },
	{ WCD9335_EAR_EN_REG,                             0x60 },
	{ WCD9335_EAR_CMBUFF,                             0x0d },
	{ WCD9335_EAR_ICTL,                               0x40 },
	{ WCD9335_EAR_EN_DBG_CTL,                         0x00 },
	{ WCD9335_EAR_CNP,                                0xe0 },
	{ WCD9335_EAR_DAC_CTL_ATEST,                      0x00 },
	{ WCD9335_EAR_STATUS_REG,                         0x04 },
	{ WCD9335_EAR_OUT_SHORT,                          0x00 },
	{ WCD9335_DIFF_LO_MISC,                           0x03 },
	{ WCD9335_DIFF_LO_LO2_COMPANDER,                  0x00 },
	{ WCD9335_DIFF_LO_LO1_COMPANDER,                  0x00 },
	{ WCD9335_DIFF_LO_COMMON,                         0x40 },
	{ WCD9335_DIFF_LO_BYPASS_EN,                      0x00 },
	{ WCD9335_DIFF_LO_CNP,                            0x20 },
	{ WCD9335_DIFF_LO_CORE_OUT_PROG,                  0x00 },
	{ WCD9335_DIFF_LO_LDO_OUT_PROG,                   0x00 },
	{ WCD9335_DIFF_LO_COM_SWCAP_REFBUF_FREQ,          0x9b },
	{ WCD9335_DIFF_LO_COM_PA_FREQ,                    0xb0 },
	{ WCD9335_DIFF_LO_RESERVED_REG,                   0x60 },
	{ WCD9335_DIFF_LO_LO1_STATUS_1,                   0x00 },
	{ WCD9335_DIFF_LO_LO1_STATUS_2,                   0x00 },
	{ WCD9335_SE_LO_COM1,                             0x80 },
	{ WCD9335_SE_LO_COM2,                             0x04 },
	{ WCD9335_SE_LO_LO3_GAIN,                         0x20 },
	{ WCD9335_SE_LO_LO3_CTRL,                         0x04 },
	{ WCD9335_SE_LO_LO4_GAIN,                         0x20 },
	{ WCD9335_SE_LO_LO4_CTRL,                         0x04 },
	{ WCD9335_SE_LO_LO3_STATUS,                       0x00 },
	{ WCD9335_SE_LO_LO4_STATUS,                       0x00 },
	/* Page #10 registers */
	{ WCD9335_PAGE10_PAGE_REGISTER,                   0x00 },
	{ WCD9335_CDC_ANC0_CLK_RESET_CTL,                 0x00 },
	{ WCD9335_CDC_ANC0_MODE_1_CTL,                    0x00 },
	{ WCD9335_CDC_ANC0_MODE_2_CTL,                    0x00 },
	{ WCD9335_CDC_ANC0_FF_SHIFT,                      0x00 },
	{ WCD9335_CDC_ANC0_FB_SHIFT,                      0x00 },
	{ WCD9335_CDC_ANC0_LPF_FF_A_CTL,                  0x00 },
	{ WCD9335_CDC_ANC0_LPF_FF_B_CTL,                  0x00 },
	{ WCD9335_CDC_ANC0_LPF_FB_CTL,                    0x00 },
	{ WCD9335_CDC_ANC0_SMLPF_CTL,                     0x00 },
	{ WCD9335_CDC_ANC0_DCFLT_SHIFT_CTL,               0x00 },
	{ WCD9335_CDC_ANC0_IIR_ADAPT_CTL,                 0x00 },
	{ WCD9335_CDC_ANC0_IIR_COEFF_1_CTL,               0x00 },
	{ WCD9335_CDC_ANC0_IIR_COEFF_2_CTL,               0x00 },
	{ WCD9335_CDC_ANC0_FF_A_GAIN_CTL,                 0x00 },
	{ WCD9335_CDC_ANC0_FF_B_GAIN_CTL,                 0x00 },
	{ WCD9335_CDC_ANC0_FB_GAIN_CTL,                   0x00 },
	{ WCD9335_CDC_ANC1_CLK_RESET_CTL,                 0x00 },
	{ WCD9335_CDC_ANC1_MODE_1_CTL,                    0x00 },
	{ WCD9335_CDC_ANC1_MODE_2_CTL,                    0x00 },
	{ WCD9335_CDC_ANC1_FF_SHIFT,                      0x00 },
	{ WCD9335_CDC_ANC1_FB_SHIFT,                      0x00 },
	{ WCD9335_CDC_ANC1_LPF_FF_A_CTL,                  0x00 },
	{ WCD9335_CDC_ANC1_LPF_FF_B_CTL,                  0x00 },
	{ WCD9335_CDC_ANC1_LPF_FB_CTL,                    0x00 },
	{ WCD9335_CDC_ANC1_SMLPF_CTL,                     0x00 },
	{ WCD9335_CDC_ANC1_DCFLT_SHIFT_CTL,               0x00 },
	{ WCD9335_CDC_ANC1_IIR_ADAPT_CTL,                 0x00 },
	{ WCD9335_CDC_ANC1_IIR_COEFF_1_CTL,               0x00 },
	{ WCD9335_CDC_ANC1_IIR_COEFF_2_CTL,               0x00 },
	{ WCD9335_CDC_ANC1_FF_A_GAIN_CTL,                 0x00 },
	{ WCD9335_CDC_ANC1_FF_B_GAIN_CTL,                 0x00 },
	{ WCD9335_CDC_ANC1_FB_GAIN_CTL,                   0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX0_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX0_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX1_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX1_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX2_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX2_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX3_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX3_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX4_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX4_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX5_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX5_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX6_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX6_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX7_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX7_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_TX8_TX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_192_CTL,                0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_192_CFG,                0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC0,                   0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC1,                   0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC4,                   0x20 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_TX8_TX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_TX9_SPKR_PROT_PATH_CTL,             0x02 },
	{ WCD9335_CDC_TX9_SPKR_PROT_PATH_CFG0,            0x00 },
	{ WCD9335_CDC_TX10_SPKR_PROT_PATH_CTL,            0x02 },
	{ WCD9335_CDC_TX10_SPKR_PROT_PATH_CFG0,           0x00 },
	{ WCD9335_CDC_TX11_SPKR_PROT_PATH_CTL,            0x02 },
	{ WCD9335_CDC_TX11_SPKR_PROT_PATH_CFG0,           0x00 },
	{ WCD9335_CDC_TX12_SPKR_PROT_PATH_CTL,            0x02 },
	{ WCD9335_CDC_TX12_SPKR_PROT_PATH_CFG0,           0x00 },
	/* Page #11 registers */
	{ WCD9335_PAGE11_PAGE_REGISTER,                   0x00 },
	{ WCD9335_CDC_COMPANDER1_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER1_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER1_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER1_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER1_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER1_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER1_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER2_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER2_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER2_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER2_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER2_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER2_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER2_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER3_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER3_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER3_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER3_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER3_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER3_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER3_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER4_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER4_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER4_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER4_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER4_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER4_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER4_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER5_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER5_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER5_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER5_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER5_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER5_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER5_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER6_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER6_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER6_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER6_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER6_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER6_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER6_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER7_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER7_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER7_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER7_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER7_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER7_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER7_CTL6,                    0x01 },
	{ WCD9335_CDC_COMPANDER8_CTL0,                    0x60 },
	{ WCD9335_CDC_COMPANDER8_CTL1,                    0xdb },
	{ WCD9335_CDC_COMPANDER8_CTL2,                    0xff },
	{ WCD9335_CDC_COMPANDER8_CTL3,                    0x35 },
	{ WCD9335_CDC_COMPANDER8_CTL4,                    0xff },
	{ WCD9335_CDC_COMPANDER8_CTL5,                    0x00 },
	{ WCD9335_CDC_COMPANDER8_CTL6,                    0x01 },
	{ WCD9335_CDC_RX0_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX0_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX0_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX0_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX0_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX1_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX1_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX1_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC4,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX1_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX2_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX2_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX2_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC4,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX2_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX3_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX3_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX3_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX3_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX4_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX4_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX4_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX4_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX5_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX5_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX5_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX5_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX6_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX6_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX6_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX6_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX7_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX7_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX7_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX7_RX_PATH_MIX_SEC1,               0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_CTL,                    0x04 },
	{ WCD9335_CDC_RX8_RX_PATH_CFG0,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_CFG2,                   0x8f },
	{ WCD9335_CDC_RX8_RX_VOL_CTL,                     0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_CTL,                0x04 },
	{ WCD9335_CDC_RX8_RX_VOL_MIX_CTL,                 0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC2,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC3,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC5,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC6,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_SEC7,                   0x00 },
	{ WCD9335_CDC_RX8_RX_PATH_MIX_SEC1,               0x00 },
	/* Page #12 registers */
	{ WCD9335_PAGE12_PAGE_REGISTER,                   0x00 },
	{ WCD9335_CDC_CLSH_CRC,                           0x00 },
	{ WCD9335_CDC_CLSH_DLY_CTRL,                      0x03 },
	{ WCD9335_CDC_CLSH_DECAY_CTRL,                    0x02 },
	{ WCD9335_CDC_CLSH_HPH_V_PA,                      0x1c },
	{ WCD9335_CDC_CLSH_EAR_V_PA,                      0x39 },
	{ WCD9335_CDC_CLSH_HPH_V_HD,                      0x0c },
	{ WCD9335_CDC_CLSH_EAR_V_HD,                      0x0c },
	{ WCD9335_CDC_CLSH_K1_MSB,                        0x01 },
	{ WCD9335_CDC_CLSH_K1_LSB,                        0x00 },
	{ WCD9335_CDC_CLSH_K2_MSB,                        0x00 },
	{ WCD9335_CDC_CLSH_K2_LSB,                        0x80 },
	{ WCD9335_CDC_CLSH_IDLE_CTRL,                     0x00 },
	{ WCD9335_CDC_CLSH_IDLE_HPH,                      0x00 },
	{ WCD9335_CDC_CLSH_IDLE_EAR,                      0x00 },
	{ WCD9335_CDC_CLSH_TEST0,                         0x07 },
	{ WCD9335_CDC_CLSH_TEST1,                         0x00 },
	{ WCD9335_CDC_CLSH_OVR_VREF,                      0x00 },
	{ WCD9335_CDC_BOOST0_BOOST_PATH_CTL,              0x00 },
	{ WCD9335_CDC_BOOST0_BOOST_CTL,                   0xb2 },
	{ WCD9335_CDC_BOOST0_BOOST_CFG1,                  0x00 },
	{ WCD9335_CDC_BOOST0_BOOST_CFG2,                  0x00 },
	{ WCD9335_CDC_BOOST1_BOOST_PATH_CTL,              0x00 },
	{ WCD9335_CDC_BOOST1_BOOST_CTL,                   0xb2 },
	{ WCD9335_CDC_BOOST1_BOOST_CFG1,                  0x00 },
	{ WCD9335_CDC_BOOST1_BOOST_CFG2,                  0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_DATA_0,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_DATA_1,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_DATA_2,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_DATA_3,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_ADDR_0,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_ADDR_1,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_ADDR_2,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_WR_ADDR_3,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_ADDR_0,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_ADDR_1,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_ADDR_2,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_ADDR_3,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_DATA_0,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_DATA_1,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_DATA_2,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_RD_DATA_3,               0x00 },
	{ WCD9335_SWR_AHB_BRIDGE_ACCESS_CFG,              0x0f },
	{ WCD9335_SWR_AHB_BRIDGE_ACCESS_STATUS,           0x03 },
	{ WCD9335_CDC_VBAT_VBAT_PATH_CTL,                 0x00 },
	{ WCD9335_CDC_VBAT_VBAT_CFG,                      0x0a },
	{ WCD9335_CDC_VBAT_VBAT_ADC_CAL1,                 0x00 },
	{ WCD9335_CDC_VBAT_VBAT_ADC_CAL2,                 0x00 },
	{ WCD9335_CDC_VBAT_VBAT_ADC_CAL3,                 0x04 },
	{ WCD9335_CDC_VBAT_VBAT_PK_EST1,                  0xe0 },
	{ WCD9335_CDC_VBAT_VBAT_PK_EST2,                  0x01 },
	{ WCD9335_CDC_VBAT_VBAT_PK_EST3,                  0x40 },
	{ WCD9335_CDC_VBAT_VBAT_RF_PROC1,                 0x2a },
	{ WCD9335_CDC_VBAT_VBAT_RF_PROC2,                 0x86 },
	{ WCD9335_CDC_VBAT_VBAT_TAC1,                     0x70 },
	{ WCD9335_CDC_VBAT_VBAT_TAC2,                     0x18 },
	{ WCD9335_CDC_VBAT_VBAT_TAC3,                     0x18 },
	{ WCD9335_CDC_VBAT_VBAT_TAC4,                     0x03 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_UPD1,                0x01 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_UPD2,                0x00 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_UPD3,                0x64 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_UPD4,                0x01 },
	{ WCD9335_CDC_VBAT_VBAT_DEBUG1,                   0x00 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_UPD_MON,             0x00 },
	{ WCD9335_CDC_VBAT_VBAT_GAIN_MON_VAL,             0x00 },
	{ WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL,      0x04 },
	{ WCD9335_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1,     0x00 },
	{ WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CTL,      0x04 },
	{ WCD9335_CDC_SIDETONE_SRC1_ST_SRC_PATH_CFG1,     0x00 },
	/* Page #13 registers */
	{ WCD9335_PAGE13_PAGE_REGISTER,                   0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT0_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT1_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT2_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT3_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT4_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT5_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT6_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT7_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG0,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_INT8_CFG1,            0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG0,             0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG1,             0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG2,             0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG3,             0x00 },
	{ WCD9335_CDC_RX_INP_MUX_RX_MIX_CFG4,             0x00 },
	{ WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0,       0x00 },
	{ WCD9335_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1,       0x00 },
	{ WCD9335_CDC_RX_INP_MUX_ANC_CFG0,                0x00 },
	{ WCD9335_CDC_RX_INP_MUX_SPLINE_SRC_CFG0,         0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX0_CFG1,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX1_CFG1,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX2_CFG1,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX3_CFG1,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX4_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX5_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX6_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX7_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX8_CFG0,           0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX10_CFG0,          0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX11_CFG0,          0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX12_CFG0,          0x00 },
	{ WCD9335_CDC_TX_INP_MUX_ADC_MUX13_CFG0,          0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG0, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG1, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG2, 0x00 },
	{ WCD9335_CDC_SIDETONE_IIR_INP_MUX_IIR1_MIX_CFG3, 0x00 },
	{ WCD9335_CDC_IF_ROUTER_TX_MUX_CFG0,              0x00 },
	{ WCD9335_CDC_IF_ROUTER_TX_MUX_CFG1,              0x00 },
	{ WCD9335_CDC_IF_ROUTER_TX_MUX_CFG2,              0x00 },
	{ WCD9335_CDC_IF_ROUTER_TX_MUX_CFG3,              0x00 },
	{ WCD9335_CDC_CLK_RST_CTRL_MCLK_CONTROL,          0x00 },
	{ WCD9335_CDC_CLK_RST_CTRL_SWR_CONTROL,           0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_CTL,               0x08 },
	{ WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD0,      0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_POLL_PERIOD1,      0x4b },
	{ WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB,   0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB,   0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_STATUS,            0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_TEST_CTRL,         0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB,     0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB,     0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD,  0x00 },
	{ WCD9335_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD,  0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_PATH_CTL,         0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_CTL,              0x40 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL,   0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_PATH_CTL,         0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B1_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B2_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B3_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B4_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B5_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B6_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B7_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_B8_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_CTL,              0x40 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_GAIN_TIMER_CTL,   0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B1_CTL,      0x00 },
	{ WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B2_CTL,      0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG0,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG1,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG2,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG3,                       0x18 },
	{ WCD9335_CDC_TOP_TOP_CFG4,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG5,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG6,                       0x00 },
	{ WCD9335_CDC_TOP_TOP_CFG7,                       0x00 },
	{ WCD9335_CDC_TOP_HPHL_COMP_WR_LSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHL_COMP_WR_MSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHL_COMP_LUT,                  0x00 },
	{ WCD9335_CDC_TOP_HPHL_COMP_RD_LSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHL_COMP_RD_MSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHR_COMP_WR_LSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHR_COMP_WR_MSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHR_COMP_LUT,                  0x00 },
	{ WCD9335_CDC_TOP_HPHR_COMP_RD_LSB,               0x00 },
	{ WCD9335_CDC_TOP_HPHR_COMP_RD_MSB,               0x00 },
	{ WCD9335_CDC_TOP_DIFFL_COMP_WR_LSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFL_COMP_WR_MSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFL_COMP_LUT,                 0x00 },
	{ WCD9335_CDC_TOP_DIFFL_COMP_RD_LSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFL_COMP_RD_MSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFR_COMP_WR_LSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFR_COMP_WR_MSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFR_COMP_LUT,                 0x00 },
	{ WCD9335_CDC_TOP_DIFFR_COMP_RD_LSB,              0x00 },
	{ WCD9335_CDC_TOP_DIFFR_COMP_RD_MSB,              0x00 },
	/* Page #0x80 registers */
	{ WCD9335_PAGE80_PAGE_REGISTER,                   0x00 },
	{ WCD9335_TLMM_BIST_MODE_PINCFG,                  0x00 },
	{ WCD9335_TLMM_RF_PA_ON_PINCFG,                   0x00 },
	{ WCD9335_TLMM_INTR1_PINCFG,                      0x00 },
	{ WCD9335_TLMM_INTR2_PINCFG,                      0x00 },
	{ WCD9335_TLMM_SWR_DATA_PINCFG,                   0x00 },
	{ WCD9335_TLMM_SWR_CLK_PINCFG,                    0x00 },
	{ WCD9335_TLMM_SLIMBUS_DATA2_PINCFG,              0x00 },
	{ WCD9335_TLMM_I2C_CLK_PINCFG,                    0x00 },
	{ WCD9335_TLMM_I2C_DATA_PINCFG,                   0x00 },
	{ WCD9335_TLMM_I2S_RX_SD0_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_RX_SD1_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_RX_SCK_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_RX_WS_PINCFG,                  0x00 },
	{ WCD9335_TLMM_I2S_TX_SD0_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_TX_SD1_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_TX_SCK_PINCFG,                 0x00 },
	{ WCD9335_TLMM_I2S_TX_WS_PINCFG,                  0x00 },
	{ WCD9335_TLMM_DMIC1_CLK_PINCFG,                  0x00 },
	{ WCD9335_TLMM_DMIC1_DATA_PINCFG,                 0x00 },
	{ WCD9335_TLMM_DMIC2_CLK_PINCFG,                  0x00 },
	{ WCD9335_TLMM_DMIC2_DATA_PINCFG,                 0x00 },
	{ WCD9335_TLMM_DMIC3_CLK_PINCFG,                  0x00 },
	{ WCD9335_TLMM_DMIC3_DATA_PINCFG,                 0x00 },
	{ WCD9335_TLMM_JTDI_PINCFG,                       0x00 },
	{ WCD9335_TLMM_JTDO_PINCFG,                       0x00 },
	{ WCD9335_TLMM_JTMS_PINCFG,                       0x00 },
	{ WCD9335_TLMM_JTCK_PINCFG,                       0x00 },
	{ WCD9335_TLMM_JTRST_PINCFG,                      0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_OE_0,                0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_OE_1,                0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_OE_2,                0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_OE_3,                0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_DATA_0,              0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_DATA_1,              0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_DATA_2,              0x00 },
	{ WCD9335_TEST_DEBUG_PIN_CTL_DATA_3,              0x00 },
	{ WCD9335_TEST_DEBUG_PAD_DRVCTL,                  0x00 },
	{ WCD9335_TEST_DEBUG_PIN_STATUS,                  0x00 },
	{ WCD9335_TEST_DEBUG_MEM_CTRL,                    0x00 },
	{ WCD9335_TEST_DEBUG_DEBUG_BUS_SEL,               0x00 },
	{ WCD9335_TEST_DEBUG_DEBUG_JTAG,                  0x00 },
	{ WCD9335_TEST_DEBUG_DEBUG_EN_1,                  0x00 },
	{ WCD9335_TEST_DEBUG_DEBUG_EN_2,                  0x00 },
	{ WCD9335_TEST_DEBUG_DEBUG_EN_3,                  0x00 },
};

/*
 * wcd9335_regmap_register_patch: Update register defaults based on version
 * @regmap: handle to wcd9xxx regmap
 * @version: wcd9335 version
 *
 * Returns error code in case of failure or 0 for success
 */
int wcd9335_regmap_register_patch(struct regmap *regmap, int version)
{
	int rc;

	if (!regmap) {
		pr_err("%s: regmap struct is NULL\n", __func__);
		return -EINVAL;
	}

	switch (version) {
	case TASHA_VERSION_1_0:
	case TASHA_VERSION_1_1:
		regcache_cache_only(regmap, true);
		rc = regmap_multi_reg_write(regmap, wcd9335_1_x_defaults,
					    ARRAY_SIZE(wcd9335_1_x_defaults));
		regcache_cache_only(regmap, false);
		break;
	case TASHA_VERSION_2_0:
		regcache_cache_only(regmap, true);
		rc = regmap_multi_reg_write(regmap, wcd9335_2_0_defaults,
					    ARRAY_SIZE(wcd9335_2_0_defaults));
		regcache_cache_only(regmap, false);
		break;
	default:
		pr_err("%s: unknown version: %d\n", __func__, version);
		rc = -EINVAL;
		break;
	}

	return rc;
}
EXPORT_SYMBOL(wcd9335_regmap_register_patch);

static bool wcd9335_is_readable_register(struct device *dev, unsigned int reg)
{
	u8 pg_num, reg_offset;
	const u8 *reg_tbl = NULL;

	/*
	 * Get the page number from MSB of codec register. If its 0x80, assign
	 * the corresponding page index PAGE_0x80.
	 */
	pg_num = reg >> 0x8;
	if (pg_num == 0x80)
		pg_num = PAGE_0X80;
	else if (pg_num >= 0xE)
		return false;

	reg_tbl = wcd9335_reg[pg_num];
	reg_offset = reg & 0xFF;

	if (reg_tbl)
		return reg_tbl[reg_offset];
	else
		return false;
}

static bool wcd9335_is_volatile_register(struct device *dev, unsigned int reg)
{
	/*
	 * registers from 0x000 to 0x0FF are volatile because
	 * this space contains registers related to interrupt
	 * status, mask etc
	 */
	if (reg < 0x100)
		return true;

	/* IIR Coeff registers are not cacheable */
	if ((reg >= WCD9335_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL) &&
	    (reg <= WCD9335_CDC_SIDETONE_IIR1_IIR_COEF_B2_CTL))
		return true;

	if ((reg >= WCD9335_CDC_ANC0_IIR_COEFF_1_CTL) &&
	    (reg <= WCD9335_CDC_ANC0_FB_GAIN_CTL))
		return true;

	if ((reg >= WCD9335_CDC_ANC1_IIR_COEFF_1_CTL) &&
	    (reg <= WCD9335_CDC_ANC1_FB_GAIN_CTL))
		return true;
	/*
	 * CPE inbox and outbox registers are volatile
	 * since they can be updated in the codec hardware
	 * to indicate CPE status
	 */
	if (reg >= WCD9335_CPE_SS_MEM_PTR_0 &&
	    reg <= WCD9335_CPE_SS_OUTBOX2_ACK)
		return true;

	if (reg >= WCD9335_RCO_CAL_OUT_1 &&
	    reg <= WCD9335_RCO_CAL_OUT_5)
		return true;

	switch (reg) {
	case WCD9335_CPE_SS_INBOX1_TRG:
	case WCD9335_CPE_SS_INBOX2_TRG:
	case WCD9335_SWR_AHB_BRIDGE_WR_DATA_0:
	case WCD9335_SWR_AHB_BRIDGE_WR_DATA_1:
	case WCD9335_SWR_AHB_BRIDGE_WR_DATA_2:
	case WCD9335_SWR_AHB_BRIDGE_WR_DATA_3:
	case WCD9335_SWR_AHB_BRIDGE_WR_ADDR_0:
	case WCD9335_SWR_AHB_BRIDGE_WR_ADDR_1:
	case WCD9335_SWR_AHB_BRIDGE_WR_ADDR_2:
	case WCD9335_SWR_AHB_BRIDGE_WR_ADDR_3:
	case WCD9335_SWR_AHB_BRIDGE_RD_DATA_0:
	case WCD9335_SWR_AHB_BRIDGE_RD_DATA_1:
	case WCD9335_SWR_AHB_BRIDGE_RD_DATA_2:
	case WCD9335_SWR_AHB_BRIDGE_RD_DATA_3:
	case WCD9335_SWR_AHB_BRIDGE_RD_ADDR_0:
	case WCD9335_SWR_AHB_BRIDGE_RD_ADDR_1:
	case WCD9335_SWR_AHB_BRIDGE_RD_ADDR_2:
	case WCD9335_SWR_AHB_BRIDGE_RD_ADDR_3:
	case WCD9335_ANA_BIAS:
	case WCD9335_ANA_CLK_TOP:
	case WCD9335_ANA_RCO:
	case WCD9335_CDC_CLK_RST_CTRL_MCLK_CONTROL:
	case WCD9335_ANA_MBHC_RESULT_3:
	case WCD9335_ANA_MBHC_RESULT_2:
	case WCD9335_ANA_MBHC_RESULT_1:
	case WCD9335_ANA_MBHC_MECH:
	case WCD9335_ANA_MBHC_ELECT:
	case WCD9335_ANA_MBHC_ZDET:
	case WCD9335_ANA_MICB2:
	case WCD9335_CPE_SS_SS_ERROR_INT_STATUS:
	case WCD9335_CPE_SS_SS_ERROR_INT_MASK:
	case WCD9335_CPE_SS_SS_ERROR_INT_CLEAR:
	case WCD9335_CPE_SS_STATUS:
	case WCD9335_CPE_SS_BACKUP_INT:
	case WCD9335_CPE_SS_CFG:
	case WCD9335_SOC_MAD_MAIN_CTL_1:
	case WCD9335_SOC_MAD_AUDIO_CTL_3:
	case WCD9335_SOC_MAD_AUDIO_CTL_4:
	case WCD9335_FLYBACK_EN:
	case WCD9335_ANA_RX_SUPPLIES:
	case WCD9335_CDC_CLK_RST_CTRL_FS_CNT_CONTROL:
	case WCD9335_SIDO_SIDO_CCL_2:
	case WCD9335_SIDO_SIDO_CCL_4:
	case WCD9335_DATA_HUB_NATIVE_FIFO_STATUS:
	case WCD9335_MBHC_FSM_STATUS:
	case WCD9335_SPLINE_SRC0_STATUS:
	case WCD9335_SPLINE_SRC1_STATUS:
	case WCD9335_SPLINE_SRC2_STATUS:
	case WCD9335_SPLINE_SRC3_STATUS:
	case WCD9335_SIDO_SIDO_TEST_2:
	case WCD9335_SIDO_SIDO_CCL_8:
	case WCD9335_BIAS_VBG_FINE_ADJ:
	case WCD9335_VBADC_ADC_DOUTMSB:
	case WCD9335_VBADC_ADC_DOUTLSB:
	case WCD9335_CDC_VBAT_VBAT_GAIN_MON_VAL:
	case WCD9335_ANA_BUCK_CTL:
		return true;
	default:
		return false;
	}
}

struct regmap_config wcd9335_regmap_config = {
	.reg_bits = 16,
	.val_bits = 8,
	.cache_type = REGCACHE_RBTREE,
	.reg_defaults = wcd9335_defaults,
	.num_reg_defaults = ARRAY_SIZE(wcd9335_defaults),
	.max_register = WCD9335_MAX_REGISTER,
	.volatile_reg = wcd9335_is_volatile_register,
	.readable_reg = wcd9335_is_readable_register,
	.can_multi_write = true,
};
