/*
 * Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __WCD9360_DEFAULTS_H__
#define __WCD9360_DEFAULTS_H__

#include <linux/types.h>
#include <asoc/wcd9360-registers.h>

#define WCD9360_REG(reg)  ((reg) & 0xFF)

static const struct reg_default wcd9360_defaults[] = {
{WCD9360_PAGE0_PAGE_REGISTER,                          0x00},
{WCD9360_CODEC_RPM_CLK_BYPASS,                         0x00},
{WCD9360_CODEC_RPM_CLK_GATE,                           0x1F},
{WCD9360_CODEC_RPM_CLK_MCLK_CFG,                       0x00},
{WCD9360_CODEC_RPM_CLK_MCLK2_CFG,                      0x02},
{WCD9360_CODEC_RPM_I2S_DSD_CLK_SEL,                    0x00},
{WCD9360_CODEC_RPM_RST_CTL,                            0x00},
{WCD9360_CODEC_RPM_PWR_CDC_DIG_HM_CTL,                 0x04},
{WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE0,                 0x10},
{WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE1,                 0x60},
{WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE2,                 0x93},
{WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE3,                 0x01},
{WCD9360_CHIP_TIER_CTRL_EFUSE_CTL,                     0x10},
{WCD9360_CHIP_TIER_CTRL_EFUSE_TEST0,                   0x00},
{WCD9360_CHIP_TIER_CTRL_EFUSE_TEST1,                   0x00},
{WCD9360_CHIP_TIER_CTRL_EFUSE_STATUS,                  0x00},
{WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO,          0x0D},
{WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_1,                0x00},
{WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_2,                0x00},
{WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_3,                0x00},
{WCD9360_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL,            0x44},
{WCD9360_CHIP_TIER_CTRL_I2C_ACTIVE,                    0x00},
{WCD9360_CHIP_TIER_CTRL_ALT_FUNC_EN,                   0x00},
{WCD9360_CHIP_TIER_CTRL_GPIO_CTL_OE,                   0x00},
{WCD9360_CHIP_TIER_CTRL_GPIO_CTL_DATA,                 0x00},
{WCD9360_DATA_HUB_RX0_CFG,                             0x00},
{WCD9360_DATA_HUB_RX1_CFG,                             0x00},
{WCD9360_DATA_HUB_RX2_CFG,                             0x00},
{WCD9360_DATA_HUB_RX3_CFG,                             0x00},
{WCD9360_DATA_HUB_RX4_CFG,                             0x00},
{WCD9360_DATA_HUB_RX5_CFG,                             0x00},
{WCD9360_DATA_HUB_RX6_CFG,                             0x00},
{WCD9360_DATA_HUB_RX7_CFG,                             0x00},
{WCD9360_DATA_HUB_SB_TX0_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX1_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX2_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX3_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX4_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX5_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX6_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX7_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX8_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX9_INP_CFG,                      0x00},
{WCD9360_DATA_HUB_SB_TX10_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_SB_TX11_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_SB_TX12_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_SB_TX13_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_SB_TX14_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_SB_TX15_INP_CFG,                     0x00},
{WCD9360_DATA_HUB_I2S_TX0_CFG,                         0x00},
{WCD9360_DATA_HUB_I2S_TX0_CFG2,                        0x00},
{WCD9360_DATA_HUB_I2S_TX1_0_CFG,                       0x00},
{WCD9360_DATA_HUB_I2S_TX1_1_CFG,                       0x00},
{WCD9360_DATA_HUB_DATA_HUB_CFG,                        0x03},
{WCD9360_DATA_HUB_I2S_0_CTL,                           0x0C},
{WCD9360_DATA_HUB_I2S_1_CTL,                           0x0C},
{WCD9360_DATA_HUB_I2S_0_CTL2,                          0x01},
{WCD9360_DATA_HUB_I2S_1_CTL2,                          0x01},
{WCD9360_DATA_HUB_I2S_CLKSRC_CTL,                      0x00},
{WCD9360_DATA_HUB_I2S_COMMON_CTL,                      0x00},
{WCD9360_DATA_HUB_I2S_0_TDM_CTL,                       0x00},
{WCD9360_DATA_HUB_I2S_0_TDM_CTL2,                      0x05},
{WCD9360_DATA_HUB_I2S_0_TDM_CH_RX,                     0x00},
{WCD9360_DATA_HUB_I2S_0_TDM_CH_TX,                     0x00},
{WCD9360_DATA_HUB_I2S_0_TDM_CFG,                       0x00},
{WCD9360_DATA_HUB_I2S_0_TDM_STRETCH,                   0x00},
{WCD9360_DATA_HUB_I2S_RESET_CTL,                       0x00},
{WCD9360_DMA_RDMA_CTL_0,                               0x00},
{WCD9360_DMA_RDMA_CTL_1,                               0x00},
{WCD9360_DMA_RDMA_CTL_2,                               0x00},
{WCD9360_DMA_RDMA_CTL_3,                               0x00},
{WCD9360_DMA_RDMA_CTL_4,                               0x00},
{WCD9360_DMA_CH_2_3_CFG_RDMA_0,                        0xFF},
{WCD9360_DMA_CH_2_3_CFG_RDMA_1,                        0xFF},
{WCD9360_DMA_CH_2_3_CFG_RDMA_2,                        0xFF},
{WCD9360_DMA_CH_2_3_CFG_RDMA_3,                        0xFF},
{WCD9360_DMA_CH_2_3_CFG_RDMA_4,                        0xFF},
{WCD9360_DMA_CH_0_1_CFG_RDMA_0,                        0xFF},
{WCD9360_DMA_CH_0_1_CFG_RDMA_1,                        0xFF},
{WCD9360_DMA_CH_0_1_CFG_RDMA_2,                        0xFF},
{WCD9360_DMA_CH_0_1_CFG_RDMA_3,                        0xFF},
{WCD9360_DMA_CH_0_1_CFG_RDMA_4,                        0xFF},
{WCD9360_DMA_RDMA4_PRT_CFG,                            0x00},
{WCD9360_DMA_RDMA_SBTX0_7_CFG,                         0x00},
{WCD9360_DMA_RDMA_SBTX8_10_CFG,                        0x00},
{WCD9360_DMA_WDMA_CTL_0,                               0x00},
{WCD9360_DMA_WDMA_CTL_1,                               0x00},
{WCD9360_DMA_WDMA_CTL_2,                               0x00},
{WCD9360_DMA_WDMA_CTL_3,                               0x00},
{WCD9360_DMA_WDMA_CTL_4,                               0x00},
{WCD9360_DMA_CH_4_5_CFG_WDMA_0,                        0x00},
{WCD9360_DMA_CH_4_5_CFG_WDMA_1,                        0x00},
{WCD9360_DMA_CH_4_5_CFG_WDMA_2,                        0x00},
{WCD9360_DMA_CH_4_5_CFG_WDMA_3,                        0x00},
{WCD9360_DMA_CH_4_5_CFG_WDMA_4,                        0x00},
{WCD9360_DMA_CH_2_3_CFG_WDMA_0,                        0x00},
{WCD9360_DMA_CH_2_3_CFG_WDMA_1,                        0x00},
{WCD9360_DMA_CH_2_3_CFG_WDMA_2,                        0x00},
{WCD9360_DMA_CH_2_3_CFG_WDMA_3,                        0x00},
{WCD9360_DMA_CH_2_3_CFG_WDMA_4,                        0x00},
{WCD9360_DMA_CH_0_1_CFG_WDMA_0,                        0x00},
{WCD9360_DMA_CH_0_1_CFG_WDMA_1,                        0x00},
{WCD9360_DMA_CH_0_1_CFG_WDMA_2,                        0x00},
{WCD9360_DMA_CH_0_1_CFG_WDMA_3,                        0x00},
{WCD9360_DMA_CH_0_1_CFG_WDMA_4,                        0x00},
{WCD9360_DMA_WDMA0_PRT_CFG,                            0x00},
{WCD9360_DMA_WDMA3_PRT_CFG,                            0x00},
{WCD9360_DMA_WDMA4_PRT0_3_CFG,                         0x00},
{WCD9360_DMA_WDMA4_PRT4_7_CFG,                         0x00},
{WCD9360_PAGE1_PAGE_REGISTER,                          0x00},
{WCD9360_CPE_FLL_USER_CTL_0,                           0x71},
{WCD9360_CPE_FLL_USER_CTL_1,                           0x34},
{WCD9360_CPE_FLL_USER_CTL_2,                           0x0B},
{WCD9360_CPE_FLL_USER_CTL_3,                           0x02},
{WCD9360_CPE_FLL_USER_CTL_4,                           0x04},
{WCD9360_CPE_FLL_USER_CTL_5,                           0x02},
{WCD9360_CPE_FLL_USER_CTL_6,                           0x6E},
{WCD9360_CPE_FLL_USER_CTL_7,                           0x00},
{WCD9360_CPE_FLL_USER_CTL_8,                           0x94},
{WCD9360_CPE_FLL_USER_CTL_9,                           0x50},
{WCD9360_CPE_FLL_L_VAL_CTL_0,                          0x53},
{WCD9360_CPE_FLL_L_VAL_CTL_1,                          0x00},
{WCD9360_CPE_FLL_DSM_FRAC_CTL_0,                       0x00},
{WCD9360_CPE_FLL_DSM_FRAC_CTL_1,                       0xFF},
{WCD9360_CPE_FLL_CONFIG_CTL_0,                         0x6B},
{WCD9360_CPE_FLL_CONFIG_CTL_1,                         0x05},
{WCD9360_CPE_FLL_CONFIG_CTL_2,                         0x20},
{WCD9360_CPE_FLL_CONFIG_CTL_3,                         0x00},
{WCD9360_CPE_FLL_CONFIG_CTL_4,                         0x10},
{WCD9360_CPE_FLL_TEST_CTL_0,                           0x80},
{WCD9360_CPE_FLL_TEST_CTL_1,                           0x00},
{WCD9360_CPE_FLL_TEST_CTL_2,                           0x00},
{WCD9360_CPE_FLL_TEST_CTL_3,                           0x00},
{WCD9360_CPE_FLL_TEST_CTL_4,                           0x00},
{WCD9360_CPE_FLL_TEST_CTL_5,                           0x00},
{WCD9360_CPE_FLL_TEST_CTL_6,                           0x04},
{WCD9360_CPE_FLL_TEST_CTL_7,                           0x33},
{WCD9360_CPE_FLL_FREQ_CTL_0,                           0x00},
{WCD9360_CPE_FLL_FREQ_CTL_1,                           0x00},
{WCD9360_CPE_FLL_FREQ_CTL_2,                           0x00},
{WCD9360_CPE_FLL_FREQ_CTL_3,                           0x00},
{WCD9360_CPE_FLL_SSC_CTL_0,                            0x00},
{WCD9360_CPE_FLL_SSC_CTL_1,                            0x00},
{WCD9360_CPE_FLL_SSC_CTL_2,                            0x00},
{WCD9360_CPE_FLL_SSC_CTL_3,                            0x00},
{WCD9360_CPE_FLL_FLL_MODE,                             0x20},
{WCD9360_CPE_FLL_STATUS_0,                             0x00},
{WCD9360_CPE_FLL_STATUS_1,                             0x00},
{WCD9360_CPE_FLL_STATUS_2,                             0x00},
{WCD9360_CPE_FLL_STATUS_3,                             0x00},
{WCD9360_I2S_FLL_USER_CTL_0,                           0x41},
{WCD9360_I2S_FLL_USER_CTL_1,                           0x94},
{WCD9360_I2S_FLL_USER_CTL_2,                           0x08},
{WCD9360_I2S_FLL_USER_CTL_3,                           0x02},
{WCD9360_I2S_FLL_USER_CTL_4,                           0x04},
{WCD9360_I2S_FLL_USER_CTL_5,                           0x02},
{WCD9360_I2S_FLL_USER_CTL_6,                           0x40},
{WCD9360_I2S_FLL_USER_CTL_7,                           0x00},
{WCD9360_I2S_FLL_USER_CTL_8,                           0x5F},
{WCD9360_I2S_FLL_USER_CTL_9,                           0x02},
{WCD9360_I2S_FLL_L_VAL_CTL_0,                          0x40},
{WCD9360_I2S_FLL_L_VAL_CTL_1,                          0x00},
{WCD9360_I2S_FLL_DSM_FRAC_CTL_0,                       0x00},
{WCD9360_I2S_FLL_DSM_FRAC_CTL_1,                       0xFF},
{WCD9360_I2S_FLL_CONFIG_CTL_0,                         0x6B},
{WCD9360_I2S_FLL_CONFIG_CTL_1,                         0x05},
{WCD9360_I2S_FLL_CONFIG_CTL_2,                         0x20},
{WCD9360_I2S_FLL_CONFIG_CTL_3,                         0x00},
{WCD9360_I2S_FLL_CONFIG_CTL_4,                         0x30},
{WCD9360_I2S_FLL_TEST_CTL_0,                           0x80},
{WCD9360_I2S_FLL_TEST_CTL_1,                           0x00},
{WCD9360_I2S_FLL_TEST_CTL_2,                           0x00},
{WCD9360_I2S_FLL_TEST_CTL_3,                           0x00},
{WCD9360_I2S_FLL_TEST_CTL_4,                           0x00},
{WCD9360_I2S_FLL_TEST_CTL_5,                           0x00},
{WCD9360_I2S_FLL_TEST_CTL_6,                           0x04},
{WCD9360_I2S_FLL_TEST_CTL_7,                           0xFF},
{WCD9360_I2S_FLL_FREQ_CTL_0,                           0x00},
{WCD9360_I2S_FLL_FREQ_CTL_1,                           0x00},
{WCD9360_I2S_FLL_FREQ_CTL_2,                           0x00},
{WCD9360_I2S_FLL_FREQ_CTL_3,                           0x00},
{WCD9360_I2S_FLL_SSC_CTL_0,                            0x00},
{WCD9360_I2S_FLL_SSC_CTL_1,                            0x00},
{WCD9360_I2S_FLL_SSC_CTL_2,                            0x00},
{WCD9360_I2S_FLL_SSC_CTL_3,                            0x00},
{WCD9360_I2S_FLL_FLL_MODE,                             0x00},
{WCD9360_I2S_FLL_STATUS_0,                             0x00},
{WCD9360_I2S_FLL_STATUS_1,                             0x00},
{WCD9360_I2S_FLL_STATUS_2,                             0x00},
{WCD9360_I2S_FLL_STATUS_3,                             0x00},
{WCD9360_PAGE2_PAGE_REGISTER,                          0x00},
{WCD9360_CPE_SS_CPE_CTL,                               0x05},
{WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_0,                  0x01},
{WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_1,                  0x00},
{WCD9360_CPE_SS_PWR_CPEFLL_CTL,                        0x02},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_0,              0xFF},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_1,              0x03},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_0,             0xFF},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_1,             0xFF},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_2,             0xFF},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_3,             0xFF},
{WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_4,             0xFF},
{WCD9360_CPE_SS_PWR_CPE_DRAM1_SHUTDOWN,                0x07},
{WCD9360_CPE_SS_US_BUF_INT_PERIOD,                     0x5F},
{WCD9360_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD,             0x13},
{WCD9360_CPE_SS_SVA_CFG,                               0x41},
{WCD9360_CPE_SS_US_CFG,                                0x00},
{WCD9360_CPE_SS_MAD_CTL,                               0x00},
{WCD9360_CPE_SS_CPAR_CTL,                              0x00},
{WCD9360_CPE_SS_DMIC0_CTL,                             0x00},
{WCD9360_CPE_SS_DMIC1_CTL,                             0x00},
{WCD9360_CPE_SS_DMIC2_CTL,                             0x00},
{WCD9360_CPE_SS_DMIC_CFG,                              0x80},
{WCD9360_CPE_SS_CPAR_CFG,                              0x00},
{WCD9360_CPE_SS_WDOG_CFG,                              0x01},
{WCD9360_CPE_SS_BACKUP_INT,                            0x00},
{WCD9360_CPE_SS_STATUS,                                0x00},
{WCD9360_CPE_SS_CPE_OCD_CFG,                           0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_MASK_0A,                  0xFF},
{WCD9360_CPE_SS_SS_ERROR_INT_MASK_0B,                  0x3F},
{WCD9360_CPE_SS_SS_ERROR_INT_MASK_1A,                  0xFF},
{WCD9360_CPE_SS_SS_ERROR_INT_MASK_1B,                  0x3F},
{WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0A,                0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0B,                0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1A,                0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1B,                0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0A,                 0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0B,                 0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1A,                 0x00},
{WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1B,                 0x00},
{WCD9360_CPE_SS_DMIC3_CTL,                             0x00},
{WCD9360_CPE_SS_WDOG_RESET,                            0x00},
{WCD9360_CPE_SS_LPASS_MCLK_PRG,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_0,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_1,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_2,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_3,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_4,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_5,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_6,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_7,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_8,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_9,                        0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_10,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_11,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_12,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_13,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_14,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_IN_15,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_0,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_1,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_2,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_3,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_4,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_5,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_6,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_7,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_8,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_9,                       0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_10,                      0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_11,                      0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_12,                      0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_13,                      0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_14,                      0x00},
{WCD9360_CPE_SS_LPASS_IPC_OUT_15,                      0x00},
{WCD9360_CPE_SS_LPASS_ARB_CTL,                         0x00},
{WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_0,                    0x00},
{WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_1,                    0x00},
{WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_0,                0x00},
{WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_1,                0x00},
{WCD9360_SOC_MAD_MAIN_CTL_1,                           0x00},
{WCD9360_SOC_MAD_MAIN_CTL_2,                           0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_1,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_2,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_3,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_4,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_5,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_6,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_7,                          0x00},
{WCD9360_SOC_MAD_AUDIO_CTL_8,                          0x00},
{WCD9360_SOC_MAD_AUDIO_IIR_CTL_PTR,                    0x00},
{WCD9360_SOC_MAD_AUDIO_IIR_CTL_VAL,                    0x40},
{WCD9360_SOC_MAD_ULTR_CTL_1,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_2,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_3,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_4,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_5,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_6,                           0x00},
{WCD9360_SOC_MAD_ULTR_CTL_7,                           0x00},
{WCD9360_SOC_MAD_BEACON_CTL_1,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_2,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_3,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_4,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_5,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_6,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_7,                         0x00},
{WCD9360_SOC_MAD_BEACON_CTL_8,                         0x00},
{WCD9360_SOC_MAD_BEACON_IIR_CTL_PTR,                   0x00},
{WCD9360_SOC_MAD_BEACON_IIR_CTL_VAL,                   0x00},
{WCD9360_SOC_MAD_INP_SEL,                              0x00},
{WCD9360_SOC_MAD_MAD2_INP_SEL,                         0x00},
{WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_CTRL,         0x00},
{WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_STATUS,       0x00},
{WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_FS,           0x00},
{WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_IN_SEL,       0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT0,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT1,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT2,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT3,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT4,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT5,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT6,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT7,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT8,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT9,                   0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT10,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT11,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT12,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT13,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT14,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT15,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT0,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT1,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT2,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT3,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT4,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT5,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT6,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT7,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT8,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT9,                  0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT10,                 0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT11,                 0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT12,                 0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT13,                 0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT14,                 0x00},
{WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT15,                 0x00},
{WCD9360_PAGE4_PAGE_REGISTER,                          0x00},
{WCD9360_INTR_CFG,                                     0x00},
{WCD9360_INTR_CLR_COMMIT,                              0x00},
{WCD9360_INTR_PIN1_MASK0,                              0xFF},
{WCD9360_INTR_PIN1_MASK1,                              0xFF},
{WCD9360_INTR_PIN1_MASK2,                              0xFF},
{WCD9360_INTR_PIN1_MASK3,                              0xFF},
{WCD9360_INTR_PIN1_STATUS0,                            0x00},
{WCD9360_INTR_PIN1_STATUS1,                            0x00},
{WCD9360_INTR_PIN1_STATUS2,                            0x00},
{WCD9360_INTR_PIN1_STATUS3,                            0x00},
{WCD9360_INTR_PIN1_CLEAR0,                             0x00},
{WCD9360_INTR_PIN1_CLEAR1,                             0x00},
{WCD9360_INTR_PIN1_CLEAR2,                             0x00},
{WCD9360_INTR_PIN1_CLEAR3,                             0x00},
{WCD9360_INTR_PIN2_MASK3,                              0xFF},
{WCD9360_INTR_PIN2_STATUS3,                            0x00},
{WCD9360_INTR_PIN2_CLEAR3,                             0x00},
{WCD9360_INTR_CPESS_SUMRY_MASK2,                       0xFF},
{WCD9360_INTR_CPESS_SUMRY_MASK3,                       0xFF},
{WCD9360_INTR_CPESS_SUMRY_STATUS2,                     0x00},
{WCD9360_INTR_CPESS_SUMRY_STATUS3,                     0x00},
{WCD9360_INTR_CPESS_SUMRY_CLEAR2,                      0x00},
{WCD9360_INTR_CPESS_SUMRY_CLEAR3,                      0x00},
{WCD9360_INTR_LEVEL0,                                  0x3B},
{WCD9360_INTR_LEVEL1,                                  0x00},
{WCD9360_INTR_LEVEL2,                                  0xD0},
{WCD9360_INTR_LEVEL3,                                  0x00},
{WCD9360_INTR_BYPASS0,                                 0x00},
{WCD9360_INTR_BYPASS1,                                 0x00},
{WCD9360_INTR_BYPASS2,                                 0x00},
{WCD9360_INTR_BYPASS3,                                 0x00},
{WCD9360_INTR_SET0,                                    0x00},
{WCD9360_INTR_SET1,                                    0x00},
{WCD9360_INTR_SET2,                                    0x00},
{WCD9360_INTR_SET3,                                    0x00},
{WCD9360_INTR_CODEC_MISC_MASK,                         0x73},
{WCD9360_INTR_CODEC_MISC_STATUS,                       0x00},
{WCD9360_INTR_CODEC_MISC_CLEAR,                        0x00},
{WCD9360_ANA_PAGE_REGISTER,                            0x00},
{WCD9360_ANA_BIAS,                                     0x00},
{WCD9360_ANA_RCO,                                      0x00},
{WCD9360_ANA_BUCK_CTL,                                 0x00},
{WCD9360_ANA_BUCK_STATUS,                              0x00},
{WCD9360_ANA_EAR,                                      0x00},
{WCD9360_ANA_MAD_SETUP,                                0x01},
{WCD9360_ANA_AMIC1,                                    0x20},
{WCD9360_ANA_AMIC2,                                    0x00},
{WCD9360_ANA_AMIC3,                                    0x20},
{WCD9360_ANA_AMIC4,                                    0x00},
{WCD9360_ANA_MICB1,                                    0x10},
{WCD9360_ANA_MICB2,                                    0x10},
{WCD9360_ANA_MICB3,                                    0x10},
{WCD9360_ANA_MICB4,                                    0x10},
{WCD9360_BIAS_CTL,                                     0x2A},
{WCD9360_BIAS_VBG_FINE_ADJ,                            0x55},
{WCD9360_RCO_CTRL_1,                                   0x44},
{WCD9360_RCO_CTRL_2,                                   0x48},
{WCD9360_RCO_CAL,                                      0x00},
{WCD9360_RCO_CAL_1,                                    0x00},
{WCD9360_RCO_CAL_2,                                    0x00},
{WCD9360_RCO_TEST_CTRL,                                0x00},
{WCD9360_RCO_CAL_OUT_1,                                0x00},
{WCD9360_RCO_CAL_OUT_2,                                0x00},
{WCD9360_RCO_CAL_OUT_3,                                0x00},
{WCD9360_RCO_CAL_OUT_4,                                0x00},
{WCD9360_RCO_CAL_OUT_5,                                0x00},
{WCD9360_SIDO_MODE_1,                                  0x84},
{WCD9360_SIDO_MODE_2,                                  0xFE},
{WCD9360_SIDO_MODE_3,                                  0xF6},
{WCD9360_SIDO_MODE_4,                                  0x56},
{WCD9360_SIDO_VCL_1,                                   0x00},
{WCD9360_SIDO_VCL_2,                                   0x6C},
{WCD9360_SIDO_VCL_3,                                   0x44},
{WCD9360_SIDO_CCL_1,                                   0x57},
{WCD9360_SIDO_CCL_2,                                   0x92},
{WCD9360_SIDO_CCL_3,                                   0x35},
{WCD9360_SIDO_CCL_4,                                   0x61},
{WCD9360_SIDO_CCL_5,                                   0x6D},
{WCD9360_SIDO_CCL_6,                                   0x60},
{WCD9360_SIDO_CCL_7,                                   0x6F},
{WCD9360_SIDO_CCL_8,                                   0x6F},
{WCD9360_SIDO_CCL_9,                                   0x6E},
{WCD9360_SIDO_CCL_10,                                  0x26},
{WCD9360_SIDO_FILTER_1,                                0x92},
{WCD9360_SIDO_FILTER_2,                                0x54},
{WCD9360_SIDO_DRIVER_1,                                0x77},
{WCD9360_SIDO_DRIVER_2,                                0x55},
{WCD9360_SIDO_DRIVER_3,                                0x55},
{WCD9360_SIDO_CAL_CODE_EXT_1,                          0x9C},
{WCD9360_SIDO_CAL_CODE_EXT_2,                          0x82},
{WCD9360_SIDO_CAL_CODE_OUT_1,                          0x00},
{WCD9360_SIDO_CAL_CODE_OUT_2,                          0x00},
{WCD9360_SIDO_TEST_1,                                  0x00},
{WCD9360_SIDO_TEST_2,                                  0x00},
{WCD9360_LDOH_MODE,                                    0x2B},
{WCD9360_LDOH_BIAS,                                    0x68},
{WCD9360_LDOH_STB_LOADS,                               0x00},
{WCD9360_LDOH_SLOWRAMP,                                0x50},
{WCD9360_MICB1_TEST_CTL_1,                             0x1A},
{WCD9360_MICB1_TEST_CTL_2,                             0x18},
{WCD9360_MICB1_TEST_CTL_3,                             0xA4},
{WCD9360_MICB2_TEST_CTL_1,                             0x1A},
{WCD9360_MICB2_TEST_CTL_2,                             0x18},
{WCD9360_MICB2_TEST_CTL_3,                             0xA4},
{WCD9360_MICB3_TEST_CTL_1,                             0x1A},
{WCD9360_MICB3_TEST_CTL_2,                             0x18},
{WCD9360_MICB3_TEST_CTL_3,                             0xA4},
{WCD9360_MICB4_TEST_CTL_1,                             0x1A},
{WCD9360_MICB4_TEST_CTL_2,                             0x18},
{WCD9360_MICB4_TEST_CTL_3,                             0xA4},
{WCD9360_TX_COM_ADC_VCM,                               0x39},
{WCD9360_TX_COM_BIAS_ATEST,                            0xC0},
{WCD9360_TX_COM_ADC_INT1_IB,                           0x6F},
{WCD9360_TX_COM_ADC_INT2_IB,                           0x4F},
{WCD9360_TX_COM_TXFE_DIV_CTL,                          0x2E},
{WCD9360_TX_COM_TXFE_DIV_START,                        0x00},
{WCD9360_TX_COM_TXFE_DIV_STOP_9P6M,                    0xC7},
{WCD9360_TX_COM_TXFE_DIV_STOP_12P288M,                 0xFF},
{WCD9360_TX_1_2_TEST_EN,                               0xCC},
{WCD9360_TX_1_2_ADC_IB,                                0x09},
{WCD9360_TX_1_2_ATEST_REFCTL,                          0x0A},
{WCD9360_TX_1_2_TEST_CTL,                              0x38},
{WCD9360_TX_1_2_TEST_BLK_EN,                           0xFF},
{WCD9360_TX_1_2_TXFE_CLKDIV,                           0x00},
{WCD9360_TX_1_2_SAR1_ERR,                              0x00},
{WCD9360_TX_1_2_SAR2_ERR,                              0x00},
{WCD9360_TX_3_4_TEST_EN,                               0xCC},
{WCD9360_TX_3_4_ADC_IB,                                0x09},
{WCD9360_TX_3_4_ATEST_REFCTL,                          0x0A},
{WCD9360_TX_3_4_TEST_CTL,                              0x38},
{WCD9360_TX_3_4_TEST_BLK_EN,                           0xFF},
{WCD9360_TX_3_4_TXFE_CLKDIV,                           0x00},
{WCD9360_TX_3_4_SAR1_ERR,                              0x00},
{WCD9360_TX_3_4_SAR2_ERR,                              0x00},
{WCD9360_RX_RX_EAR_BIAS_CON_1,                         0x2A},
{WCD9360_RX_RX_EAR_BIAS_CON_2,                         0x8A},
{WCD9360_RX_RX_AUX_BIAS_CON_1,                         0x2A},
{WCD9360_RX_RX_AUX_BIAS_CON_2,                         0x8A},
{WCD9360_RX_RX_BIAS_ATEST,                             0x0C},
{WCD9360_RX_RXTOP_RESERVED,                            0x00},
{WCD9360_EAR_EAR_EN_REG,                               0x22},
{WCD9360_EAR_EAR_PA_CON,                               0x44},
{WCD9360_EAR_EAR_SP_CON,                               0xDB},
{WCD9360_EAR_EAR_DAC_CON,                              0x00},
{WCD9360_EAR_EAR_CNP_FSM_CON,                          0xB6},
{WCD9360_EAR_DAC_CTL_TEST,                             0x00},
{WCD9360_EAR_STATUS_REG,                               0x00},
{WCD9360_EAR_EAR_COMPANDER_CON,                        0x02},
{WCD9360_ANA_NEW_PAGE_REGISTER,                        0x00},
{WCD9360_CLK_SYS_PLL_ENABLES,                          0x00},
{WCD9360_CLK_SYS_PLL_PRESET,                           0x00},
{WCD9360_CLK_SYS_PLL_STATUS,                           0x00},
{WCD9360_CLK_SYS_MCLK_PRG,                             0x10},
{WCD9360_CLK_SYS_MCLK2_PRG1,                           0x00},
{WCD9360_CLK_SYS_MCLK_MISC,                            0x00},
{WCD9360_SIDO_NEW_VOUT_A_STARTUP,                      0x17},
{WCD9360_SIDO_NEW_VOUT_D_STARTUP,                      0x0D},
{WCD9360_SIDO_NEW_VOUT_D_FREQ1,                        0x07},
{WCD9360_SIDO_NEW_VOUT_D_FREQ2,                        0x00},
{WCD9360_AUX_ANA_EAR,                                  0x00},
{WCD9360_LDORXTX_LDORXTX,                              0x10},
{WCD9360_DIE_CRACK_CTL,                                0x00},
{WCD9360_DIE_CRACK_OUT,                                0x00},
{WCD9360_LOOP_BACK_EN,                                 0x00},
{WCD9360_CLK_SYS_INT_POST_DIV_REG0,                    0x00},
{WCD9360_CLK_SYS_INT_POST_DIV_REG1,                    0x00},
{WCD9360_CLK_SYS_INT_REF_DIV_REG0,                     0x00},
{WCD9360_CLK_SYS_INT_REF_DIV_REG1,                     0x00},
{WCD9360_CLK_SYS_INT_FILTER_REG0,                      0x00},
{WCD9360_CLK_SYS_INT_FILTER_REG1,                      0x00},
{WCD9360_CLK_SYS_INT_PLL_L_VAL,                        0x00},
{WCD9360_CLK_SYS_INT_PLL_M_VAL,                        0x00},
{WCD9360_CLK_SYS_INT_PLL_N_VAL,                        0x00},
{WCD9360_CLK_SYS_INT_TEST_REG0,                        0x00},
{WCD9360_CLK_SYS_INT_PFD_CP_DSM_PROG,                  0x00},
{WCD9360_CLK_SYS_INT_VCO_PROG,                         0x00},
{WCD9360_CLK_SYS_INT_TEST_REG1,                        0x00},
{WCD9360_CLK_SYS_INT_LDO_LOCK_CFG,                     0x00},
{WCD9360_CLK_SYS_INT_DIG_LOCK_DET_CFG,                 0x00},
{WCD9360_CLK_SYS_INT_CLK_TEST1,                        0x00},
{WCD9360_CLK_SYS_INT_CLK_TEST2,                        0x00},
{WCD9360_CLK_SYS_INT_CLK_TEST3,                        0x00},
{WCD9360_SIDO_NEW_INT_RAMP_STATUS,                     0x00},
{WCD9360_SIDO_NEW_INT_SPARE_1,                         0x00},
{WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_A,            0x64},
{WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_D,            0x40},
{WCD9360_SIDO_NEW_INT_RAMP_INC_WAIT,                   0x24},
{WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_CTL,               0x09},
{WCD9360_SIDO_NEW_INT_RAMP_IBLEED_CTL,                 0x7D},
{WCD9360_SIDO_NEW_INT_DEBUG_CPROVR_TEST,               0x00},
{WCD9360_SIDO_NEW_INT_RAMP_CTL_A,                      0x14},
{WCD9360_SIDO_NEW_INT_RAMP_CTL_D,                      0x14},
{WCD9360_SIDO_NEW_INT_RAMP_TIMEOUT_PERIOD,             0x33},
{WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING1,          0x3F},
{WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING2,          0x74},
{WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING3,          0x33},
{WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL1,             0x1D},
{WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL2,             0x0A},
{WCD9360_EAR_INT_NEW_EAR_CHOPPER_CON,                  0xA8},
{WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON1,                 0x42},
{WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON2,                 0x22},
{WCD9360_EAR_INT_NEW_EAR_DYNAMIC_BIAS,                 0x00},
{WCD9360_AUX_INT_AUX_EN_REG,                           0x22},
{WCD9360_AUX_INT_AUX_PA_CON,                           0x46},
{WCD9360_AUX_INT_AUX_SP_CON,                           0xD2},
{WCD9360_AUX_INT_AUX_DAC_CON,                          0x00},
{WCD9360_AUX_INT_AUX_CNP_FSM_CON,                      0xB6},
{WCD9360_AUX_INT_AUX_TEST,                             0x00},
{WCD9360_AUX_INT_STATUS_REG,                           0x00},
{WCD9360_AUX_INT_AUX_MISC,                             0x00},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL1,                0xFF},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL2,                0xD8},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL3,                0x80},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL4,                0xFF},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL5,                0x09},
{WCD9360_LDORXTX_INT_ANA_LDORXTX_STATUS,               0x00},
{WCD9360_DIE_CRACK_INT_INT1,                           0x02},
{WCD9360_DIE_CRACK_INT_INT2,                           0x60},
{WCD9360_LOOP_BACK_INT_SPARE,                          0x00},
{WCD9360_PAGE10_PAGE_REGISTER,                         0x00},
{WCD9360_CDC_ANC0_CLK_RESET_CTL,                       0x00},
{WCD9360_CDC_ANC0_MODE_1_CTL,                          0x00},
{WCD9360_CDC_ANC0_MODE_2_CTL,                          0x00},
{WCD9360_CDC_ANC0_FF_SHIFT,                            0x00},
{WCD9360_CDC_ANC0_FB_SHIFT,                            0x00},
{WCD9360_CDC_ANC0_LPF_FF_A_CTL,                        0x00},
{WCD9360_CDC_ANC0_LPF_FF_B_CTL,                        0x00},
{WCD9360_CDC_ANC0_LPF_FB_CTL,                          0x00},
{WCD9360_CDC_ANC0_SMLPF_CTL,                           0x00},
{WCD9360_CDC_ANC0_DCFLT_SHIFT_CTL,                     0x00},
{WCD9360_CDC_ANC0_IIR_ADAPT_CTL,                       0x00},
{WCD9360_CDC_ANC0_IIR_COEFF_1_CTL,                     0x00},
{WCD9360_CDC_ANC0_IIR_COEFF_2_CTL,                     0x00},
{WCD9360_CDC_ANC0_FF_A_GAIN_CTL,                       0x00},
{WCD9360_CDC_ANC0_FF_B_GAIN_CTL,                       0x00},
{WCD9360_CDC_ANC0_FB_GAIN_CTL,                         0x00},
{WCD9360_CDC_TX0_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX0_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX0_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX0_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX0_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX0_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX0_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX0_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX0_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX0_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX0_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX0_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX0_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX1_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX1_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX1_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX1_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX1_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX1_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX1_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX1_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX1_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX1_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX1_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX1_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX1_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX2_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX2_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX2_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX2_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX2_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX2_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX2_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX2_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX2_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX2_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX2_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX2_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX2_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX3_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX3_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX3_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX3_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX3_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX3_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX3_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX3_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX3_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX3_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX3_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX3_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX3_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX4_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX4_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX4_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX4_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX4_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX4_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX4_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX4_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX4_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX4_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX4_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX4_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX4_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX5_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX5_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX5_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX5_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX5_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX5_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX5_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX5_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX5_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX5_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX5_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX5_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX5_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX6_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX6_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX6_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX6_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX6_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX6_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX6_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX6_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX6_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX6_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX6_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX6_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX6_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX7_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX7_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX7_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX7_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX7_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX7_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX7_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX7_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX7_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX7_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX7_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX7_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX7_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX8_TX_PATH_CTL,                          0x04},
{WCD9360_CDC_TX8_TX_PATH_CFG0,                         0x10},
{WCD9360_CDC_TX8_TX_PATH_CFG1,                         0x03},
{WCD9360_CDC_TX8_TX_VOL_CTL,                           0x00},
{WCD9360_CDC_TX8_TX_PATH_192_CTL,                      0x00},
{WCD9360_CDC_TX8_TX_PATH_192_CFG,                      0x00},
{WCD9360_CDC_TX8_TX_PATH_SEC0,                         0x00},
{WCD9360_CDC_TX8_TX_PATH_SEC1,                         0x00},
{WCD9360_CDC_TX8_TX_PATH_SEC2,                         0x01},
{WCD9360_CDC_TX8_TX_PATH_SEC3,                         0x3C},
{WCD9360_CDC_TX8_TX_PATH_SEC4,                         0x20},
{WCD9360_CDC_TX8_TX_PATH_SEC5,                         0x00},
{WCD9360_CDC_TX8_TX_PATH_SEC6,                         0x00},
{WCD9360_CDC_TX9_SPKR_PROT_PATH_CTL,                   0x02},
{WCD9360_CDC_TX9_SPKR_PROT_PATH_CFG0,                  0x00},
{WCD9360_CDC_TX10_SPKR_PROT_PATH_CTL,                  0x02},
{WCD9360_CDC_TX10_SPKR_PROT_PATH_CFG0,                 0x00},
{WCD9360_CDC_TX11_SPKR_PROT_PATH_CTL,                  0x02},
{WCD9360_CDC_TX11_SPKR_PROT_PATH_CFG0,                 0x00},
{WCD9360_CDC_TX12_SPKR_PROT_PATH_CTL,                  0x02},
{WCD9360_CDC_TX12_SPKR_PROT_PATH_CFG0,                 0x00},
{WCD9360_PAGE11_PAGE_REGISTER,                         0x00},
{WCD9360_CDC_COMPANDER0_CTL0,                          0x60},
{WCD9360_CDC_COMPANDER0_CTL1,                          0xDB},
{WCD9360_CDC_COMPANDER0_CTL2,                          0xFF},
{WCD9360_CDC_COMPANDER0_CTL3,                          0x35},
{WCD9360_CDC_COMPANDER0_CTL4,                          0xFF},
{WCD9360_CDC_COMPANDER0_CTL5,                          0x00},
{WCD9360_CDC_COMPANDER0_CTL6,                          0x01},
{WCD9360_CDC_COMPANDER0_CTL7,                          0x06},
{WCD9360_CDC_COMPANDER7_CTL0,                          0x60},
{WCD9360_CDC_COMPANDER7_CTL1,                          0xDB},
{WCD9360_CDC_COMPANDER7_CTL2,                          0xFF},
{WCD9360_CDC_COMPANDER7_CTL3,                          0x35},
{WCD9360_CDC_COMPANDER7_CTL4,                          0xFF},
{WCD9360_CDC_COMPANDER7_CTL5,                          0x00},
{WCD9360_CDC_COMPANDER7_CTL6,                          0x01},
{WCD9360_CDC_COMPANDER7_CTL7,                          0x06},
{WCD9360_CDC_COMPANDER8_CTL0,                          0x60},
{WCD9360_CDC_COMPANDER8_CTL1,                          0xDB},
{WCD9360_CDC_COMPANDER8_CTL2,                          0xFF},
{WCD9360_CDC_COMPANDER8_CTL3,                          0x35},
{WCD9360_CDC_COMPANDER8_CTL4,                          0xFF},
{WCD9360_CDC_COMPANDER8_CTL5,                          0x00},
{WCD9360_CDC_COMPANDER8_CTL6,                          0x01},
{WCD9360_CDC_COMPANDER8_CTL7,                          0x06},
{WCD9360_CDC_RX0_RX_PATH_CTL,                          0x04},
{WCD9360_CDC_RX0_RX_PATH_CFG0,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_CFG1,                         0x64},
{WCD9360_CDC_RX0_RX_PATH_CFG2,                         0x80},
{WCD9360_CDC_RX0_RX_VOL_CTL,                           0x00},
{WCD9360_CDC_RX0_RX_PATH_MIX_CTL,                      0x04},
{WCD9360_CDC_RX0_RX_PATH_MIX_CFG,                      0x12},
{WCD9360_CDC_RX0_RX_VOL_MIX_CTL,                       0x00},
{WCD9360_CDC_RX0_RX_PATH_SEC0,                         0xFC},
{WCD9360_CDC_RX0_RX_PATH_SEC1,                         0x08},
{WCD9360_CDC_RX0_RX_PATH_SEC2,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_SEC3,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_SEC5,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_SEC6,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_SEC7,                         0x00},
{WCD9360_CDC_RX0_RX_PATH_MIX_SEC0,                     0x08},
{WCD9360_CDC_RX0_RX_PATH_MIX_SEC1,                     0x00},
{WCD9360_CDC_RX0_RX_PATH_DSMDEM_CTL,                   0x00},
{WCD9360_CDC_RX9_RX_PATH_CTL,                          0x04},
{WCD9360_CDC_RX9_RX_PATH_CFG0,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_CFG1,                         0x64},
{WCD9360_CDC_RX9_RX_PATH_CFG2,                         0x80},
{WCD9360_CDC_RX9_RX_VOL_CTL,                           0x00},
{WCD9360_CDC_RX9_RX_PATH_MIX_CTL,                      0x04},
{WCD9360_CDC_RX9_RX_PATH_MIX_CFG,                      0x12},
{WCD9360_CDC_RX9_RX_VOL_MIX_CTL,                       0x00},
{WCD9360_CDC_RX9_RX_PATH_SEC0,                         0xFC},
{WCD9360_CDC_RX9_RX_PATH_SEC1,                         0x08},
{WCD9360_CDC_RX9_RX_PATH_SEC2,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_SEC3,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_SEC5,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_SEC6,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_SEC7,                         0x00},
{WCD9360_CDC_RX9_RX_PATH_MIX_SEC0,                     0x08},
{WCD9360_CDC_RX9_RX_PATH_MIX_SEC1,                     0x00},
{WCD9360_CDC_RX9_RX_PATH_DSMDEM_CTL,                   0x00},
{WCD9360_CDC_RX7_RX_PATH_CTL,                          0x04},
{WCD9360_CDC_RX7_RX_PATH_CFG0,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_CFG1,                         0x64},
{WCD9360_CDC_RX7_RX_PATH_CFG2,                         0x80},
{WCD9360_CDC_RX7_RX_VOL_CTL,                           0x00},
{WCD9360_CDC_RX7_RX_PATH_MIX_CTL,                      0x04},
{WCD9360_CDC_RX7_RX_PATH_MIX_CFG,                      0x12},
{WCD9360_CDC_RX7_RX_VOL_MIX_CTL,                       0x00},
{WCD9360_CDC_RX7_RX_PATH_SEC0,                         0x04},
{WCD9360_CDC_RX7_RX_PATH_SEC1,                         0x08},
{WCD9360_CDC_RX7_RX_PATH_SEC2,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_SEC3,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_SEC5,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_SEC6,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_SEC7,                         0x00},
{WCD9360_CDC_RX7_RX_PATH_MIX_SEC0,                     0x08},
{WCD9360_CDC_RX7_RX_PATH_MIX_SEC1,                     0x00},
{WCD9360_CDC_RX7_RX_PATH_DSMDEM_CTL,                   0x00},
{WCD9360_CDC_RX8_RX_PATH_CTL,                          0x04},
{WCD9360_CDC_RX8_RX_PATH_CFG0,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_CFG1,                         0x64},
{WCD9360_CDC_RX8_RX_PATH_CFG2,                         0x80},
{WCD9360_CDC_RX8_RX_VOL_CTL,                           0x00},
{WCD9360_CDC_RX8_RX_PATH_MIX_CTL,                      0x04},
{WCD9360_CDC_RX8_RX_PATH_MIX_CFG,                      0x12},
{WCD9360_CDC_RX8_RX_VOL_MIX_CTL,                       0x00},
{WCD9360_CDC_RX8_RX_PATH_SEC0,                         0x04},
{WCD9360_CDC_RX8_RX_PATH_SEC1,                         0x08},
{WCD9360_CDC_RX8_RX_PATH_SEC2,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_SEC3,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_SEC5,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_SEC6,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_SEC7,                         0x00},
{WCD9360_CDC_RX8_RX_PATH_MIX_SEC0,                     0x08},
{WCD9360_CDC_RX8_RX_PATH_MIX_SEC1,                     0x00},
{WCD9360_CDC_RX8_RX_PATH_DSMDEM_CTL,                   0x00},
{WCD9360_PAGE12_PAGE_REGISTER,                         0x00},
{WCD9360_CDC_BOOST0_BOOST_PATH_CTL,                    0x00},
{WCD9360_CDC_BOOST0_BOOST_CTL,                         0xD0},
{WCD9360_CDC_BOOST0_BOOST_CFG1,                        0x89},
{WCD9360_CDC_BOOST0_BOOST_CFG2,                        0x04},
{WCD9360_CDC_BOOST1_BOOST_PATH_CTL,                    0x00},
{WCD9360_CDC_BOOST1_BOOST_CTL,                         0xD0},
{WCD9360_CDC_BOOST1_BOOST_CFG1,                        0x89},
{WCD9360_CDC_BOOST1_BOOST_CFG2,                        0x04},
{WCD9360_MIXING_ASRC2_CLK_RST_CTL,                     0x00},
{WCD9360_MIXING_ASRC2_CTL0,                            0x00},
{WCD9360_MIXING_ASRC2_CTL1,                            0x00},
{WCD9360_MIXING_ASRC2_FIFO_CTL,                        0xA8},
{WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_LSB,            0x00},
{WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_MSB,            0x00},
{WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_LSB,            0x00},
{WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_MSB,            0x00},
{WCD9360_MIXING_ASRC2_STATUS_FIFO,                     0x00},
{WCD9360_MIXING_ASRC3_CLK_RST_CTL,                     0x00},
{WCD9360_MIXING_ASRC3_CTL0,                            0x00},
{WCD9360_MIXING_ASRC3_CTL1,                            0x00},
{WCD9360_MIXING_ASRC3_FIFO_CTL,                        0xA8},
{WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_LSB,            0x00},
{WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_MSB,            0x00},
{WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_LSB,            0x00},
{WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_MSB,            0x00},
{WCD9360_MIXING_ASRC3_STATUS_FIFO,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_DATA_0,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_DATA_1,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_DATA_2,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_DATA_3,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_ADDR_0,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_ADDR_1,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_ADDR_2,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_WR_ADDR_3,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_ADDR_0,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_ADDR_1,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_ADDR_2,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_ADDR_3,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_DATA_0,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_DATA_1,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_DATA_2,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_RD_DATA_3,                     0x00},
{WCD9360_SWR_AHB_BRIDGE_ACCESS_CFG,                    0x0F},
{WCD9360_SWR_AHB_BRIDGE_ACCESS_STATUS,                 0x03},
{WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL,            0x04},
{WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1,           0x00},
{WCD9360_SIDETONE_ASRC0_CLK_RST_CTL,                   0x00},
{WCD9360_SIDETONE_ASRC0_CTL0,                          0x00},
{WCD9360_SIDETONE_ASRC0_CTL1,                          0x00},
{WCD9360_SIDETONE_ASRC0_FIFO_CTL,                      0xA8},
{WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB,          0x00},
{WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB,          0x00},
{WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB,          0x00},
{WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB,          0x00},
{WCD9360_SIDETONE_ASRC0_STATUS_FIFO,                   0x00},
{WCD9360_EC_REF_HQ0_EC_REF_HQ_PATH_CTL,                0x00},
{WCD9360_EC_REF_HQ0_EC_REF_HQ_CFG0,                    0x01},
{WCD9360_EC_REF_HQ1_EC_REF_HQ_PATH_CTL,                0x00},
{WCD9360_EC_REF_HQ1_EC_REF_HQ_CFG0,                    0x01},
{WCD9360_EC_ASRC0_CLK_RST_CTL,                         0x00},
{WCD9360_EC_ASRC0_CTL0,                                0x00},
{WCD9360_EC_ASRC0_CTL1,                                0x00},
{WCD9360_EC_ASRC0_FIFO_CTL,                            0xA8},
{WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_LSB,                0x00},
{WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_MSB,                0x00},
{WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_LSB,                0x00},
{WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_MSB,                0x00},
{WCD9360_EC_ASRC0_STATUS_FIFO,                         0x00},
{WCD9360_EC_ASRC1_CLK_RST_CTL,                         0x00},
{WCD9360_EC_ASRC1_CTL0,                                0x00},
{WCD9360_EC_ASRC1_CTL1,                                0x00},
{WCD9360_EC_ASRC1_FIFO_CTL,                            0xA8},
{WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_LSB,                0x00},
{WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_MSB,                0x00},
{WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_LSB,                0x00},
{WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_MSB,                0x00},
{WCD9360_EC_ASRC1_STATUS_FIFO,                         0x00},
{WCD9360_PAGE13_PAGE_REGISTER,                         0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG0,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG1,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG0,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG1,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG0,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG1,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG0,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG1,                  0x00},
{WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG0,                   0x00},
{WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG1,                   0x00},
{WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG2,                   0x00},
{WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG3,                   0x00},
{WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG4,                   0x00},
{WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0,             0x00},
{WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1,             0x00},
{WCD9360_CDC_RX_INP_MUX_ANC_CFG0,                      0x00},
{WCD9360_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0,              0x00},
{WCD9360_CDC_RX_INP_MUX_EC_REF_HQ_CFG0,                0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG1,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG1,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG1,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG1,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX4_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX5_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX6_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX7_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX8_CFG0,                 0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX10_CFG0,                0x00},
{WCD9360_CDC_TX_INP_MUX_ADC_MUX11_CFG0,                0x00},
{WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0,       0x00},
{WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1,       0x00},
{WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2,       0x00},
{WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3,       0x00},
{WCD9360_CDC_IF_ROUTER_TX_MUX_CFG0,                    0x00},
{WCD9360_CDC_IF_ROUTER_TX_MUX_CFG1,                    0x00},
{WCD9360_CDC_IF_ROUTER_TX_MUX_CFG2,                    0x00},
{WCD9360_CDC_IF_ROUTER_TX_MUX_CFG3,                    0x00},
{WCD9360_CDC_CLK_RST_CTRL_MCLK_CONTROL,                0x00},
{WCD9360_CDC_CLK_RST_CTRL_FS_CNT_CONTROL,              0x00},
{WCD9360_CDC_CLK_RST_CTRL_SWR_CONTROL,                 0x00},
{WCD9360_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL,          0x0A},
{WCD9360_CDC_PROX_DETECT_PROX_CTL,                     0x08},
{WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD0,            0x00},
{WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD1,            0x4B},
{WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB,         0x00},
{WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB,         0x00},
{WCD9360_CDC_PROX_DETECT_PROX_STATUS,                  0x00},
{WCD9360_CDC_PROX_DETECT_PROX_TEST_CTRL,               0x00},
{WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB,           0x00},
{WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB,           0x00},
{WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD,        0x00},
{WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD,        0x00},
{WCD9360_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT,          0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_PATH_CTL,               0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_CTL,                    0x40},
{WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL,         0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL,            0x00},
{WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL,            0x00},
{WCD9360_CDC_TOP_TOP_CFG0,                             0x00},
{WCD9360_CDC_TOP_TOP_CFG1,                             0x00},
{WCD9360_CDC_TOP_TOP_CFG7,                             0x00},
{WCD9360_CDC_TOP_EAR_COMP_WR_LSB,                      0x00},
{WCD9360_CDC_TOP_EAR_COMP_WR_MSB,                      0x00},
{WCD9360_CDC_TOP_EAR_COMP_LUT,                         0x00},
{WCD9360_CDC_TOP_EAR_COMP_RD_LSB,                      0x00},
{WCD9360_CDC_TOP_EAR_COMP_RD_MSB,                      0x00},
{WCD9360_CDC_TOP_TOP_DEBUG,                            0x00},
{WCD9360_PAGE80_PAGE_REGISTER,                         0x00},
{WCD9360_CODEC_CPR_WR_DATA_0,                          0x00},
{WCD9360_CODEC_CPR_WR_DATA_1,                          0x00},
{WCD9360_CODEC_CPR_WR_DATA_2,                          0x00},
{WCD9360_CODEC_CPR_WR_DATA_3,                          0x00},
{WCD9360_CODEC_CPR_WR_ADDR_0,                          0x00},
{WCD9360_CODEC_CPR_WR_ADDR_1,                          0x00},
{WCD9360_CODEC_CPR_WR_ADDR_2,                          0x00},
{WCD9360_CODEC_CPR_WR_ADDR_3,                          0x00},
{WCD9360_CODEC_CPR_RD_ADDR_0,                          0x00},
{WCD9360_CODEC_CPR_RD_ADDR_1,                          0x00},
{WCD9360_CODEC_CPR_RD_ADDR_2,                          0x00},
{WCD9360_CODEC_CPR_RD_ADDR_3,                          0x00},
{WCD9360_CODEC_CPR_RD_DATA_0,                          0x00},
{WCD9360_CODEC_CPR_RD_DATA_1,                          0x00},
{WCD9360_CODEC_CPR_RD_DATA_2,                          0x00},
{WCD9360_CODEC_CPR_RD_DATA_3,                          0x00},
{WCD9360_CODEC_CPR_ACCESS_CFG,                         0x0F},
{WCD9360_CODEC_CPR_ACCESS_STATUS,                      0x03},
{WCD9360_CODEC_CPR_NOM_CX_VDD,                         0xB4},
{WCD9360_CODEC_CPR_SVS_CX_VDD,                         0x7C},
{WCD9360_CODEC_CPR_SVS2_CX_VDD,                        0x58},
{WCD9360_CODEC_CPR_NOM_MX_VDD,                         0xB4},
{WCD9360_CODEC_CPR_SVS_MX_VDD,                         0xB4},
{WCD9360_CODEC_CPR_SVS2_MX_VDD,                        0xA0},
{WCD9360_CODEC_CPR_SVS2_MIN_CX_VDD,                    0x2C},
{WCD9360_CODEC_CPR_MAX_SVS2_STEP,                      0x08},
{WCD9360_CODEC_CPR_CTL,                                0x00},
{WCD9360_CODEC_CPR_SW_MODECHNG_STATUS,                 0x00},
{WCD9360_CODEC_CPR_SW_MODECHNG_START,                  0x00},
{WCD9360_CODEC_CPR_CPR_STATUS,                         0x00},
{WCD9360_PAGE128_PAGE_REGISTER,                        0x00},
{WCD9360_TLMM_JTCK_PINCFG,                             0x00},
{WCD9360_TLMM_INTR1_PINCFG,                            0x00},
{WCD9360_TLMM_INTR2_PINCFG,                            0x00},
{WCD9360_TLMM_SWR_DATA_PINCFG,                         0x00},
{WCD9360_TLMM_SWR_CLK_PINCFG,                          0x00},
{WCD9360_TLMM_SLIMBUS_DATA1_PINCFG,                    0x00},
{WCD9360_TLMM_SLIMBUS_DATA2_PINCFG,                    0x00},
{WCD9360_TLMM_SLIMBUS_CLK_PINCFG,                      0x00},
{WCD9360_TLMM_I2C_CLK_PINCFG,                          0x00},
{WCD9360_TLMM_I2C_DATA_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_0_RX_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_0_TX_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_0_SCK_PINCFG,                        0x00},
{WCD9360_TLMM_I2S_0_WS_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_1_RX_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_1_TX_PINCFG,                         0x00},
{WCD9360_TLMM_I2S_1_SCK_PINCFG,                        0x00},
{WCD9360_TLMM_I2S_1_WS_PINCFG,                         0x00},
{WCD9360_TLMM_DMIC1_CLK_PINCFG,                        0x00},
{WCD9360_TLMM_DMIC1_DATA_PINCFG,                       0x00},
{WCD9360_TLMM_DMIC2_CLK_PINCFG,                        0x00},
{WCD9360_TLMM_DMIC2_DATA_PINCFG,                       0x00},
{WCD9360_TLMM_GPIO1_PINCFG,                            0x00},
{WCD9360_TLMM_GPIO2_PINCFG,                            0x00},
{WCD9360_TLMM_GPIO3_PINCFG,                            0x00},
{WCD9360_TLMM_GPIO4_PINCFG,                            0x00},
{WCD9360_TLMM_SPI_S_CSN_PINCFG,                        0x00},
{WCD9360_TLMM_SPI_S_CLK_PINCFG,                        0x00},
{WCD9360_TLMM_SPI_S_DOUT_PINCFG,                       0x00},
{WCD9360_TLMM_SPI_S_DIN_PINCFG,                        0x00},
{WCD9360_TLMM_GPIO0_PINCFG,                            0x00},
{WCD9360_TLMM_DMIC3_CLK_PINCFG,                        0x00},
{WCD9360_TLMM_DMIC3_DATA_PINCFG,                       0x00},
{WCD9360_TLMM_DMIC4_CLK_PINCFG,                        0x00},
{WCD9360_TLMM_DMIC4_DATA_PINCFG,                       0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_OE_0,                      0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_OE_1,                      0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_OE_2,                      0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_OE_3,                      0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_OE_4,                      0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_DATA_0,                    0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_DATA_1,                    0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_DATA_2,                    0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_DATA_3,                    0x00},
{WCD9360_TEST_DEBUG_PIN_CTL_DATA_4,                    0x00},
{WCD9360_TEST_DEBUG_PAD_DRVCTL_0,                      0x00},
{WCD9360_TEST_DEBUG_PAD_DRVCTL_1,                      0x00},
{WCD9360_TEST_DEBUG_PIN_STATUS,                        0x00},
{WCD9360_TEST_DEBUG_NPL_DLY_TEST_1,                    0x10},
{WCD9360_TEST_DEBUG_NPL_DLY_TEST_2,                    0x60},
{WCD9360_TEST_DEBUG_MEM_CTRL,                          0x00},
{WCD9360_TEST_DEBUG_DEBUG_BUS_SEL,                     0x00},
{WCD9360_TEST_DEBUG_DEBUG_JTAG,                        0x00},
{WCD9360_TEST_DEBUG_DEBUG_EN_1,                        0x00},
{WCD9360_TEST_DEBUG_DEBUG_EN_2,                        0x00},
{WCD9360_TEST_DEBUG_DEBUG_EN_3,                        0x00},
{WCD9360_TEST_DEBUG_DEBUG_EN_4,                        0x00},
{WCD9360_TEST_DEBUG_DEBUG_EN_5,                        0x00},
{WCD9360_TEST_DEBUG_ANA_DTEST_DIR,                     0x00},
{WCD9360_TEST_DEBUG_PAD_INP_DISABLE_0,                 0x00},
{WCD9360_TEST_DEBUG_PAD_INP_DISABLE_1,                 0x00},
{WCD9360_TEST_DEBUG_PAD_INP_DISABLE_2,                 0x00},
{WCD9360_TEST_DEBUG_PAD_INP_DISABLE_3,                 0x00},
{WCD9360_TEST_DEBUG_PAD_INP_DISABLE_4,                 0x00},
{WCD9360_TEST_DEBUG_SYSMEM_CTRL,                       0x00},
{WCD9360_TEST_DEBUG_LVAL_NOM_LOW,                      0x96},
{WCD9360_TEST_DEBUG_LVAL_NOM_HIGH,                     0x00},
{WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_LOW,                 0x53},
{WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_HIGH,                0x00},
{WCD9360_TEST_DEBUG_SPI_SLAVE_CHAR,                    0x00},
{WCD9360_TEST_DEBUG_CODEC_DIAGS,                       0x00},
};


const u8 wcd9360_page0_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE0_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_CLK_BYPASS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_CLK_GATE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_CLK_MCLK_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_CLK_MCLK2_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_I2S_DSD_CLK_SEL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_RPM_PWR_CDC_DIG_HM_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_EFUSE_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_EFUSE_TEST0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_EFUSE_TEST1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_EFUSE_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_I2C_ACTIVE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_ALT_FUNC_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_GPIO_CTL_OE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CHIP_TIER_CTRL_GPIO_CTL_DATA)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX0_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX1_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX2_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX3_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX4_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX5_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX6_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_RX7_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX0_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX1_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX2_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX3_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX4_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX5_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX6_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX7_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX8_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX9_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX10_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX11_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX12_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX13_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX14_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_SB_TX15_INP_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_TX0_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_TX0_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_TX1_0_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_TX1_1_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_DATA_HUB_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_1_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_CLKSRC_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_COMMON_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_CH_RX)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_CH_TX)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_0_TDM_STRETCH)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DATA_HUB_I2S_RESET_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_RDMA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_RDMA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_RDMA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_RDMA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_RDMA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_RDMA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_RDMA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_RDMA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_RDMA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_RDMA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA4_PRT_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_SBTX0_7_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_RDMA_SBTX8_10_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_4_5_CFG_WDMA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_4_5_CFG_WDMA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_4_5_CFG_WDMA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_4_5_CFG_WDMA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_4_5_CFG_WDMA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_WDMA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_WDMA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_WDMA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_WDMA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_2_3_CFG_WDMA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_WDMA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_WDMA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_WDMA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_WDMA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_CH_0_1_CFG_WDMA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA0_PRT_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA3_PRT_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA4_PRT0_3_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DMA_WDMA4_PRT4_7_CFG)] = WCD9360_RW,
};

const u8 wcd9360_page1_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE1_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_USER_CTL_9)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_L_VAL_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_L_VAL_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_DSM_FRAC_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_DSM_FRAC_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_CONFIG_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_CONFIG_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_CONFIG_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_CONFIG_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_CONFIG_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_TEST_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_FREQ_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_FREQ_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_FREQ_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_FREQ_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_SSC_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_SSC_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_SSC_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_SSC_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_FLL_MODE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_FLL_STATUS_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_FLL_STATUS_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_FLL_STATUS_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_FLL_STATUS_3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_USER_CTL_9)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_L_VAL_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_L_VAL_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_DSM_FRAC_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_DSM_FRAC_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_CONFIG_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_CONFIG_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_CONFIG_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_CONFIG_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_CONFIG_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_TEST_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_FREQ_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_FREQ_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_FREQ_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_FREQ_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_SSC_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_SSC_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_SSC_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_SSC_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_FLL_MODE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_I2S_FLL_STATUS_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_I2S_FLL_STATUS_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_I2S_FLL_STATUS_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_I2S_FLL_STATUS_3)] = WCD9360_RO,
};

const u8 wcd9360_page2_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE2_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_CPE_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPEFLL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_PWR_CPE_DRAM1_SHUTDOWN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_US_BUF_INT_PERIOD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SVA_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_US_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_MAD_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_CPAR_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_DMIC0_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_DMIC1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_DMIC2_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_DMIC_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_CPAR_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_WDOG_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_BACKUP_INT)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_STATUS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_CPE_OCD_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_MASK_0A)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_MASK_0B)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_MASK_1A)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_MASK_1B)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0A)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0B)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1A)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1B)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0A)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0B)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1A)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1B)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_DMIC3_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_WDOG_RESET)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_MCLK_PRG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_0)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_1)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_2)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_3)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_4)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_5)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_6)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_7)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_8)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_9)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_10)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_11)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_12)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_13)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_14)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_IN_15)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_4)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_5)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_7)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_8)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_9)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_10)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_11)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_12)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_13)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_14)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_IPC_OUT_15)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_LPASS_ARB_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_MAIN_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_MAIN_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_CTL_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_IIR_CTL_PTR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_AUDIO_IIR_CTL_VAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_ULTR_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_CTL_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_IIR_CTL_PTR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_BEACON_IIR_CTL_VAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_INP_SEL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SOC_MAD_MAD2_INP_SEL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_STATUS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_FS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_IN_SEL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT4)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT5)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT7)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT8)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT9)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT10)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT11)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT12)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT13)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT14)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT15)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT4)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT5)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT7)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT8)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT9)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT10)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT11)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT12)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT13)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT14)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT15)] = WCD9360_RO,
};

const u8 wcd9360_page4_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE4_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CLR_COMMIT)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_PIN1_MASK0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_PIN1_MASK1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_PIN1_MASK2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_PIN1_MASK3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_PIN1_STATUS0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_PIN1_STATUS1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_PIN1_STATUS2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_PIN1_STATUS3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_PIN1_CLEAR0)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_PIN1_CLEAR1)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_PIN1_CLEAR2)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_PIN1_CLEAR3)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_PIN2_MASK3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_PIN2_STATUS3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_PIN2_CLEAR3)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_MASK2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_MASK3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_STATUS2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_STATUS3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_CLEAR2)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_CPESS_SUMRY_CLEAR3)] = WCD9360_WO,
[WCD9360_REG(WCD9360_INTR_LEVEL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_LEVEL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_LEVEL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_LEVEL3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_BYPASS0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_BYPASS1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_BYPASS2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_BYPASS3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_SET0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_SET1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_SET2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_SET3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CODEC_MISC_MASK)] = WCD9360_RW,
[WCD9360_REG(WCD9360_INTR_CODEC_MISC_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_INTR_CODEC_MISC_CLEAR)] = WCD9360_WO,
};

const u8 wcd9360_page6_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_ANA_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_BIAS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_AMIC_INPUT_SWITCH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_RCO)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_BUCK_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_BUCK_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_ANA_EAR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_MAD_SETUP)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_AMIC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_AMIC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_AMIC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_AMIC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_MICB1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_MICB2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_MICB3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_ANA_MICB4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_BIAS_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_BIAS_VBG_FINE_ADJ)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CTRL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CTRL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CAL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CAL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_TEST_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RCO_CAL_OUT_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_RCO_CAL_OUT_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_RCO_CAL_OUT_3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_RCO_CAL_OUT_4)] = WCD9360_RO,
[WCD9360_REG(WCD9360_RCO_CAL_OUT_5)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDO_MODE_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_MODE_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_MODE_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_MODE_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_VCL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_VCL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_VCL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_9)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CCL_10)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_FILTER_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_FILTER_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_DRIVER_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_DRIVER_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_DRIVER_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CAL_CODE_EXT_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CAL_CODE_EXT_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_CAL_CODE_OUT_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDO_CAL_CODE_OUT_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDO_TEST_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_TEST_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDOH_MODE)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDOH_BIAS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDOH_STB_LOADS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDOH_SLOWRAMP)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB1_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB1_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB1_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB2_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB2_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB2_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB3_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB3_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB3_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB4_TEST_CTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB4_TEST_CTL_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MICB4_TEST_CTL_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_ADC_VCM)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_BIAS_ATEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_ADC_INT1_IB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_ADC_INT2_IB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_TXFE_DIV_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_TXFE_DIV_START)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_TXFE_DIV_STOP_9P6M)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_COM_TXFE_DIV_STOP_12P288M)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_TEST_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_ADC_IB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_ATEST_REFCTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_TEST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_TEST_BLK_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_TXFE_CLKDIV)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_1_2_SAR1_ERR)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TX_1_2_SAR2_ERR)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TX_3_4_TEST_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_ADC_IB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_ATEST_REFCTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_TEST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_TEST_BLK_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_TXFE_CLKDIV)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TX_3_4_SAR1_ERR)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TX_3_4_SAR2_ERR)] = WCD9360_RO,
[WCD9360_REG(WCD9360_RX_RX_EAR_BIAS_CON_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RX_RX_EAR_BIAS_CON_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RX_RX_AUX_BIAS_CON_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RX_RX_AUX_BIAS_CON_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RX_RX_BIAS_ATEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_RX_RXTOP_RESERVED)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_EAR_EN_REG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_EAR_PA_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_EAR_SP_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_EAR_DAC_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_EAR_CNP_FSM_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_DAC_CTL_TEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_STATUS_REG)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EAR_EAR_COMPANDER_CON)] = WCD9360_RW,
};

const u8 wcd9360_page7_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_ANA_NEW_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_PLL_ENABLES)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_PLL_PRESET)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_PLL_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CLK_SYS_MCLK_PRG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_MCLK2_PRG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_MCLK_MISC)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_VOUT_A_STARTUP)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_VOUT_D_STARTUP)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_VOUT_D_FREQ1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_VOUT_D_FREQ2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_ANA_EAR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_LDORXTX)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DIE_CRACK_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DIE_CRACK_OUT)] = WCD9360_RO,
[WCD9360_REG(WCD9360_LOOP_BACK_EN)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_POST_DIV_REG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_POST_DIV_REG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_REF_DIV_REG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_REF_DIV_REG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_FILTER_REG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_FILTER_REG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_PLL_L_VAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_PLL_M_VAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_PLL_N_VAL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_TEST_REG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_PFD_CP_DSM_PROG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_VCO_PROG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_TEST_REG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_LDO_LOCK_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_DIG_LOCK_DET_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_CLK_TEST1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_CLK_TEST2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CLK_SYS_INT_CLK_TEST3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_SPARE_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_A)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_D)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_INC_WAIT)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_IBLEED_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DEBUG_CPROVR_TEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_CTL_A)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_CTL_D)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_RAMP_TIMEOUT_PERIOD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_INT_NEW_EAR_CHOPPER_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EAR_INT_NEW_EAR_DYNAMIC_BIAS)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_EN_REG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_PA_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_SP_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_DAC_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_CNP_FSM_CON)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_AUX_TEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_AUX_INT_STATUS_REG)] = WCD9360_RO,
[WCD9360_REG(WCD9360_AUX_INT_AUX_MISC)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LDORXTX_INT_ANA_LDORXTX_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_DIE_CRACK_INT_INT1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_DIE_CRACK_INT_INT2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_LOOP_BACK_INT_SPARE)] = WCD9360_RW,
};

const u8 wcd9360_page10_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE10_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_CLK_RESET_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_MODE_1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_MODE_2_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_FF_SHIFT)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_FB_SHIFT)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_LPF_FF_A_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_LPF_FF_B_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_LPF_FB_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_SMLPF_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_DCFLT_SHIFT_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_IIR_ADAPT_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_IIR_COEFF_1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_IIR_COEFF_2_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_FF_A_GAIN_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_FF_B_GAIN_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_ANC0_FB_GAIN_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX0_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX1_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX2_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX3_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX4_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX5_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX6_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX7_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_192_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_192_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX8_TX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX9_SPKR_PROT_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX9_SPKR_PROT_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX10_SPKR_PROT_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX10_SPKR_PROT_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX11_SPKR_PROT_PATH_CTL)] =  WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX11_SPKR_PROT_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX12_SPKR_PROT_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX12_SPKR_PROT_PATH_CFG0)] = WCD9360_RW,
};

const u8 wcd9360_page11_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE11_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_COMPANDER0_CTL7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_COMPANDER7_CTL7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL6)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_COMPANDER8_CTL7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_MIX_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_VOL_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_SEC7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_MIX_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_MIX_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX0_RX_PATH_DSMDEM_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_MIX_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_VOL_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_SEC7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_MIX_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_MIX_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX9_RX_PATH_DSMDEM_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_MIX_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_VOL_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_SEC7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_MIX_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_MIX_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX7_RX_PATH_DSMDEM_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_VOL_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_MIX_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_VOL_MIX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_SEC7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_MIX_SEC0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_MIX_SEC1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX8_RX_PATH_DSMDEM_CTL)] = WCD9360_RW,
};

const u8 wcd9360_page12_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE12_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST0_BOOST_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST0_BOOST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST0_BOOST_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST0_BOOST_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST1_BOOST_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST1_BOOST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST1_BOOST_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_BOOST1_BOOST_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC2_CLK_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC2_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC2_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC2_FIFO_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC2_STATUS_FIFO)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC3_CLK_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC3_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC3_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC3_FIFO_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_MIXING_ASRC3_STATUS_FIFO)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_DATA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_DATA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_DATA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_DATA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_ADDR_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_ADDR_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_ADDR_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_WR_ADDR_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_ADDR_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_ADDR_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_ADDR_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_ADDR_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_DATA_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_DATA_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_DATA_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_RD_DATA_3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_ACCESS_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SWR_AHB_BRIDGE_ACCESS_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_CLK_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_FIFO_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_SIDETONE_ASRC0_STATUS_FIFO)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_REF_HQ0_EC_REF_HQ_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_REF_HQ0_EC_REF_HQ_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_REF_HQ1_EC_REF_HQ_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_REF_HQ1_EC_REF_HQ_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC0_CLK_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC0_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC0_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC0_FIFO_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC0_STATUS_FIFO)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC1_CLK_RST_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC1_CTL0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC1_CTL1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC1_FIFO_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_EC_ASRC1_STATUS_FIFO)] = WCD9360_RO,
};

const u8 wcd9360_page13_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE13_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_ANC_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_RX_INP_MUX_EC_REF_HQ_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX4_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX5_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX6_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX7_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX8_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX10_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TX_INP_MUX_ADC_MUX11_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_IF_ROUTER_TX_MUX_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_IF_ROUTER_TX_MUX_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_IF_ROUTER_TX_MUX_CFG2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_IF_ROUTER_TX_MUX_CFG3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_CLK_RST_CTRL_MCLK_CONTROL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_CLK_RST_CTRL_FS_CNT_CONTROL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_CLK_RST_CTRL_SWR_CONTROL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_TEST_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_PATH_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_TOP_CFG0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_TOP_CFG1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_TOP_CFG7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_EAR_COMP_WR_LSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_EAR_COMP_WR_MSB)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_EAR_COMP_LUT)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CDC_TOP_EAR_COMP_RD_LSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_TOP_EAR_COMP_RD_MSB)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CDC_TOP_TOP_DEBUG)] = WCD9360_RW,
};

const u8 wcd9360_page80_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE80_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_DATA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_DATA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_DATA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_DATA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_ADDR_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_ADDR_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_ADDR_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_WR_ADDR_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_ADDR_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_ADDR_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_ADDR_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_ADDR_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_DATA_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_DATA_1)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_DATA_2)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_RD_DATA_3)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_ACCESS_CFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_ACCESS_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_NOM_CX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SVS_CX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SVS2_CX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_NOM_MX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SVS_MX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SVS2_MX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SVS2_MIN_CX_VDD)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_MAX_SVS2_STEP)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_CTL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_CODEC_CPR_SW_MODECHNG_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_CODEC_CPR_SW_MODECHNG_START)] = WCD9360_WO,
[WCD9360_REG(WCD9360_CODEC_CPR_CPR_STATUS)] = WCD9360_RW,
};

const u8 wcd9360_page128_reg_access[WCD9360_PAGE_SIZE] = {
[WCD9360_REG(WCD9360_PAGE128_PAGE_REGISTER)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_JTCK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_INTR1_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_INTR2_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SWR_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SWR_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SLIMBUS_DATA1_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SLIMBUS_DATA2_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SLIMBUS_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2C_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2C_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_0_RX_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_0_TX_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_0_SCK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_0_WS_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_1_RX_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_1_TX_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_1_SCK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_I2S_1_WS_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC1_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC1_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC2_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC2_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_GPIO1_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_GPIO2_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_GPIO3_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_GPIO4_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SPI_S_CSN_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SPI_S_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SPI_S_DOUT_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_SPI_S_DIN_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_GPIO0_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC3_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC3_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC4_CLK_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TLMM_DMIC4_DATA_PINCFG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_OE_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_OE_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_OE_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_OE_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_OE_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_DATA_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_DATA_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_DATA_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_DATA_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_CTL_DATA_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_DRVCTL_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_DRVCTL_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PIN_STATUS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TEST_DEBUG_NPL_DLY_TEST_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_NPL_DLY_TEST_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_MEM_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_BUS_SEL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_JTAG)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_EN_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_EN_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_EN_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_EN_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_EN_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_ANA_DTEST_DIR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_INP_DISABLE_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_INP_DISABLE_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_INP_DISABLE_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_INP_DISABLE_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_INP_DISABLE_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_SYSMEM_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_LVAL_NOM_LOW)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_LVAL_NOM_HIGH)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_LOW)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_HIGH)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_SPI_SLAVE_CHAR)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_CODEC_DIAGS)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TEST_DEBUG_PAD_TEST)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_0)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_1)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_2)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_3)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_4)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_5)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_6)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_7)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_8)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_9)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_10)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_11)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_12)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_13)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_14)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_15)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_16)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_17)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_18)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_19)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_20)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_21)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_22)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_23)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_24)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_25)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_26)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_27)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_28)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_29)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_30)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_31)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_RD_CTRL)] = WCD9360_RW,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_RD_7_0)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_RD_15_8)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_RD_23_16)] = WCD9360_RO,
[WCD9360_REG(WCD9360_TEST_DEBUG_DEBUG_MUX_RD_31_24)] = WCD9360_RO,

};

const u8 * const wcd9360_reg[WCD9360_PAGE_MAX] = {
[WCD9360_PAGE_0] = wcd9360_page0_reg_access,
[WCD9360_PAGE_1] = wcd9360_page1_reg_access,
[WCD9360_PAGE_2] = wcd9360_page2_reg_access,
[WCD9360_PAGE_4] = wcd9360_page4_reg_access,
[WCD9360_PAGE_6] = wcd9360_page6_reg_access,
[WCD9360_PAGE_7] = wcd9360_page7_reg_access,
[WCD9360_PAGE_10] = wcd9360_page10_reg_access,
[WCD9360_PAGE_11] = wcd9360_page11_reg_access,
[WCD9360_PAGE_12] = wcd9360_page12_reg_access,
[WCD9360_PAGE_13] = wcd9360_page13_reg_access,
[WCD9360_PAGE_80] = wcd9360_page80_reg_access,
[WCD9360_PAGE_128] = wcd9360_page128_reg_access,
};

#endif
