/*
 * Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _WCD9360_REGISTERS_H
#define _WCD9360_REGISTERS_H

#define WCD9360_PAGE_SIZE 256
#define WCD9360_NUM_PAGES 256

enum {
	WCD9360_PAGE_0 = 0,
	WCD9360_PAGE_1,
	WCD9360_PAGE_2,
	WCD9360_PAGE_4 = 4,
	WCD9360_PAGE_6 = 6,
	WCD9360_PAGE_7,
	WCD9360_PAGE_10 = 10,
	WCD9360_PAGE_11,
	WCD9360_PAGE_12,
	WCD9360_PAGE_13,
	WCD9360_PAGE_14,
	WCD9360_PAGE_80,
	WCD9360_PAGE_128,
	WCD9360_PAGE_MAX,
};

enum {
	WCD9360_WO = 0,
	WCD9360_RO,
	WCD9360_RW,
};

extern const u8 * const wcd9360_reg[WCD9360_PAGE_MAX];

/* Page-0 Registers */
#define WCD9360_PAGE0_PAGE_REGISTER                       (0x00000000)
#define WCD9360_CODEC_RPM_CLK_BYPASS                      (0x00000001)
#define WCD9360_CODEC_RPM_CLK_GATE                        (0x00000002)
#define WCD9360_CODEC_RPM_CLK_MCLK_CFG                    (0x00000003)
#define WCD9360_CODEC_RPM_CLK_MCLK2_CFG                   (0x00000004)
#define WCD9360_CODEC_RPM_I2S_DSD_CLK_SEL                 (0x00000005)
#define WCD9360_CODEC_RPM_RST_CTL                         (0x00000009)
#define WCD9360_CODEC_RPM_PWR_CDC_DIG_HM_CTL              (0x00000011)
#define WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE0              (0x00000021)
#define WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE1              (0x00000022)
#define WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE2              (0x00000023)
#define WCD9360_CHIP_TIER_CTRL_CHIP_ID_BYTE3              (0x00000024)
#define WCD9360_CHIP_TIER_CTRL_EFUSE_CTL                  (0x00000025)
#define WCD9360_CHIP_TIER_CTRL_EFUSE_TEST0                (0x00000026)
#define WCD9360_CHIP_TIER_CTRL_EFUSE_TEST1                (0x00000027)
#define WCD9360_CHIP_TIER_CTRL_EFUSE_STATUS               (0x00000039)
#define WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_NONNEGO       (0x0000003A)
#define WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_1             (0x0000003B)
#define WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_2             (0x0000003C)
#define WCD9360_CHIP_TIER_CTRL_I2C_SLAVE_ID_3             (0x0000003D)
#define WCD9360_CHIP_TIER_CTRL_ANA_WAIT_STATE_CTL         (0x0000003E)
#define WCD9360_CHIP_TIER_CTRL_I2C_ACTIVE                 (0x00000040)
#define WCD9360_CHIP_TIER_CTRL_ALT_FUNC_EN                (0x00000041)
#define WCD9360_CHIP_TIER_CTRL_GPIO_CTL_OE                (0x00000042)
#define WCD9360_CHIP_TIER_CTRL_GPIO_CTL_DATA              (0x00000043)
#define WCD9360_DATA_HUB_RX0_CFG                          (0x00000051)
#define WCD9360_DATA_HUB_RX1_CFG                          (0x00000052)
#define WCD9360_DATA_HUB_RX2_CFG                          (0x00000053)
#define WCD9360_DATA_HUB_RX3_CFG                          (0x00000054)
#define WCD9360_DATA_HUB_RX4_CFG                          (0x00000055)
#define WCD9360_DATA_HUB_RX5_CFG                          (0x00000056)
#define WCD9360_DATA_HUB_RX6_CFG                          (0x00000057)
#define WCD9360_DATA_HUB_RX7_CFG                          (0x00000058)
#define WCD9360_DATA_HUB_SB_TX0_INP_CFG                   (0x00000061)
#define WCD9360_DATA_HUB_SB_TX1_INP_CFG                   (0x00000062)
#define WCD9360_DATA_HUB_SB_TX2_INP_CFG                   (0x00000063)
#define WCD9360_DATA_HUB_SB_TX3_INP_CFG                   (0x00000064)
#define WCD9360_DATA_HUB_SB_TX4_INP_CFG                   (0x00000065)
#define WCD9360_DATA_HUB_SB_TX5_INP_CFG                   (0x00000066)
#define WCD9360_DATA_HUB_SB_TX6_INP_CFG                   (0x00000067)
#define WCD9360_DATA_HUB_SB_TX7_INP_CFG                   (0x00000068)
#define WCD9360_DATA_HUB_SB_TX8_INP_CFG                   (0x00000069)
#define WCD9360_DATA_HUB_SB_TX9_INP_CFG                   (0x0000006A)
#define WCD9360_DATA_HUB_SB_TX10_INP_CFG                  (0x0000006B)
#define WCD9360_DATA_HUB_SB_TX11_INP_CFG                  (0x0000006C)
#define WCD9360_DATA_HUB_SB_TX12_INP_CFG                  (0x0000006D)
#define WCD9360_DATA_HUB_SB_TX13_INP_CFG                  (0x0000006E)
#define WCD9360_DATA_HUB_SB_TX14_INP_CFG                  (0x0000006F)
#define WCD9360_DATA_HUB_SB_TX15_INP_CFG                  (0x00000070)
#define WCD9360_DATA_HUB_I2S_TX0_CFG                      (0x00000071)
#define WCD9360_DATA_HUB_I2S_TX0_CFG2                     (0x00000072)
#define WCD9360_DATA_HUB_I2S_TX1_0_CFG                    (0x00000073)
#define WCD9360_DATA_HUB_I2S_TX1_1_CFG                    (0x00000074)
#define WCD9360_DATA_HUB_DATA_HUB_CFG                     (0x00000079)
#define WCD9360_DATA_HUB_I2S_0_CTL                        (0x00000081)
#define WCD9360_DATA_HUB_I2S_1_CTL                        (0x00000082)
#define WCD9360_DATA_HUB_I2S_0_CTL2                       (0x00000083)
#define WCD9360_DATA_HUB_I2S_1_CTL2                       (0x00000084)
#define WCD9360_DATA_HUB_I2S_CLKSRC_CTL                   (0x00000085)
#define WCD9360_DATA_HUB_I2S_COMMON_CTL                   (0x00000086)
#define WCD9360_DATA_HUB_I2S_0_TDM_CTL                    (0x00000087)
#define WCD9360_DATA_HUB_I2S_0_TDM_CTL2                   (0x00000089)
#define WCD9360_DATA_HUB_I2S_0_TDM_CH_RX                  (0x0000008A)
#define WCD9360_DATA_HUB_I2S_0_TDM_CH_TX                  (0x0000008B)
#define WCD9360_DATA_HUB_I2S_0_TDM_CFG                    (0x0000008C)
#define WCD9360_DATA_HUB_I2S_0_TDM_STRETCH                (0x0000008D)
#define WCD9360_DATA_HUB_I2S_RESET_CTL                    (0x00000090)
#define WCD9360_DMA_RDMA_CTL_0                            (0x00000091)
#define WCD9360_DMA_CH_2_3_CFG_RDMA_0                     (0x00000092)
#define WCD9360_DMA_CH_0_1_CFG_RDMA_0                     (0x00000093)
#define WCD9360_DMA_RDMA_CTL_1                            (0x00000094)
#define WCD9360_DMA_CH_2_3_CFG_RDMA_1                     (0x00000095)
#define WCD9360_DMA_CH_0_1_CFG_RDMA_1                     (0x00000096)
#define WCD9360_DMA_RDMA_CTL_2                            (0x00000097)
#define WCD9360_DMA_CH_2_3_CFG_RDMA_2                     (0x00000098)
#define WCD9360_DMA_CH_0_1_CFG_RDMA_2                     (0x00000099)
#define WCD9360_DMA_RDMA_CTL_3                            (0x0000009A)
#define WCD9360_DMA_CH_2_3_CFG_RDMA_3                     (0x0000009B)
#define WCD9360_DMA_CH_0_1_CFG_RDMA_3                     (0x0000009C)
#define WCD9360_DMA_RDMA_CTL_4                            (0x0000009D)
#define WCD9360_DMA_CH_2_3_CFG_RDMA_4                     (0x0000009E)
#define WCD9360_DMA_CH_0_1_CFG_RDMA_4                     (0x0000009F)
#define WCD9360_DMA_RDMA4_PRT_CFG                         (0x000000B1)
#define WCD9360_DMA_RDMA_SBTX0_7_CFG                      (0x000000B9)
#define WCD9360_DMA_RDMA_SBTX8_10_CFG                     (0x000000BA)
#define WCD9360_DMA_WDMA_CTL_0                            (0x000000C1)
#define WCD9360_DMA_WDMA_CTL_1                            (0x000000C6)
#define WCD9360_DMA_WDMA_CTL_2                            (0x000000CB)
#define WCD9360_DMA_WDMA_CTL_3                            (0x000000D0)
#define WCD9360_DMA_WDMA_CTL_4                            (0x000000D5)
#define WCD9360_DMA_CH_4_5_CFG_WDMA_0                     (0x000000C2)
#define WCD9360_DMA_CH_4_5_CFG_WDMA_1                     (0x000000C7)
#define WCD9360_DMA_CH_4_5_CFG_WDMA_2                     (0x000000CC)
#define WCD9360_DMA_CH_4_5_CFG_WDMA_3                     (0x000000D1)
#define WCD9360_DMA_CH_4_5_CFG_WDMA_4                     (0x000000D6)
#define WCD9360_DMA_CH_2_3_CFG_WDMA_0                     (0x000000C3)
#define WCD9360_DMA_CH_2_3_CFG_WDMA_1                     (0x000000C8)
#define WCD9360_DMA_CH_2_3_CFG_WDMA_2                     (0x000000CD)
#define WCD9360_DMA_CH_2_3_CFG_WDMA_3                     (0x000000D2)
#define WCD9360_DMA_CH_2_3_CFG_WDMA_4                     (0x000000D7)
#define WCD9360_DMA_CH_0_1_CFG_WDMA_0                     (0x000000C4)
#define WCD9360_DMA_CH_0_1_CFG_WDMA_1                     (0x000000C9)
#define WCD9360_DMA_CH_0_1_CFG_WDMA_2                     (0x000000CE)
#define WCD9360_DMA_CH_0_1_CFG_WDMA_3                     (0x000000D3)
#define WCD9360_DMA_CH_0_1_CFG_WDMA_4                     (0x000000D8)
#define WCD9360_DMA_WDMA0_PRT_CFG                         (0x000000E1)
#define WCD9360_DMA_WDMA3_PRT_CFG                         (0x000000E2)
#define WCD9360_DMA_WDMA4_PRT0_3_CFG                      (0x000000E3)
#define WCD9360_DMA_WDMA4_PRT4_7_CFG                      (0x000000E4)
#define WCD9360_PAGE1_PAGE_REGISTER                       (0x00000100)
#define WCD9360_CPE_FLL_USER_CTL_0                        (0x00000101)
#define WCD9360_CPE_FLL_USER_CTL_1                        (0x00000102)
#define WCD9360_CPE_FLL_USER_CTL_2                        (0x00000103)
#define WCD9360_CPE_FLL_USER_CTL_3                        (0x00000104)
#define WCD9360_CPE_FLL_USER_CTL_4                        (0x00000105)
#define WCD9360_CPE_FLL_USER_CTL_5                        (0x00000106)
#define WCD9360_CPE_FLL_USER_CTL_6                        (0x00000107)
#define WCD9360_CPE_FLL_USER_CTL_7                        (0x00000108)
#define WCD9360_CPE_FLL_USER_CTL_8                        (0x00000109)
#define WCD9360_CPE_FLL_USER_CTL_9                        (0x0000010A)
#define WCD9360_CPE_FLL_L_VAL_CTL_0                       (0x0000010B)
#define WCD9360_CPE_FLL_L_VAL_CTL_1                       (0x0000010C)
#define WCD9360_CPE_FLL_DSM_FRAC_CTL_0                    (0x0000010D)
#define WCD9360_CPE_FLL_DSM_FRAC_CTL_1                    (0x0000010E)
#define WCD9360_CPE_FLL_CONFIG_CTL_0                      (0x0000010F)
#define WCD9360_CPE_FLL_CONFIG_CTL_1                      (0x00000110)
#define WCD9360_CPE_FLL_CONFIG_CTL_2                      (0x00000111)
#define WCD9360_CPE_FLL_CONFIG_CTL_3                      (0x00000112)
#define WCD9360_CPE_FLL_CONFIG_CTL_4                      (0x00000113)
#define WCD9360_CPE_FLL_TEST_CTL_0                        (0x00000114)
#define WCD9360_CPE_FLL_TEST_CTL_1                        (0x00000115)
#define WCD9360_CPE_FLL_TEST_CTL_2                        (0x00000116)
#define WCD9360_CPE_FLL_TEST_CTL_3                        (0x00000117)
#define WCD9360_CPE_FLL_TEST_CTL_4                        (0x00000118)
#define WCD9360_CPE_FLL_TEST_CTL_5                        (0x00000119)
#define WCD9360_CPE_FLL_TEST_CTL_6                        (0x0000011A)
#define WCD9360_CPE_FLL_TEST_CTL_7                        (0x0000011B)
#define WCD9360_CPE_FLL_FREQ_CTL_0                        (0x0000011C)
#define WCD9360_CPE_FLL_FREQ_CTL_1                        (0x0000011D)
#define WCD9360_CPE_FLL_FREQ_CTL_2                        (0x0000011E)
#define WCD9360_CPE_FLL_FREQ_CTL_3                        (0x0000011F)
#define WCD9360_CPE_FLL_SSC_CTL_0                         (0x00000120)
#define WCD9360_CPE_FLL_SSC_CTL_1                         (0x00000121)
#define WCD9360_CPE_FLL_SSC_CTL_2                         (0x00000122)
#define WCD9360_CPE_FLL_SSC_CTL_3                         (0x00000123)
#define WCD9360_CPE_FLL_FLL_MODE                          (0x00000124)
#define WCD9360_CPE_FLL_STATUS_0                          (0x00000125)
#define WCD9360_CPE_FLL_STATUS_1                          (0x00000126)
#define WCD9360_CPE_FLL_STATUS_2                          (0x00000127)
#define WCD9360_CPE_FLL_STATUS_3                          (0x00000128)
#define WCD9360_I2S_FLL_USER_CTL_0                        (0x00000141)
#define WCD9360_I2S_FLL_USER_CTL_1                        (0x00000142)
#define WCD9360_I2S_FLL_USER_CTL_2                        (0x00000143)
#define WCD9360_I2S_FLL_USER_CTL_3                        (0x00000144)
#define WCD9360_I2S_FLL_USER_CTL_4                        (0x00000145)
#define WCD9360_I2S_FLL_USER_CTL_5                        (0x00000146)
#define WCD9360_I2S_FLL_USER_CTL_6                        (0x00000147)
#define WCD9360_I2S_FLL_USER_CTL_7                        (0x00000148)
#define WCD9360_I2S_FLL_USER_CTL_8                        (0x00000149)
#define WCD9360_I2S_FLL_USER_CTL_9                        (0x0000014A)
#define WCD9360_I2S_FLL_L_VAL_CTL_0                       (0x0000014B)
#define WCD9360_I2S_FLL_L_VAL_CTL_1                       (0x0000014C)
#define WCD9360_I2S_FLL_DSM_FRAC_CTL_0                    (0x0000014D)
#define WCD9360_I2S_FLL_DSM_FRAC_CTL_1                    (0x0000014E)
#define WCD9360_I2S_FLL_CONFIG_CTL_0                      (0x0000014F)
#define WCD9360_I2S_FLL_CONFIG_CTL_1                      (0x00000150)
#define WCD9360_I2S_FLL_CONFIG_CTL_2                      (0x00000151)
#define WCD9360_I2S_FLL_CONFIG_CTL_3                      (0x00000152)
#define WCD9360_I2S_FLL_CONFIG_CTL_4                      (0x00000153)
#define WCD9360_I2S_FLL_TEST_CTL_0                        (0x00000154)
#define WCD9360_I2S_FLL_TEST_CTL_1                        (0x00000155)
#define WCD9360_I2S_FLL_TEST_CTL_2                        (0x00000156)
#define WCD9360_I2S_FLL_TEST_CTL_3                        (0x00000157)
#define WCD9360_I2S_FLL_TEST_CTL_4                        (0x00000158)
#define WCD9360_I2S_FLL_TEST_CTL_5                        (0x00000159)
#define WCD9360_I2S_FLL_TEST_CTL_6                        (0x0000015A)
#define WCD9360_I2S_FLL_TEST_CTL_7                        (0x0000015B)
#define WCD9360_I2S_FLL_FREQ_CTL_0                        (0x0000015C)
#define WCD9360_I2S_FLL_FREQ_CTL_1                        (0x0000015D)
#define WCD9360_I2S_FLL_FREQ_CTL_2                        (0x0000015E)
#define WCD9360_I2S_FLL_FREQ_CTL_3                        (0x0000015F)
#define WCD9360_I2S_FLL_SSC_CTL_0                         (0x00000160)
#define WCD9360_I2S_FLL_SSC_CTL_1                         (0x00000161)
#define WCD9360_I2S_FLL_SSC_CTL_2                         (0x00000162)
#define WCD9360_I2S_FLL_SSC_CTL_3                         (0x00000163)
#define WCD9360_I2S_FLL_FLL_MODE                          (0x00000164)
#define WCD9360_I2S_FLL_STATUS_0                          (0x00000165)
#define WCD9360_I2S_FLL_STATUS_1                          (0x00000166)
#define WCD9360_I2S_FLL_STATUS_2                          (0x00000167)
#define WCD9360_I2S_FLL_STATUS_3                          (0x00000168)
#define WCD9360_PAGE2_PAGE_REGISTER                       (0x00000200)
#define WCD9360_CPE_SS_CPE_CTL                            (0x00000201)
#define WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_0               (0x00000202)
#define WCD9360_CPE_SS_PWR_SYS_PSTATE_CTL_1               (0x00000203)
#define WCD9360_CPE_SS_PWR_CPEFLL_CTL                     (0x00000204)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_0           (0x00000205)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_DEEPSLP_1           (0x00000206)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_0          (0x00000208)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_1          (0x00000209)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_2          (0x0000020A)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_3          (0x0000020B)
#define WCD9360_CPE_SS_PWR_CPE_SYSMEM_SHUTDOWN_4          (0x0000020C)
#define WCD9360_CPE_SS_PWR_CPE_DRAM1_SHUTDOWN             (0x0000020E)
#define WCD9360_CPE_SS_US_BUF_INT_PERIOD                  (0x00000212)
#define WCD9360_CPE_SS_CPARMAD_BUFRDY_INT_PERIOD          (0x00000213)
#define WCD9360_CPE_SS_SVA_CFG                            (0x00000214)
#define WCD9360_CPE_SS_US_CFG                             (0x00000215)
#define WCD9360_CPE_SS_MAD_CTL                            (0x00000216)
#define WCD9360_CPE_SS_CPAR_CTL                           (0x00000217)
#define WCD9360_CPE_SS_DMIC0_CTL                          (0x00000218)
#define WCD9360_CPE_SS_DMIC1_CTL                          (0x00000219)
#define WCD9360_CPE_SS_DMIC2_CTL                          (0x0000021A)
#define WCD9360_CPE_SS_DMIC_CFG                           (0x0000021B)
#define WCD9360_CPE_SS_CPAR_CFG                           (0x0000021C)
#define WCD9360_CPE_SS_WDOG_CFG                           (0x0000021D)
#define WCD9360_CPE_SS_BACKUP_INT                         (0x0000021E)
#define WCD9360_CPE_SS_STATUS                             (0x0000021F)
#define WCD9360_CPE_SS_CPE_OCD_CFG                        (0x00000220)
#define WCD9360_CPE_SS_SS_ERROR_INT_MASK_0A               (0x00000221)
#define WCD9360_CPE_SS_SS_ERROR_INT_MASK_0B               (0x00000222)
#define WCD9360_CPE_SS_SS_ERROR_INT_MASK_1A               (0x00000223)
#define WCD9360_CPE_SS_SS_ERROR_INT_MASK_1B               (0x00000224)
#define WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0A             (0x00000225)
#define WCD9360_CPE_SS_SS_ERROR_INT_STATUS_0B             (0x00000226)
#define WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1A             (0x00000227)
#define WCD9360_CPE_SS_SS_ERROR_INT_STATUS_1B             (0x00000228)
#define WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0A              (0x00000229)
#define WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_0B              (0x0000022A)
#define WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1A              (0x0000022B)
#define WCD9360_CPE_SS_SS_ERROR_INT_CLEAR_1B              (0x0000022C)
#define WCD9360_CPE_SS_DMIC3_CTL                          (0x00000231)
#define WCD9360_CPE_SS_WDOG_RESET                         (0x00000239)
#define WCD9360_CPE_SS_LPASS_MCLK_PRG                     (0x00000240)
#define WCD9360_CPE_SS_LPASS_IPC_IN_0                     (0x00000241)
#define WCD9360_CPE_SS_LPASS_IPC_IN_1                     (0x00000242)
#define WCD9360_CPE_SS_LPASS_IPC_IN_2                     (0x00000243)
#define WCD9360_CPE_SS_LPASS_IPC_IN_3                     (0x00000244)
#define WCD9360_CPE_SS_LPASS_IPC_IN_4                     (0x00000245)
#define WCD9360_CPE_SS_LPASS_IPC_IN_5                     (0x00000246)
#define WCD9360_CPE_SS_LPASS_IPC_IN_6                     (0x00000247)
#define WCD9360_CPE_SS_LPASS_IPC_IN_7                     (0x00000248)
#define WCD9360_CPE_SS_LPASS_IPC_IN_8                     (0x00000249)
#define WCD9360_CPE_SS_LPASS_IPC_IN_9                     (0x0000024A)
#define WCD9360_CPE_SS_LPASS_IPC_IN_10                    (0x0000024B)
#define WCD9360_CPE_SS_LPASS_IPC_IN_11                    (0x0000024C)
#define WCD9360_CPE_SS_LPASS_IPC_IN_12                    (0x0000024D)
#define WCD9360_CPE_SS_LPASS_IPC_IN_13                    (0x0000024E)
#define WCD9360_CPE_SS_LPASS_IPC_IN_14                    (0x0000024F)
#define WCD9360_CPE_SS_LPASS_IPC_IN_15                    (0x00000250)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_0                    (0x00000251)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_1                    (0x00000252)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_2                    (0x00000253)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_3                    (0x00000254)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_4                    (0x00000255)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_5                    (0x00000256)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_6                    (0x00000257)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_7                    (0x00000258)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_8                    (0x00000259)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_9                    (0x0000025A)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_10                   (0x0000025B)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_11                   (0x0000025C)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_12                   (0x0000025D)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_13                   (0x0000025E)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_14                   (0x0000025F)
#define WCD9360_CPE_SS_LPASS_IPC_OUT_15                   (0x00000260)
#define WCD9360_CPE_SS_LPASS_ARB_CTL                      (0x00000261)
#define WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_0                 (0x00000271)
#define WCD9360_CPE_SS_MEM_DEEPSLEEP_RD_1                 (0x00000272)
#define WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_0             (0x00000273)
#define WCD9360_CPE_SS_MEM_DEEPSLEEP_BYPASS_1             (0x00000274)
#define WCD9360_SOC_MAD_MAIN_CTL_1                        (0x00000281)
#define WCD9360_SOC_MAD_MAIN_CTL_2                        (0x00000282)
#define WCD9360_SOC_MAD_AUDIO_CTL_1                       (0x00000283)
#define WCD9360_SOC_MAD_AUDIO_CTL_2                       (0x00000284)
#define WCD9360_SOC_MAD_AUDIO_CTL_3                       (0x00000285)
#define WCD9360_SOC_MAD_AUDIO_CTL_4                       (0x00000286)
#define WCD9360_SOC_MAD_AUDIO_CTL_5                       (0x00000287)
#define WCD9360_SOC_MAD_AUDIO_CTL_6                       (0x00000288)
#define WCD9360_SOC_MAD_AUDIO_CTL_7                       (0x00000289)
#define WCD9360_SOC_MAD_AUDIO_CTL_8                       (0x0000028A)
#define WCD9360_SOC_MAD_AUDIO_IIR_CTL_PTR                 (0x0000028B)
#define WCD9360_SOC_MAD_AUDIO_IIR_CTL_VAL                 (0x0000028C)
#define WCD9360_SOC_MAD_ULTR_CTL_1                        (0x0000028D)
#define WCD9360_SOC_MAD_ULTR_CTL_2                        (0x0000028E)
#define WCD9360_SOC_MAD_ULTR_CTL_3                        (0x0000028F)
#define WCD9360_SOC_MAD_ULTR_CTL_4                        (0x00000290)
#define WCD9360_SOC_MAD_ULTR_CTL_5                        (0x00000291)
#define WCD9360_SOC_MAD_ULTR_CTL_6                        (0x00000292)
#define WCD9360_SOC_MAD_ULTR_CTL_7                        (0x00000293)
#define WCD9360_SOC_MAD_BEACON_CTL_1                      (0x00000294)
#define WCD9360_SOC_MAD_BEACON_CTL_2                      (0x00000295)
#define WCD9360_SOC_MAD_BEACON_CTL_3                      (0x00000296)
#define WCD9360_SOC_MAD_BEACON_CTL_4                      (0x00000297)
#define WCD9360_SOC_MAD_BEACON_CTL_5                      (0x00000298)
#define WCD9360_SOC_MAD_BEACON_CTL_6                      (0x00000299)
#define WCD9360_SOC_MAD_BEACON_CTL_7                      (0x0000029A)
#define WCD9360_SOC_MAD_BEACON_CTL_8                      (0x0000029B)
#define WCD9360_SOC_MAD_BEACON_IIR_CTL_PTR                (0x0000029C)
#define WCD9360_SOC_MAD_BEACON_IIR_CTL_VAL                (0x0000029D)
#define WCD9360_SOC_MAD_INP_SEL                           (0x0000029E)
#define WCD9360_SOC_MAD_MAD2_INP_SEL                      (0x0000029F)
#define WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_CTRL      (0x000002B1)
#define WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_STATUS    (0x000002B2)
#define WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_FS        (0x000002B3)
#define WCD9360_SWR_SAMPLE_PACK_SWR_SAMPLE_PACK_IN_SEL    (0x000002B4)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT0                (0x000002C1)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT1                (0x000002C2)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT2                (0x000002C3)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT3                (0x000002C4)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT4                (0x000002C5)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT5                (0x000002C6)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT6                (0x000002C7)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT7                (0x000002C8)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT8                (0x000002C9)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT9                (0x000002CA)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT10               (0x000002CB)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT11               (0x000002CC)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT12               (0x000002CD)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT13               (0x000002CE)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT14               (0x000002CF)
#define WCD9360_EFUSE_VALUE_EFUSE_VAL_OUT15               (0x000002D0)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT0               (0x000002D1)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT1               (0x000002D2)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT2               (0x000002D3)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT3               (0x000002D4)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT4               (0x000002D5)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT5               (0x000002D6)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT6               (0x000002D7)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT7               (0x000002D8)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT8               (0x000002D9)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT9               (0x000002DA)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT10              (0x000002DB)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT11              (0x000002DC)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT12              (0x000002DD)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT13              (0x000002DE)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT14              (0x000002DF)
#define WCD9360_EFUSE_VALUE_EFUSE2_VAL_OUT15              (0x000002E0)
#define WCD9360_PAGE4_PAGE_REGISTER                       (0x00000400)
#define WCD9360_INTR_CFG                                  (0x00000401)
#define WCD9360_INTR_CLR_COMMIT                           (0x00000402)
#define WCD9360_INTR_PIN1_MASK0                           (0x00000409)
#define WCD9360_INTR_PIN1_MASK1                           (0x0000040A)
#define WCD9360_INTR_PIN1_MASK2                           (0x0000040B)
#define WCD9360_INTR_PIN1_MASK3                           (0x0000040C)
#define WCD9360_INTR_PIN1_STATUS0                         (0x00000411)
#define WCD9360_INTR_PIN1_STATUS1                         (0x00000412)
#define WCD9360_INTR_PIN1_STATUS2                         (0x00000413)
#define WCD9360_INTR_PIN1_STATUS3                         (0x00000414)
#define WCD9360_INTR_PIN1_CLEAR0                          (0x00000419)
#define WCD9360_INTR_PIN1_CLEAR1                          (0x0000041A)
#define WCD9360_INTR_PIN1_CLEAR2                          (0x0000041B)
#define WCD9360_INTR_PIN1_CLEAR3                          (0x0000041C)
#define WCD9360_INTR_PIN2_MASK3                           (0x00000424)
#define WCD9360_INTR_PIN2_STATUS3                         (0x0000042C)
#define WCD9360_INTR_PIN2_CLEAR3                          (0x00000434)
#define WCD9360_INTR_CPESS_SUMRY_MASK2                    (0x0000043B)
#define WCD9360_INTR_CPESS_SUMRY_MASK3                    (0x0000043C)
#define WCD9360_INTR_CPESS_SUMRY_STATUS2                  (0x00000443)
#define WCD9360_INTR_CPESS_SUMRY_STATUS3                  (0x00000444)
#define WCD9360_INTR_CPESS_SUMRY_CLEAR2                   (0x0000044B)
#define WCD9360_INTR_CPESS_SUMRY_CLEAR3                   (0x0000044C)
#define WCD9360_INTR_LEVEL0                               (0x00000461)
#define WCD9360_INTR_LEVEL1                               (0x00000462)
#define WCD9360_INTR_LEVEL2                               (0x00000463)
#define WCD9360_INTR_LEVEL3                               (0x00000464)
#define WCD9360_INTR_BYPASS0                              (0x00000469)
#define WCD9360_INTR_BYPASS1                              (0x0000046A)
#define WCD9360_INTR_BYPASS2                              (0x0000046B)
#define WCD9360_INTR_BYPASS3                              (0x0000046C)
#define WCD9360_INTR_SET0                                 (0x00000471)
#define WCD9360_INTR_SET1                                 (0x00000472)
#define WCD9360_INTR_SET2                                 (0x00000473)
#define WCD9360_INTR_SET3                                 (0x00000474)
#define WCD9360_INTR_CODEC_MISC_MASK                      (0x000004B1)
#define WCD9360_INTR_CODEC_MISC_STATUS                    (0x000004B2)
#define WCD9360_INTR_CODEC_MISC_CLEAR                     (0x000004B3)
#define WCD9360_ANA_PAGE_REGISTER                         (0x00000600)
#define WCD9360_ANA_BIAS                                  (0x00000601)
#define WCD9360_ANA_AMIC_INPUT_SWITCH_CTL                 (0x00000602)
#define WCD9360_ANA_RCO                                   (0x00000603)
#define WCD9360_ANA_BUCK_CTL                              (0x00000606)
#define WCD9360_ANA_BUCK_STATUS                           (0x00000607)
#define WCD9360_ANA_EAR                                   (0x0000060A)
#define WCD9360_ANA_MAD_SETUP                             (0x0000060D)
#define WCD9360_ANA_AMIC1                                 (0x0000060E)
#define WCD9360_ANA_AMIC2                                 (0x0000060F)
#define WCD9360_ANA_AMIC3                                 (0x00000610)
#define WCD9360_ANA_AMIC4                                 (0x00000611)
#define WCD9360_ANA_MICB1                                 (0x00000622)
#define WCD9360_ANA_MICB2                                 (0x00000623)
#define WCD9360_ANA_MICB3                                 (0x00000625)
#define WCD9360_ANA_MICB4                                 (0x00000626)
#define WCD9360_BIAS_CTL                                  (0x00000628)
#define WCD9360_BIAS_VBG_FINE_ADJ                         (0x00000629)
#define WCD9360_RCO_CTRL_1                                (0x0000062E)
#define WCD9360_RCO_CTRL_2                                (0x0000062F)
#define WCD9360_RCO_CAL                                   (0x00000630)
#define WCD9360_RCO_CAL_1                                 (0x00000631)
#define WCD9360_RCO_CAL_2                                 (0x00000632)
#define WCD9360_RCO_TEST_CTRL                             (0x00000633)
#define WCD9360_RCO_CAL_OUT_1                             (0x00000634)
#define WCD9360_RCO_CAL_OUT_2                             (0x00000635)
#define WCD9360_RCO_CAL_OUT_3                             (0x00000636)
#define WCD9360_RCO_CAL_OUT_4                             (0x00000637)
#define WCD9360_RCO_CAL_OUT_5                             (0x00000638)
#define WCD9360_SIDO_MODE_1                               (0x0000063A)
#define WCD9360_SIDO_MODE_2                               (0x0000063B)
#define WCD9360_SIDO_MODE_3                               (0x0000063C)
#define WCD9360_SIDO_MODE_4                               (0x0000063D)
#define WCD9360_SIDO_VCL_1                                (0x0000063E)
#define WCD9360_SIDO_VCL_2                                (0x0000063F)
#define WCD9360_SIDO_VCL_3                                (0x00000640)
#define WCD9360_SIDO_CCL_1                                (0x00000641)
#define WCD9360_SIDO_CCL_2                                (0x00000642)
#define WCD9360_SIDO_CCL_3                                (0x00000643)
#define WCD9360_SIDO_CCL_4                                (0x00000644)
#define WCD9360_SIDO_CCL_5                                (0x00000645)
#define WCD9360_SIDO_CCL_6                                (0x00000646)
#define WCD9360_SIDO_CCL_7                                (0x00000647)
#define WCD9360_SIDO_CCL_8                                (0x00000648)
#define WCD9360_SIDO_CCL_9                                (0x00000649)
#define WCD9360_SIDO_CCL_10                               (0x0000064A)
#define WCD9360_SIDO_FILTER_1                             (0x0000064B)
#define WCD9360_SIDO_FILTER_2                             (0x0000064C)
#define WCD9360_SIDO_DRIVER_1                             (0x0000064D)
#define WCD9360_SIDO_DRIVER_2                             (0x0000064E)
#define WCD9360_SIDO_DRIVER_3                             (0x0000064F)
#define WCD9360_SIDO_CAL_CODE_EXT_1                       (0x00000650)
#define WCD9360_SIDO_CAL_CODE_EXT_2                       (0x00000651)
#define WCD9360_SIDO_CAL_CODE_OUT_1                       (0x00000652)
#define WCD9360_SIDO_CAL_CODE_OUT_2                       (0x00000653)
#define WCD9360_SIDO_TEST_1                               (0x00000654)
#define WCD9360_SIDO_TEST_2                               (0x00000655)
#define WCD9360_LDOH_MODE                                 (0x00000667)
#define WCD9360_LDOH_BIAS                                 (0x00000668)
#define WCD9360_LDOH_STB_LOADS                            (0x00000669)
#define WCD9360_LDOH_SLOWRAMP                             (0x0000066A)
#define WCD9360_MICB1_TEST_CTL_1                          (0x0000066B)
#define WCD9360_MICB1_TEST_CTL_2                          (0x0000066C)
#define WCD9360_MICB1_TEST_CTL_3                          (0x0000066D)
#define WCD9360_MICB2_TEST_CTL_1                          (0x0000066E)
#define WCD9360_MICB2_TEST_CTL_2                          (0x0000066F)
#define WCD9360_MICB2_TEST_CTL_3                          (0x00000670)
#define WCD9360_MICB3_TEST_CTL_1                          (0x00000671)
#define WCD9360_MICB3_TEST_CTL_2                          (0x00000672)
#define WCD9360_MICB3_TEST_CTL_3                          (0x00000673)
#define WCD9360_MICB4_TEST_CTL_1                          (0x00000674)
#define WCD9360_MICB4_TEST_CTL_2                          (0x00000675)
#define WCD9360_MICB4_TEST_CTL_3                          (0x00000676)
#define WCD9360_TX_COM_ADC_VCM                            (0x00000677)
#define WCD9360_TX_COM_BIAS_ATEST                         (0x00000678)
#define WCD9360_TX_COM_ADC_INT1_IB                        (0x00000679)
#define WCD9360_TX_COM_ADC_INT2_IB                        (0x0000067A)
#define WCD9360_TX_COM_TXFE_DIV_CTL                       (0x0000067B)
#define WCD9360_TX_COM_TXFE_DIV_START                     (0x0000067C)
#define WCD9360_TX_COM_TXFE_DIV_STOP_9P6M                 (0x0000067D)
#define WCD9360_TX_COM_TXFE_DIV_STOP_12P288M              (0x0000067E)
#define WCD9360_TX_1_2_TEST_EN                            (0x0000067F)
#define WCD9360_TX_1_2_ADC_IB                             (0x00000680)
#define WCD9360_TX_1_2_ATEST_REFCTL                       (0x00000681)
#define WCD9360_TX_1_2_TEST_CTL                           (0x00000682)
#define WCD9360_TX_1_2_TEST_BLK_EN                        (0x00000683)
#define WCD9360_TX_1_2_TXFE_CLKDIV                        (0x00000684)
#define WCD9360_TX_1_2_SAR1_ERR                           (0x00000685)
#define WCD9360_TX_1_2_SAR2_ERR                           (0x00000686)
#define WCD9360_TX_3_4_TEST_EN                            (0x00000687)
#define WCD9360_TX_3_4_ADC_IB                             (0x00000688)
#define WCD9360_TX_3_4_ATEST_REFCTL                       (0x00000689)
#define WCD9360_TX_3_4_TEST_CTL                           (0x0000068A)
#define WCD9360_TX_3_4_TEST_BLK_EN                        (0x0000068B)
#define WCD9360_TX_3_4_TXFE_CLKDIV                        (0x0000068C)
#define WCD9360_TX_3_4_SAR1_ERR                           (0x0000068D)
#define WCD9360_TX_3_4_SAR2_ERR                           (0x0000068E)
#define WCD9360_RX_RX_EAR_BIAS_CON_1                      (0x000006B3)
#define WCD9360_RX_RX_EAR_BIAS_CON_2                      (0x000006B4)
#define WCD9360_RX_RX_AUX_BIAS_CON_1                      (0x000006B5)
#define WCD9360_RX_RX_AUX_BIAS_CON_2                      (0x000006B6)
#define WCD9360_RX_RX_BIAS_ATEST                          (0x000006B7)
#define WCD9360_RX_RXTOP_RESERVED                         (0x000006B8)
#define WCD9360_EAR_EAR_EN_REG                            (0x000006E1)
#define WCD9360_EAR_EAR_PA_CON                            (0x000006E2)
#define WCD9360_EAR_EAR_SP_CON                            (0x000006E3)
#define WCD9360_EAR_EAR_DAC_CON                           (0x000006E4)
#define WCD9360_EAR_EAR_CNP_FSM_CON                       (0x000006E5)
#define WCD9360_EAR_DAC_CTL_TEST                          (0x000006E6)
#define WCD9360_EAR_STATUS_REG                            (0x000006E7)
#define WCD9360_EAR_EAR_COMPANDER_CON                     (0x000006E8)
#define WCD9360_ANA_NEW_PAGE_REGISTER                     (0x00000700)
#define WCD9360_CLK_SYS_PLL_ENABLES                       (0x0000070E)
#define WCD9360_CLK_SYS_PLL_PRESET                        (0x0000070F)
#define WCD9360_CLK_SYS_PLL_STATUS                        (0x00000710)
#define WCD9360_CLK_SYS_MCLK_PRG                          (0x00000711)
#define WCD9360_CLK_SYS_MCLK2_PRG1                        (0x00000712)
#define WCD9360_CLK_SYS_MCLK_MISC                         (0x00000713)
#define WCD9360_SIDO_NEW_VOUT_A_STARTUP                   (0x0000071B)
#define WCD9360_SIDO_NEW_VOUT_D_STARTUP                   (0x0000071C)
#define WCD9360_SIDO_NEW_VOUT_D_FREQ1                     (0x0000071D)
#define WCD9360_SIDO_NEW_VOUT_D_FREQ2                     (0x0000071E)
#define WCD9360_AUX_ANA_EAR                               (0x00000728)
#define WCD9360_LDORXTX_LDORXTX                           (0x00000729)
#define WCD9360_DIE_CRACK_CTL                             (0x0000072A)
#define WCD9360_DIE_CRACK_OUT                             (0x0000072B)
#define WCD9360_LOOP_BACK_EN                              (0x0000072C)
#define WCD9360_CLK_SYS_INT_POST_DIV_REG0                 (0x0000076C)
#define WCD9360_CLK_SYS_INT_POST_DIV_REG1                 (0x0000076D)
#define WCD9360_CLK_SYS_INT_REF_DIV_REG0                  (0x0000076E)
#define WCD9360_CLK_SYS_INT_REF_DIV_REG1                  (0x0000076F)
#define WCD9360_CLK_SYS_INT_FILTER_REG0                   (0x00000770)
#define WCD9360_CLK_SYS_INT_FILTER_REG1                   (0x00000771)
#define WCD9360_CLK_SYS_INT_PLL_L_VAL                     (0x00000772)
#define WCD9360_CLK_SYS_INT_PLL_M_VAL                     (0x00000773)
#define WCD9360_CLK_SYS_INT_PLL_N_VAL                     (0x00000774)
#define WCD9360_CLK_SYS_INT_TEST_REG0                     (0x00000775)
#define WCD9360_CLK_SYS_INT_PFD_CP_DSM_PROG               (0x00000776)
#define WCD9360_CLK_SYS_INT_VCO_PROG                      (0x00000777)
#define WCD9360_CLK_SYS_INT_TEST_REG1                     (0x00000778)
#define WCD9360_CLK_SYS_INT_LDO_LOCK_CFG                  (0x00000779)
#define WCD9360_CLK_SYS_INT_DIG_LOCK_DET_CFG              (0x0000077A)
#define WCD9360_CLK_SYS_INT_CLK_TEST1                     (0x0000077B)
#define WCD9360_CLK_SYS_INT_CLK_TEST2                     (0x0000077C)
#define WCD9360_CLK_SYS_INT_CLK_TEST3                     (0x0000077D)
#define WCD9360_SIDO_NEW_INT_RAMP_STATUS                  (0x00000796)
#define WCD9360_SIDO_NEW_INT_SPARE_1                      (0x00000797)
#define WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_A         (0x00000798)
#define WCD9360_SIDO_NEW_INT_DEBUG_VOUT_SETTING_D         (0x00000799)
#define WCD9360_SIDO_NEW_INT_RAMP_INC_WAIT                (0x0000079A)
#define WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_CTL            (0x0000079B)
#define WCD9360_SIDO_NEW_INT_RAMP_IBLEED_CTL              (0x0000079C)
#define WCD9360_SIDO_NEW_INT_DEBUG_CPROVR_TEST            (0x0000079D)
#define WCD9360_SIDO_NEW_INT_RAMP_CTL_A                   (0x0000079E)
#define WCD9360_SIDO_NEW_INT_RAMP_CTL_D                   (0x0000079F)
#define WCD9360_SIDO_NEW_INT_RAMP_TIMEOUT_PERIOD          (0x000007A0)
#define WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING1       (0x000007A1)
#define WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING2       (0x000007A2)
#define WCD9360_SIDO_NEW_INT_DYNAMIC_IPEAK_SETTING3       (0x000007A3)
#define WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL1          (0x000007A4)
#define WCD9360_SIDO_NEW_INT_HIGH_ACCU_MODE_SEL2          (0x000007A5)
#define WCD9360_EAR_INT_NEW_EAR_CHOPPER_CON               (0x000007B7)
#define WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON1              (0x000007B8)
#define WCD9360_EAR_INT_NEW_EAR_VCM_GEN_CON2              (0x000007B9)
#define WCD9360_EAR_INT_NEW_EAR_DYNAMIC_BIAS              (0x000007BA)
#define WCD9360_AUX_INT_AUX_EN_REG                        (0x000007BD)
#define WCD9360_AUX_INT_AUX_PA_CON                        (0x000007BE)
#define WCD9360_AUX_INT_AUX_SP_CON                        (0x000007BF)
#define WCD9360_AUX_INT_AUX_DAC_CON                       (0x000007C0)
#define WCD9360_AUX_INT_AUX_CNP_FSM_CON                   (0x000007C1)
#define WCD9360_AUX_INT_AUX_TEST                          (0x000007C2)
#define WCD9360_AUX_INT_STATUS_REG                        (0x000007C3)
#define WCD9360_AUX_INT_AUX_MISC                          (0x000007C4)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL1             (0x000007C5)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL2             (0x000007C6)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL3             (0x000007C7)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL4             (0x000007C8)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_CTRL5             (0x000007C9)
#define WCD9360_LDORXTX_INT_ANA_LDORXTX_STATUS            (0x000007CA)
#define WCD9360_DIE_CRACK_INT_INT1                        (0x000007CC)
#define WCD9360_DIE_CRACK_INT_INT2                        (0x000007CD)
#define WCD9360_LOOP_BACK_INT_SPARE                       (0x000007CE)
#define WCD9360_PAGE10_PAGE_REGISTER                      (0x00000A00)
#define WCD9360_CDC_ANC0_CLK_RESET_CTL                    (0x00000A01)
#define WCD9360_CDC_ANC0_MODE_1_CTL                       (0x00000A02)
#define WCD9360_CDC_ANC0_MODE_2_CTL                       (0x00000A03)
#define WCD9360_CDC_ANC0_FF_SHIFT                         (0x00000A04)
#define WCD9360_CDC_ANC0_FB_SHIFT                         (0x00000A05)
#define WCD9360_CDC_ANC0_LPF_FF_A_CTL                     (0x00000A06)
#define WCD9360_CDC_ANC0_LPF_FF_B_CTL                     (0x00000A07)
#define WCD9360_CDC_ANC0_LPF_FB_CTL                       (0x00000A08)
#define WCD9360_CDC_ANC0_SMLPF_CTL                        (0x00000A09)
#define WCD9360_CDC_ANC0_DCFLT_SHIFT_CTL                  (0x00000A0A)
#define WCD9360_CDC_ANC0_IIR_ADAPT_CTL                    (0x00000A0B)
#define WCD9360_CDC_ANC0_IIR_COEFF_1_CTL                  (0x00000A0C)
#define WCD9360_CDC_ANC0_IIR_COEFF_2_CTL                  (0x00000A0D)
#define WCD9360_CDC_ANC0_FF_A_GAIN_CTL                    (0x00000A0E)
#define WCD9360_CDC_ANC0_FF_B_GAIN_CTL                    (0x00000A0F)
#define WCD9360_CDC_ANC0_FB_GAIN_CTL                      (0x00000A10)
#define WCD9360_CDC_TX0_TX_PATH_CTL                       (0x00000A31)
#define WCD9360_CDC_TX0_TX_PATH_CFG0                      (0x00000A32)
#define WCD9360_CDC_TX0_TX_PATH_CFG1                      (0x00000A33)
#define WCD9360_CDC_TX0_TX_VOL_CTL                        (0x00000A34)
#define WCD9360_CDC_TX0_TX_PATH_192_CTL                   (0x00000A35)
#define WCD9360_CDC_TX0_TX_PATH_192_CFG                   (0x00000A36)
#define WCD9360_CDC_TX0_TX_PATH_SEC0                      (0x00000A37)
#define WCD9360_CDC_TX0_TX_PATH_SEC1                      (0x00000A38)
#define WCD9360_CDC_TX0_TX_PATH_SEC2                      (0x00000A39)
#define WCD9360_CDC_TX0_TX_PATH_SEC3                      (0x00000A3A)
#define WCD9360_CDC_TX0_TX_PATH_SEC4                      (0x00000A3B)
#define WCD9360_CDC_TX0_TX_PATH_SEC5                      (0x00000A3C)
#define WCD9360_CDC_TX0_TX_PATH_SEC6                      (0x00000A3D)
#define WCD9360_CDC_TX1_TX_PATH_CTL                       (0x00000A41)
#define WCD9360_CDC_TX1_TX_PATH_CFG0                      (0x00000A42)
#define WCD9360_CDC_TX1_TX_PATH_CFG1                      (0x00000A43)
#define WCD9360_CDC_TX1_TX_VOL_CTL                        (0x00000A44)
#define WCD9360_CDC_TX1_TX_PATH_192_CTL                   (0x00000A45)
#define WCD9360_CDC_TX1_TX_PATH_192_CFG                   (0x00000A46)
#define WCD9360_CDC_TX1_TX_PATH_SEC0                      (0x00000A47)
#define WCD9360_CDC_TX1_TX_PATH_SEC1                      (0x00000A48)
#define WCD9360_CDC_TX1_TX_PATH_SEC2                      (0x00000A49)
#define WCD9360_CDC_TX1_TX_PATH_SEC3                      (0x00000A4A)
#define WCD9360_CDC_TX1_TX_PATH_SEC4                      (0x00000A4B)
#define WCD9360_CDC_TX1_TX_PATH_SEC5                      (0x00000A4C)
#define WCD9360_CDC_TX1_TX_PATH_SEC6                      (0x00000A4D)
#define WCD9360_CDC_TX2_TX_PATH_CTL                       (0x00000A51)
#define WCD9360_CDC_TX2_TX_PATH_CFG0                      (0x00000A52)
#define WCD9360_CDC_TX2_TX_PATH_CFG1                      (0x00000A53)
#define WCD9360_CDC_TX2_TX_VOL_CTL                        (0x00000A54)
#define WCD9360_CDC_TX2_TX_PATH_192_CTL                   (0x00000A55)
#define WCD9360_CDC_TX2_TX_PATH_192_CFG                   (0x00000A56)
#define WCD9360_CDC_TX2_TX_PATH_SEC0                      (0x00000A57)
#define WCD9360_CDC_TX2_TX_PATH_SEC1                      (0x00000A58)
#define WCD9360_CDC_TX2_TX_PATH_SEC2                      (0x00000A59)
#define WCD9360_CDC_TX2_TX_PATH_SEC3                      (0x00000A5A)
#define WCD9360_CDC_TX2_TX_PATH_SEC4                      (0x00000A5B)
#define WCD9360_CDC_TX2_TX_PATH_SEC5                      (0x00000A5C)
#define WCD9360_CDC_TX2_TX_PATH_SEC6                      (0x00000A5D)
#define WCD9360_CDC_TX3_TX_PATH_CTL                       (0x00000A61)
#define WCD9360_CDC_TX3_TX_PATH_CFG0                      (0x00000A62)
#define WCD9360_CDC_TX3_TX_PATH_CFG1                      (0x00000A63)
#define WCD9360_CDC_TX3_TX_VOL_CTL                        (0x00000A64)
#define WCD9360_CDC_TX3_TX_PATH_192_CTL                   (0x00000A65)
#define WCD9360_CDC_TX3_TX_PATH_192_CFG                   (0x00000A66)
#define WCD9360_CDC_TX3_TX_PATH_SEC0                      (0x00000A67)
#define WCD9360_CDC_TX3_TX_PATH_SEC1                      (0x00000A68)
#define WCD9360_CDC_TX3_TX_PATH_SEC2                      (0x00000A69)
#define WCD9360_CDC_TX3_TX_PATH_SEC3                      (0x00000A6A)
#define WCD9360_CDC_TX3_TX_PATH_SEC4                      (0x00000A6B)
#define WCD9360_CDC_TX3_TX_PATH_SEC5                      (0x00000A6C)
#define WCD9360_CDC_TX3_TX_PATH_SEC6                      (0x00000A6D)
#define WCD9360_CDC_TX4_TX_PATH_CTL                       (0x00000A71)
#define WCD9360_CDC_TX4_TX_PATH_CFG0                      (0x00000A72)
#define WCD9360_CDC_TX4_TX_PATH_CFG1                      (0x00000A73)
#define WCD9360_CDC_TX4_TX_VOL_CTL                        (0x00000A74)
#define WCD9360_CDC_TX4_TX_PATH_192_CTL                   (0x00000A75)
#define WCD9360_CDC_TX4_TX_PATH_192_CFG                   (0x00000A76)
#define WCD9360_CDC_TX4_TX_PATH_SEC0                      (0x00000A77)
#define WCD9360_CDC_TX4_TX_PATH_SEC1                      (0x00000A78)
#define WCD9360_CDC_TX4_TX_PATH_SEC2                      (0x00000A79)
#define WCD9360_CDC_TX4_TX_PATH_SEC3                      (0x00000A7A)
#define WCD9360_CDC_TX4_TX_PATH_SEC4                      (0x00000A7B)
#define WCD9360_CDC_TX4_TX_PATH_SEC5                      (0x00000A7C)
#define WCD9360_CDC_TX4_TX_PATH_SEC6                      (0x00000A7D)
#define WCD9360_CDC_TX5_TX_PATH_CTL                       (0x00000A81)
#define WCD9360_CDC_TX5_TX_PATH_CFG0                      (0x00000A82)
#define WCD9360_CDC_TX5_TX_PATH_CFG1                      (0x00000A83)
#define WCD9360_CDC_TX5_TX_VOL_CTL                        (0x00000A84)
#define WCD9360_CDC_TX5_TX_PATH_192_CTL                   (0x00000A85)
#define WCD9360_CDC_TX5_TX_PATH_192_CFG                   (0x00000A86)
#define WCD9360_CDC_TX5_TX_PATH_SEC0                      (0x00000A87)
#define WCD9360_CDC_TX5_TX_PATH_SEC1                      (0x00000A88)
#define WCD9360_CDC_TX5_TX_PATH_SEC2                      (0x00000A89)
#define WCD9360_CDC_TX5_TX_PATH_SEC3                      (0x00000A8A)
#define WCD9360_CDC_TX5_TX_PATH_SEC4                      (0x00000A8B)
#define WCD9360_CDC_TX5_TX_PATH_SEC5                      (0x00000A8C)
#define WCD9360_CDC_TX5_TX_PATH_SEC6                      (0x00000A8D)
#define WCD9360_CDC_TX6_TX_PATH_CTL                       (0x00000A91)
#define WCD9360_CDC_TX6_TX_PATH_CFG0                      (0x00000A92)
#define WCD9360_CDC_TX6_TX_PATH_CFG1                      (0x00000A93)
#define WCD9360_CDC_TX6_TX_VOL_CTL                        (0x00000A94)
#define WCD9360_CDC_TX6_TX_PATH_192_CTL                   (0x00000A95)
#define WCD9360_CDC_TX6_TX_PATH_192_CFG                   (0x00000A96)
#define WCD9360_CDC_TX6_TX_PATH_SEC0                      (0x00000A97)
#define WCD9360_CDC_TX6_TX_PATH_SEC1                      (0x00000A98)
#define WCD9360_CDC_TX6_TX_PATH_SEC2                      (0x00000A99)
#define WCD9360_CDC_TX6_TX_PATH_SEC3                      (0x00000A9A)
#define WCD9360_CDC_TX6_TX_PATH_SEC4                      (0x00000A9B)
#define WCD9360_CDC_TX6_TX_PATH_SEC5                      (0x00000A9C)
#define WCD9360_CDC_TX6_TX_PATH_SEC6                      (0x00000A9D)
#define WCD9360_CDC_TX7_TX_PATH_CTL                       (0x00000AA1)
#define WCD9360_CDC_TX7_TX_PATH_CFG0                      (0x00000AA2)
#define WCD9360_CDC_TX7_TX_PATH_CFG1                      (0x00000AA3)
#define WCD9360_CDC_TX7_TX_VOL_CTL                        (0x00000AA4)
#define WCD9360_CDC_TX7_TX_PATH_192_CTL                   (0x00000AA5)
#define WCD9360_CDC_TX7_TX_PATH_192_CFG                   (0x00000AA6)
#define WCD9360_CDC_TX7_TX_PATH_SEC0                      (0x00000AA7)
#define WCD9360_CDC_TX7_TX_PATH_SEC1                      (0x00000AA8)
#define WCD9360_CDC_TX7_TX_PATH_SEC2                      (0x00000AA9)
#define WCD9360_CDC_TX7_TX_PATH_SEC3                      (0x00000AAA)
#define WCD9360_CDC_TX7_TX_PATH_SEC4                      (0x00000AAB)
#define WCD9360_CDC_TX7_TX_PATH_SEC5                      (0x00000AAC)
#define WCD9360_CDC_TX7_TX_PATH_SEC6                      (0x00000AAD)
#define WCD9360_CDC_TX8_TX_PATH_CTL                       (0x00000AB1)
#define WCD9360_CDC_TX8_TX_PATH_CFG0                      (0x00000AB2)
#define WCD9360_CDC_TX8_TX_PATH_CFG1                      (0x00000AB3)
#define WCD9360_CDC_TX8_TX_VOL_CTL                        (0x00000AB4)
#define WCD9360_CDC_TX8_TX_PATH_192_CTL                   (0x00000AB5)
#define WCD9360_CDC_TX8_TX_PATH_192_CFG                   (0x00000AB6)
#define WCD9360_CDC_TX8_TX_PATH_SEC0                      (0x00000AB7)
#define WCD9360_CDC_TX8_TX_PATH_SEC1                      (0x00000AB8)
#define WCD9360_CDC_TX8_TX_PATH_SEC2                      (0x00000AB9)
#define WCD9360_CDC_TX8_TX_PATH_SEC3                      (0x00000ABA)
#define WCD9360_CDC_TX8_TX_PATH_SEC4                      (0x00000ABB)
#define WCD9360_CDC_TX8_TX_PATH_SEC5                      (0x00000ABC)
#define WCD9360_CDC_TX8_TX_PATH_SEC6                      (0x00000ABD)
#define WCD9360_CDC_TX9_SPKR_PROT_PATH_CTL                (0x00000AC2)
#define WCD9360_CDC_TX9_SPKR_PROT_PATH_CFG0               (0x00000AC3)
#define WCD9360_CDC_TX10_SPKR_PROT_PATH_CTL               (0x00000AC6)
#define WCD9360_CDC_TX10_SPKR_PROT_PATH_CFG0              (0x00000AC7)
#define WCD9360_CDC_TX11_SPKR_PROT_PATH_CTL               (0x00000ACA)
#define WCD9360_CDC_TX11_SPKR_PROT_PATH_CFG0              (0x00000ACB)
#define WCD9360_CDC_TX12_SPKR_PROT_PATH_CTL               (0x00000ACE)
#define WCD9360_CDC_TX12_SPKR_PROT_PATH_CFG0              (0x00000ACF)
#define WCD9360_PAGE11_PAGE_REGISTER                      (0x00000B00)
#define WCD9360_CDC_COMPANDER0_CTL0                       (0x00000B21)
#define WCD9360_CDC_COMPANDER0_CTL1                       (0x00000B22)
#define WCD9360_CDC_COMPANDER0_CTL2                       (0x00000B23)
#define WCD9360_CDC_COMPANDER0_CTL3                       (0x00000B24)
#define WCD9360_CDC_COMPANDER0_CTL4                       (0x00000B25)
#define WCD9360_CDC_COMPANDER0_CTL5                       (0x00000B26)
#define WCD9360_CDC_COMPANDER0_CTL6                       (0x00000B27)
#define WCD9360_CDC_COMPANDER0_CTL7                       (0x00000B28)
#define WCD9360_CDC_COMPANDER7_CTL0                       (0x00000B31)
#define WCD9360_CDC_COMPANDER7_CTL1                       (0x00000B32)
#define WCD9360_CDC_COMPANDER7_CTL2                       (0x00000B33)
#define WCD9360_CDC_COMPANDER7_CTL3                       (0x00000B34)
#define WCD9360_CDC_COMPANDER7_CTL4                       (0x00000B35)
#define WCD9360_CDC_COMPANDER7_CTL5                       (0x00000B36)
#define WCD9360_CDC_COMPANDER7_CTL6                       (0x00000B37)
#define WCD9360_CDC_COMPANDER7_CTL7                       (0x00000B38)
#define WCD9360_CDC_COMPANDER8_CTL0                       (0x00000B39)
#define WCD9360_CDC_COMPANDER8_CTL1                       (0x00000B3A)
#define WCD9360_CDC_COMPANDER8_CTL2                       (0x00000B3B)
#define WCD9360_CDC_COMPANDER8_CTL3                       (0x00000B3C)
#define WCD9360_CDC_COMPANDER8_CTL4                       (0x00000B3D)
#define WCD9360_CDC_COMPANDER8_CTL5                       (0x00000B3E)
#define WCD9360_CDC_COMPANDER8_CTL6                       (0x00000B3F)
#define WCD9360_CDC_COMPANDER8_CTL7                       (0x00000B40)
#define WCD9360_CDC_RX0_RX_PATH_CTL                       (0x00000B41)
#define WCD9360_CDC_RX0_RX_PATH_CFG0                      (0x00000B42)
#define WCD9360_CDC_RX0_RX_PATH_CFG1                      (0x00000B43)
#define WCD9360_CDC_RX0_RX_PATH_CFG2                      (0x00000B44)
#define WCD9360_CDC_RX0_RX_VOL_CTL                        (0x00000B45)
#define WCD9360_CDC_RX0_RX_PATH_MIX_CTL                   (0x00000B46)
#define WCD9360_CDC_RX0_RX_PATH_MIX_CFG                   (0x00000B47)
#define WCD9360_CDC_RX0_RX_VOL_MIX_CTL                    (0x00000B48)
#define WCD9360_CDC_RX0_RX_PATH_SEC0                      (0x00000B49)
#define WCD9360_CDC_RX0_RX_PATH_SEC1                      (0x00000B4A)
#define WCD9360_CDC_RX0_RX_PATH_SEC2                      (0x00000B4B)
#define WCD9360_CDC_RX0_RX_PATH_SEC3                      (0x00000B4C)
#define WCD9360_CDC_RX0_RX_PATH_SEC5                      (0x00000B4E)
#define WCD9360_CDC_RX0_RX_PATH_SEC6                      (0x00000B4F)
#define WCD9360_CDC_RX0_RX_PATH_SEC7                      (0x00000B50)
#define WCD9360_CDC_RX0_RX_PATH_MIX_SEC0                  (0x00000B51)
#define WCD9360_CDC_RX0_RX_PATH_MIX_SEC1                  (0x00000B52)
#define WCD9360_CDC_RX0_RX_PATH_DSMDEM_CTL                (0x00000B53)
#define WCD9360_CDC_RX9_RX_PATH_CTL                       (0x00000BA5)
#define WCD9360_CDC_RX9_RX_PATH_CFG0                      (0x00000BA6)
#define WCD9360_CDC_RX9_RX_PATH_CFG1                      (0x00000BA7)
#define WCD9360_CDC_RX9_RX_PATH_CFG2                      (0x00000BA8)
#define WCD9360_CDC_RX9_RX_VOL_CTL                        (0x00000BA9)
#define WCD9360_CDC_RX9_RX_PATH_MIX_CTL                   (0x00000BAA)
#define WCD9360_CDC_RX9_RX_PATH_MIX_CFG                   (0x00000BAB)
#define WCD9360_CDC_RX9_RX_VOL_MIX_CTL                    (0x00000BAC)
#define WCD9360_CDC_RX9_RX_PATH_SEC0                      (0x00000BAD)
#define WCD9360_CDC_RX9_RX_PATH_SEC1                      (0x00000BAE)
#define WCD9360_CDC_RX9_RX_PATH_SEC2                      (0x00000BAF)
#define WCD9360_CDC_RX9_RX_PATH_SEC3                      (0x00000BB0)
#define WCD9360_CDC_RX9_RX_PATH_SEC5                      (0x00000BB2)
#define WCD9360_CDC_RX9_RX_PATH_SEC6                      (0x00000BB3)
#define WCD9360_CDC_RX9_RX_PATH_SEC7                      (0x00000BB4)
#define WCD9360_CDC_RX9_RX_PATH_MIX_SEC0                  (0x00000BB5)
#define WCD9360_CDC_RX9_RX_PATH_MIX_SEC1                  (0x00000BB6)
#define WCD9360_CDC_RX9_RX_PATH_DSMDEM_CTL                (0x00000BB7)
#define WCD9360_CDC_RX7_RX_PATH_CTL                       (0x00000BCD)
#define WCD9360_CDC_RX7_RX_PATH_CFG0                      (0x00000BCE)
#define WCD9360_CDC_RX7_RX_PATH_CFG1                      (0x00000BCF)
#define WCD9360_CDC_RX7_RX_PATH_CFG2                      (0x00000BD0)
#define WCD9360_CDC_RX7_RX_VOL_CTL                        (0x00000BD1)
#define WCD9360_CDC_RX7_RX_PATH_MIX_CTL                   (0x00000BD2)
#define WCD9360_CDC_RX7_RX_PATH_MIX_CFG                   (0x00000BD3)
#define WCD9360_CDC_RX7_RX_VOL_MIX_CTL                    (0x00000BD4)
#define WCD9360_CDC_RX7_RX_PATH_SEC0                      (0x00000BD5)
#define WCD9360_CDC_RX7_RX_PATH_SEC1                      (0x00000BD6)
#define WCD9360_CDC_RX7_RX_PATH_SEC2                      (0x00000BD7)
#define WCD9360_CDC_RX7_RX_PATH_SEC3                      (0x00000BD8)
#define WCD9360_CDC_RX7_RX_PATH_SEC5                      (0x00000BDA)
#define WCD9360_CDC_RX7_RX_PATH_SEC6                      (0x00000BDB)
#define WCD9360_CDC_RX7_RX_PATH_SEC7                      (0x00000BDC)
#define WCD9360_CDC_RX7_RX_PATH_MIX_SEC0                  (0x00000BDD)
#define WCD9360_CDC_RX7_RX_PATH_MIX_SEC1                  (0x00000BDE)
#define WCD9360_CDC_RX7_RX_PATH_DSMDEM_CTL                (0x00000BDF)
#define WCD9360_CDC_RX8_RX_PATH_CTL                       (0x00000BE1)
#define WCD9360_CDC_RX8_RX_PATH_CFG0                      (0x00000BE2)
#define WCD9360_CDC_RX8_RX_PATH_CFG1                      (0x00000BE3)
#define WCD9360_CDC_RX8_RX_PATH_CFG2                      (0x00000BE4)
#define WCD9360_CDC_RX8_RX_VOL_CTL                        (0x00000BE5)
#define WCD9360_CDC_RX8_RX_PATH_MIX_CTL                   (0x00000BE6)
#define WCD9360_CDC_RX8_RX_PATH_MIX_CFG                   (0x00000BE7)
#define WCD9360_CDC_RX8_RX_VOL_MIX_CTL                    (0x00000BE8)
#define WCD9360_CDC_RX8_RX_PATH_SEC0                      (0x00000BE9)
#define WCD9360_CDC_RX8_RX_PATH_SEC1                      (0x00000BEA)
#define WCD9360_CDC_RX8_RX_PATH_SEC2                      (0x00000BEB)
#define WCD9360_CDC_RX8_RX_PATH_SEC3                      (0x00000BEC)
#define WCD9360_CDC_RX8_RX_PATH_SEC5                      (0x00000BEE)
#define WCD9360_CDC_RX8_RX_PATH_SEC6                      (0x00000BEF)
#define WCD9360_CDC_RX8_RX_PATH_SEC7                      (0x00000BF0)
#define WCD9360_CDC_RX8_RX_PATH_MIX_SEC0                  (0x00000BF1)
#define WCD9360_CDC_RX8_RX_PATH_MIX_SEC1                  (0x00000BF2)
#define WCD9360_CDC_RX8_RX_PATH_DSMDEM_CTL                (0x00000BF3)
#define WCD9360_PAGE12_PAGE_REGISTER                      (0x00000C00)
#define WCD9360_CDC_BOOST0_BOOST_PATH_CTL                 (0x00000C19)
#define WCD9360_CDC_BOOST0_BOOST_CTL                      (0x00000C1A)
#define WCD9360_CDC_BOOST0_BOOST_CFG1                     (0x00000C1B)
#define WCD9360_CDC_BOOST0_BOOST_CFG2                     (0x00000C1C)
#define WCD9360_CDC_BOOST1_BOOST_PATH_CTL                 (0x00000C21)
#define WCD9360_CDC_BOOST1_BOOST_CTL                      (0x00000C22)
#define WCD9360_CDC_BOOST1_BOOST_CFG1                     (0x00000C23)
#define WCD9360_CDC_BOOST1_BOOST_CFG2                     (0x00000C24)
#define WCD9360_MIXING_ASRC2_CLK_RST_CTL                  (0x00000C6D)
#define WCD9360_MIXING_ASRC2_CTL0                         (0x00000C6E)
#define WCD9360_MIXING_ASRC2_CTL1                         (0x00000C6F)
#define WCD9360_MIXING_ASRC2_FIFO_CTL                     (0x00000C70)
#define WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_LSB         (0x00000C71)
#define WCD9360_MIXING_ASRC2_STATUS_FMIN_CNTR_MSB         (0x00000C72)
#define WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_LSB         (0x00000C73)
#define WCD9360_MIXING_ASRC2_STATUS_FMAX_CNTR_MSB         (0x00000C74)
#define WCD9360_MIXING_ASRC2_STATUS_FIFO                  (0x00000C75)
#define WCD9360_MIXING_ASRC3_CLK_RST_CTL                  (0x00000C79)
#define WCD9360_MIXING_ASRC3_CTL0                         (0x00000C7A)
#define WCD9360_MIXING_ASRC3_CTL1                         (0x00000C7B)
#define WCD9360_MIXING_ASRC3_FIFO_CTL                     (0x00000C7C)
#define WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_LSB         (0x00000C7D)
#define WCD9360_MIXING_ASRC3_STATUS_FMIN_CNTR_MSB         (0x00000C7E)
#define WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_LSB         (0x00000C7F)
#define WCD9360_MIXING_ASRC3_STATUS_FMAX_CNTR_MSB         (0x00000C80)
#define WCD9360_MIXING_ASRC3_STATUS_FIFO                  (0x00000C81)
#define WCD9360_SWR_AHB_BRIDGE_WR_DATA_0                  (0x00000C85)
#define WCD9360_SWR_AHB_BRIDGE_WR_DATA_1                  (0x00000C86)
#define WCD9360_SWR_AHB_BRIDGE_WR_DATA_2                  (0x00000C87)
#define WCD9360_SWR_AHB_BRIDGE_WR_DATA_3                  (0x00000C88)
#define WCD9360_SWR_AHB_BRIDGE_WR_ADDR_0                  (0x00000C89)
#define WCD9360_SWR_AHB_BRIDGE_WR_ADDR_1                  (0x00000C8A)
#define WCD9360_SWR_AHB_BRIDGE_WR_ADDR_2                  (0x00000C8B)
#define WCD9360_SWR_AHB_BRIDGE_WR_ADDR_3                  (0x00000C8C)
#define WCD9360_SWR_AHB_BRIDGE_RD_ADDR_0                  (0x00000C8D)
#define WCD9360_SWR_AHB_BRIDGE_RD_ADDR_1                  (0x00000C8E)
#define WCD9360_SWR_AHB_BRIDGE_RD_ADDR_2                  (0x00000C8F)
#define WCD9360_SWR_AHB_BRIDGE_RD_ADDR_3                  (0x00000C90)
#define WCD9360_SWR_AHB_BRIDGE_RD_DATA_0                  (0x00000C91)
#define WCD9360_SWR_AHB_BRIDGE_RD_DATA_1                  (0x00000C92)
#define WCD9360_SWR_AHB_BRIDGE_RD_DATA_2                  (0x00000C93)
#define WCD9360_SWR_AHB_BRIDGE_RD_DATA_3                  (0x00000C94)
#define WCD9360_SWR_AHB_BRIDGE_ACCESS_CFG                 (0x00000C95)
#define WCD9360_SWR_AHB_BRIDGE_ACCESS_STATUS              (0x00000C96)
#define WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CTL         (0x00000CB5)
#define WCD9360_CDC_SIDETONE_SRC0_ST_SRC_PATH_CFG1        (0x00000CB6)
#define WCD9360_SIDETONE_ASRC0_CLK_RST_CTL                (0x00000CBD)
#define WCD9360_SIDETONE_ASRC0_CTL0                       (0x00000CBE)
#define WCD9360_SIDETONE_ASRC0_CTL1                       (0x00000CBF)
#define WCD9360_SIDETONE_ASRC0_FIFO_CTL                   (0x00000CC0)
#define WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_LSB       (0x00000CC1)
#define WCD9360_SIDETONE_ASRC0_STATUS_FMIN_CNTR_MSB       (0x00000CC2)
#define WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_LSB       (0x00000CC3)
#define WCD9360_SIDETONE_ASRC0_STATUS_FMAX_CNTR_MSB       (0x00000CC4)
#define WCD9360_SIDETONE_ASRC0_STATUS_FIFO                (0x00000CC5)
#define WCD9360_EC_REF_HQ0_EC_REF_HQ_PATH_CTL             (0x00000CD5)
#define WCD9360_EC_REF_HQ0_EC_REF_HQ_CFG0                 (0x00000CD6)
#define WCD9360_EC_REF_HQ1_EC_REF_HQ_PATH_CTL             (0x00000CDD)
#define WCD9360_EC_REF_HQ1_EC_REF_HQ_CFG0                 (0x00000CDE)
#define WCD9360_EC_ASRC0_CLK_RST_CTL                      (0x00000CE5)
#define WCD9360_EC_ASRC0_CTL0                             (0x00000CE6)
#define WCD9360_EC_ASRC0_CTL1                             (0x00000CE7)
#define WCD9360_EC_ASRC0_FIFO_CTL                         (0x00000CE8)
#define WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_LSB             (0x00000CE9)
#define WCD9360_EC_ASRC0_STATUS_FMIN_CNTR_MSB             (0x00000CEA)
#define WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_LSB             (0x00000CEB)
#define WCD9360_EC_ASRC0_STATUS_FMAX_CNTR_MSB             (0x00000CEC)
#define WCD9360_EC_ASRC0_STATUS_FIFO                      (0x00000CED)
#define WCD9360_EC_ASRC1_CLK_RST_CTL                      (0x00000CF1)
#define WCD9360_EC_ASRC1_CTL0                             (0x00000CF2)
#define WCD9360_EC_ASRC1_CTL1                             (0x00000CF3)
#define WCD9360_EC_ASRC1_FIFO_CTL                         (0x00000CF4)
#define WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_LSB             (0x00000CF5)
#define WCD9360_EC_ASRC1_STATUS_FMIN_CNTR_MSB             (0x00000CF6)
#define WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_LSB             (0x00000CF7)
#define WCD9360_EC_ASRC1_STATUS_FMAX_CNTR_MSB             (0x00000CF8)
#define WCD9360_EC_ASRC1_STATUS_FIFO                      (0x00000CF9)
#define WCD9360_PAGE13_PAGE_REGISTER                      (0x00000D00)
#define WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG0               (0x00000D01)
#define WCD9360_CDC_RX_INP_MUX_RX_INT0_CFG1               (0x00000D02)
#define WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG0               (0x00000D0B)
#define WCD9360_CDC_RX_INP_MUX_RX_INT9_CFG1               (0x00000D0C)
#define WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG0               (0x00000D0F)
#define WCD9360_CDC_RX_INP_MUX_RX_INT7_CFG1               (0x00000D10)
#define WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG0               (0x00000D11)
#define WCD9360_CDC_RX_INP_MUX_RX_INT8_CFG1               (0x00000D12)
#define WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG0                (0x00000D13)
#define WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG1                (0x00000D14)
#define WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG2                (0x00000D15)
#define WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG3                (0x00000D16)
#define WCD9360_CDC_RX_INP_MUX_RX_MIX_CFG4                (0x00000D17)
#define WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG0          (0x00000D18)
#define WCD9360_CDC_RX_INP_MUX_SIDETONE_SRC_CFG1          (0x00000D19)
#define WCD9360_CDC_RX_INP_MUX_ANC_CFG0                   (0x00000D1A)
#define WCD9360_CDC_RX_INP_MUX_SPLINE_ASRC_CFG0           (0x00000D1B)
#define WCD9360_CDC_RX_INP_MUX_EC_REF_HQ_CFG0             (0x00000D1C)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG0              (0x00000D1D)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX0_CFG1              (0x00000D1E)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG0              (0x00000D1F)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX1_CFG1              (0x00000D20)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG0              (0x00000D21)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX2_CFG1              (0x00000D22)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG0              (0x00000D23)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX3_CFG1              (0x00000D25)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX4_CFG0              (0x00000D26)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX5_CFG0              (0x00000D27)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX6_CFG0              (0x00000D28)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX7_CFG0              (0x00000D29)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX8_CFG0              (0x00000D2A)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX10_CFG0             (0x00000D2B)
#define WCD9360_CDC_TX_INP_MUX_ADC_MUX11_CFG0             (0x00000D2C)
#define WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG0    (0x00000D31)
#define WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG1    (0x00000D32)
#define WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG2    (0x00000D33)
#define WCD9360_CDC_SIDETONE_IIR_INP_MUX_IIR0_MIX_CFG3    (0x00000D34)
#define WCD9360_CDC_IF_ROUTER_TX_MUX_CFG0                 (0x00000D3A)
#define WCD9360_CDC_IF_ROUTER_TX_MUX_CFG1                 (0x00000D3B)
#define WCD9360_CDC_IF_ROUTER_TX_MUX_CFG2                 (0x00000D3C)
#define WCD9360_CDC_IF_ROUTER_TX_MUX_CFG3                 (0x00000D3D)
#define WCD9360_CDC_CLK_RST_CTRL_MCLK_CONTROL             (0x00000D41)
#define WCD9360_CDC_CLK_RST_CTRL_FS_CNT_CONTROL           (0x00000D42)
#define WCD9360_CDC_CLK_RST_CTRL_SWR_CONTROL              (0x00000D43)
#define WCD9360_CDC_CLK_RST_CTRL_ASRC_SHARE_CONTROL       (0x00000D45)
#define WCD9360_CDC_PROX_DETECT_PROX_CTL                  (0x00000D49)
#define WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD0         (0x00000D4A)
#define WCD9360_CDC_PROX_DETECT_PROX_POLL_PERIOD1         (0x00000D4B)
#define WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_LSB      (0x00000D4C)
#define WCD9360_CDC_PROX_DETECT_PROX_SIG_PATTERN_MSB      (0x00000D4D)
#define WCD9360_CDC_PROX_DETECT_PROX_STATUS               (0x00000D4E)
#define WCD9360_CDC_PROX_DETECT_PROX_TEST_CTRL            (0x00000D4F)
#define WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB        (0x00000D50)
#define WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB        (0x00000D51)
#define WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_LSB_RD     (0x00000D52)
#define WCD9360_CDC_PROX_DETECT_PROX_TEST_BUFF_MSB_RD     (0x00000D53)
#define WCD9360_CDC_PROX_DETECT_PROX_CTL_REPEAT_PAT       (0x00000D54)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_PATH_CTL            (0x00000D55)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B1_CTL         (0x00000D56)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B2_CTL         (0x00000D57)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B3_CTL         (0x00000D58)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B4_CTL         (0x00000D59)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B5_CTL         (0x00000D5A)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B6_CTL         (0x00000D5B)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B7_CTL         (0x00000D5C)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_B8_CTL         (0x00000D5D)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_CTL                 (0x00000D5E)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_GAIN_TIMER_CTL      (0x00000D5F)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B1_CTL         (0x00000D60)
#define WCD9360_CDC_SIDETONE_IIR0_IIR_COEF_B2_CTL         (0x00000D61)
#define WCD9360_CDC_TOP_TOP_CFG0                          (0x00000D81)
#define WCD9360_CDC_TOP_TOP_CFG1                          (0x00000D82)
#define WCD9360_CDC_TOP_TOP_CFG7                          (0x00000D88)
#define WCD9360_CDC_TOP_EAR_COMP_WR_LSB                   (0x00000DA9)
#define WCD9360_CDC_TOP_EAR_COMP_WR_MSB                   (0x00000DAA)
#define WCD9360_CDC_TOP_EAR_COMP_LUT                      (0x00000DAB)
#define WCD9360_CDC_TOP_EAR_COMP_RD_LSB                   (0x00000DAC)
#define WCD9360_CDC_TOP_EAR_COMP_RD_MSB                   (0x00000DAD)
#define WCD9360_CDC_TOP_TOP_DEBUG                         (0x00000DAE)
#define WCD9360_PAGE80_PAGE_REGISTER                      (0x00005000)
#define WCD9360_CODEC_CPR_WR_DATA_0                       (0x00005001)
#define WCD9360_CODEC_CPR_WR_DATA_1                       (0x00005002)
#define WCD9360_CODEC_CPR_WR_DATA_2                       (0x00005003)
#define WCD9360_CODEC_CPR_WR_DATA_3                       (0x00005004)
#define WCD9360_CODEC_CPR_WR_ADDR_0                       (0x00005005)
#define WCD9360_CODEC_CPR_WR_ADDR_1                       (0x00005006)
#define WCD9360_CODEC_CPR_WR_ADDR_2                       (0x00005007)
#define WCD9360_CODEC_CPR_WR_ADDR_3                       (0x00005008)
#define WCD9360_CODEC_CPR_RD_ADDR_0                       (0x00005009)
#define WCD9360_CODEC_CPR_RD_ADDR_1                       (0x0000500A)
#define WCD9360_CODEC_CPR_RD_ADDR_2                       (0x0000500B)
#define WCD9360_CODEC_CPR_RD_ADDR_3                       (0x0000500C)
#define WCD9360_CODEC_CPR_RD_DATA_0                       (0x0000500D)
#define WCD9360_CODEC_CPR_RD_DATA_1                       (0x0000500E)
#define WCD9360_CODEC_CPR_RD_DATA_2                       (0x0000500F)
#define WCD9360_CODEC_CPR_RD_DATA_3                       (0x00005010)
#define WCD9360_CODEC_CPR_ACCESS_CFG                      (0x00005011)
#define WCD9360_CODEC_CPR_ACCESS_STATUS                   (0x00005012)
#define WCD9360_CODEC_CPR_NOM_CX_VDD                      (0x00005021)
#define WCD9360_CODEC_CPR_SVS_CX_VDD                      (0x00005022)
#define WCD9360_CODEC_CPR_SVS2_CX_VDD                     (0x00005023)
#define WCD9360_CODEC_CPR_NOM_MX_VDD                      (0x00005024)
#define WCD9360_CODEC_CPR_SVS_MX_VDD                      (0x00005025)
#define WCD9360_CODEC_CPR_SVS2_MX_VDD                     (0x00005026)
#define WCD9360_CODEC_CPR_SVS2_MIN_CX_VDD                 (0x00005027)
#define WCD9360_CODEC_CPR_MAX_SVS2_STEP                   (0x00005028)
#define WCD9360_CODEC_CPR_CTL                             (0x00005029)
#define WCD9360_CODEC_CPR_SW_MODECHNG_STATUS              (0x0000502A)
#define WCD9360_CODEC_CPR_SW_MODECHNG_START               (0x0000502B)
#define WCD9360_CODEC_CPR_CPR_STATUS                      (0x0000502C)
#define WCD9360_PAGE128_PAGE_REGISTER                     (0x00008000)
#define WCD9360_TLMM_JTCK_PINCFG                          (0x00008001)
#define WCD9360_TLMM_INTR1_PINCFG                         (0x00008002)
#define WCD9360_TLMM_INTR2_PINCFG                         (0x00008003)
#define WCD9360_TLMM_SWR_DATA_PINCFG                      (0x00008004)
#define WCD9360_TLMM_SWR_CLK_PINCFG                       (0x00008005)
#define WCD9360_TLMM_SLIMBUS_DATA1_PINCFG                 (0x00008006)
#define WCD9360_TLMM_SLIMBUS_DATA2_PINCFG                 (0x00008007)
#define WCD9360_TLMM_SLIMBUS_CLK_PINCFG                   (0x00008008)
#define WCD9360_TLMM_I2C_CLK_PINCFG                       (0x00008009)
#define WCD9360_TLMM_I2C_DATA_PINCFG                      (0x0000800A)
#define WCD9360_TLMM_I2S_0_RX_PINCFG                      (0x0000800B)
#define WCD9360_TLMM_I2S_0_TX_PINCFG                      (0x0000800C)
#define WCD9360_TLMM_I2S_0_SCK_PINCFG                     (0x0000800D)
#define WCD9360_TLMM_I2S_0_WS_PINCFG                      (0x0000800E)
#define WCD9360_TLMM_I2S_1_RX_PINCFG                      (0x0000800F)
#define WCD9360_TLMM_I2S_1_TX_PINCFG                      (0x00008010)
#define WCD9360_TLMM_I2S_1_SCK_PINCFG                     (0x00008011)
#define WCD9360_TLMM_I2S_1_WS_PINCFG                      (0x00008012)
#define WCD9360_TLMM_DMIC1_CLK_PINCFG                     (0x00008013)
#define WCD9360_TLMM_DMIC1_DATA_PINCFG                    (0x00008014)
#define WCD9360_TLMM_DMIC2_CLK_PINCFG                     (0x00008015)
#define WCD9360_TLMM_DMIC2_DATA_PINCFG                    (0x00008016)
#define WCD9360_TLMM_GPIO1_PINCFG                         (0x00008017)
#define WCD9360_TLMM_GPIO2_PINCFG                         (0x00008018)
#define WCD9360_TLMM_GPIO3_PINCFG                         (0x00008019)
#define WCD9360_TLMM_GPIO4_PINCFG                         (0x0000801A)
#define WCD9360_TLMM_SPI_S_CSN_PINCFG                     (0x0000801B)
#define WCD9360_TLMM_SPI_S_CLK_PINCFG                     (0x0000801C)
#define WCD9360_TLMM_SPI_S_DOUT_PINCFG                    (0x0000801D)
#define WCD9360_TLMM_SPI_S_DIN_PINCFG                     (0x0000801E)
#define WCD9360_TLMM_GPIO0_PINCFG                         (0x0000801F)
#define WCD9360_TLMM_DMIC3_CLK_PINCFG                     (0x00008020)
#define WCD9360_TLMM_DMIC3_DATA_PINCFG                    (0x00008021)
#define WCD9360_TLMM_DMIC4_CLK_PINCFG                     (0x00008022)
#define WCD9360_TLMM_DMIC4_DATA_PINCFG                    (0x00008023)
#define WCD9360_TEST_DEBUG_PIN_CTL_OE_0                   (0x00008031)
#define WCD9360_TEST_DEBUG_PIN_CTL_OE_1                   (0x00008032)
#define WCD9360_TEST_DEBUG_PIN_CTL_OE_2                   (0x00008033)
#define WCD9360_TEST_DEBUG_PIN_CTL_OE_3                   (0x00008034)
#define WCD9360_TEST_DEBUG_PIN_CTL_OE_4                   (0x00008035)
#define WCD9360_TEST_DEBUG_PIN_CTL_DATA_0                 (0x00008036)
#define WCD9360_TEST_DEBUG_PIN_CTL_DATA_1                 (0x00008037)
#define WCD9360_TEST_DEBUG_PIN_CTL_DATA_2                 (0x00008038)
#define WCD9360_TEST_DEBUG_PIN_CTL_DATA_3                 (0x00008039)
#define WCD9360_TEST_DEBUG_PIN_CTL_DATA_4                 (0x0000803A)
#define WCD9360_TEST_DEBUG_PAD_DRVCTL_0                   (0x0000803B)
#define WCD9360_TEST_DEBUG_PAD_DRVCTL_1                   (0x0000803C)
#define WCD9360_TEST_DEBUG_PIN_STATUS                     (0x0000803D)
#define WCD9360_TEST_DEBUG_NPL_DLY_TEST_1                 (0x0000803E)
#define WCD9360_TEST_DEBUG_NPL_DLY_TEST_2                 (0x0000803F)
#define WCD9360_TEST_DEBUG_MEM_CTRL                       (0x00008040)
#define WCD9360_TEST_DEBUG_DEBUG_BUS_SEL                  (0x00008041)
#define WCD9360_TEST_DEBUG_DEBUG_JTAG                     (0x00008042)
#define WCD9360_TEST_DEBUG_DEBUG_EN_1                     (0x00008043)
#define WCD9360_TEST_DEBUG_DEBUG_EN_2                     (0x00008044)
#define WCD9360_TEST_DEBUG_DEBUG_EN_3                     (0x00008045)
#define WCD9360_TEST_DEBUG_DEBUG_EN_4                     (0x00008046)
#define WCD9360_TEST_DEBUG_DEBUG_EN_5                     (0x00008047)
#define WCD9360_TEST_DEBUG_ANA_DTEST_DIR                  (0x0000804A)
#define WCD9360_TEST_DEBUG_PAD_INP_DISABLE_0              (0x0000804B)
#define WCD9360_TEST_DEBUG_PAD_INP_DISABLE_1              (0x0000804C)
#define WCD9360_TEST_DEBUG_PAD_INP_DISABLE_2              (0x0000804D)
#define WCD9360_TEST_DEBUG_PAD_INP_DISABLE_3              (0x0000804E)
#define WCD9360_TEST_DEBUG_PAD_INP_DISABLE_4              (0x0000804F)
#define WCD9360_TEST_DEBUG_SYSMEM_CTRL                    (0x00008050)
#define WCD9360_TEST_DEBUG_LVAL_NOM_LOW                   (0x00008052)
#define WCD9360_TEST_DEBUG_LVAL_NOM_HIGH                  (0x00008053)
#define WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_LOW              (0x00008054)
#define WCD9360_TEST_DEBUG_LVAL_SVS_SVS2_HIGH             (0x00008055)
#define WCD9360_TEST_DEBUG_SPI_SLAVE_CHAR                 (0x00008056)
#define WCD9360_TEST_DEBUG_CODEC_DIAGS                    (0x00008057)
#define WCD9360_TEST_DEBUG_PAD_TEST                       (0x00008058)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_0                (0x00008061)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_1                (0x00008062)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_2                (0x00008063)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_3                (0x00008064)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_4                (0x00008065)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_5                (0x00008066)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_6                (0x00008067)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_7                (0x00008068)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_8                (0x00008069)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_9                (0x0000806A)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_10               (0x0000806B)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_11               (0x0000806C)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_12               (0x0000806D)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_13               (0x0000806E)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_14               (0x0000806F)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_15               (0x00008070)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_16               (0x00008071)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_17               (0x00008072)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_18               (0x00008073)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_19               (0x00008074)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_20               (0x00008075)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_21               (0x00008076)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_22               (0x00008077)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_23               (0x00008078)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_24               (0x00008079)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_25               (0x0000807A)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_26               (0x0000807B)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_27               (0x0000807C)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_28               (0x0000807D)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_29               (0x0000807E)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_30               (0x0000807F)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_BIT_31               (0x00008080)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_RD_CTRL              (0x00008081)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_RD_7_0               (0x00008082)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_RD_15_8              (0x00008083)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_RD_23_16             (0x00008084)
#define WCD9360_TEST_DEBUG_DEBUG_MUX_RD_31_24             (0x00008085)
#define WCD9360_MAX_REGISTER                               0x80FF

/* SLIMBUS Slave Registers */
#define WCD9360_SLIM_PGD_PORT_INT_RX_EN0                     (0x30)
#define WCD9360_SLIM_PGD_PORT_INT_TX_EN0                     (0x32)
#define WCD9360_SLIM_PGD_PORT_INT_STATUS_RX_0                (0x34)
#define WCD9360_SLIM_PGD_PORT_INT_STATUS_RX_1                (0x35)
#define WCD9360_SLIM_PGD_PORT_INT_STATUS_TX_0                (0x36)
#define WCD9360_SLIM_PGD_PORT_INT_STATUS_TX_1                (0x37)
#define WCD9360_SLIM_PGD_PORT_INT_CLR_RX_0                   (0x38)
#define WCD9360_SLIM_PGD_PORT_INT_CLR_RX_1                   (0x39)
#define WCD9360_SLIM_PGD_PORT_INT_CLR_TX_0                   (0x3A)
#define WCD9360_SLIM_PGD_PORT_INT_CLR_TX_1                   (0x3B)
#define WCD9360_SLIM_PGD_PORT_INT_RX_SOURCE0                 (0x60)
#define WCD9360_SLIM_PGD_PORT_INT_TX_SOURCE0                 (0x70)

#endif
