/*
 * Copyright (c) 2017, The Linux Foundation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *    * Neither the name of The Linux Foundation nor the names of its
 *      contributors may be used to endorse or promote products derived
 *      from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

uint8_t default_edid[] = {
/* Block 0 (EDID Base Block) */
0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
/* Vendor Identification */
0x45, 0x23, 0xDD, 0xDD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16,
/* EDID Structure Version and Revision */
0x01, 0x03,
/* Display Parameters */
0x80, 0x90, 0x51, 0x78, 0x0A,
/* Color characteristics */
0x0D, 0xC9, 0xA0, 0x57, 0x47, 0x98, 0x27, 0x12, 0x48, 0x4C,
/* Established Timings */
0x21, 0x08, 0x00,
/* Standard Timings */
0x81, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
/* Detailed Descriptors */
0x02, 0x3A, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40,
0x58, 0x2C,
0x45, 0x00, 0xA0, 0x2A, 0x53, 0x00, 0x00, 0x1E,
/* Detailed Descriptors */
0x01, 0x1D, 0x00, 0x72, 0x51, 0xD0, 0x1E, 0x20,
0x6E, 0x28, 0x55, 0x00, 0xA0, 0x2A, 0x53, 0x00,
0x00, 0x1E,
/* Monitor Descriptor */
0x00, 0x00, 0x00, 0xFD, 0x00, 0x3A, 0x3E, 0x0F,
0x46, 0x0F, 0x00, 0x0A, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20,
/* Monitor Descriptor */
0x00, 0x00, 0x00, 0xFC, 0x00, 0x54, 0x56, 0x0A,
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20,
/* Extension Flag */
0x01,
/*checksum */
0x9A,

/* Block 1 (Extension Block) */
/* Extension Header */
0x02, 0x03, 0x37,
/* Display supports */
0xF0,
/* Video Data Bock */
0x4A, 0x10, 0x04, 0x05, 0x03, 0x02, 0x07, 0x06,
0x20, 0x01, 0x3C,
/* Audio Data Block */
0x29,
0x09, 0x07, 0x07, /* LPCM, max 2 ch, 48k, 44.1k, 32k */
0x15, 0x07, 0x50, /* AC-3, max 6 ch, 48k, 44.1k, 32k, max bitrate 640*/
0x3D, 0x07, 0x50, /* DTS, max 6ch, 48,44.1,32k, max br 640*/
/* Speaker Allocation Data Block */
0x83, 0x01, 0x00, 0x00,
/* HDMI VSDB */
/* no deep color, Max_TMDS_Clock = 165 MHz*/
0x76, 0x03, 0x0C, 0x00, 0x30, 0x00, 0x80, 0x21,
/* hdmi_video_present=1, 3d_present=1, 3d_multi_present=0,
hdmi_vic_len=0, hdmi_3d_len=0xC*/
0x2F, 0x88, 0x0C, 0x20, 0x90, 0x08, 0x10, 0x18,
0x10, 0x28, 0x10, 0x78, 0x10, 0x06, 0x26,
/* VCDB */
0xE2, 0x00, 0x7B,
/* Detailed Descriptor */
0x01, 0x1D, 0x80, 0x18, 0x71, 0x1C, 0x16, 0x20,
0x58, 0x2C, 0x25, 0x00, 0xA0, 0x2A, 0x53, 0x00,
0x00, 0x9E,
/* Detailed Descriptor */
0x8C, 0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10,
0x10, 0x3E, 0x96, 0x00, 0xA0, 0x2A, 0x53, 0x00,
0x00, 0x18,
/* Detailed Descriptor */
0x8C, 0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10,
0x10, 0x3E, 0x96, 0x00, 0x38, 0x2A, 0x43, 0x00,
0x00, 0x18,
/* Detailed Descriptor */
0x8C, 0x0A, 0xA0, 0x14, 0x51, 0xF0, 0x16, 0x00,
0x26, 0x7C, 0x43, 0x00, 0x38, 0x2A, 0x43, 0x00,
0x00, 0x98,
/* checksum */
0x38
};

uint8_t edid_with_addtnl_snd_formats[] = {
/* Block 0 (EDID Base Block) */
0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
/* Vendor Identification */
0x1E, 0x6D, 0x01, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17,
/* EDID Structure Version and Revision */
0x01, 0x03,
/* Display Parameters */
0x80, 0xa0, 0x5A, 0x78, 0x0A,
/* Color characteristics */
0xEE, 0x91, 0xa3, 0x54, 0x4c, 0x99, 0x26, 0x0f, 0x50, 0x54,
/* Established Timings */
0xa1, 0x08, 0x00,

0x31, 0x40, 0x45, 0x40, 0x61, 0x40, 0x71, 0x40,
0x81, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,

0x02, 0x3a, 0x80, 0x18, 0x71, 0x38, 0x2d, 0x40,
0x58, 0x2c,
0x45, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e,

0x66, 0x21, 0x50, 0xb0, 0x51, 0x00, 0x1b, 0x30,
0x40, 0x70, 0x36, 0x00, 0xa0, 0x5a, 0x00, 0x00,
0x00, 0x1e,

0x00, 0x00, 0x00, 0xfd, 0x00, 0x3a, 0x3e, 0x1e,
0x53, 0x10, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20,

0x00, 0x00, 0x00, 0xfc, 0x00, 0x4c, 0x47, 0x20,
0x54, 0x56, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
0x20, 0x20,

/* Extension Flag */
0x01,
/*checksum */
0x42,

/* Block 1 (Extension Block) */
/* Extension Header */
0x02, 0x03, 0x37,
/* Display supports */
0xF0,
/* Video Data Bock */
0x4E, 0x10, 0x9F, 0x04, 0x13, 0x05, 0x14, 0x03, 0x02, 0x12, 0x20, 0x21,
0x22, 0x15, 0x01,

/* Audio Data Block */
0x2F,
0x3D, 0x06, 0xC0,
0x15, 0x07, 0x50,
0x0F, 0x57, 0x07,
0x57, 0x06, 0x00,
0x5F, 0x7E, 0x01,

/* Speaker Allocation Data Block */
0x67, 0x03, 0x0C, 0x00,

0x30, 0x00, 0x80, 0x1E, 0xE3, 0x05, 0x00, 0x00, 0x01,

0x1D, 0x80, 0x18, 0x71, 0x1C, 0x16, 0x20, 0x58, 0x2C, 0x25, 0x00,
0xA0, 0x5A, 0x00, 0x00, 0x00,
0x9E, 0x01, 0x1D, 0x00, 0x80, 0x51, 0xD0, 0x1A, 0x20, 0x6E, 0x88,
0x55, 0x00, 0xA0, 0x5A, 0x00,
0x00, 0x00, 0x1A, 0x02, 0x3A, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40,
0x58, 0x2C, 0x45, 0x00, 0xA0,
0x5A, 0x00, 0x00, 0x00, 0x1E, 0x66, 0x21, 0x50, 0xB0, 0x51, 0x00,
0x1B, 0x30, 0x40, 0x70, 0x36,
0x00, 0xA0, 0x5A, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,
/* checksum */
0xFB
};
