#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/kobject.h>
#include <linux/sysfs.h>
#include <linux/string.h>

static struct kobject *kcrash_kobj;

static ssize_t trigger_store(struct kobject *kobj,
                             struct kobj_attribute *attr,
                             const char *buf, size_t count)
{
    if (buf[0] == 'c') {
        pr_emerg("kcrash: Triggering kernel panic!\n");
        panic("kcrash triggered panic via sysfs\n");
    }
    return count;
}

static struct kobj_attribute trigger_attr = __ATTR_WO(trigger);

static int __init kcrash_init(void)
{
    kcrash_kobj = kobject_create_and_add("kcrash", kernel_kobj);
    if (!kcrash_kobj)
        return -ENOMEM;

    return sysfs_create_file(kcrash_kobj, &trigger_attr.attr);
}

static void __exit kcrash_exit(void)
{
    sysfs_remove_file(kcrash_kobj, &trigger_attr.attr);
    kobject_put(kcrash_kobj);
}

module_init(kcrash_init);
module_exit(kcrash_exit);

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Kamal EL Din Reda");
MODULE_DESCRIPTION("Kernel module to trigger panic via sysfs");

