/*
    intercom - Event based Interprocess Communication for Dummies
    Copyright 2016 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <getopt.h>
#include <unistd.h>

#include <olcutils/alloc.h>
#include <olcutils/memtrace.h>
#include <intercom/server.h>
#include <intercom/log.h>

static int evt_cb_demo( t_icom_evt* p_evt )
{
  char data[128];
  int errors = 0;

  if( p_evt->type == ICOM_EVT_SERVER_CON ) {
    printf( "---> connection event received\n" );
  } else if( p_evt->type == ICOM_EVT_SERVER_DIS ) {
    printf( "---> disconnection event received\n" );
  }
  else if( p_evt->type == ICOM_EVT_SERVER_DATA ) {
    printf( "---> received event: %s\n", p_evt->p_data );
    snprintf( data, sizeof(data), "pong-> %s\n", p_evt->p_data );

    if( strstr( p_evt->p_data, "b1" ) )
      errors = icom_reply_to_address( p_evt, data, strlen( data ) );
    else if( strstr( p_evt->p_data, "b2" ) )
      errors = icom_reply_to_all_connections( p_evt, data, strlen( data ) );
    else
      errors = icom_reply_to_sender( p_evt, data, strlen( data ) );

    if( errors)
      fprintf( stderr, "error while sending \"%30s\" occured!\n", data );
  }

  return errors;
}


int main()
{
  t_icom_server_state* p_server_state;
  t_icom_server_decl decl_table[] = {
    { { AF_UNIX, "/tmp/icom.sock", 0 }, 10 },
    { { AF_INET, "0.0.0.0", 5000 }, 10 },
  };
  const int decl_table_len = sizeof(decl_table) / sizeof( t_icom_server_decl );

  printf("Starting test server ...\n" );

  p_server_state = icom_create_server_handlers( decl_table, decl_table_len, 256, 10, evt_cb_demo, NULL );
  if( p_server_state == NULL ) {
    fprintf( stderr, "could not create server handlers error!\n" );
    return -1;
  }

  printf("\tsleeping for 10 seconds\n");
  sleep(10);

  printf("\tkill socket handlers ...\n" );
  icom_kill_server_handlers( p_server_state );

  printf("\tsocket handlers killed\n" );
  sleep( 3 );

  return 0;
}
