/*
    intercom - Event based Interprocess Communication for Dummies
    Copyright 2016 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef COMMON_H
#define COMMON_H

#include <stdint.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/un.h>

#ifdef __cplusplus
extern "C" {
#endif

/*! \file common.h
    \brief declaration for both, server and client

    \addtogroup common_api Common Address Declarations
    @{
 */


/*! variant for joint representation of unix domain and IP addresses */
typedef union {
  struct sockaddr_un          uds;                          /*!< internal unix domain address specification */
  struct sockaddr_in          inet;                         /*!< internal IP address specification */
} t_icom_sock_addr;


/*! data type for ASCII representation of an unix domain or IP address */
typedef struct {
  int                         sock_family;                  /*!< AF_INET or AF_UNIX */
  char                        address[108];                 /*!< IP address, socket file or NULL */
  uint16_t                    port;                         /*!< port, specifies valid connections for server */
} t_icom_addr_decl;

/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifdef COMMON_H */
