/*
    intercom - Event based Interprocess Communication for Dummies
    Copyright 2016 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <sys/syslog.h>

#include <intercom/log.h>
#include <config.h>

#define LOG_SETTING  ( LOG_NOWAIT | LOG_PID )

/*! initialize logging (syslog) */
int icom_log_init(void)
{
#ifdef ENABLE_SYSLOG
  openlog( LOG_TAG, LOG_SETTING, LOG_SYSLOG );
#endif /* #ifdef ENABLE_SYSLOG */

  return 0;
}


/*! release logging (syslog) */
void icom_log_release(void)
{
#ifdef ENABLE_SYSLOG
  closelog();
#endif /* #ifdef ENABLE_SYSLOG */
}


/*!
 * for message log output
 */
void icom_message( const char* fmt, ... )
{
  va_list args;

  va_start( args, fmt );
#ifdef ENABLE_SYSLOG
  vsyslog( LOG_NOTICE, fmt, args );
#else
  vprintf( fmt, args );
  fflush( stdout );
#endif /* #ifdef ENABLE_SYSLOG */
  va_end( args );
}

/*!
 * for error log output
 */
void icom_error( const char* fmt, ... )
{
  va_list args;

  va_start( args, fmt );
#ifdef ENABLE_SYSLOG
  vsyslog( LOG_ERR, fmt, args );
#else
  vfprintf( stderr, fmt, args );
  fflush( stderr );
#endif /* #ifdef ENABLE_SYSLOG */
  va_end( args );
}
