# cutils - Some Useful C-Utilities

## Object
Libcutils  provides  a self-contained  set  of  fundamental routines  which  are
essential to basically any Unix utility  or daemon application written in C. The
library provides fundamental  data structures such as  lists, hash-maps, strings
and parsing functions for JSON or the typical dot-file based configuration data.
The following list summarizes the currently supported functionality:

* length delimited instead of NULL terminated strings
* memory management based on reference counting
* several list processing functions like iterators and map-reduce
* support of [Ideal Hash Tries](http://infoscience.epfl.ch/record/64398/files/idealhashtrees.pdf)
  for highly efficient hash map data structures
* parsers for [JSON](http://json.org) data and the text configuration files found
  in Unix system
* doubly linked circular lists for reliable event queues
* support for test and debugging of memory management problems such as memory leaks

This  library  is  the  result  of several  years  of  practical  experience  in
C-programming  and the  rediscovery  of a  (more)  functional programming  style
mainly  driven  by  extremly  positive   experiences  with  the  relatively  new
Programming Language [Clojure](http://clojure.org).

## How to build and use the library.
In the following we give a very brief overview how to get things up and running.
For a more detailed explanation about underlying concepts refer to the complete
[API description](http://linneman.github.io/libcutils/doc/doxygen/html/group__cutils.html).

Most  of the  functions within  libcutils exclusively  require the  prencense of
a  C  compiler compliant  to  ANSI-C  or  C99.  The event  processing  functions
currently  refer  to  the  pthread  library and  the  configure  script  of  the
build  system  requires  a  Unix  shell  and  make.  In  case  the  source  code
is  fetched  from  a git  repository  you  will  furthermore  need to  have  git
and [autotools](http://en.wikipedia.org/wiki/GNU_build_system)  consisted out of
[autoconf](http://en.wikipedia.org/wiki/Autoconf),
[automake](http://en.wikipedia.org/wiki/Automake) and
[libtool](http://en.wikipedia.org/wiki/GNU_Libtool) installed on your build machine.

### Download, Build and Installation
On Unix, that is  any Linux variant, Mac OS X or  [cygwin](http://www.cygwin.com) /
[mingw](http://www.mingw.org) under the Windows platform, the download and build
process is done with the following shell commands:

    git clone git://github.com/linneman/libcutils.git
    cd libcutils

    autoreconf -i # generate configure script

    ./configure
    make
    make install # as root

In case you download an official release as gzipped tarball you exclusively will
need the  last three commands  since the  configure script is  already delivered
with stable releases.

Pay  attention to  the fact  that  the library  is per  default installed  under
`/usr/local/lib` which is  not in the library path on  many linux distributions.
Thus you will need to put `/usr/local/lib` to your library path e.g. by defining
the enviroment variable

    export LD_LIBRARY_PATH=/usr/local/lib.

Alternatively,  you  can  edit  `/etc/ld.so.conf`  which  contains  the  default
directories  searched.  Note  that  you  may  also  need  to  update  the  cache
`/etc/ld.so.cache` by running ldconfig (as root, or with sudo).

### Testing the library
The library comes with the console based test application `test_cutilslib` which
will check  all functions  to execute  appropriately. The test program can be
exectuded also by make with the command:

    make check

The source files for all corresponding module tests follow the naming convention
`test\_<module>.c` and serve as sample application at the same time. We strictly
recommend to  study these sample  files for a  better understanding how  to make
best use of the provided functionality.


### Integrating the libcutils within your own project
The interation of the libctutils within  your own FSF compliant application is a
nobrainer. Just put the following line within your `configure.ac` file:

    PKG_CHECK_MODULES(libcutils, libcutils >= 0.1 )

Refer to `libcutils/example` for a small sample project which provide a complete
example about a minimum version of `configure.ac` and `Makefile.am` as the input
for the autoconf and automake.

## Licence
This implementation code stands under the terms of the
[GNU LESSER GENERAL PUBLIC LICENSE, Version 2.1](http://www.gnu.org/licenses/old-licenses/lgpl-2.1).

April 2014, Otto Linnemann
