#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <olcutils/hashmap.h>
#include <olcutils/slist.h>
#include <olcutils/memtrace.h>

static void* lambda_p_kv( void* key, void* val )
{
  hm_kv_t* kv = (hm_kv_t *)val;

  if( kv )
  {
    printf("(");
    string_print( kv->key );
    printf(", %d), ", *((int*)kv->val) );
  }

  return NULL;
}

static void* print_kv( void* p )
{
  hm_kv_t* kv = (hm_kv_t *)p;

  if( kv )
  {
    printf("(");
    string_print( kv->key );
    printf(", %d), ", *((int*)kv->val) );
  }

  return NULL;
}

int main()
{
  int result = 0;

  int a = 1;
  int b = 33;
  int c = 2;
  int d = 34;
  int e = 35;

  int f = 11;

  memtrace_enable();

  string_t* sa = string_new_from( "1" );
  string_t* sb = string_new_from( "33" );
  string_t* sc = string_new_from( "2" );
  string_t* sd = string_new_from( "34" );
  string_t* se = string_new_from( "35" );

  hm_t* my_hash = hm_alloc();;
  int* found_pi;
  slist_t* l = NULL;

  printf("\n%s()\n", __func__ );

  hm_assoc_with_key( my_hash, sa, &a  );
  hm_assoc_with_key( my_hash, sb, &b  );
  hm_assoc_with_key( my_hash, sc, &c  );
  hm_assoc_with_key( my_hash, sd, &d  );
  hm_assoc_with_key( my_hash, se, &e  );

  hm_dissoc_with_key( my_hash, sa );
  hm_assoc_with_key( my_hash, sa, &f  );

  printf("\nstored this values in hash table->\n");
  hm_doseq( my_hash, 0, lambda_p_kv );

  l = hm_slist_with_keys( l, my_hash );
  printf("\n\ngot the following list->\n");
  slist_doseq( l, print_kv ); printf("\n");
  slist_free( l );
  printf("\n");

  found_pi = (int *)hm_find_val_for_key( my_hash, sc );
  if( found_pi && *found_pi == 2 )
  {
    printf("found val: %d\n", *found_pi );
  }
  else
  {
    printf("hash %d not found!\n", 2 );
    result = -1;
  }

  string_release( se );
  string_release( sd );
  string_release( sc );
  string_release( sb );
  string_release( sa );

  hm_free_with_keys( my_hash );

  memtrace_disable();
  memtrace_print_log( stdout );

  if( ! result )
    printf("%s()\t\t[OK]\n", __func__ );

  return result;
}
