/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef CFG_STRING_H
#define CFG_STRING_H

#include <olcutils/hashmap.h>
#include <olcutils/slist.h>
#include <olcutils/refstring.h>

#ifdef __cplusplus
extern "C" {
#endif

/*! \file cfg_string.h
    \brief Parsing JSON Data

    \addtogroup cfg_string_parsing_api Parsing Configuration Data
    \ingroup parsers
    @{

    Unix daemons  and command line  utilities are usually configured  by a
    configuration  file  store under /etc  or in so called  dot-file whose
    file format  is a key-value  pair separate  by a blank  character. The
    function cfgstring_parse()  reads such configuration data  from cutils
    string type and stores the content within a hash map.
*/


/*!
 * Parse configuration file data
 *
 * Read configuration data where each key-value pair is stored within a
 * separated line. Comment lines are preceeded with a "#" character and
 * ignored. The function returns a hash map.
 *
 * \param cfg_string typical unix configuration data read from dot or
 *        etc file
 * \return hash map with parsed parsed key-value pairs
 * \
 */
hm_t* cfgstring_parse( string_t* cfg_string );


/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef CFG_STRING_H */
