/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef HASHFUNC_H
#define HASHFUNC_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*! \file hashfunc.h
    \brief hash functions

    \addtogroup hashfunction_api Hash Functions
    \ingroup hashmap_api
    @{

    API functions  for the  calculation of (hopefully)  collision free
    hash values from a given object represented as byte string or simply
    as NULL terminated C-string.
 */


/*!
 * Bitwise core hash function used for byte strings of given length
 *
 * Author J. Zobel, April 2001.
 *
 * \param word byte string for hash value calculation
 * \param len length of byte string (in bytes)
 * \return unsigned 32 bit value representing the hash value
 */
uint32_t hf_bitwisehash( const char *word, const int len );


/*!
 * Calculate hash value of NULL terminated C-string
 *
 * This is just a wrapper for hf_bitwisehash() but it takes a NULL
 * terminated C-string as sole input argument instead.
 *
 * \param s NULL terminated input string used for hash calculation
 * \return unsigned 32 bit value representing the hash value
 */
uint32_t cstring_hash( const char* s );


/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef HASHFUNC_H */

