/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#ifndef LAMBDA_H
#define LAMBDA_H

#ifdef __cplusplus
extern "C" {
#endif

/*! \file lambda.h
    \brief declaration of mostly used lambda functions in the LIPS family

    \addtogroup lambda_api Lambda Functions
    \ingroup functional_programming_api
    @{

    Instead  of "real"  lambda  functions  as commonly  used  by all  Lisp
    dialects  we  simply  use   function  pointers  as  substitution.  The
    main  difference is  that invoked  C-functions do  not preserve  their
    invocation context.  Refer to section  \ref lambda_functions_emulation
    "C  is not  Lisp"  for  more detailed  information  about this  design
    decision. */


/*! lambda function which takes one dynamic argument as input
    and genrates one (optional) output argument */
typedef void *(*lambda_t)(void *);


/*! lambda function which takes two dynamic arguments as input
    and genrates one (optional) output argument */
typedef void *(*lambda2_t)(void *, void *);


/*! @} */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef LAMBDA_H */

