/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <olcutils/cfg_string.h>

static void* free_string_val( void* p )
{
  string_release( (string_t*)p );

  return NULL;
}

hm_t* str2hash( hm_t* h, string_t* s )
{
  if( s && *s->p != '#' )
  {
    slist_t* l_vk = string_split( s, " ", 2 );
    string_t *val, *key;

    if( slist_cnt(l_vk ) == 2 )
    {
      val = slist_first( l_vk );
      key = slist_first ( slist_rest( l_vk ) );
      hm_assoc( h, 0, string_hash(key), val  );
      string_release(key);
    }
    else
    {
      slist_doseq( l_vk, free_string_val );
    }

    slist_free( l_vk );
  }

  return h;
}

hm_t* cfgstring_parse( string_t* cfg_string )
{
  slist_t* lines;
  slist_t* hash_plus_lines;
  hm_t* h = hm_alloc();

  if( h==NULL )
    return NULL;

  lines = string_split_lines( cfg_string );

  hash_plus_lines = slist_prepend( lines, h );
  h = slist_reduce( hash_plus_lines, (lambda2_t)str2hash, NULL );

  slist_doseq( lines, free_string_val );
  slist_free( hash_plus_lines );

  return h;
}
