/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <olcutils/clist.h>


void clist_init( t_clist* p ) {
  p->prev = p->next = p;
}

int clist_is_empty( t_clist* p ) {
  return( p->next == p );
}

void clist_insert_head( t_clist* p, t_clist* e )
{
  p->next->prev = e;
  e->next = p->next;
  p->next = e;
  e->prev = p;
}

void clist_insert_tail( t_clist* p, t_clist* e )
{
  p->prev->next = e;
  e->prev = p->prev;
  p->prev = e;
  e->next = p;
}

t_clist* clist_remove_head( t_clist* p )
{
  t_clist* e = p->next;
  e->prev->next = e->next;
  e->next->prev = e->prev;
  e->prev = e->next = p;

  return e;
}

t_clist* clist_remove_tail( t_clist* p )
{
  t_clist* e = p->prev;
  e->prev->next = e->next;
  e->next->prev = e->prev;
  e->prev = e->next = p;

  return e;
}

t_clist* clist_get_head( t_clist* p ) {
  return p->next;
}

t_clist* clist_get_tail( t_clist* p ) {
  return p->prev;
}


void clist_print_elements( t_clist* first, void (*print_element_cb)(t_clist*) )
{
  t_clist* p = first;
  int i = 0;
  const int max = 100;

  while( p->next != first ) {
    p = p->next;

    print_element_cb( p );
    if( ++i > max ) {
      fprintf( stderr, "stop printing after %d elements!, circluar?\n", max );
      return;
    }
  }
}
