/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <string.h>
#include <olcutils/hashfunc.h>

/* Author J. Zobel, April 2001.
   Permission to use this code is freely granted, provided that this
   statement is retained. */

/* Bitwise hash function.  Note that tsize does not have to be prime. */
uint32_t hf_bitwisehash( const char *word, const int len )
{
  uint32_t h;
  const uint32_t seed = 0x3A1F652C;
  int i;

  h = seed;
  for( i=0 ; i < len ;++i )
  {
    h ^= ( (h << 5) + word[i] + (h >> 2) );
  }

  return( (uint32_t)(h&0x7fffffff) );
}

uint32_t cstring_hash( const char* s )
{
  return( hf_bitwisehash( s, strlen(s) ) );
}
