/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <olcutils/refcnt.h>
#include <olcutils/alloc.h>

t_ref* ref_new( const int size )
{
  t_ref* r = cul_malloc( size );
  // printf("--- malloc %d->%p\n", size, r );
  if( r )
  {
    r->refcnt = 1;
  }
  return r;
}

void ref_retain( void* r )
{
  t_ref* _r = (t_ref*) r;
  // printf("--- retain: %p, cnt: %d\n", _r, _r->refcnt );
  ++(_r->refcnt);
}

void ref_release( void* r )
{
  t_ref* _r = (t_ref*) r;
  // printf("--- release: %p, cnt: %d\n", _r, _r->refcnt );
  if( --(_r->refcnt) < 1 )
  {
    // printf("--- free: %p\n", _r );
    cul_free( _r );
  }
}
