/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <olcutils/cfg_string.h>

static void* free_string_val( void* p )
{
  string_release( (string_t*)p );

  return NULL;
}

static void* lambda_p_key_strval( void* key, void* val )
{
  printf("%d->", * ((int *)key) );
  string_println( val );

  return NULL;
}


int test_cfg_parse( void )
{
  hm_leaf_node_t* ln;
  int result = 0;

  printf("\n%s()\n", __func__ );

  string_t* s = string_new_from( " \t# comment line\nIP 192.168.0.1\nHOST http://google.com\n\nPROJECT CUTILLIB");
  hm_t* params;

  params = cfgstring_parse( s );

  printf("got hash value --->\n");
  hm_doseq( params, 0, lambda_p_key_strval );


  printf("check for IP ...\n");
  ln = hm_find( params, cstring_hash( "IP" ) );
  if( ln ) {
    printf( "\tIP=" ); string_println( ln->val );
  }
  else {
    fprintf( stderr, "\tIP not found error!\n");
    result = -1;
  }

  printf("check for HOST ...\n");
  ln = hm_find( params, cstring_hash( "HOST" ) );
  if( ln ) {
    printf( "\tHOST=" ); string_println( ln->val );
  }
  else {
    fprintf( stderr, "\tHOST not found error!\n");
    result = -1;
  }

  printf("check for PROJECT ...\n");
  ln = hm_find( params, cstring_hash( "PROJECT" ) );
  if( ln ) {
    printf( "\tPROJECT=" ); string_println( ln->val );
  }
  else {
    fprintf( stderr, "\tPROJECT not found error!\n");
    result = -1;
  }

  string_release( s );
  hm_free_deep( params, 0, free_string_val );

  if( ! result )
    printf("%s()\t\t[OK]\n", __func__ );

  return result;
}
