/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <test_json.h>
#include <config.h>

string_t* load_json_data( void )
{
  const char* full_qualified_name1 = "test.json";
  const char* full_qualified_name2 = DATADIR "/test.json";
  const char* full_qualified_name3 = "example.json";
  const char* full_qualified_name4 = DATADIR "/example.json";
  char* json_data = NULL;
  string_t* json_string = NULL;
  long size;
  FILE* fp;

  fp = fopen( full_qualified_name1, "r" );
  if( fp == NULL ) {
    fp = fopen( full_qualified_name2, "r" );
    if( fp == NULL ) {
      fp = fopen( full_qualified_name3, "r" );
      if( fp == NULL ) {
        fp = fopen( full_qualified_name4, "r" );
        if( fp == NULL ) {
          fprintf( stderr, "none of the following files with json input data could be opened:\n\t%s,\n\t%s,\n\t%s,\n\t%s\n\n",
                   full_qualified_name1, full_qualified_name2, full_qualified_name3, full_qualified_name4 );
          fprintf( stderr, "Install sample data with 'make install'!\n\n" );
          return NULL;
        } } } }

  fseek(fp, 0L, SEEK_END);
  size= ftell(fp);
  fseek(fp, 0L, SEEK_SET);

  if( size > 3 )
  {
    json_data = malloc( size );
    if( json_data && size == fread( json_data, sizeof(char), size, fp ) )
      json_string = string_new_from( json_data );
  }

  if( json_data )
    free( json_data );

  fclose( fp );
  return json_string;
}



int test_json(void)
{
  int result = 0;
  string_t* s = load_json_data();
  json_val_t* my_json = NULL;
  json_val_t* found;
  string_t* search_key1 = string_new_from( "author" );
  string_t* search_key2 = string_new_from( "emphasis" );
  string_t* search_key_empty = string_new_from( "" );

  printf("\n%s()\n", __func__ );

  if( s )
    my_json = json_parse_string( s );
  else
    result = -1;

  if( my_json )
  {
    json_emerge( stdout, my_json );
    printf("\n\n");

    found = json_find( my_json, search_key1, 1 );
    if( found )
    {
      printf("found string: "); string_println( search_key1 );
      printf("got value:  "); string_println( found->u.string );
      printf("\t[OK]\n\n");
    }
    else
      result = -1;

    found = json_find( my_json, search_key2, 2 );
    if( found )
    {
      printf("found string: "); string_println( search_key2 );
      printf("got value:  "); printf( "%d\n", (int)found->u.boolean );
      printf("\t[OK]\n\n");
    }
    else
      result = -1;

    found = json_errors( my_json );
    if( found )
    {
      printf("parsing error %d occured\n", (int)found->u.error);
    }

    json_free( my_json );
    string_release( s );
  }

  if( ! result )
    printf("%s()\t\t[OK]\n", __func__ );


  string_release( search_key1 );
  string_release( search_key2 );
  string_release( search_key_empty );

  return result;
}
