/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <test_refstring.h>
#include <test_slist.h>
#include <test_clist.h>
#include <test_memcheck.h>
#include <test_hashmap.h>
#include <test_cfg_string.h>
#include <test_json.h>
#include <olcutils/memtrace.h>
#include <olcutils/alloc.h>
#include <olcutils/revision.h>

int main()
{
  int result = 0;
  cul_allocstat_t allocstat;
  FILE* free_log_fp = NULL;
  long i;

  printf("starting tests for cutils library revision %s ... \n\n",
         g_cutillib_revision );

  memtrace_enable();

  if( ! result )
    result = test_refstring();

  if( ! result )
    result = test_slist();

  if( ! result )
    result = test_clist();

  if( ! result )
    result = test_memcheck();

  if( ! result )
    result = test_hashmap();

  if( ! result )
    result = test_cfg_parse();

  if( ! result )
    result = test_json();

  memtrace_disable();


  allocstat = get_allocstat();
  printf("\n\n");
  printf("Memory Allocation Statistics in cutillib functions\n");
  printf("--------------------------------------------------\n");
  printf("       number of open allocations: %ld\n", allocstat.nr_allocs );
  printf("     number of failed allocations: %ld\n", allocstat.nr_allocs_failed );
  printf("  still allocated memory in bytes: %ld\n", allocstat.mem_allocated );
  printf("maximum allocated memory in bytes: %ld\n", allocstat.max_allocated );
  printf("\n");

  if( allocstat.nr_allocs != 0 || allocstat.mem_allocated != 0 )
  {
    fprintf( stderr, "ATTENTION: Some memory is leaking out, configure with alloctrace or memcheck option and check for root cause!\n\n");

    if( allocstat.alloc_trace.addr_table_head > 0 ) {
      fprintf( stderr, "Non-freed Memory Allocations\n");
      fprintf( stderr, "----------------------------\n");
      for( i=0; i<allocstat.alloc_trace.addr_table_head; ++i ) {
        fprintf( stderr, "idx: %.3ld, function: %-20.20s, file: %-10.10s, line: %.4d, size: %.4ld, addr: %.5lx\n",
                 i,
                 allocstat.alloc_trace.addr_table[i].dbg.func,
                 allocstat.alloc_trace.addr_table[i].dbg.file,
                 allocstat.alloc_trace.addr_table[i].dbg.line,
                 (unsigned long) (allocstat.alloc_trace.addr_table[i].size),
                 (unsigned long) (allocstat.alloc_trace.addr_table[i].addr) );
      }
      fprintf( stderr, "\n" );
    }

    result = -1;
  }

  memtrace_print_log( stdout );

  free_log_fp = fopen("/tmp/freelog.txt", "w" );
  if( free_log_fp != NULL )
  {
    memtrace_print_free_log( free_log_fp );
    fclose( free_log_fp );
  }

  return result;
}
