/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <olcutils/refstring.h>

int test_refstring(void)
{
  int result = 0;
  char tmp_buf[1000];
  slist_t* line_lst;

  printf("\n%s()\n", __func__ );

  // printf("------ new_string-from -----\n");
  string_t* s = string_new_from( "hello world! This is a test sequence." );
  string_t* t = string_new_from( "   hello world! This test sequence has preceeding and trailing spaces.     " );
  string_t* u = string_new_from( " first line\n\rsecond line\n third line  \r fourth line \n\n\r");
  // printf("\n\n------ retain_sub_string ------\n");

  string_t* sub = string_retain_sub( s, 6, 10 );

  printf("size:%d:%s\n", sub->size, string_tmp_cstring_from( sub, tmp_buf, sizeof(tmp_buf) ) );
  if( sub->size != 5 ) {
    fprintf( stderr, "got wrong size in string_retain_sub() error!\n" );
    result = -1;
  }

  // printf("\n\n------ release_ref( sub ); ------\n");
  string_release( sub );

  // printf("\n\n------ release_ref( s ); ------\n");
  string_release( s );

  printf("string before trim:" ); string_println( t );
  printf(" string after trim:" ); string_println( string_trim( t ) );
  printf(" hash value: %d\n", string_hash( t ) );

  line_lst = string_split_lines( u );
  slist_doseq( line_lst, (lambda_t)string_println );

  slist_free_deep( line_lst, (lambda_t)string_release );
  string_release( t );
  string_release( u );

  //printf("s->refcnt: %d\n", ((t_ref*)s)->refcnt );
  //printf("sub->refcnt: %d\n", ((t_ref*)sub)->refcnt );
  //printf("s->p_lstring->refcnt: %d\n", ((t_ref*)s->p_lstring)->refcnt );

  if( ! result )
    printf("%s()\t\t[OK]\n", __func__ );

  return result;
}
