/*
    cutils - Common Utilities for functional programming style under ANSI-C
    Copyright 2014 Otto Linnemann

    This program is free software: you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation, either version 2.1
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General
    Public License along with this program. If not, see
    <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <olcutils/slist.h>

#ifndef SQUARE
# define SQUARE(x) ((x)*(x))
#endif

static void* square_int( void* i )
{
  int* ni = NULL;

  if( i )
  {
    ni = malloc( sizeof(int) );

    if( ni )
    {
      *ni = SQUARE( *((int *)i) );
    }
  }

  return ni;
}

static void* add_ints( void* i, void* j )
{
  int* ni = NULL;

  if( i!=NULL && j!=NULL )
  {
    ni = malloc( sizeof(int) );

    if( ni )
    {
      *ni = ( *((int *)i) ) + ( *((int *)j) );
    }
  }

  return ni;
}

static void* print_int( void* i )
{
  if( i )
    printf("%3d, ", *((int*)i) );

  return i;
}

static void* free_int( void* i )
{
  free( i );
  return NULL;
}



int test_slist(void)
{
  slist_t* l = slist_alloc(), *lr;
  slist_t* n;
  int* elem;
  void* r;
  int i;

  printf("\n%s()\n", __func__ );

  /* fill with integer elements  */
  for( i = 0; i < 10; ++ i )
  {
    elem = malloc( sizeof( int ) );
    if( elem )
      *elem = i;
    else
    {
      free( elem );
      break;
    }

    if( l )
      l = slist_prepend( l, elem );
    else
      break;
  }


  n = slist_map( l, square_int, free_int );
  r = slist_reduce( l, add_ints, free_int );
  lr = slist_reverse( l );

  printf("input list l:   ");
  slist_doseq( l, print_int );
  printf("\n");

  printf("reverse input list l:   ");
  slist_doseq( lr, print_int );
  printf("\n");

  printf("number of elements in l, lr, n: %d, %d, %d\n", slist_cnt(l), slist_cnt(lr), slist_cnt(n) );

  elem = malloc( sizeof(int) );
  *elem = 42;
  l = slist_append( l, elem );

  printf("input list l with 42 appended:    ");
  slist_doseq( l, print_int );
  printf("\n");
  printf("number of elements in l after append %d\n", slist_cnt(l) );

  printf("squared list n: ");
  slist_doseq( n, print_int );
  printf("\n");

  printf("reduce list l: ");
  if( r ) printf("%d\n", *((int*)r) );

  slist_free_deep( l, free_int );
  slist_free( lr );
  slist_free_deep( n, free_int );
  if( r )
    free_int( r );

  printf("%s()\t\t[OK]\n", __func__ );

  return 0;
}
