/*
 * Copyright (c) 2019, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#define pr_fmt(fmt) "clk: %s: " fmt, __func__

#include <linux/kernel.h>
#include <linux/err.h>
#include <linux/platform_device.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/regmap.h>
#include <linux/mfd/syscon.h>

#include "clk-debug.h"

static struct measure_clk_data debug_mux_priv = {
	.ctl_reg = 0x62024,
	.status_reg = 0x62028,
	.xo_div4_cbcr = 0x43008,
};

static const char *const debug_mux_parent_names[] = {
	"cam_cc_bps_ahb_clk",
	"cam_cc_bps_areg_clk",
	"cam_cc_bps_axi_clk",
	"cam_cc_bps_clk",
	"cam_cc_camnoc_atb_clk",
	"cam_cc_camnoc_axi_clk",
	"cam_cc_cci_0_clk",
	"cam_cc_cci_1_clk",
	"cam_cc_core_ahb_clk",
	"cam_cc_cpas_ahb_clk",
	"cam_cc_csi0phytimer_clk",
	"cam_cc_csi1phytimer_clk",
	"cam_cc_csi2phytimer_clk",
	"cam_cc_csi3phytimer_clk",
	"cam_cc_csiphy0_clk",
	"cam_cc_csiphy1_clk",
	"cam_cc_csiphy2_clk",
	"cam_cc_csiphy3_clk",
	"cam_cc_icp_apb_clk",
	"cam_cc_icp_atb_clk",
	"cam_cc_icp_clk",
	"cam_cc_icp_cti_clk",
	"cam_cc_icp_ts_clk",
	"cam_cc_ife_0_axi_clk",
	"cam_cc_ife_0_clk",
	"cam_cc_ife_0_cphy_rx_clk",
	"cam_cc_ife_0_csid_clk",
	"cam_cc_ife_0_dsp_clk",
	"cam_cc_ife_1_axi_clk",
	"cam_cc_ife_1_clk",
	"cam_cc_ife_1_cphy_rx_clk",
	"cam_cc_ife_1_csid_clk",
	"cam_cc_ife_1_dsp_clk",
	"cam_cc_ife_lite_clk",
	"cam_cc_ife_lite_cphy_rx_clk",
	"cam_cc_ife_lite_csid_clk",
	"cam_cc_ipe_0_ahb_clk",
	"cam_cc_ipe_0_areg_clk",
	"cam_cc_ipe_0_axi_clk",
	"cam_cc_ipe_0_clk",
	"cam_cc_jpeg_clk",
	"cam_cc_lrme_clk",
	"cam_cc_mclk0_clk",
	"cam_cc_mclk1_clk",
	"cam_cc_mclk2_clk",
	"cam_cc_mclk3_clk",
	"cam_cc_mclk4_clk",
	"cam_cc_soc_ahb_clk",
	"cam_cc_sys_tmr_clk",
	"disp_cc_mdss_ahb_clk",
	"disp_cc_mdss_byte0_clk",
	"disp_cc_mdss_byte0_intf_clk",
	"disp_cc_mdss_dp_aux_clk",
	"disp_cc_mdss_dp_crypto_clk",
	"disp_cc_mdss_dp_link_clk",
	"disp_cc_mdss_dp_link_intf_clk",
	"disp_cc_mdss_dp_pixel_clk",
	"disp_cc_mdss_esc0_clk",
	"disp_cc_mdss_mdp_clk",
	"disp_cc_mdss_mdp_lut_clk",
	"disp_cc_mdss_non_gdsc_ahb_clk",
	"disp_cc_mdss_pclk0_clk",
	"disp_cc_mdss_rot_clk",
	"disp_cc_mdss_rscc_ahb_clk",
	"disp_cc_mdss_rscc_vsync_clk",
	"disp_cc_mdss_vsync_clk",
	"disp_cc_sleep_clk",
	"disp_cc_xo_clk",
	"gcc_aggre_ufs_phy_axi_clk",
	"gcc_aggre_usb3_prim_axi_clk",
	"gcc_boot_rom_ahb_clk",
	"gcc_camera_ahb_clk",
	"gcc_camera_hf_axi_clk",
	"gcc_camera_throttle_hf_axi_clk",
	"gcc_camera_xo_clk",
	"gcc_ce1_ahb_clk",
	"gcc_ce1_axi_clk",
	"gcc_ce1_clk",
	"gcc_cfg_noc_usb3_prim_axi_clk",
	"gcc_cpuss_ahb_clk",
	"gcc_cpuss_gnoc_clk",
	"gcc_cpuss_rbcpr_clk",
	"gcc_ddrss_gpu_axi_clk",
	"gcc_disp_ahb_clk",
	"gcc_disp_gpll0_clk_src",
	"gcc_disp_gpll0_div_clk_src",
	"gcc_disp_hf_axi_clk",
	"gcc_disp_throttle_hf_axi_clk",
	"gcc_disp_xo_clk",
	"gcc_gp1_clk",
	"gcc_gp2_clk",
	"gcc_gp3_clk",
	"gcc_gpu_cfg_ahb_clk",
	"gcc_gpu_gpll0_clk_src",
	"gcc_gpu_gpll0_div_clk_src",
	"gcc_gpu_memnoc_gfx_clk",
	"gcc_gpu_snoc_dvm_gfx_clk",
	"gcc_npu_axi_clk",
	"gcc_npu_bwmon_axi_clk",
	"gcc_npu_bwmon_dma_cfg_ahb_clk",
	"gcc_npu_bwmon_dsp_cfg_ahb_clk",
	"gcc_npu_cfg_ahb_clk",
	"gcc_npu_dma_clk",
	"gcc_npu_gpll0_clk_src",
	"gcc_npu_gpll0_div_clk_src",
	"gcc_pdm2_clk",
	"gcc_pdm_ahb_clk",
	"gcc_pdm_xo4_clk",
	"gcc_prng_ahb_clk",
	"gcc_qspi_cnoc_periph_ahb_clk",
	"gcc_qspi_core_clk",
	"gcc_qupv3_wrap0_core_2x_clk",
	"gcc_qupv3_wrap0_core_clk",
	"gcc_qupv3_wrap0_s0_clk",
	"gcc_qupv3_wrap0_s1_clk",
	"gcc_qupv3_wrap0_s2_clk",
	"gcc_qupv3_wrap0_s3_clk",
	"gcc_qupv3_wrap0_s4_clk",
	"gcc_qupv3_wrap0_s5_clk",
	"gcc_qupv3_wrap1_core_2x_clk",
	"gcc_qupv3_wrap1_core_clk",
	"gcc_qupv3_wrap1_s0_clk",
	"gcc_qupv3_wrap1_s1_clk",
	"gcc_qupv3_wrap1_s2_clk",
	"gcc_qupv3_wrap1_s3_clk",
	"gcc_qupv3_wrap1_s4_clk",
	"gcc_qupv3_wrap1_s5_clk",
	"gcc_qupv3_wrap_0_m_ahb_clk",
	"gcc_qupv3_wrap_0_s_ahb_clk",
	"gcc_qupv3_wrap_1_m_ahb_clk",
	"gcc_qupv3_wrap_1_s_ahb_clk",
	"gcc_sdcc1_ahb_clk",
	"gcc_sdcc1_apps_clk",
	"gcc_sdcc1_ice_core_clk",
	"gcc_sdcc2_ahb_clk",
	"gcc_sdcc2_apps_clk",
	"gcc_sys_noc_cpuss_ahb_clk",
	"gcc_ufs_phy_ahb_clk",
	"gcc_ufs_phy_axi_clk",
	"gcc_ufs_phy_ice_core_clk",
	"gcc_ufs_phy_phy_aux_clk",
	"gcc_ufs_phy_rx_symbol_0_clk",
	"gcc_ufs_phy_tx_symbol_0_clk",
	"gcc_ufs_phy_unipro_core_clk",
	"gcc_usb30_prim_master_clk",
	"gcc_usb30_prim_mock_utmi_clk",
	"gcc_usb30_prim_sleep_clk",
	"gcc_usb3_prim_phy_aux_clk",
	"gcc_usb3_prim_phy_com_aux_clk",
	"gcc_usb3_prim_phy_pipe_clk",
	"gcc_usb_phy_cfg_ahb2phy_clk",
	"gcc_video_ahb_clk",
	"gcc_video_axi_clk",
	"gcc_video_gpll0_div_clk_src",
	"gcc_video_throttle_axi_clk",
	"gcc_video_xo_clk",
	"gpu_cc_acd_ahb_clk",
	"gpu_cc_acd_cxo_clk",
	"gpu_cc_ahb_clk",
	"gpu_cc_crc_ahb_clk",
	"gpu_cc_cx_apb_clk",
	"gpu_cc_cx_gfx3d_clk",
	"gpu_cc_cx_gfx3d_slv_clk",
	"gpu_cc_cx_gmu_clk",
	"gpu_cc_cx_qdss_at_clk",
	"gpu_cc_cx_qdss_trig_clk",
	"gpu_cc_cx_qdss_tsctr_clk",
	"gpu_cc_cx_snoc_dvm_clk",
	"gpu_cc_cxo_aon_clk",
	"gpu_cc_cxo_clk",
	"gpu_cc_gx_cxo_clk",
	"gpu_cc_gx_gfx3d_clk",
	"gpu_cc_gx_gmu_clk",
	"gpu_cc_gx_qdss_tsctr_clk",
	"gpu_cc_gx_vsense_clk",
	"gpu_cc_rbcpr_ahb_clk",
	"gpu_cc_rbcpr_clk",
	"gpu_cc_sleep_clk",
	"measure_only_mccc_clk",
	"measure_only_cnoc_clk",
	"measure_only_ipa_2x_clk",
	"measure_only_snoc_clk",
	"npu_cc_atb_clk",
	"npu_cc_bto_core_clk",
	"npu_cc_bwmon_clk",
	"npu_cc_cal_hm0_cdc_clk",
	"npu_cc_cal_hm0_clk",
	"npu_cc_cal_hm0_perf_cnt_clk",
	"npu_cc_core_clk",
	"npu_cc_dsp_ahbm_clk",
	"npu_cc_dsp_ahbs_clk",
	"npu_cc_dsp_axi_clk",
	"npu_cc_noc_ahb_clk",
	"npu_cc_noc_axi_clk",
	"npu_cc_noc_dma_clk",
	"npu_cc_rsc_xo_clk",
	"npu_cc_s2p_clk",
	"npu_cc_xo_clk",
	"video_cc_apb_clk",
	"video_cc_at_clk",
	"video_cc_qdss_trig_clk",
	"video_cc_qdss_tsctr_div8_clk",
	"video_cc_sleep_clk",
	"video_cc_vcodec0_axi_clk",
	"video_cc_vcodec0_core_clk",
	"video_cc_venus_ahb_clk",
	"video_cc_venus_ctl_axi_clk",
	"video_cc_venus_ctl_core_clk",
	"video_cc_xo_clk",
	"l3_clk",
	"pwrcl_clk",
	"perfcl_clk",
};

static struct clk_debug_mux gcc_debug_mux = {
	.priv = &debug_mux_priv,
	.debug_offset = 0x62008,
	.post_div_offset = 0x62000,
	.cbcr_offset = 0x62004,
	.period_offset = 0x50,
	.src_sel_mask = 0x3FF,
	.src_sel_shift = 0,
	.post_div_mask = 0xF,
	.post_div_shift = 0,
	MUX_SRC_LIST(
		{ "cam_cc_bps_ahb_clk", 0x46, 4, CAM_CC,
			0xE, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_bps_areg_clk", 0x46, 4, CAM_CC,
			0xD, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_bps_axi_clk", 0x46, 4, CAM_CC,
			0xC, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_bps_clk", 0x46, 4, CAM_CC,
			0xB, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_camnoc_atb_clk", 0x46, 4, CAM_CC,
			0x34, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_camnoc_axi_clk", 0x46, 4, CAM_CC,
			0x2D, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_cci_0_clk", 0x46, 4, CAM_CC,
			0x2A, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_cci_1_clk", 0x46, 4, CAM_CC,
			0x3B, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_core_ahb_clk", 0x46, 4, CAM_CC,
			0x3A, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_cpas_ahb_clk", 0x46, 4, CAM_CC,
			0x2C, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csi0phytimer_clk", 0x46, 4, CAM_CC,
			0x5, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csi1phytimer_clk", 0x46, 4, CAM_CC,
			0x7, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csi2phytimer_clk", 0x46, 4, CAM_CC,
			0x9, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csi3phytimer_clk", 0x46, 4, CAM_CC,
			0x13, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy0_clk", 0x46, 4, CAM_CC,
			0x6, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy1_clk", 0x46, 4, CAM_CC,
			0x8, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy2_clk", 0x46, 4, CAM_CC,
			0xA, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy3_clk", 0x46, 4, CAM_CC,
			0x14, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_icp_apb_clk", 0x46, 4, CAM_CC,
			0x32, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_icp_atb_clk", 0x46, 4, CAM_CC,
			0x2F, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_icp_clk", 0x46, 4, CAM_CC,
			0x26, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_icp_cti_clk", 0x46, 4, CAM_CC,
			0x30, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_icp_ts_clk", 0x46, 4, CAM_CC,
			0x31, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_axi_clk", 0x46, 4, CAM_CC,
			0x1B, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_clk", 0x46, 4, CAM_CC,
			0x17, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_cphy_rx_clk", 0x46, 4, CAM_CC,
			0x1A, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_csid_clk", 0x46, 4, CAM_CC,
			0x19, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_dsp_clk", 0x46, 4, CAM_CC,
			0x18, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_axi_clk", 0x46, 4, CAM_CC,
			0x21, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_clk", 0x46, 4, CAM_CC,
			0x1D, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_cphy_rx_clk", 0x46, 4, CAM_CC,
			0x20, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_csid_clk", 0x46, 4, CAM_CC,
			0x1F, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_dsp_clk", 0x46, 4, CAM_CC,
			0x1E, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_clk", 0x46, 4, CAM_CC,
			0x22, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_cphy_rx_clk", 0x46, 4, CAM_CC,
			0x24, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_csid_clk", 0x46, 4, CAM_CC,
			0x23, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_ahb_clk", 0x46, 4, CAM_CC,
			0x12, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_areg_clk", 0x46, 4, CAM_CC,
			0x11, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_axi_clk", 0x46, 4, CAM_CC,
			0x10, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_clk", 0x46, 4, CAM_CC,
			0xF, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_jpeg_clk", 0x46, 4, CAM_CC,
			0x25, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_lrme_clk", 0x46, 4, CAM_CC,
			0x2B, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_mclk0_clk", 0x46, 4, CAM_CC,
			0x1, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_mclk1_clk", 0x46, 4, CAM_CC,
			0x2, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_mclk2_clk", 0x46, 4, CAM_CC,
			0x3, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_mclk3_clk", 0x46, 4, CAM_CC,
			0x4, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_mclk4_clk", 0x46, 4, CAM_CC,
			0x15, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_soc_ahb_clk", 0x46, 4, CAM_CC,
			0x2E, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "cam_cc_sys_tmr_clk", 0x46, 4, CAM_CC,
			0x33, 0xFF, 0, 0x3, 0, 2, 0xD000, 0xC004, 0xC008 },
		{ "disp_cc_mdss_ahb_clk", 0x47, 4, DISP_CC,
			0x14, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_byte0_clk", 0x47, 4, DISP_CC,
			0xC, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_byte0_intf_clk", 0x47, 4, DISP_CC,
			0xD, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_aux_clk", 0x47, 4, DISP_CC,
			0x13, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_crypto_clk", 0x47, 4, DISP_CC,
			0x11, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_link_clk", 0x47, 4, DISP_CC,
			0xF, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_link_intf_clk", 0x47, 4, DISP_CC,
			0x10, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_pixel_clk", 0x47, 4, DISP_CC,
			0x12, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_esc0_clk", 0x47, 4, DISP_CC,
			0xE, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_mdp_clk", 0x47, 4, DISP_CC,
			0x8, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_mdp_lut_clk", 0x47, 4, DISP_CC,
			0xA, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_non_gdsc_ahb_clk", 0x47, 4, DISP_CC,
			0x15, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_pclk0_clk", 0x47, 4, DISP_CC,
			0x7, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rot_clk", 0x47, 4, DISP_CC,
			0x9, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rscc_ahb_clk", 0x47, 4, DISP_CC,
			0x17, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rscc_vsync_clk", 0x47, 4, DISP_CC,
			0x16, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_vsync_clk", 0x47, 4, DISP_CC,
			0xB, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_sleep_clk", 0x47, 4, DISP_CC,
			0x1E, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_xo_clk", 0x47, 4, DISP_CC,
			0x1D, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "gcc_aggre_ufs_phy_axi_clk", 0x11D, 4, GCC,
			0x11D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_aggre_usb3_prim_axi_clk", 0x11B, 4, GCC,
			0x11B, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_boot_rom_ahb_clk", 0x94, 4, GCC,
			0x94, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_camera_ahb_clk", 0x3A, 4, GCC,
			0x3A, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_camera_hf_axi_clk", 0x40, 4, GCC,
			0x40, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_camera_throttle_hf_axi_clk", 0x1AA, 4, GCC,
			0x1AA, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_camera_xo_clk", 0x43, 4, GCC,
			0x43, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ce1_ahb_clk", 0xA9, 4, GCC,
			0xA9, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ce1_axi_clk", 0xA8, 4, GCC,
			0xA8, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ce1_clk", 0xA7, 4, GCC,
			0xA7, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_cfg_noc_usb3_prim_axi_clk", 0x1D, 4, GCC,
			0x1D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_cpuss_ahb_clk", 0xCE, 4, GCC,
			0xCE, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_cpuss_gnoc_clk", 0xCF, 4, GCC,
			0xCF, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_cpuss_rbcpr_clk", 0xD0, 4, GCC,
			0xD0, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ddrss_gpu_axi_clk", 0xBB, 4, GCC,
			0xBB, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_ahb_clk", 0x3B, 4, GCC,
			0x3B, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_gpll0_clk_src", 0x4C, 4, GCC,
			0x4C, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_gpll0_div_clk_src", 0x4D, 4, GCC,
			0x4D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_hf_axi_clk", 0x41, 4, GCC,
			0x41, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_throttle_hf_axi_clk", 0x1AB, 4, GCC,
			0x1AB, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_disp_xo_clk", 0x44, 4, GCC,
			0x44, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gp1_clk", 0xDE, 4, GCC,
			0xDE, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gp2_clk", 0xDF, 4, GCC,
			0xDF, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gp3_clk", 0xE0, 4, GCC,
			0xE0, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gpu_cfg_ahb_clk", 0x142, 4, GCC,
			0x142, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gpu_gpll0_clk_src", 0x148, 4, GCC,
			0x148, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gpu_gpll0_div_clk_src", 0x149, 4, GCC,
			0x149, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gpu_memnoc_gfx_clk", 0x145, 4, GCC,
			0x145, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_gpu_snoc_dvm_gfx_clk", 0x147, 4, GCC,
			0x147, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_axi_clk", 0x16A, 4, GCC,
			0x16A, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_bwmon_axi_clk", 0x182, 4, GCC,
			0x182, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_bwmon_dma_cfg_ahb_clk", 0x7E, 4, GCC,
			0x7E, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_bwmon_dsp_cfg_ahb_clk", 0x7F, 4, GCC,
			0x7F, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_cfg_ahb_clk", 0x169, 4, GCC,
			0x169, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_dma_clk", 0x185, 4, GCC,
			0x185, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_gpll0_clk_src", 0x16D, 4, GCC,
			0x16D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_npu_gpll0_div_clk_src", 0x16E, 4, GCC,
			0x16E, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_pdm2_clk", 0x8E, 4, GCC,
			0x8E, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_pdm_ahb_clk", 0x8C, 4, GCC,
			0x8C, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_pdm_xo4_clk", 0x8D, 4, GCC,
			0x8D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_prng_ahb_clk", 0x8F, 4, GCC,
			0x8F, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qspi_cnoc_periph_ahb_clk", 0x1B0, 4, GCC,
			0x1B0, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qspi_core_clk", 0x1B1, 4, GCC,
			0x1B1, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_core_2x_clk", 0x77, 4, GCC,
			0x77, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_core_clk", 0x76, 4, GCC,
			0x76, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s0_clk", 0x78, 4, GCC,
			0x78, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s1_clk", 0x79, 4, GCC,
			0x79, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s2_clk", 0x7A, 4, GCC,
			0x7A, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s3_clk", 0x7B, 4, GCC,
			0x7B, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s4_clk", 0x7C, 4, GCC,
			0x7C, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap0_s5_clk", 0x7D, 4, GCC,
			0x7D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_core_2x_clk", 0x80, 4, GCC,
			0x80, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_core_clk", 0x81, 4, GCC,
			0x81, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s0_clk", 0x84, 4, GCC,
			0x84, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s1_clk", 0x85, 4, GCC,
			0x85, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s2_clk", 0x86, 4, GCC,
			0x86, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s3_clk", 0x87, 4, GCC,
			0x87, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s4_clk", 0x88, 4, GCC,
			0x88, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap1_s5_clk", 0x89, 4, GCC,
			0x89, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap_0_m_ahb_clk", 0x74, 4, GCC,
			0x74, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap_0_s_ahb_clk", 0x75, 4, GCC,
			0x75, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap_1_m_ahb_clk", 0x82, 4, GCC,
			0x82, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_qupv3_wrap_1_s_ahb_clk", 0x83, 4, GCC,
			0x83, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sdcc1_ahb_clk", 0x15C, 4, GCC,
			0x15C, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sdcc1_apps_clk", 0x15B, 4, GCC,
			0x15B, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sdcc1_ice_core_clk", 0x15D, 4, GCC,
			0x15D, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sdcc2_ahb_clk", 0x71, 4, GCC,
			0x71, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sdcc2_apps_clk", 0x70, 4, GCC,
			0x70, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_sys_noc_cpuss_ahb_clk", 0xC, 4, GCC,
			0xC, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_ahb_clk", 0xFC, 4, GCC,
			0xFC, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_axi_clk", 0xFB, 4, GCC,
			0xFB, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_ice_core_clk", 0x102, 4, GCC,
			0x102, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_phy_aux_clk", 0x103, 4, GCC,
			0x103, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_rx_symbol_0_clk", 0xFE, 4, GCC,
			0xFE, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_tx_symbol_0_clk", 0xFD, 4, GCC,
			0xFD, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_ufs_phy_unipro_core_clk", 0x101, 4, GCC,
			0x101, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb30_prim_master_clk", 0x5F, 4, GCC,
			0x5F, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb30_prim_mock_utmi_clk", 0x61, 4, GCC,
			0x61, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb30_prim_sleep_clk", 0x60, 4, GCC,
			0x60, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb3_prim_phy_aux_clk", 0x62, 4, GCC,
			0x62, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb3_prim_phy_com_aux_clk", 0x63, 4, GCC,
			0x63, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb3_prim_phy_pipe_clk", 0x64, 4, GCC,
			0x64, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_usb_phy_cfg_ahb2phy_clk", 0x6F, 4, GCC,
			0x6F, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_video_ahb_clk", 0x39, 4, GCC,
			0x39, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_video_axi_clk", 0x3F, 4, GCC,
			0x3F, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_video_gpll0_div_clk_src", 0x18A, 4, GCC,
			0x18A, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_video_throttle_axi_clk", 0x1A9, 4, GCC,
			0x1A9, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gcc_video_xo_clk", 0x42, 4, GCC,
			0x42, 0x3FF, 0, 0xF, 0, 4, 0x62008, 0x62000, 0x62004 },
		{ "gpu_cc_acd_ahb_clk", 0x144, 4, GPU_CC,
			0x24, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_acd_cxo_clk", 0x144, 4, GPU_CC,
			0x1F, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_ahb_clk", 0x144, 4, GPU_CC,
			0x11, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_crc_ahb_clk", 0x144, 4, GPU_CC,
			0x12, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_apb_clk", 0x144, 4, GPU_CC,
			0x15, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gfx3d_clk", 0x144, 4, GPU_CC,
			0x1A, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gfx3d_slv_clk", 0x144, 4, GPU_CC,
			0x1B, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gmu_clk", 0x144, 4, GPU_CC,
			0x19, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_at_clk", 0x144, 4, GPU_CC,
			0x13, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_trig_clk", 0x144, 4, GPU_CC,
			0x18, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_tsctr_clk", 0x144, 4, GPU_CC,
			0x14, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_snoc_dvm_clk", 0x144, 4, GPU_CC,
			0x16, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cxo_aon_clk", 0x144, 4, GPU_CC,
			0xB, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cxo_clk", 0x144, 4, GPU_CC,
			0xA, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_cxo_clk", 0x144, 4, GPU_CC,
			0xF, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_gfx3d_clk", 0x144, 4, GPU_CC,
			0xC, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_gmu_clk", 0x144, 4, GPU_CC,
			0x10, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_qdss_tsctr_clk", 0x144, 4, GPU_CC,
			0xE, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_vsense_clk", 0x144, 4, GPU_CC,
			0xD, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_rbcpr_ahb_clk", 0x144, 4, GPU_CC,
			0x1D, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_rbcpr_clk", 0x144, 4, GPU_CC,
			0x1C, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_sleep_clk", 0x144, 4, GPU_CC,
			0x17, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "measure_only_mccc_clk", 0xC2, 1, MC_CC,
			0xC2, 0x3FF, 0, 0xF, 0, 1, 0x62008, 0x62000, 0x62004 },
		{ "measure_only_cnoc_clk", 0x15, 1, GCC,
			0x15, 0x3FF, 0, 0xF, 0, 1, 0x62008, 0x62000, 0x62004 },
		{ "measure_only_ipa_2x_clk", 0x128, 1, GCC,
			0x128, 0x3FF, 0, 0xF, 0, 1, 0x62008, 0x62000, 0x62004 },
		{ "measure_only_snoc_clk", 0x7, 1, GCC,
			0x7, 0x3FF, 0, 0xF, 0, 1, 0x62008, 0x62000, 0x62004 },
		{ "npu_cc_atb_clk", 0x16F, 4, NPU_CC,
			0x17, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_bto_core_clk", 0x16F, 4, NPU_CC,
			0x19, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_bwmon_clk", 0x16F, 4, NPU_CC,
			0x18, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_cal_hm0_cdc_clk", 0x16F, 4, NPU_CC,
			0xB, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_cal_hm0_clk", 0x16F, 4, NPU_CC,
			0x2, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_cal_hm0_perf_cnt_clk", 0x16F, 4, NPU_CC,
			0xD, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_core_clk", 0x16F, 4, NPU_CC,
			0x4, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_dsp_ahbm_clk", 0x16F, 4, NPU_CC,
			0x1C, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_dsp_ahbs_clk", 0x16F, 4, NPU_CC,
			0x1B, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_dsp_axi_clk", 0x16F, 4, NPU_CC,
			0x1E, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_noc_ahb_clk", 0x16F, 4, NPU_CC,
			0x13, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_noc_axi_clk", 0x16F, 4, NPU_CC,
			0x12, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_noc_dma_clk", 0x16F, 4, NPU_CC,
			0x11, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_rsc_xo_clk", 0x16F, 4, NPU_CC,
			0x1A, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_s2p_clk", 0x16F, 4, NPU_CC,
			0x16, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "npu_cc_xo_clk", 0x16F, 4, NPU_CC,
			0x1, 0xFF, 0, 0x3, 0, 2, 0x3000, 0x3004, 0x3008 },
		{ "video_cc_apb_clk", 0x48, 4, VIDEO_CC,
			0xA, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_at_clk", 0x48, 4, VIDEO_CC,
			0xD, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_qdss_trig_clk", 0x48, 4, VIDEO_CC,
			0x9, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_qdss_tsctr_div8_clk", 0x48, 4, VIDEO_CC,
			0xC, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_sleep_clk", 0x48, 4, VIDEO_CC,
			0x6, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_vcodec0_axi_clk", 0x48, 4, VIDEO_CC,
			0x8, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_vcodec0_core_clk", 0x48, 4, VIDEO_CC,
			0x3, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_venus_ahb_clk", 0x48, 4, VIDEO_CC,
			0xB, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_venus_ctl_axi_clk", 0x48, 4, VIDEO_CC,
			0x7, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_venus_ctl_core_clk", 0x48, 4, VIDEO_CC,
			0x1, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "video_cc_xo_clk", 0x48, 4, VIDEO_CC,
			0x5, 0x3F, 0, 0x7, 0, 5, 0xACC, 0x938, 0x940 },
		{ "l3_clk", 0xD6, 4, CPU_CC,
			0x46, 0x7F, 4, 0xF, 11, 1, 0x0, 0x0, U32_MAX, 16 },
		{ "pwrcl_clk", 0xD6, 4, CPU_CC,
			0x44, 0x7F, 4, 0xF, 11, 1, 0x0, 0x0, U32_MAX, 16 },
		{ "perfcl_clk", 0xD6, 4, CPU_CC,
			0x45, 0x7F, 4, 0xF, 11, 1, 0x0, 0x0, U32_MAX, 16 },
	),
	.hw.init = &(struct clk_init_data){
		.name = "gcc_debug_mux",
		.ops = &clk_debug_mux_ops,
		.parent_names = debug_mux_parent_names,
		.num_parents = ARRAY_SIZE(debug_mux_parent_names),
		.flags = CLK_IS_MEASURE,
	},
};

static const struct of_device_id clk_debug_match_table[] = {
	{ .compatible = "qcom,atoll-debugcc" },
	{ }
};

static int map_debug_bases(struct platform_device *pdev, char *base, int cc)
{
	if (!of_get_property(pdev->dev.of_node, base, NULL))
		return -ENODEV;

	gcc_debug_mux.regmap[cc] =
		syscon_regmap_lookup_by_phandle(pdev->dev.of_node, base);
	if (IS_ERR(gcc_debug_mux.regmap[cc])) {
		pr_err("Failed to map %s (ret=%ld)\n", base,
				PTR_ERR(gcc_debug_mux.regmap[cc]));
		return PTR_ERR(gcc_debug_mux.regmap[cc]);
	}
	return 0;
}

static int clk_debug_atoll_probe(struct platform_device *pdev)
{
	struct clk *clk;
	int ret, count;

	clk = devm_clk_get(&pdev->dev, "xo_clk_src");
	if (IS_ERR(clk)) {
		if (PTR_ERR(clk) != -EPROBE_DEFER)
			dev_err(&pdev->dev, "Unable to get xo clock\n");
		return PTR_ERR(clk);
	}

	debug_mux_priv.cxo = clk;

	ret = of_property_read_u32(pdev->dev.of_node, "qcom,cc-count",
								&count);
	if (ret < 0) {
		dev_err(&pdev->dev, "Num of debug clock controller not specified\n");
		return ret;
	}

	if (!count) {
		dev_err(&pdev->dev, "Count of CC cannot be zero\n");
		return -EINVAL;
	}

	gcc_debug_mux.regmap = devm_kzalloc(&pdev->dev,
			sizeof(struct regmap *) * count, GFP_KERNEL);
	if (!gcc_debug_mux.regmap)
		return -ENOMEM;

	ret = map_debug_bases(pdev, "qcom,gcc", GCC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,dispcc", DISP_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,npucc", NPU_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,videocc", VIDEO_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,camcc", CAM_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,gpucc", GPU_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,cpucc", CPU_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,mccc", MC_CC);
	if (ret)
		return ret;

	clk = devm_clk_register(&pdev->dev, &gcc_debug_mux.hw);
	if (IS_ERR(clk)) {
		dev_err(&pdev->dev, "Unable to register GCC debug mux\n");
		return PTR_ERR(clk);
	}

	ret = clk_debug_measure_register(&gcc_debug_mux.hw);
	if (ret)
		dev_err(&pdev->dev, "Could not register Measure clock\n");
	else
		dev_info(&pdev->dev, "Registered debug mux successfully\n");

	return ret;
}

static struct platform_driver clk_debug_driver = {
	.probe = clk_debug_atoll_probe,
	.driver = {
		.name = "atoll-debugcc",
		.of_match_table = clk_debug_match_table,
	},
};

int __init clk_debug_atoll_init(void)
{
	return platform_driver_register(&clk_debug_driver);
}
fs_initcall(clk_debug_atoll_init);

MODULE_DESCRIPTION("QTI DEBUG CC atoll Driver");
MODULE_LICENSE("GPL v2");
MODULE_ALIAS("platform:atoll-debugcc");
