/*
 * Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#define pr_fmt(fmt) "clk: %s: " fmt, __func__

#include <linux/kernel.h>
#include <linux/err.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/of_device.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/regmap.h>
#include <linux/mfd/syscon.h>

#include "clk-debug.h"

static struct measure_clk_data debug_mux_priv = {
	.ctl_reg = 0x62038,
	.status_reg = 0x6203C,
	.xo_div4_cbcr = 0x43008,
};

static const char *const debug_mux_parent_names[] = {
	"cam_cc_bps_ahb_clk",
	"cam_cc_bps_areg_clk",
	"cam_cc_bps_axi_clk",
	"cam_cc_bps_clk",
	"cam_cc_camnoc_atb_clk",
	"cam_cc_camnoc_axi_clk",
	"cam_cc_cci_clk",
	"cam_cc_core_ahb_clk",
	"cam_cc_cpas_ahb_clk",
	"cam_cc_csi0phytimer_clk",
	"cam_cc_csi1phytimer_clk",
	"cam_cc_csi2phytimer_clk",
	"cam_cc_csiphy0_clk",
	"cam_cc_csiphy1_clk",
	"cam_cc_csiphy2_clk",
	"cam_cc_icp_apb_clk",
	"cam_cc_icp_atb_clk",
	"cam_cc_icp_clk",
	"cam_cc_icp_cti_clk",
	"cam_cc_icp_ts_clk",
	"cam_cc_ife_0_axi_clk",
	"cam_cc_ife_0_clk",
	"cam_cc_ife_0_cphy_rx_clk",
	"cam_cc_ife_0_csid_clk",
	"cam_cc_ife_0_dsp_clk",
	"cam_cc_ife_1_axi_clk",
	"cam_cc_ife_1_clk",
	"cam_cc_ife_1_cphy_rx_clk",
	"cam_cc_ife_1_csid_clk",
	"cam_cc_ife_1_dsp_clk",
	"cam_cc_ife_lite_clk",
	"cam_cc_ife_lite_cphy_rx_clk",
	"cam_cc_ife_lite_csid_clk",
	"cam_cc_ipe_0_ahb_clk",
	"cam_cc_ipe_0_areg_clk",
	"cam_cc_ipe_0_axi_clk",
	"cam_cc_ipe_0_clk",
	"cam_cc_jpeg_clk",
	"cam_cc_lrme_clk",
	"cam_cc_mclk0_clk",
	"cam_cc_mclk1_clk",
	"cam_cc_mclk2_clk",
	"cam_cc_mclk3_clk",
	"cam_cc_soc_ahb_clk",
	"cam_cc_spdm_bps_clk",
	"cam_cc_spdm_ife_0_clk",
	"cam_cc_spdm_ife_0_csid_clk",
	"cam_cc_spdm_ipe_0_clk",
	"cam_cc_spdm_jpeg_clk",
	"cam_cc_sys_tmr_clk",
	"disp_cc_mdss_ahb_clk",
	"disp_cc_mdss_byte0_clk",
	"disp_cc_mdss_byte0_intf_clk",
	"disp_cc_mdss_dp_aux_clk",
	"disp_cc_mdss_dp_crypto_clk",
	"disp_cc_mdss_dp_link_clk",
	"disp_cc_mdss_dp_link_intf_clk",
	"disp_cc_mdss_dp_pixel1_clk",
	"disp_cc_mdss_dp_pixel_clk",
	"disp_cc_mdss_esc0_clk",
	"disp_cc_mdss_mdp_clk",
	"disp_cc_mdss_mdp_lut_clk",
	"disp_cc_mdss_non_gdsc_ahb_clk",
	"disp_cc_mdss_pclk0_clk",
	"disp_cc_mdss_rot_clk",
	"disp_cc_mdss_rscc_ahb_clk",
	"disp_cc_mdss_rscc_vsync_clk",
	"disp_cc_mdss_spdm_dp_crypto_clk",
	"disp_cc_mdss_spdm_dp_pixel1_clk",
	"disp_cc_mdss_spdm_dp_pixel_clk",
	"disp_cc_mdss_spdm_mdp_clk",
	"disp_cc_mdss_spdm_pclk0_clk",
	"disp_cc_mdss_spdm_rot_clk",
	"disp_cc_mdss_vsync_clk",
	"disp_cc_sleep_clk",
	"disp_cc_xo_clk",
	"gcc_aggre_ufs_phy_axi_clk",
	"gcc_aggre_usb2_sec_axi_clk",
	"gcc_aggre_usb3_prim_axi_clk",
	"gcc_ahb2phy_east_clk",
	"gcc_ahb2phy_west_clk",
	"gcc_apc_vs_clk",
	"gcc_boot_rom_ahb_clk",
	"gcc_camera_ahb_clk",
	"gcc_camera_hf_axi_clk",
	"gcc_camera_xo_clk",
	"gcc_ce1_ahb_clk",
	"gcc_ce1_axi_clk",
	"gcc_ce1_clk",
	"gcc_cfg_noc_usb2_sec_axi_clk",
	"gcc_cfg_noc_usb3_prim_axi_clk",
	"gcc_cpuss_ahb_clk",
	"gcc_cpuss_gnoc_clk",
	"gcc_ddrss_gpu_axi_clk",
	"gcc_disp_ahb_clk",
	"gcc_disp_gpll0_div_clk_src",
	"gcc_disp_hf_axi_clk",
	"gcc_disp_xo_clk",
	"gcc_emac_axi_clk",
	"gcc_emac_ptp_clk",
	"gcc_emac_rgmii_clk",
	"gcc_emac_slv_ahb_clk",
	"gcc_gp1_clk",
	"gcc_gp2_clk",
	"gcc_gp3_clk",
	"gcc_gpu_cfg_ahb_clk",
	"gcc_gpu_gpll0_clk_src",
	"gcc_gpu_gpll0_div_clk_src",
	"gcc_gpu_memnoc_gfx_clk",
	"gcc_gpu_snoc_dvm_gfx_clk",
	"gcc_mss_axis2_clk",
	"gcc_mss_cfg_ahb_clk",
	"gcc_mss_gpll0_div_clk_src",
	"gcc_mss_mfab_axis_clk",
	"gcc_mss_q6_memnoc_axi_clk",
	"gcc_mss_snoc_axi_clk",
	"gcc_mss_vs_clk",
	"gcc_pcie0_phy_refgen_clk",
	"gcc_pcie_0_aux_clk",
	"gcc_pcie_0_cfg_ahb_clk",
	"gcc_pcie_0_mstr_axi_clk",
	"gcc_pcie_0_pipe_clk",
	"gcc_pcie_0_slv_axi_clk",
	"gcc_pcie_0_slv_q2a_axi_clk",
	"gcc_pcie_phy_aux_clk",
	"gcc_pdm2_clk",
	"gcc_pdm_ahb_clk",
	"gcc_pdm_xo4_clk",
	"gcc_prng_ahb_clk",
	"gcc_qmip_camera_nrt_ahb_clk",
	"gcc_qmip_disp_ahb_clk",
	"gcc_qmip_pcie_ahb_clk",
	"gcc_qmip_video_vcodec_ahb_clk",
	"gcc_qspi_cnoc_periph_ahb_clk",
	"gcc_qspi_core_clk",
	"gcc_qupv3_wrap0_core_2x_clk",
	"gcc_qupv3_wrap0_core_clk",
	"gcc_qupv3_wrap0_s0_clk",
	"gcc_qupv3_wrap0_s1_clk",
	"gcc_qupv3_wrap0_s2_clk",
	"gcc_qupv3_wrap0_s3_clk",
	"gcc_qupv3_wrap0_s4_clk",
	"gcc_qupv3_wrap0_s5_clk",
	"gcc_qupv3_wrap1_core_2x_clk",
	"gcc_qupv3_wrap1_core_clk",
	"gcc_qupv3_wrap1_s0_clk",
	"gcc_qupv3_wrap1_s1_clk",
	"gcc_qupv3_wrap1_s2_clk",
	"gcc_qupv3_wrap1_s3_clk",
	"gcc_qupv3_wrap1_s4_clk",
	"gcc_qupv3_wrap1_s5_clk",
	"gcc_qupv3_wrap_0_m_ahb_clk",
	"gcc_qupv3_wrap_0_s_ahb_clk",
	"gcc_qupv3_wrap_1_m_ahb_clk",
	"gcc_qupv3_wrap_1_s_ahb_clk",
	"gcc_sdcc1_ahb_clk",
	"gcc_sdcc1_apps_clk",
	"gcc_sdcc1_ice_core_clk",
	"gcc_sdcc2_ahb_clk",
	"gcc_sdcc2_apps_clk",
	"gcc_sys_noc_cpuss_ahb_clk",
	"gcc_ufs_phy_ahb_clk",
	"gcc_ufs_phy_axi_clk",
	"gcc_ufs_phy_ice_core_clk",
	"gcc_ufs_phy_phy_aux_clk",
	"gcc_ufs_phy_rx_symbol_0_clk",
	"gcc_ufs_phy_tx_symbol_0_clk",
	"gcc_ufs_phy_unipro_core_clk",
	"gcc_usb20_sec_master_clk",
	"gcc_usb20_sec_mock_utmi_clk",
	"gcc_usb20_sec_sleep_clk",
	"gcc_usb2_sec_phy_aux_clk",
	"gcc_usb2_sec_phy_com_aux_clk",
	"gcc_usb2_sec_phy_pipe_clk",
	"gcc_usb30_prim_master_clk",
	"gcc_usb30_prim_mock_utmi_clk",
	"gcc_usb30_prim_sleep_clk",
	"gcc_usb3_prim_phy_aux_clk",
	"gcc_usb3_prim_phy_com_aux_clk",
	"gcc_usb3_prim_phy_pipe_clk",
	"gcc_vdda_vs_clk",
	"gcc_vddcx_vs_clk",
	"gcc_vddmx_vs_clk",
	"gcc_video_ahb_clk",
	"gcc_video_axi0_clk",
	"gcc_video_xo_clk",
	"gcc_vs_ctrl_ahb_clk",
	"gcc_vs_ctrl_clk",
	"gcc_wcss_vs_clk",
	"gpu_cc_ahb_clk",
	"gpu_cc_crc_ahb_clk",
	"gpu_cc_cx_apb_clk",
	"gpu_cc_cx_gfx3d_clk",
	"gpu_cc_cx_gfx3d_slv_clk",
	"gpu_cc_cx_gmu_clk",
	"gpu_cc_cx_qdss_at_clk",
	"gpu_cc_cx_qdss_trig_clk",
	"gpu_cc_cx_qdss_tsctr_clk",
	"gpu_cc_cx_snoc_dvm_clk",
	"gpu_cc_cxo_aon_clk",
	"gpu_cc_cxo_clk",
	"gpu_cc_gx_cxo_clk",
	"gpu_cc_gx_gfx3d_clk",
	"gpu_cc_gx_gmu_clk",
	"gpu_cc_gx_qdss_tsctr_clk",
	"gpu_cc_gx_vsense_clk",
	"gpu_cc_sleep_clk",
	"measure_only_mccc_clk",
	"measure_only_cnoc_clk",
	"measure_only_ipa_2x_clk",
	"measure_only_snoc_clk",
	"video_cc_apb_clk",
	"video_cc_at_clk",
	"video_cc_qdss_trig_clk",
	"video_cc_qdss_tsctr_div8_clk",
	"video_cc_sleep_clk",
	"video_cc_vcodec0_axi_clk",
	"video_cc_vcodec0_core_clk",
	"video_cc_venus_ahb_clk",
	"video_cc_venus_ctl_axi_clk",
	"video_cc_venus_ctl_core_clk",
	"video_cc_xo_clk",
	"l3_clk",
	"pwrcl_clk",
	"perfcl_clk",
};

static struct clk_debug_mux gcc_debug_mux = {
	.priv = &debug_mux_priv,
	.debug_offset = 0x62000,
	.post_div_offset = 0x62004,
	.cbcr_offset = 0x62008,
	.src_sel_mask = 0x3FF,
	.src_sel_shift = 0,
	.post_div_mask = 0xF,
	.post_div_shift = 0,
	.period_offset = 0x50,
	MUX_SRC_LIST(
		{ "cam_cc_bps_ahb_clk", 0x46, 1, CAM_CC,
			0xE, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_bps_areg_clk", 0x46, 1, CAM_CC,
			0xD, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_bps_axi_clk", 0x46, 1, CAM_CC,
			0xC, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_bps_clk", 0x46, 1, CAM_CC,
			0xB, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_camnoc_atb_clk", 0x46, 1, CAM_CC,
			0x34, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_camnoc_axi_clk", 0x46, 1, CAM_CC,
			0x2D, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_cci_clk", 0x46, 1, CAM_CC,
			0x2A, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_core_ahb_clk", 0x46, 1, CAM_CC,
			0x3A, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_cpas_ahb_clk", 0x46, 1, CAM_CC,
			0x2C, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csi0phytimer_clk", 0x46, 1, CAM_CC,
			0x5, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csi1phytimer_clk", 0x46, 1, CAM_CC,
			0x7, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csi2phytimer_clk", 0x46, 1, CAM_CC,
			0x9, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy0_clk", 0x46, 1, CAM_CC,
			0x6, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy1_clk", 0x46, 1, CAM_CC,
			0x8, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_csiphy2_clk", 0x46, 1, CAM_CC,
			0xA, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_icp_apb_clk", 0x46, 1, CAM_CC,
			0x32, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_icp_atb_clk", 0x46, 1, CAM_CC,
			0x2F, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_icp_clk", 0x46, 1, CAM_CC,
			0x26, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_icp_cti_clk", 0x46, 1, CAM_CC,
			0x30, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_icp_ts_clk", 0x46, 1, CAM_CC,
			0x31, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_axi_clk", 0x46, 1, CAM_CC,
			0x1B, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_clk", 0x46, 1, CAM_CC,
			0x17, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_cphy_rx_clk", 0x46, 1, CAM_CC,
			0x1A, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_csid_clk", 0x46, 1, CAM_CC,
			0x19, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_0_dsp_clk", 0x46, 1, CAM_CC,
			0x18, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_axi_clk", 0x46, 1, CAM_CC,
			0x21, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_clk", 0x46, 1, CAM_CC,
			0x1D, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_cphy_rx_clk", 0x46, 1, CAM_CC,
			0x20, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_csid_clk", 0x46, 1, CAM_CC,
			0x1F, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_1_dsp_clk", 0x46, 1, CAM_CC,
			0x1E, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_clk", 0x46, 1, CAM_CC,
			0x22, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_cphy_rx_clk", 0x46, 1, CAM_CC,
			0x24, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ife_lite_csid_clk", 0x46, 1, CAM_CC,
			0x23, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_ahb_clk", 0x46, 1, CAM_CC,
			0x12, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_areg_clk", 0x46, 1, CAM_CC,
			0x11, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_axi_clk", 0x46, 1, CAM_CC,
			0x10, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_ipe_0_clk", 0x46, 1, CAM_CC,
			0xF, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_jpeg_clk", 0x46, 1, CAM_CC,
			0x25, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_lrme_clk", 0x46, 1, CAM_CC,
			0x2B, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_mclk0_clk", 0x46, 1, CAM_CC,
			0x1, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_mclk1_clk", 0x46, 1, CAM_CC,
			0x2, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_mclk2_clk", 0x46, 1, CAM_CC,
			0x3, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_mclk3_clk", 0x46, 1, CAM_CC,
			0x4, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_soc_ahb_clk", 0x46, 1, CAM_CC,
			0x2E, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_spdm_bps_clk", 0x46, 1, CAM_CC,
			0x35, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_spdm_ife_0_clk", 0x46, 1, CAM_CC,
			0x37, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_spdm_ife_0_csid_clk", 0x46, 1, CAM_CC,
			0x38, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_spdm_ipe_0_clk", 0x46, 1, CAM_CC,
			0x36, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_spdm_jpeg_clk", 0x46, 1, CAM_CC,
			0x39, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "cam_cc_sys_tmr_clk", 0x46, 1, CAM_CC,
			0x33, 0xFF, 0, 0x3, 0, 2, 0xC000, 0xC004, 0xC008 },
		{ "disp_cc_mdss_ahb_clk", 0x47, 1, DISP_CC,
			0x1B, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_byte0_clk", 0x47, 1, DISP_CC,
			0x12, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_byte0_intf_clk", 0x47, 1, DISP_CC,
			0x13, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_aux_clk", 0x47, 1, DISP_CC,
			0x1A, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_crypto_clk", 0x47, 1, DISP_CC,
			0x17, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_link_clk", 0x47, 1, DISP_CC,
			0x15, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_link_intf_clk", 0x47, 1, DISP_CC,
			0x16, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_pixel1_clk", 0x47, 1, DISP_CC,
			0x19, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_dp_pixel_clk", 0x47, 1, DISP_CC,
			0x18, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_esc0_clk", 0x47, 1, DISP_CC,
			0x14, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_mdp_clk", 0x47, 1, DISP_CC,
			0xE, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_mdp_lut_clk", 0x47, 1, DISP_CC,
			0x10, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_non_gdsc_ahb_clk", 0x47, 1, DISP_CC,
			0x1C, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_pclk0_clk", 0x47, 1, DISP_CC,
			0xD, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rot_clk", 0x47, 1, DISP_CC,
			0xF, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rscc_ahb_clk", 0x47, 1, DISP_CC,
			0x1E, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_rscc_vsync_clk", 0x47, 1, DISP_CC,
			0x1D, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_dp_crypto_clk", 0x47, 1, DISP_CC,
			0x22, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_dp_pixel1_clk", 0x47, 1, DISP_CC,
			0x24, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_dp_pixel_clk", 0x47, 1, DISP_CC,
			0x23, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_mdp_clk", 0x47, 1, DISP_CC,
			0x20, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_pclk0_clk", 0x47, 1, DISP_CC,
			0x1F, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_spdm_rot_clk", 0x47, 1, DISP_CC,
			0x21, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_mdss_vsync_clk", 0x47, 1, DISP_CC,
			0x11, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_sleep_clk", 0x47, 1, DISP_CC,
			0x26, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "disp_cc_xo_clk", 0x47, 1, DISP_CC,
			0x25, 0xFF, 0, 0x3, 0, 4, 0x7000, 0x5008, 0x500C },
		{ "gcc_aggre_ufs_phy_axi_clk", 0x11D, 1, GCC,
			0x11D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_aggre_usb2_sec_axi_clk", 0x1C8, 1, GCC,
			0x1C8, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_aggre_usb3_prim_axi_clk", 0x11B, 1, GCC,
			0x11B, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ahb2phy_east_clk", 0x73, 1, GCC,
			0x73, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ahb2phy_west_clk", 0x6F, 1, GCC,
			0x6F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_apc_vs_clk", 0x1B9, 1, GCC,
			0x1B9, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_boot_rom_ahb_clk", 0x94, 1, GCC,
			0x94, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_camera_ahb_clk", 0x3A, 1, GCC,
			0x3A, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_camera_hf_axi_clk", 0x40, 1, GCC,
			0x40, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_camera_xo_clk", 0x43, 1, GCC,
			0x43, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ce1_ahb_clk", 0xA9, 1, GCC,
			0xA9, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ce1_axi_clk", 0xA8, 1, GCC,
			0xA8, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ce1_clk", 0xA7, 1, GCC,
			0xA7, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_cfg_noc_usb2_sec_axi_clk", 0x1C7, 1, GCC,
			0x1C7, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_cfg_noc_usb3_prim_axi_clk", 0x1D, 1, GCC,
			0x1D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_cpuss_ahb_clk", 0xCE, 1, GCC,
			0xCE, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_cpuss_gnoc_clk", 0xCF, 1, GCC,
			0xCF, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ddrss_gpu_axi_clk", 0xBB, 1, GCC,
			0xBB, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_disp_ahb_clk", 0x3B, 1, GCC,
			0x3B, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_disp_gpll0_div_clk_src", 0x152, 1, GCC,
			0x152, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_disp_hf_axi_clk", 0x41, 1, GCC,
			0x41, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_disp_xo_clk", 0x44, 1, GCC,
			0x44, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_emac_axi_clk", 0x16D, 1, GCC,
			0x16D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_emac_ptp_clk", 0x1D3, 1, GCC,
			0x1D3, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_emac_rgmii_clk", 0x16A, 1, GCC,
			0x16A, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_emac_slv_ahb_clk", 0x16C, 1, GCC,
			0x16C, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gp1_clk", 0xDE, 1, GCC,
			0xDE, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gp2_clk", 0xDF, 1, GCC,
			0xDF, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gp3_clk", 0xE0, 1, GCC,
			0xE0, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gpu_cfg_ahb_clk", 0x142, 1, GCC,
			0x142, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gpu_gpll0_clk_src", 0x148, 1, GCC,
			0x148, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gpu_gpll0_div_clk_src", 0x149, 1, GCC,
			0x149, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gpu_memnoc_gfx_clk", 0x145, 1, GCC,
			0x145, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_gpu_snoc_dvm_gfx_clk", 0x147, 1, GCC,
			0x147, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_axis2_clk", 0x12F, 1, GCC,
			0x12F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_cfg_ahb_clk", 0x12D, 1, GCC,
			0x12D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_gpll0_div_clk_src", 0x133, 1, GCC,
			0x133, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_mfab_axis_clk", 0x12E, 1, GCC,
			0x12E, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_q6_memnoc_axi_clk", 0x135, 1, GCC,
			0x135, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_snoc_axi_clk", 0x134, 1, GCC,
			0x134, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_mss_vs_clk", 0x111, 1, GCC,
			0x111, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie0_phy_refgen_clk", 0x1F3, 1, GCC,
			0x1F3, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_aux_clk", 0xE5, 1, GCC,
			0xE5, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_cfg_ahb_clk", 0xE4, 1, GCC,
			0xE4, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_mstr_axi_clk", 0xE3, 1, GCC,
			0xE3, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_pipe_clk", 0xE6, 1, GCC,
			0xE6, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_slv_axi_clk", 0xE2, 1, GCC,
			0xE2, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_0_slv_q2a_axi_clk", 0xE1, 1, GCC,
			0xE1, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pcie_phy_aux_clk", 0xEF, 1, GCC,
			0xEF, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pdm2_clk", 0x8E, 1, GCC,
			0x8E, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pdm_ahb_clk", 0x8C, 1, GCC,
			0x8C, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_pdm_xo4_clk", 0x8D, 1, GCC,
			0x8D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_prng_ahb_clk", 0x8F, 1, GCC,
			0x8F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qmip_camera_nrt_ahb_clk", 0x3D, 1, GCC,
			0x3D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qmip_disp_ahb_clk", 0x3E, 1, GCC,
			0x3E, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qmip_pcie_ahb_clk", 0xE8, 1, GCC,
			0xE8, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qmip_video_vcodec_ahb_clk", 0x15C, 1, GCC,
			0x15C, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qspi_cnoc_periph_ahb_clk", 0x168, 1, GCC,
			0x168, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qspi_core_clk", 0x169, 1, GCC,
			0x169, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_core_2x_clk", 0x77, 1, GCC,
			0x77, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_core_clk", 0x76, 1, GCC,
			0x76, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s0_clk", 0x78, 1, GCC,
			0x78, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s1_clk", 0x79, 1, GCC,
			0x79, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s2_clk", 0x7A, 1, GCC,
			0x7A, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s3_clk", 0x7B, 1, GCC,
			0x7B, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s4_clk", 0x7C, 1, GCC,
			0x7C, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap0_s5_clk", 0x7D, 1, GCC,
			0x7D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_core_2x_clk", 0x194, 1, GCC,
			0x194, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_core_clk", 0x193, 1, GCC,
			0x193, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s0_clk", 0x195, 1, GCC,
			0x195, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s1_clk", 0x196, 1, GCC,
			0x196, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s2_clk", 0x197, 1, GCC,
			0x197, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s3_clk", 0x198, 1, GCC,
			0x198, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s4_clk", 0x199, 1, GCC,
			0x199, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap1_s5_clk", 0x19A, 1, GCC,
			0x19A, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap_0_m_ahb_clk", 0x74, 1, GCC,
			0x74, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap_0_s_ahb_clk", 0x75, 1, GCC,
			0x75, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap_1_m_ahb_clk", 0x191, 1, GCC,
			0x191, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_qupv3_wrap_1_s_ahb_clk", 0x192, 1, GCC,
			0x192, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sdcc1_ahb_clk", 0x1F0, 1, GCC,
			0x1F0, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sdcc1_apps_clk", 0x1CB, 1, GCC,
			0x1CB, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sdcc1_ice_core_clk", 0x185, 1, GCC,
			0x185, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sdcc2_ahb_clk", 0x71, 1, GCC,
			0x71, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sdcc2_apps_clk", 0x70, 1, GCC,
			0x70, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_sys_noc_cpuss_ahb_clk", 0xC, 1, GCC,
			0xC, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_ahb_clk", 0xFC, 1, GCC,
			0xFC, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_axi_clk", 0xFB, 1, GCC,
			0xFB, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_ice_core_clk", 0x102, 1, GCC,
			0x102, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_phy_aux_clk", 0x103, 1, GCC,
			0x103, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_rx_symbol_0_clk", 0xFE, 1, GCC,
			0xFE, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_tx_symbol_0_clk", 0xFD, 1, GCC,
			0xFD, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_ufs_phy_unipro_core_clk", 0x101, 1, GCC,
			0x101, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb20_sec_master_clk", 0x1AF, 1, GCC,
			0x1AF, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb20_sec_mock_utmi_clk", 0x1B1, 1, GCC,
			0x1B1, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb20_sec_sleep_clk", 0x1B0, 1, GCC,
			0x1B0, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb2_sec_phy_aux_clk", 0x1BD, 1, GCC,
			0x1BD, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb2_sec_phy_com_aux_clk", 0x1BE, 1, GCC,
			0x1BE, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb2_sec_phy_pipe_clk", 0x1BF, 1, GCC,
			0x1BF, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb30_prim_master_clk", 0x5F, 1, GCC,
			0x5F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb30_prim_mock_utmi_clk", 0x61, 1, GCC,
			0x61, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb30_prim_sleep_clk", 0x60, 1, GCC,
			0x60, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb3_prim_phy_aux_clk", 0x62, 1, GCC,
			0x62, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb3_prim_phy_com_aux_clk", 0x63, 1, GCC,
			0x63, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_usb3_prim_phy_pipe_clk", 0x64, 1, GCC,
			0x64, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_vdda_vs_clk", 0x10E, 1, GCC,
			0x10E, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_vddcx_vs_clk", 0x10C, 1, GCC,
			0x10C, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_vddmx_vs_clk", 0x10D, 1, GCC,
			0x10D, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_video_ahb_clk", 0x39, 1, GCC,
			0x39, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_video_axi0_clk", 0x3F, 1, GCC,
			0x3F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_video_xo_clk", 0x42, 1, GCC,
			0x42, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_vs_ctrl_ahb_clk", 0x110, 1, GCC,
			0x110, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_vs_ctrl_clk", 0x10F, 1, GCC,
			0x10F, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gcc_wcss_vs_clk", 0x113, 1, GCC,
			0x113, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "gpu_cc_ahb_clk", 0x144, 1, GPU_CC,
			0x10, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_crc_ahb_clk", 0x144, 1, GPU_CC,
			0x11, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_apb_clk", 0x144, 1, GPU_CC,
			0x14, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gfx3d_clk", 0x144, 1, GPU_CC,
			0x1A, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gfx3d_slv_clk", 0x144, 1, GPU_CC,
			0x1B, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_gmu_clk", 0x144, 1, GPU_CC,
			0x18, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_at_clk", 0x144, 1, GPU_CC,
			0x12, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_trig_clk", 0x144, 1, GPU_CC,
			0x17, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_qdss_tsctr_clk", 0x144, 1, GPU_CC,
			0x13, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cx_snoc_dvm_clk", 0x144, 1, GPU_CC,
			0x15, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cxo_aon_clk", 0x144, 1, GPU_CC,
			0xA, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_cxo_clk", 0x144, 1, GPU_CC,
			0x19, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_cxo_clk", 0x144, 1, GPU_CC,
			0xE, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_gfx3d_clk", 0x144, 1, GPU_CC,
			0xB, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_gmu_clk", 0x144, 1, GPU_CC,
			0xF, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_qdss_tsctr_clk", 0x144, 1, GPU_CC,
			0xD, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_gx_vsense_clk", 0x144, 1, GPU_CC,
			0xC, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "gpu_cc_sleep_clk", 0x144, 1, GPU_CC,
			0x16, 0xFF, 0, 0x3, 0, 2, 0x1568, 0x10FC, 0x1100 },
		{ "measure_only_mccc_clk", 0xC2, 1, MC_CC,
			0xC2, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "measure_only_cnoc_clk", 0x15, 1, GCC,
			0x15, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "measure_only_ipa_2x_clk", 0x128, 1, GCC,
			0x128, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "measure_only_snoc_clk", 0x7, 1, GCC,
			0x7, 0x3FF, 0, 0xF, 0, 1, 0x62000, 0x62004, 0x62008 },
		{ "video_cc_apb_clk", 0x48, 1, VIDEO_CC,
			0x8, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_at_clk", 0x48, 1, VIDEO_CC,
			0xB, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_qdss_trig_clk", 0x48, 1, VIDEO_CC,
			0x7, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_qdss_tsctr_div8_clk", 0x48, 1, VIDEO_CC,
			0xA, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_sleep_clk", 0x48, 1, VIDEO_CC,
			0xD, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_vcodec0_axi_clk", 0x48, 1, VIDEO_CC,
			0x6, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_vcodec0_core_clk", 0x48, 1, VIDEO_CC,
			0x3, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_venus_ahb_clk", 0x48, 1, VIDEO_CC,
			0x9, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_venus_ctl_axi_clk", 0x48, 1, VIDEO_CC,
			0x5, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_venus_ctl_core_clk", 0x48, 1, VIDEO_CC,
			0x1, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "video_cc_xo_clk", 0x48, 1, VIDEO_CC,
			0xC, 0x3F, 0, 0x7, 0, 5, 0xA4C, 0xA30, 0xA38 },
		{ "l3_clk", 0xD6, 4, CPU_CC,
			0x46, 0x7F, 4, 0xf, 11, 1, 0x0, 0x0, U32_MAX, 16 },
		{ "pwrcl_clk", 0xD6, 4, CPU_CC,
			0x44, 0x7F, 4, 0xf, 11, 1, 0x0, 0x0, U32_MAX, 16 },
		{ "perfcl_clk", 0xD6, 4, CPU_CC,
			0x45, 0x7F, 4, 0xf, 11, 1, 0x0, 0x0, U32_MAX, 16 },
	),
	.hw.init = &(struct clk_init_data){
		.name = "gcc_debug_mux",
		.ops = &clk_debug_mux_ops,
		.parent_names = debug_mux_parent_names,
		.num_parents = ARRAY_SIZE(debug_mux_parent_names),
		.flags = CLK_IS_MEASURE,
	},
};

static const struct of_device_id clk_debug_match_table[] = {
	{ .compatible = "qcom,debugcc-sm6150" },
	{ }
};

static int map_debug_bases(struct platform_device *pdev, char *base, int cc)
{
	if (!of_get_property(pdev->dev.of_node, base, NULL)) {
		pr_err("error in of_get prop\n");
		return -ENODEV;
	}

	gcc_debug_mux.regmap[cc] =
		syscon_regmap_lookup_by_phandle(pdev->dev.of_node,
				base);
	if (IS_ERR(gcc_debug_mux.regmap[cc])) {
		pr_err("Failed to map %s (ret=%ld)\n", base,
			PTR_ERR(gcc_debug_mux.regmap[cc]));
		return PTR_ERR(gcc_debug_mux.regmap[cc]);
	}

	return 0;
}

static int clk_debug_sm6150_probe(struct platform_device *pdev)
{
	struct clk *clk;
	int ret;

	clk = devm_clk_get(&pdev->dev, "cxo");
	if (IS_ERR(clk)) {
		if (PTR_ERR(clk) != -EPROBE_DEFER)
			dev_err(&pdev->dev, "Unable to get xo clock\n");
		return PTR_ERR(clk);
	}

	debug_mux_priv.cxo = clk;

	gcc_debug_mux.regmap = devm_kcalloc(&pdev->dev, MAX_NUM_CC,
				sizeof(*gcc_debug_mux.regmap), GFP_KERNEL);
	if (!gcc_debug_mux.regmap)
		return -ENOMEM;

	ret = map_debug_bases(pdev, "qcom,gcc", GCC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,videocc", VIDEO_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,gpucc", GPU_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,camcc", CAM_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,dispcc", DISP_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,cpucc", CPU_CC);
	if (ret)
		return ret;

	ret = map_debug_bases(pdev, "qcom,mccc", MC_CC);
	if (ret)
		return ret;

	clk = devm_clk_register(&pdev->dev, &gcc_debug_mux.hw);
	if (IS_ERR(clk)) {
		dev_err(&pdev->dev, "Unable to register GCC debug mux\n");
		return PTR_ERR(clk);
	}

	ret = clk_debug_measure_register(&gcc_debug_mux.hw);
	if (ret)
		dev_err(&pdev->dev, "Could not register Measure clock\n");

	return ret;
}

static struct platform_driver clk_debug_driver = {
	.probe = clk_debug_sm6150_probe,
	.driver = {
		.name = "debugcc-sm6150",
		.of_match_table = clk_debug_match_table,
		.owner = THIS_MODULE,
	},
};

int __init clk_debug_sm6150_init(void)
{
	return platform_driver_register(&clk_debug_driver);
}
fs_initcall(clk_debug_sm6150_init);

MODULE_DESCRIPTION("QTI DEBUG CC sm6150 Driver");
MODULE_LICENSE("GPL v2");
MODULE_ALIAS("platform:debugcc-sm6150");
