/*
 * vtz Valeo TrustZone user interface for Qualcomm MSM9640 SoC
 *
 *   Copyright (C) 2016 Valeo peiker Telematik GmbH
 *
 *   Author: Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */


/**************************/
/* public user mode types */
/**************************/

#define VTZ_RSA_KEYBLOB_SIZE     1656
#define VTZ_RSA_MODULUS_MAX      (512+16)
#define VTZ_STORAGE_KEYBLOB_SIZE 56

enum vtz_rsa_digest_padding_t {
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_256	= 1,
	VTZ_RSA_DIGEST_PADDING_PSS_SHA2_256	= 2,
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_384	= 3,
	VTZ_RSA_DIGEST_PADDING_PKCS115_SHA2_512	= 4
};

enum vtz_ioctl_cmd_t {
	VTZ_IOCTL_STORAGE_REGISTER	= 0xF0000010,
	VTZ_IOCTL_STORAGE_GENERATE,
	VTZ_IOCTL_STORAGE_SEAL,
	VTZ_IOCTL_STORAGE_UNSEAL,
	VTZ_IOCTL_RSA_REGISTER		= 0xF0000020,
	VTZ_IOCTL_RSA_GENERATE,
	VTZ_IOCTL_RSA_SIGN,
	VTZ_IOCTL_RSA_VERIFY,
	VTZ_IOCTL_RSA_EXPORT,
	VTZ_IOCTL_RSA_SIGN_MHASH,
	VTZ_IOCTL_RSA_IMPORT,
};

typedef struct {
	void*		addr;
	size_t		size;
} vtz_memory_t;

typedef struct {
	uint64_t	transaction_challenge;
} vtz_ioctl_register_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
} vtz_ioctl_storage_generate_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	sealed;
	vtz_memory_t	unsealed;
} vtz_ioctl_storage_seal_unseal_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	uint64_t	public_exponent;	// e.g. 65537
	int		digest_pad_type;	// DIGEST_PADDING_NONE=0, PKCS115_SHA2_256=1, PSS_SHA2_256=2
	uint16_t	modulus_bitlen;		// e.g. 4096
} vtz_ioctl_rsa_generate_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	data;
	vtz_memory_t	signature;
} vtz_ioctl_rsa_sign_verify_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	modulus;
	uint64_t	public_exponent;	// e.g. 65537
} vtz_ioctl_rsa_export_t;

typedef struct {
	uint64_t	transaction;
	vtz_memory_t	keyblob;
	vtz_memory_t	modulus;
	uint64_t	public_exponent;	// e.g. 65537, max. 5 byte (<= 0xFFFFFFFFFF)
	vtz_memory_t	private_exponent;
	int		digest_pad_type;	// DIGEST_PADDING_NONE=0, PKCS115_SHA2_256=1, PSS_SHA2_256=2
} vtz_ioctl_rsa_import_t;
