#ifndef __VTZ2_HELPER__H
#define __VTZ2_HELPER__H
/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

/* atomic counter helper */
#include <linux/atomic.h> /* atomic operations*/
#include <linux/mutex.h>		 /*struct mutex */

#include <vtz2_mem.h>

void vtz_short_tz_duration_count_inc(void);
void vtz_short_tz_duration_count_dec(void);
int vtz_short_tz_duration_running(void);
void vtz_long_tz_duration_count_inc(void);
void vtz_long_tz_duration_count_dec(void);
int vtz_long_tz_duration_running(void);

/* locking api */
int vtz_enter_critical_short_tz_duration(void);
void vtz_leave_critical_short_tz_duration(void);
void vtz_enter_critical_long_tz_duration(void);
void vtz_leave_critical_long_tz_duration(void);

/* Ring buffer API */
int vtz_buffer_read(vtz_error *error_return);
void vtz_buffer_clear(void);
uint32_t vtz_buffer_count(void);

/*********************/
/* error exit helper */
/*********************/

int vtz_throw_exception(int rc, vtz_mem_internal_t *tz_memory_cleanup, vtz_err_type_t error_code,const char* const funcname, const int line);

/************************************/
/* transaction random number helper */
/************************************/

void vtz_next_transaction(uint64_t* transaction_ptr);

#endif