#ifndef __VTZ2_SCM_H__
#define __VTZ2_SCM_H__
/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

#include <linux/types.h>
#include <soc/qcom/scm.h>
#include <asm/cacheflush.h>	/* dmac_flush_range(), dmac_inv_range() */

#ifdef CONFIG_HAS_WAKELOCK
#include <linux/wakelock.h> /*included here and in vtz2_main.c*/
#endif

#include <vtz2_mem.h>

extern void pdev_set_bus(bool);		/* external clock bus setting tool in Qualcomm module pdev_test */

int vtz_scm_call(uint32_t scm_service_id, uint32_t scm_cmd_id, vtz_mem_internal_t *tz_memory);
/**************************************************/
/* TrustZone Macros (with permission by Qualcomm) */
/**************************************************/

/* leave this as it is! */

#define TZ_SVC_CRYPTO			10	/* TZ secure monitor call service id for crypto subsystem */
#define TZ_SVC_OEM			254	/* TZ secure monitor call service id for OEM subsystem */


#define TZ_MASK_BITS(h,l)     ((0xffffffff >> (32 - ((h - l) + 1))) << l)

#define TZ_SYSCALL_PARAM_NARGS_MASK  TZ_MASK_BITS(3,0)
#define TZ_SYSCALL_PARAM_TYPE_MASK   TZ_MASK_BITS(1,0)

#define _TZ_SYSCALL_CREATE_PARAM_ID(nargs, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, ...) \
  (((nargs)&TZ_SYSCALL_PARAM_NARGS_MASK)+ \
  (((p1)&TZ_SYSCALL_PARAM_TYPE_MASK)<<4)+ \
  (((p2)&TZ_SYSCALL_PARAM_TYPE_MASK)<<6)+ \
  (((p3)&TZ_SYSCALL_PARAM_TYPE_MASK)<<8)+ \
  (((p4)&TZ_SYSCALL_PARAM_TYPE_MASK)<<10)+ \
  (((p5)&TZ_SYSCALL_PARAM_TYPE_MASK)<<12)+ \
  (((p6)&TZ_SYSCALL_PARAM_TYPE_MASK)<<14)+ \
  (((p7)&TZ_SYSCALL_PARAM_TYPE_MASK)<<16)+ \
  (((p8)&TZ_SYSCALL_PARAM_TYPE_MASK)<<18)+ \
  (((p9)&TZ_SYSCALL_PARAM_TYPE_MASK)<<20)+ \
  (((p10)&TZ_SYSCALL_PARAM_TYPE_MASK)<<22))

#define __TZ_SYSCALL_CREATE_PARAM_ID(...) \
  _TZ_SYSCALL_CREATE_PARAM_ID(__VA_ARGS__, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

#define TZ_SYSCALL_CREATE_PARAM_ID_4(p1, p2, p3, p4) \
  __TZ_SYSCALL_CREATE_PARAM_ID(4, p1, p2, p3, p4)

#define TZ_SYSCALL_PARAM_TYPE_VAL              0x0
#define TZ_SYSCALL_PARAM_TYPE_BUF_RW           0x2

#define TZ_SYSCALL_CREATE_SMC_ID(o, s, f) \
  ((uint32_t)((((o & 0x3f) << 24 ) | (s & 0xff) << 8) | (f & 0xff)))

#define TZ_OWNER_SIP                        2
#define TZ_OWNER_OEM                        3
  
#define TZ_CRYPTO_SERVICE_SYM_ID                    \
  TZ_SYSCALL_CREATE_SMC_ID(TZ_OWNER_SIP, TZ_SVC_CRYPTO, 0x03)

#define TZ_SVC_SYM_ID			TZ_CRYPTO_SERVICE_SYM_ID


#ifdef CONFIG_VTZ2_RSA

#define TZ_CRYPTO_ASYM_SERVICE_ID                    \
  TZ_SYSCALL_CREATE_SMC_ID(TZ_OWNER_SIP, TZ_SVC_CRYPTO, 0x04)

	#define TZ_SVC_RSA_ID			TZ_CRYPTO_ASYM_SERVICE_ID

#endif

#define TZ_OEM_TEST_ID \
  TZ_SYSCALL_CREATE_SMC_ID(TZ_OWNER_OEM, TZ_SVC_OEM, 0x01)  

#define TZ_SVC_OEM_ID			TZ_OEM_TEST_ID

#endif /*__VTZ2_SCM_H__*/