#ifndef __VTZ2_STORAGE_H__
#define __VTZ2_STORAGE_H__
/*
 * vtz2 Valeo TrustZone driver2 for Qualcomm MDM9607 SoC
 *
 *   Copyright (C) 2016-2021 Valeo peiker Telematik GmbH
 *
 *   Authors: Mohamed Ahmed Hassan <mohamed.ahmed-hassan@valeo.com>
 *            Simon Gleissner <simon.gleissner@valeo.com>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   version 2 as published by the Free Software Foundation.
 *
 *   This program is licensed "as is" without any warranty of any kind,
 *   whether express or implied.
 */

#include <linux/types.h>

/*********************************************/
/*  file_operations structure for secure storage */
/*********************************************/

extern const struct file_operations vtz_fops_storage;

/******************************************************************/
/* TrustZone Storage struct defines (with permission by Qualcomm) */
/******************************************************************/

typedef struct {
	void*				key_material;
	uint32_t			key_material_len;
} tz_storage_service_key_blob_t;

typedef enum {
	TZ_STORAGE_SERVICE_GENERATE_KEY	= 0x00000001,
	TZ_STORAGE_SERVICE_SEAL_DATA	= 0x00000002,
	TZ_STORAGE_SERVICE_UNSEAL_DATA	= 0x00000003
} tz_storage_service_cmd_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	tz_storage_service_key_blob_t	key_blob;
} tz_storage_service_gen_key_cmd_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	int32_t				status;
	uint32_t			key_blob_size;
} tz_storage_service_gen_key_resp_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	tz_storage_service_key_blob_t	key_blob;
	uint8_t*			plain_data;
	uint32_t			plain_dlen;
	uint8_t*			output_buffer;
	uint32_t			output_len;
} tz_storage_service_seal_data_cmd_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	int32_t				status;
	uint32_t			sealed_data_len;
} tz_storage_service_seal_data_resp_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	tz_storage_service_key_blob_t	key_blob;
	uint8_t*			sealed_data;
	uint32_t			sealed_dlen;
	uint8_t*			output_buffer;
	uint32_t			output_len;
} tz_storage_service_unseal_data_cmd_t;

typedef struct {
	tz_storage_service_cmd_t	cmd_id;
	int32_t				status;
	uint32_t			unsealed_data_len;
} tz_storage_service_unseal_data_resp_t;


 #endif /* __VTZ2_STORAGE_H__ */