// SPDX-License-Identifier: BSD-3-Clause OR GPL-2.0
/**
 * This file is provided under a dual BSD/GPLv2 license.  When using or
 * redistributing this file, you may do so under either license.
 *
 * GPL LICENSE
 * Copyright (c) 2020-2021 Robert Bosch GmbH. All rights reserved.
 * Copyright (c) 2020 Bosch Sensortec GmbH. All rights reserved.
 *
 * This file is free software licensed under the terms of version 2 
 * of the GNU General Public License, available from the file LICENSE-GPL 
 * in the main directory of this source tree.
 *
 * BSD LICENSE
 * Copyright (c) 2020-2021 Robert Bosch GmbH. All rights reserved.
 * Copyright (c) 2020 Bosch Sensortec GmbH. All rights reserved.
 *
 * BSD-3-Clause
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 **/

/*! \file smi230_data_sync.c
 * \brief Sensor Driver for SMI230 sensors */

/****************************************************************************/

/**\name        Header files
 ****************************************************************************/
#include "smi230.h"
#include "smi230_data_sync.h"

/****************************************************************************/

/** \name       Macros
 ****************************************************************************/

/****************************************************************************/

/**\name        Local structures
 ****************************************************************************/

/****************************************************************************/

/*! Static Function Declarations
 ****************************************************************************/

/*!
 * @brief This API is used to validate the device structure pointer for
 * null conditions.
 *
 * @param[in] dev : Structure instance of smi230_dev.
 *
 * @return Result of API execution status
 * @retval zero -> Success / -ve value -> Error
 */
static int8_t null_ptr_check(const struct smi230_dev *dev);

/**\name Feature configuration file */
const uint8_t smi230_config_file[] = {
0xC8, 0x2E, 0x00, 0x2E, 0x80, 0x2E, 0x47, 0x01, 0xC8, 0x2E, 0x00,
0x2E, 0xC8, 0x2E, 0x00, 0x2E, 0xC8, 0x2E, 0x00, 0x2E, 0x80, 0x2E,
0xA0, 0x00, 0x80, 0x2E, 0x7C, 0x00, 0x80, 0x2E, 0x11, 0x01, 0x50,
0x39, 0x21, 0x2E, 0xB0, 0xF0, 0x10, 0x30, 0x21, 0x2E, 0x16, 0xF0,
0x80, 0x2E, 0x90, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0xBE, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x50, 0x80, 0x7F, 0xE7,
0x7F, 0xD5, 0x7F, 0xC4, 0x7F, 0xB3, 0x7F, 0xA2, 0x7F, 0x91, 0x7F,
0xF6, 0x7F, 0x7B, 0x7F, 0x00, 0x2E, 0x01, 0x2E, 0x43, 0xF0, 0x08,
0xBC, 0x0F, 0xB8, 0x60, 0x7F, 0x00, 0x2E, 0x60, 0x6F, 0x00, 0xB2,
0x01, 0x2F, 0x98, 0x2E, 0xD9, 0xB1, 0x40, 0x30, 0x21, 0x2E, 0xB8,
0xF0, 0xF6, 0x6F, 0x91, 0x6F, 0xA2, 0x6F, 0xB3, 0x6F, 0xC4, 0x6F,
0xD5, 0x6F, 0xE7, 0x6F, 0x7B, 0x6F, 0x80, 0x6F, 0x60, 0x5F, 0xC8,
0x2E, 0xA0, 0x50, 0x80, 0x7F, 0xE7, 0x7F, 0xD5, 0x7F, 0xC4, 0x7F,
0xB3, 0x7F, 0xA2, 0x7F, 0x91, 0x7F, 0xF6, 0x7F, 0x7B, 0x7F, 0x00,
0x2E, 0x01, 0x2E, 0x29, 0xF0, 0x08, 0xBC, 0x0F, 0xB8, 0x60, 0x7F,
0x00, 0x2E, 0x60, 0x6F, 0x01, 0x90, 0x1B, 0x2F, 0x01, 0x2E, 0x02,
0x01, 0x0E, 0xBC, 0x0E, 0xB8, 0x00, 0x90, 0x05, 0x2F, 0x01, 0x2E,
0x04, 0x01, 0x0F, 0xBC, 0x0F, 0xB8, 0x01, 0xB2, 0x0D, 0x2F, 0x01,
0x2E, 0x63, 0x00, 0x01, 0x90, 0x04, 0x2F, 0x98, 0x2E, 0x6D, 0xB2,
0x00, 0x30, 0x21, 0x2E, 0x63, 0x00, 0x01, 0x2E, 0x37, 0xF0, 0x21,
0x2E, 0x37, 0xF0, 0x02, 0x2D, 0x98, 0x2E, 0x45, 0xB3, 0x80, 0x30,
0x21, 0x2E, 0xB8, 0xF0, 0xF6, 0x6F, 0x91, 0x6F, 0xA2, 0x6F, 0xB3,
0x6F, 0xC4, 0x6F, 0xD5, 0x6F, 0xE7, 0x6F, 0x7B, 0x6F, 0x80, 0x6F,
0x60, 0x5F, 0xC8, 0x2E, 0x40, 0x30, 0x21, 0x2E, 0xBA, 0xF0, 0xB8,
0x2E, 0x80, 0x30, 0x21, 0x2E, 0xBA, 0xF0, 0x10, 0x24, 0x80, 0x00,
0x03, 0x2E, 0x06, 0xF0, 0x08, 0x0A, 0x21, 0x2E, 0x06, 0xF0, 0x00,
0x3E, 0x03, 0x2E, 0x06, 0xF0, 0x08, 0x08, 0x51, 0x30, 0x01, 0x0A,
0x21, 0x2E, 0x06, 0xF0, 0xB8, 0x2E, 0x00, 0x31, 0x21, 0x2E, 0xBA,
0xF0, 0xB8, 0x2E, 0x10, 0x30, 0x21, 0x2E, 0xBB, 0xF0, 0xB8, 0x2E,
0x80, 0x2E, 0x18, 0x00, 0xFD, 0x2D, 0xAA, 0x00, 0x05, 0x00, 0x00,
0x00, 0x00, 0x00, 0x04, 0x00, 0x01, 0x00, 0xED, 0x8F, 0xD9, 0x31,
0xC6, 0x01, 0x8C, 0x03, 0xC6, 0x01, 0x00, 0x00, 0x0E, 0x00, 0x0E,
0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x60, 0x50, 0xE7, 0x7F,
0xF6, 0x7F, 0x36, 0x30, 0x0F, 0x2E, 0x01, 0xF0, 0xFE, 0xBF, 0xFE,
0xBB, 0xB7, 0x05, 0xA6, 0x7F, 0xD3, 0x7F, 0xC4, 0x7F, 0xB5, 0x7F,
0x14, 0x24, 0x89, 0xF0, 0x3F, 0x8B, 0x03, 0x41, 0x44, 0x41, 0xB8,
0xBD, 0x9C, 0x0B, 0xA3, 0x6F, 0x14, 0x24, 0x19, 0x00, 0xB3, 0x11,
0x43, 0x8B, 0x16, 0x43, 0x00, 0x2E, 0x67, 0x41, 0x46, 0x41, 0xF8,
0xBF, 0xBE, 0x0B, 0xB3, 0x11, 0x16, 0x43, 0x43, 0x8D, 0x00, 0x2E,
0xA5, 0x41, 0x86, 0x41, 0xD8, 0xBE, 0x6E, 0x0B, 0xEB, 0x10, 0x03,
0x43, 0x13, 0x30, 0x27, 0x2E, 0x18, 0x00, 0x03, 0x31, 0x27, 0x2E,
0xB8, 0xF0, 0xF6, 0x6F, 0xE7, 0x6F, 0xC4, 0x6F, 0xB5, 0x6F, 0xD3,
0x6F, 0xA0, 0x5F, 0xC8, 0x2E, 0xA0, 0x50, 0x80, 0x7F, 0x91, 0x7F,
0xE7, 0x7F, 0xD5, 0x7F, 0xC4, 0x7F, 0xB3, 0x7F, 0xA2, 0x7F, 0xF6,
0x7F, 0x7B, 0x7F, 0x00, 0x2E, 0x01, 0x2E, 0xB9, 0xF0, 0x60, 0x7F,
0x10, 0x30, 0x61, 0x6F, 0x08, 0x08, 0x00, 0xB2, 0x01, 0x2F, 0x98,
0x2E, 0xE6, 0xB0, 0x10, 0x30, 0x21, 0x2E, 0xB9, 0xF0, 0x21, 0x2E,
0x5F, 0xF0, 0xF6, 0x6F, 0x91, 0x6F, 0xA2, 0x6F, 0xB3, 0x6F, 0xC4,
0x6F, 0xD5, 0x6F, 0xE7, 0x6F, 0x7B, 0x6F, 0x80, 0x6F, 0x60, 0x5F,
0xC8, 0x2E, 0x98, 0x2E, 0x9E, 0x01, 0x20, 0x26, 0x98, 0x2E, 0xDE,
0x00, 0x98, 0x2E, 0xF9, 0x00, 0x98, 0x2E, 0xF5, 0x00, 0x98, 0x2E,
0xE2, 0x00, 0x10, 0x30, 0x21, 0x2E, 0x59, 0xF0, 0x98, 0x2E, 0x94,
0x01, 0x21, 0x30, 0x10, 0x24, 0x19, 0x00, 0x00, 0x2E, 0x00, 0x2E,
0xD0, 0x2E, 0x05, 0x2E, 0x18, 0x00, 0x80, 0xB2, 0x02, 0x30, 0x05,
0x2F, 0x23, 0x2E, 0x5F, 0xF0, 0x25, 0x2E, 0x18, 0x00, 0x98, 0x2E,
0x00, 0xB0, 0x98, 0x2E, 0x51, 0xB2, 0xEC, 0x2D, 0x1A, 0x24, 0x26,
0x00, 0x80, 0x2E, 0x6C, 0x01, 0x10, 0x50, 0x01, 0x2E, 0x55, 0xF0,
0xF0, 0x7F, 0x00, 0x2E, 0xF0, 0x6F, 0x21, 0x2E, 0x55, 0xF0, 0xF0,
0x5F, 0xB8, 0x2E, 0x20, 0x50, 0x00, 0x30, 0xE0, 0x7F, 0xFB, 0x7F,
0x11, 0x24, 0xB1, 0xF0, 0x42, 0x40, 0x43, 0x30, 0x93, 0x0A, 0x42,
0x42, 0x58, 0x82, 0x12, 0x24, 0xAF, 0x00, 0x62, 0x42, 0x12, 0x24,
0xFF, 0x00, 0x42, 0x42, 0x69, 0x82, 0x72, 0x3C, 0x43, 0x40, 0x9A,
0x08, 0x83, 0x32, 0x93, 0x0A, 0x42, 0x42, 0x42, 0x82, 0x02, 0x3F,
0x43, 0x40, 0x9A, 0x08, 0x52, 0x42, 0x0B, 0x31, 0x4B, 0x42, 0x7E,
0x82, 0x12, 0x31, 0x42, 0x42, 0x11, 0x24, 0xFE, 0x00, 0x05, 0x2E,
0x40, 0xF0, 0x51, 0x08, 0x5E, 0x90, 0x27, 0x2F, 0x11, 0x24, 0x00,
0x02, 0x12, 0x24, 0x05, 0x80, 0x13, 0x24, 0xFF, 0xB7, 0x1B, 0x24,
0x00, 0xB0, 0x04, 0x30, 0x05, 0x30, 0x56, 0x32, 0x6E, 0x1A, 0x00,
0x2F, 0xA5, 0x34, 0x69, 0x1A, 0x01, 0x2F, 0x5B, 0x25, 0x00, 0x2E,
0x56, 0x41, 0x26, 0x0D, 0x06, 0x30, 0xCF, 0xBB, 0x41, 0xBE, 0xC0,
0x91, 0x01, 0x2F, 0x00, 0x2E, 0x01, 0x2D, 0x22, 0x0D, 0x81, 0x8D,
0x90, 0xA1, 0xF5, 0x2F, 0xEB, 0x0E, 0xE8, 0x2F, 0x01, 0x2E, 0x25,
0x00, 0x20, 0x1A, 0x05, 0x2F, 0x20, 0x30, 0xE0, 0x7F, 0x03, 0x2D,
0x30, 0x30, 0xE0, 0x7F, 0x00, 0x2E, 0xE0, 0x6F, 0x00, 0xB2, 0x03,
0x2F, 0x21, 0x2E, 0x59, 0xF0, 0x98, 0x2E, 0x94, 0x01, 0xFB, 0x6F,
0xE0, 0x5F, 0xB8, 0x2E, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0xB0, 0x50, 0xF0, 0x7F, 0x00, 0x2E, 0x01, 0x2E, 0x01, 0x01,
0x02, 0xBC, 0x0F, 0xB8, 0xE0, 0x7F, 0x00, 0x2E, 0x01, 0x2E, 0x01,
0x01, 0x01, 0xBC, 0x0F, 0xB8, 0xD0, 0x7F, 0x00, 0x2E, 0x01, 0x2E,
0x01, 0x01, 0x0F, 0xB8, 0xC0, 0x7F, 0x02, 0x30, 0xE6, 0x6F, 0xD4,
0x6F, 0xC3, 0x6F, 0x80, 0x91, 0x04, 0x2F, 0x00, 0x91, 0x02, 0x2F,
0xC0, 0xB2, 0x90, 0x2E, 0xE2, 0xB0, 0xF0, 0x6F, 0x0B, 0x2E, 0x24,
0x00, 0x01, 0x82, 0x40, 0x91, 0x14, 0x2F, 0x41, 0x87, 0x27, 0x2E,
0x24, 0x00, 0x00, 0x40, 0x21, 0x2E, 0x1F, 0x00, 0x53, 0x40, 0x10,
0x24, 0x20, 0x00, 0x13, 0x42, 0x00, 0x2E, 0x41, 0x40, 0x01, 0x42,
0x25, 0x2E, 0x1C, 0x00, 0x25, 0x2E, 0x1D, 0x00, 0x25, 0x2E, 0x22,
0x00, 0x50, 0x5F, 0xB8, 0x2E, 0x0B, 0x2E, 0x00, 0x01, 0xD5, 0xBE,
0xD5, 0xBA, 0xB5, 0x7F, 0x00, 0x2E, 0x0B, 0x2E, 0x01, 0x01, 0xD3,
0xBE, 0xD3, 0xBA, 0xA5, 0x7F, 0x00, 0x2E, 0x0B, 0x2E, 0x00, 0x01,
0xD4, 0xBE, 0xDF, 0xBA, 0x95, 0x7F, 0x00, 0x2E, 0x95, 0x6F, 0x0F,
0x2E, 0x1E, 0x00, 0x3D, 0x1A, 0x05, 0x2F, 0x25, 0x2E, 0x1C, 0x00,
0x25, 0x2E, 0x1D, 0x00, 0x2B, 0x2E, 0x1E, 0x00, 0x82, 0x7F, 0x72,
0x7F, 0x80, 0x91, 0x62, 0x7F, 0x01, 0x2F, 0x06, 0x30, 0x07, 0x2D,
0x06, 0x40, 0x0F, 0x2E, 0x1F, 0x00, 0xB7, 0x05, 0x80, 0xA9, 0xD6,
0x05, 0xB7, 0x23, 0x86, 0x7F, 0x00, 0x91, 0x01, 0x2F, 0x04, 0x30,
0x07, 0x2D, 0x44, 0x40, 0x0D, 0x2E, 0x20, 0x00, 0x26, 0x05, 0x00,
0xA9, 0x94, 0x05, 0x26, 0x23, 0x74, 0x7F, 0xC0, 0x90, 0x01, 0x2F,
0x00, 0x2E, 0x09, 0x2D, 0x02, 0x86, 0x00, 0x2E, 0xC3, 0x40, 0x09,
0x2E, 0x21, 0x00, 0xDC, 0x04, 0xC0, 0xA8, 0x93, 0x04, 0x9A, 0x22,
0x62, 0x7F, 0x12, 0x30, 0x84, 0x6F, 0xB3, 0x6F, 0x63, 0x0F, 0x14,
0x30, 0x08, 0x2F, 0x74, 0x6F, 0x63, 0x0F, 0x14, 0x30, 0x04, 0x2F,
0x64, 0x6F, 0x63, 0x0F, 0x14, 0x30, 0x00, 0x2F, 0x04, 0x30, 0x54,
0x7F, 0x40, 0x91, 0x0B, 0x2E, 0x1C, 0x00, 0x54, 0x6F, 0xA3, 0x6F,
0x6A, 0x29, 0x1D, 0x2F, 0x00, 0x91, 0x06, 0x30, 0x14, 0x24, 0x20,
0x00, 0x0D, 0x2F, 0x2D, 0x2E, 0x1C, 0x00, 0x05, 0x2E, 0x1D, 0x00,
0x81, 0x84, 0x25, 0x2E, 0x1D, 0x00, 0x05, 0x2E, 0x1D, 0x00, 0x53,
0x0E, 0x2B, 0x2F, 0x2D, 0x2E, 0x22, 0x00, 0x29, 0x2D, 0x2B, 0x2E,
0x1C, 0x00, 0x2D, 0x2E, 0x1D, 0x00, 0x0B, 0x2E, 0x1C, 0x00, 0x6B,
0x0E, 0x20, 0x2F, 0x25, 0x2E, 0x22, 0x00, 0x1E, 0x2D, 0x00, 0xB3,
0x05, 0x2F, 0x02, 0x30, 0x25, 0x2E, 0x1C, 0x00, 0x25, 0x2E, 0x22,
0x00, 0x08, 0x2D, 0x2B, 0x2E, 0x1C, 0x00, 0x09, 0x2E, 0x1C, 0x00,
0x63, 0x0E, 0x01, 0x2F, 0x25, 0x2E, 0x22, 0x00, 0x02, 0x40, 0x25,
0x2E, 0x1F, 0x00, 0x31, 0x25, 0x00, 0x2E, 0xD5, 0x40, 0x12, 0x24,
0x20, 0x00, 0x42, 0x25, 0x95, 0x42, 0x00, 0x2E, 0xC3, 0x40, 0x83,
0x42, 0x00, 0x2E, 0x05, 0x2E, 0x22, 0x00, 0x80, 0xB2, 0x0D, 0x2F,
0x00, 0x40, 0x21, 0x2E, 0x1F, 0x00, 0x50, 0x40, 0x10, 0x43, 0x00,
0x2E, 0x40, 0x40, 0x00, 0x43, 0x20, 0x30, 0x21, 0x2E, 0x5E, 0xF0,
0x02, 0x2D, 0x25, 0x2E, 0x24, 0x00, 0x50, 0x5F, 0xB8, 0x2E, 0x30,
0x50, 0xFB, 0x7F, 0x98, 0x2E, 0x23, 0xB2, 0x13, 0x24, 0x4F, 0x00,
0xD0, 0x42, 0xC1, 0x42, 0xFA, 0x82, 0xD1, 0x7F, 0xE3, 0x7F, 0x98,
0x2E, 0x8D, 0xB1, 0xD1, 0x6F, 0x00, 0x2E, 0x41, 0x40, 0x40, 0xB2,
0x6D, 0x2F, 0xE1, 0x6F, 0x44, 0x84, 0x03, 0x2E, 0x4F, 0x00, 0x83,
0x40, 0xB7, 0x84, 0x4B, 0x04, 0x81, 0x42, 0x00, 0x2E, 0x83, 0x40,
0xC0, 0xAC, 0x01, 0x2F, 0x23, 0x2E, 0x4B, 0x00, 0x12, 0x25, 0x93,
0x40, 0x82, 0x40, 0x1A, 0x0F, 0x01, 0x2F, 0xC0, 0xAC, 0x02, 0x2F,
0x03, 0x30, 0x27, 0x2E, 0x4B, 0x00, 0x42, 0x86, 0xC9, 0x84, 0xC0,
0x40, 0x43, 0x40, 0x18, 0x0E, 0x82, 0x40, 0x25, 0x2F, 0x12, 0x25,
0x12, 0x24, 0x51, 0x00, 0x8F, 0x80, 0x82, 0x40, 0xE0, 0x7F, 0x98,
0x2E, 0x69, 0xB1, 0xE1, 0x6F, 0x00, 0x2E, 0x40, 0x42, 0x77, 0x82,
0x7B, 0x84, 0xB9, 0x86, 0xD6, 0x80, 0x41, 0x40, 0x82, 0x40, 0xC3,
0x40, 0xE0, 0x7F, 0x98, 0x2E, 0x69, 0xB1, 0xE1, 0x6F, 0x00, 0x2E,
0x40, 0x42, 0x77, 0x82, 0x7B, 0x84, 0xB8, 0x86, 0xD7, 0x80, 0x41,
0x40, 0x82, 0x40, 0xC3, 0x40, 0xE0, 0x7F, 0x98, 0x2E, 0x69, 0xB1,
0xE1, 0x6F, 0x00, 0x2E, 0x40, 0x42, 0x24, 0x2D, 0x11, 0x24, 0x5B,
0x00, 0x45, 0x80, 0x41, 0x40, 0xE0, 0x7F, 0x98, 0x2E, 0x7B, 0xB1,
0xE1, 0x6F, 0x00, 0x2E, 0x40, 0x42, 0x7C, 0x82, 0x7B, 0x84, 0xB4,
0x86, 0xD6, 0x80, 0x41, 0x40, 0x82, 0x40, 0xC3, 0x40, 0xE0, 0x7F,
0x98, 0x2E, 0x7B, 0xB1, 0xE1, 0x6F, 0x00, 0x2E, 0x40, 0x42, 0x7C,
0x82, 0x7B, 0x84, 0xB3, 0x86, 0xD7, 0x80, 0x41, 0x40, 0x82, 0x40,
0xC3, 0x40, 0xE0, 0x7F, 0x98, 0x2E, 0x7B, 0xB1, 0xE1, 0x6F, 0x00,
0x2E, 0x40, 0x42, 0x98, 0x2E, 0xC5, 0xB1, 0x11, 0x30, 0x23, 0x2E,
0x5E, 0xF0, 0xFB, 0x6F, 0xD0, 0x5F, 0xB8, 0x2E, 0x30, 0x50, 0xF3,
0x7F, 0xE2, 0x7F, 0xD1, 0x7F, 0x13, 0x24, 0x4E, 0x00, 0xD1, 0x6F,
0xE4, 0x6F, 0xE2, 0x40, 0xF0, 0x6F, 0x21, 0x05, 0xC3, 0x40, 0xA2,
0x10, 0x03, 0x04, 0x10, 0x18, 0xD0, 0x5F, 0x0E, 0x00, 0xB8, 0x2E,
0x30, 0x50, 0xF3, 0x7F, 0xE2, 0x7F, 0xD1, 0x7F, 0x13, 0x24, 0x4E,
0x00, 0xE1, 0x6F, 0xD4, 0x6F, 0xE2, 0x40, 0xF0, 0x6F, 0x21, 0x05,
0xC3, 0x40, 0xA2, 0x10, 0x18, 0x04, 0x10, 0x18, 0xD0, 0x5F, 0x0E,
0x00, 0xB8, 0x2E, 0x01, 0x2E, 0x02, 0x01, 0x8E, 0xBC, 0x01, 0x2E,
0x4A, 0x00, 0x9E, 0xB8, 0x01, 0x1A, 0x2E, 0x2F, 0x01, 0x2E, 0x02,
0x01, 0x0E, 0xBC, 0x0E, 0xB8, 0x21, 0x2E, 0x4A, 0x00, 0x03, 0x2E,
0x4A, 0x00, 0x43, 0xB2, 0x10, 0x24, 0x4D, 0x00, 0x1B, 0x2F, 0x42,
0xB2, 0x11, 0x2F, 0x41, 0xB2, 0x06, 0x2F, 0x01, 0x30, 0x11, 0x42,
0x01, 0x42, 0x3E, 0x80, 0x00, 0x2E, 0x01, 0x42, 0xB8, 0x2E, 0x41,
0x33, 0x11, 0x42, 0x61, 0x30, 0x01, 0x42, 0x3E, 0x80, 0x11, 0x24,
0x80, 0x00, 0x01, 0x42, 0xB8, 0x2E, 0x01, 0x30, 0x11, 0x42, 0x51,
0x30, 0x01, 0x42, 0x3E, 0x80, 0x41, 0x33, 0x01, 0x42, 0xB8, 0x2E,
0x71, 0x30, 0x11, 0x42, 0x41, 0x30, 0x01, 0x42, 0x3E, 0x80, 0x81,
0x31, 0x01, 0x42, 0xB8, 0x2E, 0x10, 0x24, 0x60, 0x00, 0x11, 0x24,
0x52, 0xF0, 0x12, 0x40, 0x52, 0x42, 0x28, 0xB5, 0x52, 0x42, 0x00,
0x2E, 0x12, 0x40, 0x42, 0x42, 0x42, 0x82, 0x00, 0x40, 0x50, 0x42,
0x08, 0xB4, 0x40, 0x42, 0x7E, 0x80, 0xA8, 0xB4, 0x01, 0x42, 0xB8,
0x2E, 0x12, 0x24, 0x59, 0x00, 0x90, 0x40, 0x84, 0x82, 0x20, 0x50,
0x50, 0x42, 0x77, 0x80, 0x82, 0x40, 0x42, 0x42, 0xFB, 0x7F, 0x05,
0x82, 0x00, 0x40, 0x40, 0x42, 0x7C, 0x80, 0x05, 0x82, 0x00, 0x40,
0x40, 0x42, 0x7C, 0x80, 0x05, 0x82, 0x00, 0x40, 0x40, 0x42, 0x77,
0x84, 0x00, 0x2E, 0x90, 0x40, 0x84, 0x82, 0x82, 0x40, 0x50, 0x42,
0x77, 0x80, 0x42, 0x42, 0x05, 0x82, 0x00, 0x40, 0x40, 0x42, 0x7C,
0x80, 0x05, 0x82, 0x00, 0x40, 0x40, 0x42, 0x7C, 0x80, 0x05, 0x82,
0x00, 0x40, 0x40, 0x42, 0x7C, 0x82, 0xE1, 0x7F, 0x98, 0x2E, 0x23,
0xB2, 0xE2, 0x6F, 0x00, 0x2E, 0x90, 0x42, 0x81, 0x42, 0xBC, 0x82,
0x10, 0x24, 0x33, 0xF0, 0x23, 0x40, 0x02, 0x40, 0xB8, 0xBD, 0x9A,
0x0A, 0x03, 0x80, 0x52, 0x42, 0x00, 0x2E, 0x23, 0x40, 0x02, 0x40,
0xB8, 0xBD, 0x9A, 0x0A, 0x03, 0x80, 0x52, 0x42, 0x00, 0x2E, 0x22,
0x40, 0x00, 0x40, 0x28, 0xBD, 0x10, 0x0A, 0x40, 0x42, 0x00, 0x2E,
0xFB, 0x6F, 0xE0, 0x5F, 0xB8, 0x2E, 0x11, 0x24, 0x28, 0xF0, 0x50,
0x50, 0x60, 0x40, 0xF0, 0x7F, 0x51, 0x25, 0x60, 0x40, 0xE0, 0x7F,
0x00, 0x2E, 0x41, 0x40, 0xD1, 0x7F, 0x00, 0x2E, 0xE2, 0x6F, 0xD0,
0x6F, 0x00, 0xB2, 0xF3, 0x6F, 0xA8, 0xB8, 0x28, 0xBE, 0x59, 0x0A,
0x20, 0x0A, 0x01, 0x2F, 0xB0, 0x5F, 0xB8, 0x2E, 0x45, 0x41, 0xC5,
0x7F, 0x00, 0x2E, 0xC5, 0x6F, 0x40, 0x91, 0x09, 0x2F, 0x05, 0x2E,
0x28, 0xF0, 0xB2, 0x7F, 0x00, 0x2E, 0xB2, 0x6F, 0x1A, 0x1A, 0x07,
0x2F, 0xF0, 0x3F, 0x13, 0x25, 0x05, 0x2D, 0x15, 0x1A, 0x02, 0x2F,
0x10, 0x24, 0xFF, 0x00, 0x20, 0x0A, 0xB0, 0x5F, 0xB8, 0x2E, 0x01,
0x2E, 0x03, 0x01, 0x8F, 0xBC, 0x01, 0x2E, 0x23, 0x00, 0x9F, 0xB8,
0x01, 0x1A, 0x12, 0x2F, 0x01, 0x2E, 0x03, 0x01, 0x0F, 0xBC, 0x0F,
0xB8, 0x21, 0x2E, 0x23, 0x00, 0x11, 0x30, 0x05, 0x2E, 0x23, 0x00,
0x51, 0x08, 0xD2, 0x3F, 0x01, 0x2E, 0x07, 0xF0, 0x02, 0x08, 0x91,
0xBC, 0x01, 0x0A, 0x21, 0x2E, 0x07, 0xF0, 0xB8, 0x2E, 0xB8, 0x2E,
0x10, 0x50, 0x12, 0x24, 0x6D, 0x00, 0x00, 0x30, 0x1B, 0x2D, 0xF1,
0x6F, 0xD1, 0x00, 0x00, 0x2E, 0xC0, 0x42, 0xBD, 0x84, 0xD1, 0x00,
0x00, 0x2E, 0xC0, 0x42, 0x89, 0x84, 0xD1, 0x00, 0x00, 0x2E, 0xC0,
0x42, 0xBD, 0x84, 0xD1, 0x00, 0x00, 0x2E, 0xC0, 0x42, 0x89, 0x84,
0xD1, 0x00, 0x00, 0x2E, 0xC0, 0x42, 0xBD, 0x84, 0xD1, 0x00, 0x00,
0x2E, 0xC0, 0x42, 0x41, 0x82, 0xF1, 0x7F, 0xB7, 0x84, 0xF1, 0x6F,
0x42, 0xA2, 0xE1, 0x2F, 0xF0, 0x5F, 0xB8, 0x2E, 0xC0, 0x50, 0x92,
0x7F, 0xFB, 0x7F, 0x81, 0x7F, 0x00, 0x30, 0x60, 0x7F, 0x70, 0x7F,
0x50, 0x7F, 0x00, 0x2E, 0x03, 0x2E, 0x04, 0x01, 0x9D, 0xBC, 0x9E,
0xB8, 0x41, 0x7F, 0x00, 0x2E, 0x42, 0x6F, 0x52, 0x7F, 0xE2, 0x7F,
0x00, 0x2E, 0x83, 0x6F, 0xC3, 0x82, 0xD3, 0x7F, 0x0C, 0x2D, 0x55,
0x6F, 0x7F, 0x89, 0xDC, 0x01, 0x9D, 0x01, 0xCB, 0x41, 0x8B, 0x43,
0xCC, 0x01, 0x4D, 0x01, 0xC7, 0x41, 0x47, 0x43, 0x54, 0x7F, 0x00,
0x2E, 0x54, 0x6F, 0x00, 0xAB, 0xF0, 0x2F, 0x9B, 0x6F, 0x8A, 0x00,
0x4B, 0x42, 0xC2, 0x7F, 0xB1, 0x7F, 0x50, 0x7F, 0x7D, 0x80, 0xA0,
0x7F, 0x13, 0x24, 0x08, 0x01, 0x3F, 0x2D, 0x50, 0x6F, 0x18, 0x01,
0xC6, 0x84, 0xC8, 0x00, 0x50, 0x00, 0x05, 0x41, 0xC7, 0x40, 0x44,
0x40, 0x61, 0x6F, 0x73, 0x6F, 0x2F, 0x18, 0x00, 0xB3, 0x0B, 0x2F,
0x10, 0xA1, 0x03, 0x2F, 0x30, 0x89, 0xBC, 0x11, 0xCE, 0x17, 0x06,
0x2D, 0x74, 0x13, 0x06, 0x31, 0xB4, 0x05, 0xBE, 0x15, 0xFC, 0x11,
0xAE, 0x0B, 0x4E, 0x00, 0xDF, 0x02, 0x61, 0x7F, 0x73, 0x7F, 0xB7,
0x84, 0x01, 0x82, 0xD1, 0x00, 0x86, 0x80, 0xA2, 0x6F, 0x11, 0x01,
0x81, 0x00, 0xC3, 0x40, 0x05, 0x41, 0x84, 0x40, 0x1D, 0x18, 0x72,
0x6F, 0x00, 0xB3, 0x63, 0x6F, 0x0B, 0x2F, 0x10, 0xA1, 0x03, 0x2F,
0x30, 0x89, 0xBC, 0x11, 0xCE, 0x17, 0x06, 0x2D, 0x74, 0x13, 0x06,
0x31, 0xB4, 0x05, 0xBE, 0x15, 0xFC, 0x11, 0xAE, 0x0B, 0xDE, 0x04,
0x97, 0x06, 0x63, 0x7F, 0x72, 0x7F, 0x51, 0x7F, 0x3D, 0x86, 0xB1,
0x6F, 0xE2, 0x6F, 0x50, 0x6F, 0x42, 0x0E, 0xBC, 0x2F, 0xE0, 0x6F,
0xC6, 0x82, 0x98, 0x00, 0x48, 0x00, 0xC0, 0x6F, 0x83, 0x40, 0x04,
0x40, 0x42, 0x40, 0x61, 0x6F, 0x70, 0x6F, 0x80, 0xB2, 0x1C, 0x18,
0x0B, 0x2F, 0x90, 0xA0, 0x03, 0x2F, 0xB0, 0x84, 0xBA, 0x11, 0xCE,
0x17, 0x06, 0x2D, 0x03, 0x31, 0xDA, 0x04, 0xFB, 0x14, 0x32, 0x13,
0xFA, 0x11, 0xA3, 0x0B, 0x4E, 0x00, 0x07, 0x02, 0x61, 0x7F, 0x70,
0x7F, 0x00, 0x2E, 0x72, 0x6F, 0x80, 0xA8, 0x60, 0x6F, 0xD1, 0x6F,
0x13, 0x2F, 0x80, 0x90, 0x03, 0x2F, 0x13, 0x24, 0xFF, 0x7F, 0x43,
0x0F, 0x0D, 0x2F, 0xBF, 0xA0, 0x07, 0x2F, 0xBF, 0x90, 0x03, 0x2F,
0x12, 0x24, 0x00, 0x80, 0x42, 0x0E, 0x01, 0x2F, 0x40, 0x42, 0x07,
0x2D, 0x10, 0x24, 0x00, 0x80, 0x40, 0x42, 0x03, 0x2D, 0x10, 0x24,
0xFF, 0x7F, 0x40, 0x42, 0x00, 0x2E, 0xFB, 0x6F, 0x40, 0x5F, 0x40,
0x40, 0xB8, 0x2E, 0x11, 0x24, 0x63, 0x00, 0x30, 0x50, 0x10, 0x30,
0x50, 0x42, 0xFB, 0x7F, 0x10, 0x24, 0x33, 0xF0, 0x23, 0x40, 0x02,
0x40, 0xB8, 0xBD, 0x9A, 0x0A, 0x03, 0x80, 0x52, 0x42, 0x00, 0x2E,
0x23, 0x40, 0x02, 0x40, 0xB8, 0xBD, 0x9A, 0x0A, 0x03, 0x80, 0x52,
0x42, 0x00, 0x2E, 0x23, 0x40, 0x02, 0x40, 0xB8, 0xBD, 0x9A, 0x0A,
0x3C, 0x80, 0x42, 0x42, 0x7E, 0x84, 0xE0, 0x7F, 0x86, 0x82, 0xD1,
0x7F, 0x00, 0x2E, 0x82, 0x40, 0x98, 0x2E, 0x92, 0xB2, 0xD1, 0x6F,
0x7D, 0x82, 0x00, 0x2E, 0x40, 0x42, 0x7E, 0x80, 0x0B, 0x82, 0x02,
0x40, 0xD1, 0x7F, 0x98, 0x2E, 0x92, 0xB2, 0xD1, 0x6F, 0x78, 0x82,
0x00, 0x2E, 0x40, 0x42, 0x7E, 0x80, 0x10, 0x82, 0x02, 0x40, 0xD1,
0x7F, 0x98, 0x2E, 0x92, 0xB2, 0xD1, 0x6F, 0x73, 0x82, 0x00, 0x2E,
0x40, 0x42, 0x7E, 0x80, 0xE1, 0x6F, 0x12, 0x40, 0x52, 0x42, 0x28,
0xB5, 0x52, 0x42, 0x00, 0x2E, 0x12, 0x40, 0x52, 0x42, 0x28, 0xB5,
0x52, 0x42, 0x00, 0x2E, 0x00, 0x40, 0x50, 0x42, 0x08, 0xB4, 0x40,
0x42, 0x00, 0x2E, 0xFB, 0x6F, 0xD0, 0x5F, 0xB8, 0x2E, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18,
0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E,
0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80,
0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00, 0x80, 0x2E, 0x18, 0x00,
0x80, 0x2E, 0x18, 0x00, 0xFD, 0x2D
};

/****************************************************************************/

/**\name        Extern Declarations
 ****************************************************************************/

/****************************************************************************/

/**\name        Globals
 ****************************************************************************/

/****************************************************************************/

/**\name        Function definitions
 ****************************************************************************/

/*!
 *  @brief This API is the entry point for smi230 sensors.
 *  It performs the selection of I2C/SPI read mechanism according to the
 *  selected interface and reads the chip-id of accel & gyro sensors.
 *  Additionally the smi230 config file is loaded onto the device.
 */
int8_t smi230_init(struct smi230_dev *dev)
{
    int8_t rslt;

    /* Initialize smi230 accel sensor */
    rslt = smi230_acc_init(dev);

    if (rslt == SMI230_OK)
    {
        /* Initialize smi230 gyro sensor */
        rslt = smi230_gyro_init(dev);
    }

    return rslt;
}

/*!
 *  @brief This API uploads the smi230 config file onto the device.
 */
int8_t smi230_apply_config_file(struct smi230_dev *dev)
{
    int8_t rslt;

    /* Check for null pointer in the device structure */
    rslt = null_ptr_check(dev);

    /* Proceed if null check is fine */
    if (rslt == SMI230_OK)
    {
        /* Assign stream file */
        dev->config_file_ptr = smi230_config_file;

        /* Upload binary */
        rslt = smi230_acc_write_config_file(dev);
    }

    return rslt;
}

/*!
 *  @brief This API is used to enable/disable and configure the data synchronization
 *  feature.
 */
int8_t smi230_configure_data_synchronization(struct smi230_data_sync_cfg sync_cfg, struct smi230_dev *dev)
{
    int8_t rslt;
    uint16_t data[SMI230_ACCEL_DATA_SYNC_LEN];

    /* Check for null pointer in the device structure */
    rslt = null_ptr_check(dev);

    /* Proceed if null check is fine */
    if (rslt == SMI230_OK)
    {
        /* Change sensor meas config */
        switch (sync_cfg.mode)
        {
            case SMI230_ACCEL_DATA_SYNC_MODE_2000HZ:
                dev->accel_cfg.odr = SMI230_ACCEL_ODR_1600_HZ;
                dev->accel_cfg.bw = SMI230_ACCEL_BW_NORMAL;
                dev->gyro_cfg.odr = SMI230_GYRO_BW_230_ODR_2000_HZ;
                dev->gyro_cfg.bw = SMI230_GYRO_BW_230_ODR_2000_HZ;
                break;
            case SMI230_ACCEL_DATA_SYNC_MODE_1000HZ:
                dev->accel_cfg.odr = SMI230_ACCEL_ODR_800_HZ;
                dev->accel_cfg.bw = SMI230_ACCEL_BW_NORMAL;
                dev->gyro_cfg.odr = SMI230_GYRO_BW_116_ODR_1000_HZ;
                dev->gyro_cfg.bw = SMI230_GYRO_BW_116_ODR_1000_HZ;
                break;
            case SMI230_ACCEL_DATA_SYNC_MODE_400HZ:
                dev->accel_cfg.odr = SMI230_ACCEL_ODR_400_HZ;
                dev->accel_cfg.bw = SMI230_ACCEL_BW_NORMAL;
                dev->gyro_cfg.odr = SMI230_GYRO_BW_47_ODR_400_HZ;
                dev->gyro_cfg.bw = SMI230_GYRO_BW_47_ODR_400_HZ;
                break;
            default:
                break;
        }
        rslt = smi230_acc_set_meas_conf(dev);
        if (rslt != SMI230_OK)
        {
            return rslt;
        }

        rslt = smi230_gyro_set_meas_conf(dev);
        if (rslt != SMI230_OK)
        {
            return rslt;
        }

        /* Enable data synchronization */
        data[0] = (sync_cfg.mode & SMI230_ACCEL_DATA_SYNC_MODE_MASK);
        rslt = smi230_acc_write_feature_config(SMI230_ACCEL_DATA_SYNC_ADR, &data[0], SMI230_ACCEL_DATA_SYNC_LEN, dev);
    }

    return rslt;
}

/*!
 *  @brief This API is used to enable/disable and configure the anymotion
 *  feature.
 */
int8_t smi230_configure_anymotion(struct smi230_anymotion_cfg anymotion_cfg, const struct smi230_dev *dev)
{
    int8_t rslt;
    uint16_t data[SMI230_ACCEL_ANYMOTION_LEN];

    /* Check for null pointer in the device structure */
    rslt = null_ptr_check(dev);

    /* Proceed if null check is fine */
    if (rslt == SMI230_OK)
    {
        /* Enable data synchronization */
        data[0] = (anymotion_cfg.threshold & SMI230_ACCEL_ANYMOTION_THRESHOLD_MASK);
        data[0] |=
            ((anymotion_cfg.nomotion_sel << SMI230_ACCEL_ANYMOTION_NOMOTION_SEL_SHIFT) &
             SMI230_ACCEL_ANYMOTION_NOMOTION_SEL_MASK);
        data[1] = (anymotion_cfg.duration & SMI230_ACCEL_ANYMOTION_DURATION_MASK);
        data[1] |= ((anymotion_cfg.x_en << SMI230_ACCEL_ANYMOTION_X_EN_SHIFT) & SMI230_ACCEL_ANYMOTION_X_EN_MASK);
        data[1] |= ((anymotion_cfg.y_en << SMI230_ACCEL_ANYMOTION_Y_EN_SHIFT) & SMI230_ACCEL_ANYMOTION_Y_EN_MASK);
        data[1] |= ((anymotion_cfg.z_en << SMI230_ACCEL_ANYMOTION_Z_EN_SHIFT) & SMI230_ACCEL_ANYMOTION_Z_EN_MASK);
        rslt = smi230_acc_write_feature_config(SMI230_ACCEL_ANYMOTION_ADR, &data[0], SMI230_ACCEL_ANYMOTION_LEN, dev);
    }

    return rslt;
}

/*!
 *  @brief This API reads the synchronized accel & gyro data from the sensor,
 *  store it in the smi230_sensor_data structure instance
 *  passed by the user.
 */
int8_t smi230_get_synchronized_data(struct smi230_sensor_data *accel,
                                    struct smi230_sensor_data *gyro,
                                    const struct smi230_dev *dev)
{
    int8_t rslt;
    uint8_t reg_addr, data[6];
    uint8_t lsb, msb;
    uint16_t msblsb;

    /* Check for null pointer in the device structure */
    rslt = null_ptr_check(dev);

    /* Proceed if null check is fine */
    if ((rslt == SMI230_OK) && (accel != NULL) && (gyro != NULL))
    {
        /* Read accel x,y sensor data */
        reg_addr = SMI230_ACCEL_GP_0_REG;
        rslt = smi230_acc_get_regs(reg_addr, &data[0], 4, dev);

        if (rslt == SMI230_OK)
        {
            /* Read accel sensor data */
            reg_addr = SMI230_ACCEL_GP_4_REG;
            rslt = smi230_acc_get_regs(reg_addr, &data[4], 2, dev);

            if (rslt == SMI230_OK)
            {
                lsb = data[0];
                msb = data[1];
                msblsb = (msb << 8) | lsb;
                accel->x = ((int16_t) msblsb); /* Data in X axis */

                lsb = data[2];
                msb = data[3];
                msblsb = (msb << 8) | lsb;
                accel->y = ((int16_t) msblsb); /* Data in Y axis */

                lsb = data[4];
                msb = data[5];
                msblsb = (msb << 8) | lsb;
                accel->z = ((int16_t) msblsb); /* Data in Z axis */

                /* Read gyro sensor data */
                rslt = smi230_gyro_get_data(gyro, dev);
            }
        }

    }
    else
    {
        rslt = SMI230_E_NULL_PTR;
    }

    return rslt;
}

/*!
 *  @brief This API configures the synchronization interrupt
 *  based on the user settings in the smi230_int_cfg
 *  structure instance.
 */
int8_t smi230_set_data_sync_int_config(const struct smi230_int_cfg *int_config, const struct smi230_dev *dev)
{
    int8_t rslt;

    /* Configure accel sync data ready interrupt configuration */
    rslt = smi230_acc_set_int_config(&int_config->accel_int_config_1, dev);
    if (rslt != SMI230_OK)
    {
        return rslt;
    }

    rslt = smi230_acc_set_int_config(&int_config->accel_int_config_2, dev);
    if (rslt != SMI230_OK)
    {
        return rslt;
    }

    /* Configure gyro data ready interrupt configuration */
    rslt = smi230_gyro_set_int_config(&int_config->gyro_int_config_1, dev);
    if (rslt != SMI230_OK)
    {
        return rslt;
    }

    rslt = smi230_gyro_set_int_config(&int_config->gyro_int_config_2, dev);

    return rslt;
}

/*****************************************************************************/
/* Static function definition */

/*!
 * @brief This API is used to validate the device structure pointer for
 * null conditions.
 */
static int8_t null_ptr_check(const struct smi230_dev *dev)
{
    int8_t rslt;

    if ((dev == NULL) || (dev->read == NULL) || (dev->write == NULL) || (dev->delay_ms == NULL))
    {
        /* Device structure pointer is not valid */
        rslt = SMI230_E_NULL_PTR;
    }
    else
    {
        /* Device structure is fine */
        rslt = SMI230_OK;
    }

    return rslt;
}

/** @}*/
