/* Copyright (c) 2012-2020, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __VIDC_HFI_IO_H__
#define __VIDC_HFI_IO_H__

#include <linux/io.h>

#define VIDC_VBIF_BASE_OFFS			0x00080000

#define VIDC_CPU_BASE_OFFS			0x000C0000
#define VIDEO_CC_BASE_OFFS			0x00100000
#define VIDC_CPU_CS_BASE_OFFS		(VIDC_CPU_BASE_OFFS + 0x00012000)
#define VIDC_CPU_IC_BASE_OFFS		(VIDC_CPU_BASE_OFFS + 0x0001F000)

#define VIDC_CPU_CS_REMAP_OFFS		(VIDC_CPU_CS_BASE_OFFS + 0x00)
#define VIDC_CPU_CS_TIMER_CONTROL	(VIDC_CPU_CS_BASE_OFFS + 0x04)
#define VIDC_CPU_CS_A2HSOFTINTEN	(VIDC_CPU_CS_BASE_OFFS + 0x10)
#define VIDC_CPU_CS_A2HSOFTINTENCLR	(VIDC_CPU_CS_BASE_OFFS + 0x14)
#define VIDC_CPU_CS_A2HSOFTINT		(VIDC_CPU_CS_BASE_OFFS + 0x18)
#define VIDC_CPU_CS_A2HSOFTINTCLR	(VIDC_CPU_CS_BASE_OFFS + 0x1C)
#define VIDC_CPU_CS_VMIMSG		(VIDC_CPU_CS_BASE_OFFS + 0x34)
#define VIDC_CPU_CS_VMIMSGAG0		(VIDC_CPU_CS_BASE_OFFS + 0x38)
#define VIDC_CPU_CS_VMIMSGAG1		(VIDC_CPU_CS_BASE_OFFS + 0x3C)
#define VIDC_CPU_CS_VMIMSGAG2		(VIDC_CPU_CS_BASE_OFFS + 0x40)
#define VIDC_CPU_CS_VMIMSGAG3		(VIDC_CPU_CS_BASE_OFFS + 0x44)
#define VIDC_CPU_CS_SCIACMD			(VIDC_CPU_CS_BASE_OFFS + 0x48)

/* HFI_CTRL_STATUS */
#define VIDC_CPU_CS_SCIACMDARG0		(VIDC_CPU_CS_BASE_OFFS + 0x4C)
#define VIDC_CPU_CS_SCIACMDARG0_BMSK	0xff
#define VIDC_CPU_CS_SCIACMDARG0_SHFT	0x0
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_ERROR_STATUS_BMSK	0xfe
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_ERROR_STATUS_SHFT	0x1
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_INIT_STATUS_BMSK	0x1
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_INIT_STATUS_SHFT	0x0
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_PC_READY           0x100
#define VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_INIT_IDLE_MSG_BMSK     0x40000000

/* HFI_QTBL_INFO */
#define VIDC_CPU_CS_SCIACMDARG1		(VIDC_CPU_CS_BASE_OFFS + 0x50)

/* HFI_QTBL_ADDR */
#define VIDC_CPU_CS_SCIACMDARG2		(VIDC_CPU_CS_BASE_OFFS + 0x54)

/* HFI_VERSION_INFO */
#define VIDC_CPU_CS_SCIACMDARG3		(VIDC_CPU_CS_BASE_OFFS + 0x58)

/* VIDC_SFR_ADDR */
#define VIDC_CPU_CS_SCIBCMD		(VIDC_CPU_CS_BASE_OFFS + 0x5C)

/* VIDC_MMAP_ADDR */
#define VIDC_CPU_CS_SCIBCMDARG0		(VIDC_CPU_CS_BASE_OFFS + 0x60)

/* VIDC_UC_REGION_ADDR */
#define VIDC_CPU_CS_SCIBARG1		(VIDC_CPU_CS_BASE_OFFS + 0x64)

/* VIDC_UC_REGION_ADDR */
#define VIDC_CPU_CS_SCIBARG2		(VIDC_CPU_CS_BASE_OFFS + 0x68)

#define VIDC_CPU_CS_SCIBARG3		(VIDC_CPU_CS_BASE_OFFS + 0x6C)

#define VIDC_CPU_IC_IRQSTATUS		(VIDC_CPU_IC_BASE_OFFS + 0x00)
#define VIDC_CPU_IC_FIQSTATUS		(VIDC_CPU_IC_BASE_OFFS + 0x04)
#define VIDC_CPU_IC_RAWINTR			(VIDC_CPU_IC_BASE_OFFS + 0x08)
#define VIDC_CPU_IC_INTSELECT		(VIDC_CPU_IC_BASE_OFFS + 0x0C)
#define VIDC_CPU_IC_INTENABLE		(VIDC_CPU_IC_BASE_OFFS + 0x10)
#define VIDC_CPU_IC_INTENACLEAR		(VIDC_CPU_IC_BASE_OFFS + 0x14)
#define VIDC_CPU_IC_SOFTINT			(VIDC_CPU_IC_BASE_OFFS + 0x18)
#define VIDC_CPU_IC_SOFTINT_H2A_BMSK	0x8000
#define VIDC_CPU_IC_SOFTINT_H2A_SHFT	0xF
#define VIDC_CPU_IC_SOFTINTCLEAR	(VIDC_CPU_IC_BASE_OFFS + 0x1C)

/*
 * --------------------------------------------------------------------------
 * MODULE: vidc_wrapper
 * --------------------------------------------------------------------------
 */
#define VIDC_WRAPPER_BASE_OFFS		0x000E0000

#define VIDC_WRAPPER_HW_VERSION		(VIDC_WRAPPER_BASE_OFFS + 0x00)
#define VIDC_WRAPPER_HW_VERSION_MAJOR_VERSION_MASK  0x78000000
#define VIDC_WRAPPER_HW_VERSION_MAJOR_VERSION_SHIFT 28
#define VIDC_WRAPPER_HW_VERSION_MINOR_VERSION_MASK  0xFFF0000
#define VIDC_WRAPPER_HW_VERSION_MINOR_VERSION_SHIFT 16
#define VIDC_WRAPPER_HW_VERSION_STEP_VERSION_MASK   0xFFFF
#define VIDC_WRAPPER_CLOCK_CONFIG	(VIDC_WRAPPER_BASE_OFFS + 0x04)

#define VIDC_WRAPPER_INTR_STATUS	(VIDC_WRAPPER_BASE_OFFS + 0x0C)
#define VIDC_WRAPPER_INTR_STATUS_A2HWD_BMSK	0x10
#define VIDC_WRAPPER_INTR_STATUS_A2HWD_SHFT	0x4
#define VIDC_WRAPPER_INTR_STATUS_A2H_BMSK	0x4
#define VIDC_WRAPPER_INTR_STATUS_A2H_SHFT	0x2

#define VIDC_WRAPPER_INTR_MASK		(VIDC_WRAPPER_BASE_OFFS + 0x10)
#define VIDC_WRAPPER_INTR_MASK_A2HWD_BMSK	0x10
#define VIDC_WRAPPER_INTR_MASK_A2HWD_SHFT	0x4
#define VIDC_WRAPPER_INTR_MASK_A2HVCODEC_BMSK	0x8
#define VIDC_WRAPPER_INTR_MASK_A2HCPU_BMSK	0x4
#define VIDC_WRAPPER_INTR_MASK_A2HCPU_SHFT	0x2

#define VIDC_WRAPPER_INTR_CLEAR		(VIDC_WRAPPER_BASE_OFFS + 0x14)
#define VIDC_WRAPPER_INTR_CLEAR_A2HWD_BMSK	0x10
#define VIDC_WRAPPER_INTR_CLEAR_A2HWD_SHFT	0x4
#define VIDC_WRAPPER_INTR_CLEAR_A2H_BMSK	0x4
#define VIDC_WRAPPER_INTR_CLEAR_A2H_SHFT	0x2

#define VIDC_WRAPPER_CPU_CLOCK_CONFIG	(VIDC_WRAPPER_BASE_OFFS + 0x2000)
#define VIDC_WRAPPER_CPU_CGC_DIS	(VIDC_WRAPPER_BASE_OFFS + 0x2010)
#define VIDC_WRAPPER_CPU_STATUS (VIDC_WRAPPER_BASE_OFFS + 0x2014)
#define VIDC_VENUS_VBIF_CLK_ON		(VIDC_VBIF_BASE_OFFS + 0x4)
#define VENUS_VBIF_AXI_HALT_CTRL0   (VIDC_VBIF_BASE_OFFS + 0x208)
#define VENUS_VBIF_AXI_HALT_CTRL1   (VIDC_VBIF_BASE_OFFS + 0x20C)

#define VENUS_VBIF_AXI_HALT_CTRL0_HALT_REQ		BIT(0)
#define VENUS_VBIF_AXI_HALT_CTRL1_HALT_ACK		BIT(0)
#define VENUS_VBIF_AXI_HALT_ACK_TIMEOUT_US		500000


#define VIDC_CTRL_INIT		VIDC_CPU_CS_SCIACMD

#define VIDC_CTRL_STATUS	VIDC_CPU_CS_SCIACMDARG0
#define VIDC_CTRL_ERROR_STATUS__M \
		VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_ERROR_STATUS_BMSK
#define VIDC_CTRL_INIT_IDLE_MSG_BMSK \
		VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_INIT_IDLE_MSG_BMSK
#define VIDC_CTRL_STATUS_PC_READY \
		VIDC_CPU_CS_SCIACMDARG0_HFI_CTRL_PC_READY


#define VIDC_QTBL_INFO		VIDC_CPU_CS_SCIACMDARG1

#define VIDC_QTBL_ADDR		VIDC_CPU_CS_SCIACMDARG2

#define VIDC_VERSION_INFO	VIDC_CPU_CS_SCIACMDARG3

#define VIDC_SFR_ADDR		VIDC_CPU_CS_SCIBCMD
#define VIDC_MMAP_ADDR		VIDC_CPU_CS_SCIBCMDARG0
#define VIDC_UC_REGION_ADDR	VIDC_CPU_CS_SCIBARG1
#define VIDC_UC_REGION_SIZE	VIDC_CPU_CS_SCIBARG2

/* HFI_DSP_QTBL_ADDR
 * 31:3 - HFI_DSP_QTBL_ADDR
 *        4-byte aligned Address
 */
#define HFI_DSP_QTBL_ADDR	VIDC_CPU_CS_VMIMSG

/* HFI_DSP_UC_REGION_ADDR
 * 31:20 - HFI_DSP_UC_REGION_ADDR
 *         1MB aligned address.
 *         Uncached Region start Address. This region covers
 *         HFI DSP QTable,
 *         HFI DSP Queue Headers,
 *         HFI DSP Queues,
 */
#define HFI_DSP_UC_REGION_ADDR	VIDC_CPU_CS_VMIMSGAG0

/* HFI_DSP_UC_REGION_SIZE
 * 31:20 - HFI_DSP_UC_REGION_SIZE
 *         Multiples of 1MB.
 *         Size of the DSP_UC_REGION Uncached Region
 */
#define HFI_DSP_UC_REGION_SIZE	VIDC_CPU_CS_VMIMSGAG1

/*
 * --------------------------------------------------------------------------
 * MODULE: vcodec noc error log registers
 * --------------------------------------------------------------------------
 */
#define VCODEC_CORE0_VIDEO_NOC_BASE_OFFS		0x00004000
#define CVP_NOC_BASE_OFFS				0x0000C000
#define VCODEC_COREX_VIDEO_NOC_ERR_SWID_LOW_OFFS	0x0500
#define VCODEC_COREX_VIDEO_NOC_ERR_SWID_HIGH_OFFS	0x0504
#define VCODEC_COREX_VIDEO_NOC_ERR_MAINCTL_LOW_OFFS	0x0508
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRVLD_LOW_OFFS	0x0510
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRCLR_LOW_OFFS	0x0518
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG0_LOW_OFFS	0x0520
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG0_HIGH_OFFS	0x0524
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG1_LOW_OFFS	0x0528
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG1_HIGH_OFFS	0x052C
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG2_LOW_OFFS	0x0530
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG2_HIGH_OFFS	0x0534
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG3_LOW_OFFS	0x0538
#define VCODEC_COREX_VIDEO_NOC_ERR_ERRLOG3_HIGH_OFFS	0x053C

#endif
